@~/idl/read_parameters
@~/idl/rgb

function make_uv,image,pars
  npix=pars.npix
  npix_ft=pars.npix_ft
  if (npix gt npix_ft) then begin
    npix_ft=npix
    pars.npix_ft=npix_ft
  endif

  big_image=fltarr(npix_ft,npix_ft)
  big_image[0:n_elements(image[*,0])-1,0:n_elements(image[0,*])-1]=image

  ft_image=fft(big_image,-1)
  ft_image=shift((abs(ft_image)/abs(ft_image[0,0])),$
                      npix_ft/2,npix_ft/2)

  low=floor(npix_ft/2)-floor(npix/2)
  high=floor(npix_ft/2)+floor(npix/2)-1
  uv=ft_image[low:high,low:high]
  return,uv
end

function make_grid,pars
  npix=pars.npix
  im=fltarr(npix,npix)
  center=floor(npix/2)

  dummy=dindgen(npix)
  im1=im
  im2=im
  for i=0,npix-1 do begin
    im1[*,i]=dummy
    im2[i,*]=dummy
  endfor

  im1=im1-center
  im2=im2-center
  im=sqrt(im1^2.+im2^2.) ;; contains distance to center in pixels
  im=im*pars.boxsize/npix ;; distance to center in mas

  return,im
end

pro test_gauss_ft
  pars=read_parameters('parameters_test_gauss.txt')
  grid=make_grid(pars)

  im=exp(-grid^2/(2.*pars.sigma_gauss^2))
  plot,im[pars.npix/2,*]
  uv=make_uv(im,pars)
  plot,uv[pars.npix/2,*]
  
  center=pars.npix/2
  visgrid=dindgen(center)
  trace=fltarr(2,center)
  trace[0,*]=visgrid*sin(pars.phi*!dpi/180)+center
  trace[1,*]=visgrid*cos(pars.phi*!dpi/180)+center
  vis=interpolate(uv,trace[0,*],trace[1,*],cubic=-0.5)

  npix=n_elements(vis)
  k_pix=dindgen(npix)
  pixelsize_arcsec=1d-3*pars.boxsize/pars.npix
  k=k_pix/(pixelsize_arcsec*pars.npix_ft)

  plot,k,vis,xrange=[0,250],$
    xtitle='k (cycles/arcsec)',$
    ytitle='V'

  analytic_sig_vis=1./(2.*!dpi*1d-3*pars.sigma_gauss)
  analytic_vis=exp(-k^2/(2.*analytic_sig_vis^2))
  oplot,k,analytic_vis,line=2,color=rgb(255,0,0)


end  
