@~/idl/read_parameters
@~/idl/rgb
@read_vinci_data
;@calculate_elevation

pro oplot_baseline,vinci,pars,ps=ps
  ha_min=pars.ha_min
  ha_max=pars.ha_max
  n_ha=pars.n_ha
  ha=dindgen(n_ha)*(ha_max-ha_min)/(n_ha-1.)+ha_min
  ha=ha*!dpi/12. ;; radians

  n=n_elements(vinci)

  b_index=0*vinci.b_index
  nb=0 ;; number of baselines
  for i=0,n-1 do begin
    match='false'
    for j=0,nb do begin
      if (b_index[j] eq vinci[i].b_index) then match='true'
    endfor
    if (match eq 'false') then begin
      b_index[nb]=vinci[i].b_index
      nb=nb+1
    endif
  endfor
  b_index=b_index[where(b_index ne 0)]

  lambda=1d-6*pars.lambda
  for i=0,n_elements(b_index)-1 do begin
    index=where(vinci.b_index eq b_index[i])
    index=index[0]

    B_N=vinci[index].B_N
    B_E=vinci[index].B_E
    B_L=vinci[index].B_L
  
    dec=pars.dec*!dpi/180       ;; source declination and
    bl=pars.obs_lat*!dpi/180     ;; observatory lattitude in radians

    u=(B_E*cos(ha)-B_N*sin(bl)*sin(ha)+B_L*cos(bl)*sin(ha))$  
      /(206264.81*lambda)

    v=(B_E*sin(dec)*sin(ha)+B_N*(sin(bl)*sin(dec)*cos(ha)+cos(bl)*cos(dec))$
                            -B_L*(cos(bl)*sin(dec)*cos(ha)-sin(bl)*cos(dec)))$
        /(206264.81*lambda)

    delta=-B_E*cos(dec)*sin(ha) $
          -B_N*(sin(bl)*cos(dec)*cos(ha)-cos(bl)*sin(dec)) $
          +B_L*(cos(bl)*cos(dec)*cos(ha)+sin(bl)*sin(dec))

;    u=-u ;; project on sky NO, is now done by plotting East-West mirrored!
    k=sqrt(u^2+v^2)
    phi=atan(u/v)

    oplot,u,v
    oplot,-u,-v
;    xyouts,u[0],v[0],strtrim(string(b_index[i]),2)
  endfor
end


pro plot_uv,vinci,pars,ps=ps,baseline=baseline
  range=230
  plot,[0,0],[0,0],xrange=[range,-range],yrange=[-range,range],psym=-1,$
    xtitle='U (cycles/arcsec)',$
    ytitle='V (cycles/arcsec)'

  arrowcen=[0.7,0.7]*range
  arrowlen=0.18*range

  arrow,arrowcen[0],arrowcen[1],arrowcen[0]+arrowlen,arrowcen[1],/data
  arrow,arrowcen[0],arrowcen[1],arrowcen[0],arrowcen[1]+arrowlen,/data
  xyouts,arrowcen[0]+1.3*arrowlen,arrowcen[1],'E'
  xyouts,arrowcen[0]+0.1*arrowlen,arrowcen[1]+1.25*arrowlen,'N'

  lambda=1d-6*pars.lambda     ;; wavelength of observation
  ha=vinci.ha*!dpi/12.        ;; hour angles of observations in radians
  B_E=vinci.B_E               ;; \  
  B_N=vinci.B_N               ;;  > Baseline components in m
  B_L=vinci.B_L               ;; /
  B=vinci.B                   ;; Baseline in m
  az=vinci.az*!dpi/180.       ;; azimuth in radians
  V2=vinci.v2
  Ev2=vinci.Ev2

  ktab=B/(206264.81*lambda)

; current definition of azimuth: north=0, positive clockwise (on sky)
;  az=-az
; current definition of azimuth: north=0, positive counter-clockwise (on sky)
  utab=ktab*sin(az)
  vtab=ktab*cos(az)


; east=0, positive counter-clockwise
;  utab=ktab*cos(az)
;  vtab=ktab*sin(az)

  dec=pars.dec*!dpi/180       ;; source declination and
  bl=pars.obs_lat*!dpi/180     ;; observatory lattitude in radians

  u=(B_E*cos(ha)-B_N*sin(bl)*sin(ha)+B_L*cos(bl)*sin(ha))$
      /(206264.81*lambda)

  v=(B_E*sin(dec)*sin(ha)+B_N*(sin(bl)*sin(dec)*cos(ha)+cos(bl)*cos(dec))$
                          -B_L*(cos(bl)*sin(dec)*cos(ha)-sin(bl)*cos(dec)))$
      /(206264.81*lambda)

;    u=-u ;; project on sky NO, is now done by plotting East-West mirrored!
  k=sqrt(u^2+v^2)
  pa=180./!dpi*atan(u/v)
  indx=where(pa lt 0.)
  if (indx[0] ne -1) then pa[indx]=pa[indx]+180

  resolved=0.43
  sigmas=sqrt(-k^2/(2.*alog(sqrt(v2)/(1.-resolved))))
  sigma_high=sqrt(-k^2/(2.*alog(sqrt(v2-Ev2)/(1.-resolved))))
  err_sigmas=abs(sigmas-sigma_high)
  indx=where(err_sigmas lt 1.)
  fwhm=2.355*1./(2.*!dpi*sigmas)
;  xyouts,u[indx],v[indx],string(1d3*fwhm[indx],format='(f6.1)'),charsize=0.3
;  xyouts,u,v,string(vinci.ha,format='(f6.1)'),charsize=0.3

;print,vinci.b_index
;print,k/ktab

if not keyword_set(baseline) then begin
  index=where(vinci.b_index eq 8)
  plots,u[index],v[index],psym=1
  plots,-u[index],-v[index],psym=1
  if keyword_set(ps) then color=2 else color=rgb(255,0,0)
  plots,utab[index],vtab[index],psym=1,color=color
;  plots,-utab[index],-vtab[index],psym=1,color=color

  index=where(vinci.b_index eq 16)
  plots,u[index],v[index],psym=4
  plots,-u[index],-v[index],psym=4
  if keyword_set(ps) then color=2 else color=rgb(255,0,0)
  plots,utab[index],vtab[index],psym=4,color=color
;  plots,-utab[index],-vtab[index],psym=4,color=color

  index=where(vinci.b_index eq 24)
  plots,u[index],v[index],psym=7
  plots,-u[index],-v[index],psym=7
  if keyword_set(ps) then color=2 else color=rgb(255,0,0)
  plots,utab[index],vtab[index],psym=7,color=color
;  plots,-utab[index],-vtab[index],psym=7,color=color

  index=where(vinci.b_index eq 66)
  plots,u[index],v[index],psym=5
  plots,-u[index],-v[index],psym=5
  if keyword_set(ps) then color=2 else color=rgb(255,0,0)
  plots,utab[index],vtab[index],psym=5,color=color
;  plots,-utab[index],-vtab[index],psym=5,color=color

  index=where(vinci.b_index eq 103)
  plots,u[index],v[index],psym=6
  plots,-u[index],-v[index],psym=6
  if keyword_set(ps) then color=2 else color=rgb(255,0,0)
  plots,utab[index],vtab[index],psym=6,color=color
;  plots,-utab[index],-vtab[index],psym=6,color=color
endif else begin
  index=where(vinci.b_index eq baseline)
  plots,u[index],v[index],psym=5
  plots,-u[index],-v[index],psym=5
  if keyword_set(ps) then color=2 else color=rgb(255,0,0)
  plots,utab[index],vtab[index],psym=5,color=color
;  plots,-utab[index],-vtab[index],psym=5,color=color
endelse
end

pro uv_coverage,ps=ps,baseline=baseline
  pars=read_parameters('parameters.txt')

;  inputfile='eta_car_vinci.txt'
  inputfile='Eta_Car_2003_03_15.txt_short'
  inputfile='eta_car_070403.txt_short'

  if (inputfile eq 'eta_car_070403.txt_short') then $
    vinci=read_vinci_data(pars,inputfile,/tenplus) else $
    vinci=read_vinci_data(pars,inputfile)


  if keyword_Set(baseline) then $
    vinci=vinci[where(vinci.b_index eq baseline)]

  window,0,xsize=500,ysize=500,xpos=10000,ypos=10000

    if keyword_set(ps) then begin
    postscriptname='uv_coverage.ps'
    xsize=17
    ysize=16
    set_plot,'ps',/interpolate
    device,file=postscriptname,/portrait,/color,$
      font_size=16.,xsize=xsize,ysize=ysize,yoffset=0,xoffset=2
    charsize=0.6
    TVLCT, [0,255,255,0,0], [0,255,0,255,0], [0,255,0,0,255]
    ;; 0 = black
    ;; 1 = white
  endif else charsize=1.


  plot_uv,vinci,pars,ps=ps,baseline=baseline
  oplot_baseline,vinci,pars,ps=ps

  if keyword_set(ps) then begin
    device,/close
    set_plot,'x'
    print,'wrote ',postscriptname
  endif


end
