@~/idl/planck

function diff_func,p
  common common_flux_conversion,Fnu,omega,nu

  F=omega*planck(nu,p[0]) ;; W/m2/Hz
  diff=(Fnu-F)^2
  return,diff
end

pro plot_result,lambda,flux,a,omega
  nlam=1024
  lam_min=0.1*lambda
  lam_max=100.*lambda
  loglam=dindgen(nlam)*alog(lam_max/lam_min)/(nlam-1.)+alog(lam_min)
  lam=exp(loglam)
  nu=3d8/(1d-6*lam)
  Fnu=1d26*omega*planck(nu,a[0]) ;; [Jy]

  yrange=[min(Fnu),1.5*max(Fnu)]
  plot,lam,Fnu,/xlog,/ylog,yrange=yrange
  plots,lambda,flux,psym=5

end

pro min_Teff,lambda,flux,radius
  common common_flux_conversion
;; lambda in micron
;; flux in Jy
;; radius in mas

  nu=3d8/(1d-6*lambda)
  Fnu=flux/1d26 ;; in W/m2/Hz
  omega=!dpi*radius^2 ;; in square mas
  omega=omega/4.25451703d16 ;; in sr

  init=2000
  scale=0.1*init
  a=amoeba(1d-6,function_name='diff_func',$
           p0=init,scale=scale,simplex=simplex)
  if (a[0]=-1) then a=simplex  

  plot_result,lambda,flux,a,omega

  print,'BB temperature needed for given flux in given solid angle:',a[0],' K'

end

pro all
  ;; THIS IS FOR JOHN's 1.5e-3 model scaled up by 1.0365
  core_flux=200.
  print,'A_k=0:'
  min_Teff,2.2,core_flux/2.,5.6888925/2.3
  print,'A_k=1:'
  min_Teff,2.2,2.51*core_flux/2.,5.6888925/2.3
  print,'A_k=2:'
  min_Teff,2.2,2.51^2*core_flux/2.,5.6888925/2.3

end
