@~/idl/integrate

pro test_integration,log=log
  nx=1024
  xmin=0.001
  xmax=10.0
  powerlaw=-4

  if keyword_set(log) then begin
    logx=alog(xmax/xmin)*dindgen(nx)/(nx-1)+alog(xmin)
    x=exp(logx)
  endif else x=(xmax-xmin)*dindgen(nx)/(nx-1)+xmin
  f=x^powerlaw
  plot,x,f,/xlog,/ylog

  integral1=integrate(x,f)
  print,integral1

  weight=(1./(powerlaw+1))*x^(powerlaw+1)
  integral2=integrate(weight,f*x^(-powerlaw))
  print,integral2

  analytical=(1./(powerlaw+1))*xmax^(powerlaw+1)-$
             (1./(powerlaw+1))*xmin^(powerlaw+1)
  print,analytical

end
