@simple_model

pro best_john,first=first

  fac_min=0.95
  fac_max=1.1

;  fac_min=1.05
;  fac_max=1.20

;  fac_min=1.15
;  fac_max=1.30

  nfac=16
  fac=fac_min+dindgen(nfac)*(fac_max-fac_min)/(nfac-1)

  params=read_parameters('parameters.txt')

  filename='best_john.dat'
  if keyword_set(first) then begin
    chisquare=0.*fac
    for i=0,nfac-1 do begin
      pars=params
      pars.john_scale=fac[i]
      simple_model,pars=pars,/silent,chisq=chisq,hlr=hlr,Fnu=Fnu,/john
      chisquare[i]=chisq
      print,fac[i],chisq
    endfor
    save,chisquare,pars,fac,filename=filename
  endif else restore,filename

  plot,fac,chisquare,yrange=[0,max(chisquare)]
  c=poly_fit(fac,chisquare,3)
  oplot,fac,poly(fac,c),color=rgb(255,0,0)

  nfac=2048
  fac2=fac_min+dindgen(nfac)*(fac_max-fac_min)/(nfac-1)

  f=poly(fac2,c)
  oplot,fac2,f,color=rgb(0,255,0)
  dummy=min(f,index)
  print,'best value for john_scale: ',fac2[index]

;; best value for john_scale: 1.053

end

pro bla
;fac=[1.268,1.146,1.053]
fac=[1.268,1.146,1.0365]
mdot=[1.0,1.25,1.5]
flux=[771.,786.,793.]

plot,mdot,fac,xstyle=2,yrange=[0.95,1.35],xrange=[0.9,1.8]
order=2
c=poly_fit(fac,mdot,order)
mlr=poly(1.0,c)
plots,mlr,1.0,psym=6

print,'best solution mlr: ',mlr

c2=poly_fit(mdot,flux,1)
print,'flux of this model: ',poly(mlr,c2)
plot,mdot,flux
end
