@source/read_parameters
@source/find_opt

function get_chisquare,DATA_K,DATA_v2,DATA_Ev2,k,v2
  model_v2=interpol(v2,k,DATA_K)
  ndata=n_elements(DATA_K) ;; number of data points
  npars=2. ;; number of free paramters
  chisq=total((DATA_v2-model_v2)^2/DATA_Ev2^2)/(1d0*ndata-npars)
  return,chisq
end


pro figure1_rohied,ps=ps,first=first

  params=read_parameters('parameters.txt')
  params.vis_ps='x'      ;; make postscript files for all models
  params.make_im_uv='x'  ;; make sure to make images/vis curves!
  use_f_law=''           ;; constant clumping for now
  params.include_ff='x'    ;; \ make sure to use both ff
  params.include_es='x'    ;; / and es opacities

  fmin=0.001
  fmax=1.0
  nf=64

  mdotmin=0.1e-3
  mdotmax=3.0e-3
  nmdot=64

  logf=dindgen(nf)*alog(fmax/fmin)/(nf-1)+alog(fmin)
  f=exp(logf)
  mdot=dindgen(nmdot)*(mdotmax-mdotmin)/(nmdot-1)+mdotmin

  ;; THE DATA:
  B=[7.9046163,14.205558,22.125905,62.199575]
  v2=[0.25128050,0.20616964,0.13247845,0.02602200]
  Ev2=[0.013616442,0.008697413,0.011328906,0.002633462]
  Ev2[1]=0.015 ;; 16m point has much larger errors than the scatter (2 points)

;  Ev2=[0.014,0.015,0.01,0.01]
;  B=[B,8.458E+01] & v2=[v2,0.0111] & eV2=[Ev2,0.01]

  Ev2=[0.014,0.015,0.01,0.003]
  B=[B,8.458E+01] & v2=[v2,0.0111] & eV2=[Ev2,0.0037]

  DATA_K=(B/(1d-6*params.lambda))*!dpi/(3600.*180.)
  DATA_v2=v2 & DATA_Ev2=Ev2 & low=DATA_v2-DATA_Ev2 & high=DATA_v2+DATA_Ev2

  ;; FIRST GET THE CHI-SQUARES:
  chisq_file='DATA_FILES/quick_figure2_chisquare.dat'
  if keyword_set(first) then begin
    chisquare=fltarr(nmdot,nf) & half_light_r=fltarr(nmdot,nf)
    Flux_Jy=fltarr(nmdot,nf)
    for i=0,nmdot-1 do begin
      print,'doing ',i+1,' out of ',nmdot
      for j=0,nf-1 do begin
        pars=params
        pars.mdot=mdot[i]
        pars.f=f[j]
  
        file='VIS_DATA_FILES/vis_'+$
          strtrim(string(pars.mdot,format='(e12.2)'),2)+'_'+$
         'f'+strtrim(string(pars.f,format='(f10.4)'),2)+'.dat'

        restore,file
        chisq=get_chisquare(DATA_K,DATA_v2,DATA_Ev2,k,v2)
        chisquare[i,j]=chisq
      endfor
    endfor
    save,chisquare,filename=chisq_file
    print,'wrote: ',chisq_file
  endif else restore,chisq_file

  ;; THEN, MAKE SOME PLOTS ...
  landscape=1
  if (landscape eq 1) then begin
    xoffset=0.5
    yoffset=28
    xsize=25
  endif else begin
    xoffset=0
    yoffset=1
    xsize=18
  endelse

  grey=165
  if keyword_set(ps) then begin
    postscriptname='FIGURES/figure1_rohied.ps'
    xsize=20.
    ysize=12.
    set_plot,'ps',/interpolate
    device,file=postscriptname,/portrait,/color,$
      font_size=16.,xsize=xsize,ysize=ysize,yoffset=0,xoffset=0
    charsize=1.0
    TVLCT, [0,255,grey],[0,255,grey], [0,255,grey]
    ;; 0 = black
    ;; 1 = white
    ;; 2 = grey
    thick=3.  
    symsize=0.6
  endif else thick=1.

  xstart=0.11
  ystart=0.09
  xend=0.965
  yend=0.9

  x1=xstart
  y1=ystart
  x2=xend
  y2=yend
  !P.POSITION=[x1,y1,x2,y2]

;======================================================= START UPPER PLOT

  !p.thick=thick
  !x.thick=thick
  !y.thick=thick
  !p.charthick=thick

  plot,[0,0],[0,0],xrange=[5,200],yrange=[0,0.4],$
    ytitle='V!A2!N',xstyle=5
  axis,xaxis=1,xtitle='spatial frequency (cycles/arcsec)'
  axis,xaxis=0,charsize=0.001

  plots,DATA_k,DATA_v2,psym=4,symsize=symsize,thick=thick
  errplot,DATA_k,low,high

  restore,'VIS_DATA_FILES/vis_1.60e-03_f0.2560.dat'
;  restore,'VIS_DATA_FILES/vis_1.62e-03_f0.262.dat'
;  oplot,k,v2

  
;  restore,'VIS_DATA_FILES/vis_john.dat'
  restore,'VIS_DATA_FILES/vis_john.dat2'
  oplot,k,v2


  labelx=90
  linelength=25
  labely=0.355
  labelystep=0.035
  oplot,[labelx,labelx+linelength],[labely,labely]
  xyouts,labelx+linelength+5.,labely-0.008,'best fit wind model'

;  sig=60.
;  x=dindgen(1024)
;  y=exp(-x^2/(2.*sig^2.))*(1.-0.48)
;  oplot,x,y^2,line=2

  if keyword_set(ps) then begin
    device,/close
    set_plot,'x'
    print,'wrote ',postscriptname
  endif
end
