pro make_illustration,ps=ps

  grey=165
  if keyword_set(ps) then begin
    postscriptname='FIGURES/figure2.ps'
    xsize=14.
    ysize=24
    set_plot,'ps',/interpolate
    device,file=postscriptname,/portrait,/color,$
      font_size=16.,xsize=xsize,ysize=ysize,yoffset=2,xoffset=2
    charsize=1.0
    TVLCT, [0,255,grey],[0,255,grey], [0,255,grey]
    ;; 0 = black
    ;; 1 = white
    ;; 2 = grey
    thick=3.  
    symsize=0.6
  endif else thick=1.

  ychange=0.6
  ychange_border=0.045
  xstart=0.175
  ystart=0.09
  xend=0.965
  yend=0.935
  !P.MULTI = [0,1,2,0,0]

  x1=xstart
  y1=ystart+(ychange+ychange_border)*(yend-ystart)
  x2=xend
  y2=yend
  !P.POSITION=[x1,y1,x2,y2]
;======================================================= START UPPER PLOT
;  restore,'VIS_DATA_FILES/vis_1.50e-03_f0.225.dat' ;; for errors2 file
;  restore,'VIS_DATA_FILES/vis_1.78e-03_f0.334.dat' ;; for errors1 file
  restore,'VIS_DATA_FILES/vis_1.60e-03_f0.256.dat'

  !p.thick=thick
  !x.thick=thick
  !y.thick=thick
  !p.charthick=thick

  plot,k,v2,xrange=[5,200],yrange=[0,0.4],$
    ytitle='V!A2!N',xstyle=5
  axis,xaxis=1,xtitle='spatial frequency (cycles/arcsec)'
  axis,xaxis=0,charsize=0.001
  
;  restore,'VIS_DATA_FILES/vis_john.dat'
  restore,'VIS_DATA_FILES/vis_john.dat2'
  oplot,k,v2,line=2

  low=data_v2-Ev2
  high=data_v2+Ev2

  plots,datak,data_v2,psym=4,symsize=symsize,thick=thick
  errplot,datak,low,high

  labelx=90
  linelength=25
  labely=0.355
  labelystep=0.035
  oplot,[labelx,labelx+linelength],[labely,labely]
  xyouts,labelx+linelength+5.,labely-0.008,'LTE H+He model'
  labely=labely-labelystep
  oplot,[labelx,labelx+linelength],[labely,labely],line=2
  xyouts,labelx+linelength+5.,labely-0.008,'non-LTE model'

;======================================================= START LOWER PLOT
  x1=xstart
  y1=ystart
  x2=xend
  y2=ystart+(ychange-ychange_border)*(yend-ystart)
  !P.POSITION=[x1,y1,x2,y2]


;  restore,'DATA_FILES/chisquare.dat_errors1'
;  restore,'DATA_FILES/chisquare.dat_errors2'
  restore,'DATA_FILES/chisquare.dat'
  ndata=4
  nparams=2
  reduced_chisq=chisquare*1d0*ndata/(1d0*ndata-1d0*nparams)
  mdot=mdot*1d3 ;; in units of 10^-3 msun/yr

;  chisq_LEVELS=[0.6,1.0,2.0,5.0,10.0,20.,40.,80.,160.,320.]
  chisq_LEVELS=[1.0,3.0,10.0,30.,100.,300.]
  chisq_C_labels=fix(0.*chisq_levels+1)
  CONTOUR,reduced_chisq,mdot,f,levels=chisq_LEVELS,C_LABELS=chisq_C_LABELS,$
    xtitle='Mass Loss Rate [10!A-3!N M!B!9n!3!N yr!A-1!N]',$
    ytitle='Clumping factor',/ylog,c_charsize=c_charsize,charsize=charsize,$
    title='reduced !4v!3!A2!N of fit',xrange=[0.1,2.]

  plots,1.60,0.254,psym=4
  john_f=0.1*(mdot)^2
  oplot,mdot,john_f,line=2

  if keyword_set(ps) then begin
    device,/close
    set_plot,'x'
    print,'wrote ',postscriptname

  endif
  !P.MULTI = 0
end
