@source/read_parameters
@source/find_opt


function get_chisquare,DATA_K,DATA_v2,DATA_Ev2,k,v2
  model_v2=interpol(v2,k,DATA_K)
  ndata=n_elements(DATA_K) ;; number of data points
  npars=2. ;; number of free paramters
  chisq=total((DATA_v2-model_v2)^2/DATA_Ev2^2)/(1d0*ndata-npars)
  return,chisq
end


pro quick_figure2,ps=ps,first=first

  params=read_parameters('parameters.txt')
  params.vis_ps='x'      ;; make postscript files for all models
  params.make_im_uv='x'  ;; make sure to make images/vis curves!
  use_f_law=''           ;; constant clumping for now
  params.include_ff='x'    ;; \ make sure to use both ff
  params.include_es='x'    ;; / and es opacities

  fmin=0.001
  fmax=1.0
  nf=64

  mdotmin=0.1e-3
  mdotmax=3.0e-3
  nmdot=64

  logf=dindgen(nf)*alog(fmax/fmin)/(nf-1)+alog(fmin)
  f=exp(logf)
  mdot=dindgen(nmdot)*(mdotmax-mdotmin)/(nmdot-1)+mdotmin

  ;; THE DATA:
  B=[7.9046163,14.205558,22.125905,62.199575]
  v2=[0.25128050,0.20616964,0.13247845,0.02602200]
  Ev2=[0.013616442,0.008697413,0.011328906,0.002633462]
  Ev2[1]=0.015 ;; 16m point has much larger errors than the scatter (2 points)

  Ev2=[0.014,0.015,0.01,0.01]
;  B=[B,8.458E+01] & v2=[v2,0.0111] & eV2=[Ev2,0.01]

  Ev2=[0.014,0.015,0.01,0.003]
;  B=[B,8.458E+01] & v2=[v2,0.0111] & eV2=[Ev2,0.0037]

  DATA_K=(B/(1d-6*params.lambda))*!dpi/(3600.*180.)
  DATA_v2=v2 & DATA_Ev2=Ev2 & low=DATA_v2-DATA_Ev2 & high=DATA_v2+DATA_Ev2

  ;; FIRST GET THE CHI-SQUARES:
  chisq_file='DATA_FILES/quick_figure2_chisquare.dat'
  if keyword_set(first) then begin
    chisquare=fltarr(nmdot,nf) & half_light_r=fltarr(nmdot,nf)
    Flux_Jy=fltarr(nmdot,nf)
    for i=0,nmdot-1 do begin
      print,'doing ',i+1,' out of ',nmdot
      for j=0,nf-1 do begin
        pars=params
        pars.mdot=mdot[i]
        pars.f=f[j]
  
        file='VIS_DATA_FILES/vis_'+$
          strtrim(string(pars.mdot,format='(e12.2)'),2)+'_'+$
         'f'+strtrim(string(pars.f,format='(f10.4)'),2)+'.dat'

        restore,file
        chisq=get_chisquare(DATA_K,DATA_v2,DATA_Ev2,k,v2)
        chisquare[i,j]=chisq
      endfor
    endfor
    save,chisquare,filename=chisq_file
    print,'wrote: ',chisq_file
  endif else restore,chisq_file

  ;; THEN, MAKE SOME PLOTS ...
  landscape=1
  if (landscape eq 1) then begin
    xoffset=0.5
    yoffset=28
    xsize=25
  endif else begin
    xoffset=0
    yoffset=1
    xsize=18
  endelse

  grey=165
  if keyword_set(ps) then begin
    postscriptname='FIGURES/figure2.ps'
    xsize=14.
    ysize=24
    set_plot,'ps',/interpolate
    device,file=postscriptname,/portrait,/color,$
      font_size=16.,xsize=xsize,ysize=ysize,yoffset=2,xoffset=2
    charsize=1.0
    TVLCT, [0,255,grey],[0,255,grey], [0,255,grey]
    ;; 0 = black
    ;; 1 = white
    ;; 2 = grey
    thick=3.  
    symsize=0.6
  endif else thick=1.

  ychange=0.6
  ychange_border=0.045
  xstart=0.175
  ystart=0.09
  xend=0.965
  yend=0.935
  !P.MULTI = [0,1,2,0,0]

  x1=xstart
  y1=ystart+(ychange+ychange_border)*(yend-ystart)
  x2=xend
  y2=yend
  !P.POSITION=[x1,y1,x2,y2]

;======================================================= START UPPER PLOT

  !p.thick=thick
  !x.thick=thick
  !y.thick=thick
  !p.charthick=thick

  plot,[0,0],[0,0],xrange=[5,200],yrange=[0,0.4],$
    ytitle='V!A2!N',xstyle=5
  axis,xaxis=1,xtitle='spatial frequency (cycles/arcsec)'
  axis,xaxis=0,charsize=0.001

  plots,DATA_k,DATA_v2,psym=4,symsize=symsize,thick=thick
  errplot,DATA_k,low,high

  restore,'VIS_DATA_FILES/vis_1.60e-03_f0.2560.dat'
;  restore,'VIS_DATA_FILES/vis_1.62e-03_f0.262.dat'
  oplot,k,v2

  
;  restore,'VIS_DATA_FILES/vis_john.dat'
  restore,'VIS_DATA_FILES/vis_john.dat2'
  oplot,k,v2,line=2


  labelx=90
  linelength=25
  labely=0.355
  labelystep=0.035
  oplot,[labelx,labelx+linelength],[labely,labely]
  xyouts,labelx+linelength+5.,labely-0.008,'LTE H+He model'
  labely=labely-labelystep
  oplot,[labelx,labelx+linelength],[labely,labely],line=2
  xyouts,labelx+linelength+5.,labely-0.008,'non-LTE model'

;======================================================= START LOWER PLOT
  x1=xstart
  y1=ystart
  x2=xend
  y2=ystart+(ychange-ychange_border)*(yend-ystart)
  !P.POSITION=[x1,y1,x2,y2]

  mdot=mdot*1d3 ;; in units of 10^-3 msun/yr

  if keyword_set(smooth) then begin ;; smooth the contours
    x=0.*chisquare & y=x
    for i=0,n_elements(x[0,*])-1 do x[*,i]=mdot
    for i=0,n_elements(y[*,0])-1 do y[i,*]=f
    chisquare=MIN_CURVE_SURF(chisquare,x,y,xout=mdot,yout=f)
  endif

  reduced_chisq=chisquare

;  chisq_LEVELS=[0.5,0.8,1.3,2.5,5.0,10.0,20.,40.,80.,160.]
  chisq_LEVELS=[0.6,1.0,1.5,2.5,5.0,10.0,20.,40.,80.,160.,320.]
  chisq_C_labels=fix(0.*chisq_levels+1)
  CONTOUR,reduced_chisq,mdot,f,levels=chisq_LEVELS,C_LABELS=chisq_C_LABELS,$
    xtitle='Mass Loss Rate [10!A-3!N M!B!9n!3!N yr!A-1!N]',$
    ytitle='Clumping factor',/ylog,c_charsize=c_charsize,charsize=charsize,$
    title='reduced !4v!3!A2!N of fit',xrange=[0.1,2.]

;  plots,1.43,0.2045,psym=4
;  plots,1.5,0.225,psym=4
  plots,1.6,0.256,psym=4
  john_f=0.1*(mdot)^2
  indx=where(mdot ge 0.5)
  oplot,mdot[indx],john_f[indx],line=2


  min=find_opt(reduced_chisq,min_max='min')
  print,'Lowest chi-square that occurs: ',reduced_chisq(min[0],min[1])
  print,'for mdot=',mdot[min[0]],' and f=',f[min[1]]

  if keyword_set(ps) then begin
    device,/close
    set_plot,'x'
    print,'wrote ',postscriptname
  endif
end
