@source/read_parameters
@source/integrate
@source/rgb
@source/trivial_stuff
@source/integrate2
@source/planck
@source/calculate_bII
@source/make_grids
@source/make_image
@source/compute_visibilities

function get_Intensity,p,A,pars,nu,W,Rgrid
  ;; p along axis 1
  ;; z along axis 2
  ;; in A[*,*,0] are the R values
  ;; in A[*,*,1] are the tau-ff values along line of sight
  ;; in A[*,*,2] are the tau-es values along line of sight
  ;; in A[*,*,3] are the chi-ff values
  ;; in A[*,*,4] are the chi-es values
  Twind=pars.Twind

  np=n_elements(p)
  I=0d0*p

  for ii=0,np-1 do begin
    index=where(A[ii,*,0] ne -1)
    R=reform(A[ii,index,0])
    tau=reform(A[ii,index,1]+A[ii,index,2])
    chi_ff=reform(A[ii,index,3])
    chi_es=reform(A[ii,index,4])
    Ws=interpol(W,Rgrid,R)
    if (pars.include_ff ne '') then J=Ws*B(nu,Twind) else begin ; no ff opacity
      Ws=0.5*(1d0-sqrt(abs(1d0-abs(pars.Rstar/R)^2)))
      J=Ws*B(nu,pars.Tstar)
    endelse
    S=(chi_ff*B(nu,Twind)+chi_es*J)/(chi_ff+chi_es)
    I[ii]=integrate2(tau,S)
  endfor

  return,I
end

function make_f,pars,V,R
  f=pars.fmin+(1.-pars.fmin)*exp(-V/pars.v_cl)
  return,f
end

function calculate_W,A,Rgrid,p,pars,R_where_tau_ff_is_tau_core
  np=pars.np
  nR=pars.nR
  nex=pars.np_inRstar

  W=0d0*Rgrid
  for k=0,nR-1 do begin
    ps=p[0:k+nex] & nps=n_elements(ps)
    Rs=Rgrid[k]
    mu=sqrt(1d0-(ps/Rs)^2)

    tau=0d0*ps & tau_max=0d0*ps
    for i=0,nps-1 do begin
      index_tau_min=fix(nR-1-k)
      tau[i]=A[i,index_tau_min,1]
      if (i lt (nex)) then begin
        index_tau_max=fix(nR-1)
        tau_max[i]=A[i,index_tau_max,1]
      endif
      if (i ge (nex)) then begin
        index_tau_max=fix(2*(nR-1+nex-i))
        tau_max[i]=A[i,index_tau_max,1]
      endif
    endfor
    f=0.5*((1d0-exp(-tau))+(1d0-exp(-(tau_max-tau))))
    W[k]=integrate(mu,f)
  endfor

  return,W
end

pro simple_model,ps=ps,pars=pars,silent=silent,chisq=chisq,hlr=hlr,Fnu=Fnu,$
                 nodispl=nodispl,john=john,demo=demo
  ;; chisq will contain the chi-square of the visibility fit
  ;; hlr will contain the 'half light radius, i.e. within what radius
  ;; half of the total flux emerges. This is some measure for the 'size'.

  if (not keyword_set(pars)) then pars=read_parameters('parameters.txt')

  pars=convert_to_cgs(pars)

  if (not keyword_set(john)) then begin

  Mdot=pars.Mdot   ;; MLR [g/s]
  gamma=(pars.X*pars.qH+pars.Y*pars.qHe/4.)/(pars.X+pars.Y/4.) ;; ioniz. frac.
  v_inf=pars.v_inf ;; Terminal velocity of wind [cm/s]
  v0=pars.v0       ;; Initial velocity of wind at stellar surface [cm/s]
  beta=pars.Beta   ;; Beta of velocity law
  mu_a=(pars.X+pars.Y)/(pars.X+pars.Y/4.) ;; mean atomic weight [amu]
  sigT=pars.sig_thom ;; Thomson cross section of free electron [cm2]
  mH=pars.mH       ;; Mass of H atom [g]
  Rstar=pars.Rstar ;; [cm]
  Tstar=get_Tstar(pars) ;; [K]
  if (pars.Twind eq '') then Twind=Tstar else Twind=pars.Twind
  if (not keyword_set(silent)) then $
    print,'Stellar temperature at chosen luminosity and radius: ',Tstar,' K'
  nu=pars.c/pars.lambda
  h=pars.h
  k=pars.k
  f=pars.f

  if keyword_set(john) then pars.vis_dataf=''


  Rgrid=make_R_grid(pars) ;; Radial grid [cm], OK
  p=make_p_grid(Rgrid,pars) ;; impact parameters [cm], OK
  np=n_elements(p)
  pars=create_struct(pars,'np',np) ;; put the # of impact parameters in pars
  pars=create_struct(pars,'Tstar',Tstar) ;; put Tstar in pars

  total_tau_es=0.*p   ;; total e- scattering optical depth for each p 
  total_tau_ff=0.*p   ;; total ff optical depth for each p 

  bII=calculate_bII(pars)
  Zjk=pars.X/(pars.X+pars.Y/4.)
  Kff=3.692d8*(pars.gIII+bII)*Zjk/(sqrt(Twind)*nu^3)*(1.-exp(-h*nu/(k*Twind)))
  ;; constant factor in ff opacity (includes also bf!!!)

  A=dblarr(pars.np,2*pars.nR-1,5)
  ;; p along axis 1
  ;; z along axis 2
  ;; in A[*,*,0] are the R values
  ;; in A[*,*,1] are the tau-ff values along line of sight
  ;; in A[*,*,2] are the tau-es values along line of sight
  ;; in A[*,*,3] are the chi-ff values
  ;; in A[*,*,4] are the chi-es values
  ;; Many elements of A will not be used (only one line of sight
  ;; has all 2*pars.nR-1 z-points. Unused elements are set to -1.

  for ii=0,np-1 do begin
    z=make_z_grid(p[ii],Rgrid,pars)   ;; z-grid [cm], OK
    R=sqrt(p[ii]^2+z^2)               ;; corresponding R values
    A[ii,0:n_elements(R)-1,0]=R ;; store the R-values

    if (n_elements(R) lt (2*pars.nR-1)) then $
      A[ii,n_elements(R):2*pars.nR-2,*]=-1 ;; set the unused elements to -1

    V=V0+(v_inf-V0)*(1.-Rstar/R)^beta ;; velocity, [cm/s], OK
    if (pars.use_f_law ne '') then f=make_f(pars,V,R)

    n=Mdot/(4*!dpi*R^2*mu_a*mH*V) ;; number density of nucleons [#/cm3], OK
    nHII=n*pars.qH/(1+pars.Y/(4.*pars.X))

    nel=gamma*n ;; number density of electrons [#/cm3], OK
    chi_es=sigT*nel/f ;; OK

    chi_ff=Kff*(nel*nHII/f^2) ;; OK, includes also bf!

    if (pars.include_ff eq '') then chi_ff=0.*chi_ff
    if (pars.include_es eq '') then chi_es=0.*sigT*nel
    A[ii,0:n_elements(R)-1,3]=chi_ff ;; store chi-ff
    A[ii,0:n_elements(R)-1,4]=chi_es ;; store chi-es

    total_tau_es[ii]=integrate(z,chi_es*f,cumul=tau_es,/gi) ;; es and ff 
    total_tau_ff[ii]=integrate(z,chi_ff*f,cumul=tau_ff,/gi) ;; optical depths
    tau_ff=[0.,tau_ff] & tau_es=[0.,tau_es]

    A[ii,0:n_elements(R)-1,1]=tau_ff ;; store tau-ff
    A[ii,0:n_elements(R)-1,2]=tau_es ;; store tau-es

    if (ii eq 0) then begin ;; impact parameter is 0.
      tau_es_R=tau_es
      tau_ff_R=tau_ff
      tau_R=tau_es+tau_ff
      chi_es_R=chi_es
      chi_ff_R=chi_ff
      tau_R2_3=interpol(R,tau_R,0.66666667)
    endif
  endfor
  ;; p along axis 1
  ;; z along axis 2
  ;; in A[*,*,0] are the R values
  ;; in A[*,*,1] are the tau-ff values along line of sight
  ;; in A[*,*,2] are the tau-es values along line of sight
  ;; in A[*,*,3] are the chi-ff values
  ;; in A[*,*,4] are the chi-es values


;  plot,total_tau_es,/ylog,yrange=[total_tau_es[np-3],1.1*max(total_tau_es)]
;  tau_es=0.*total_tau_es
;  for i=0,np-1 do tau_es[i]=max(A[i,*,2])
;  oplot,tau_es,color=rgb(255,0,0)
;  print,(max(tau_es)/tau_es[0])/!dpi
;
;  plot,total_tau_ff,/ylog,yrange=[total_tau_ff[np-3],1.1*max(total_tau_ff)]
;  tau_ff=0.*total_tau_ff
;  for i=0,np-1 do tau_ff[i]=max(A[i,*,1])
;  oplot,tau_ff,color=rgb(255,0,0)
;  print,(max(tau_ff)/tau_ff[0])/!dpi


  R_where_tau_ff_tang_is_tau_core=interpol(p,total_tau_ff,pars.tau_core)
  dummy=R_where_tau_ff_tang_is_tau_core
  if not keyword_set(silent) then $
    print,'tau_p(ff)=2/3 for p=',dummy,' cm'

  W=calculate_W(A,Rgrid,p,pars,R_where_tau_ff_is_tau_core)
  I=get_Intensity(p,A,pars,nu,W,Rgrid)

  total_tau=total_tau_es+total_tau_ff
  tau_p2_3=interpol(p,total_tau,2./3.)
  tau_es2_3=interpol(p,total_tau_es,2./3.)
  tau_ff2_3=interpol(p,total_tau_ff,2./3.)

  endif else begin ;; Take john's intensity profile
    a=read_ascii('DATA_FILES/'+pars.john_file,com='#')
    x=a.field1
    logp=reform(x[0,*])
    logI=reform(x[1,*])
    p=10d0^logp
    I=10d0^logI  ; [erg/cm2/s/Hz/sr]
    Rc=417.6e10
    p=p*Rc     ; [cm]
    p=p*pars.john_scale ;; scaling trick applied to johns 1.25e-3 model!!!
    ;; in order to match the visibilities
    Rstar=Rc
    TAU_P2_3=1d100
    TAU_R2_3=1d100
    TAU_FF2_3=1d100
  endelse

  prad=(p/pars.distance)  ;; [radians]
  Fnu=integrate(prad,2.*!dpi*prad*I,cumul=cumul_Fnu,/givecumul)
  cumul_Fnu=[0.,cumul_Fnu]
  if (not keyword_set(silent)) then $
    print,'Fnu: ',Fnu*1d23,' Jy'

  p50=interpol(p,cumul_Fnu,max(cumul_Fnu/2.))
  hlr=p50 ;; to pass it on to survey.pro!
  if (not keyword_set(silent)) then $
    print,'50% of the flux within ',p50/pars.au,' AU'

  if (pars.make_im_uv ne '') then begin
    image=make_image(p,I,pars,uv=uv,silent=silent)
    if (not keyword_set(silent)) then $
      print,'Total flux in image: Fnu=',total(image),' Jy'
    compute_visibilities,uv,pars,ps=1,chisq=chisq,silent=silent,demo=demo,$
                         john=john
    if (not keyword_set(silent)) then $
      print,'Chi square: ',chisq
  endif

  ;; WHAT FOLLOWS IS JUST PLOTTING SOME RESULTS, CALCULATIONS ARE FINISHED!
  n_p=n_elements(p)

  if (not keyword_set(john)) then begin ;; for johns model we dont have tau

  if (not keyword_set(nodispl)) then $
    window,1,xsize=640,ysize=400,xpos=1000,ypos=0

  mdot=pars.mdot*pars.year/pars.Msun
  if keyword_set(ps) then begin
    postscriptname='POSTSCRIPTS/TAU_PROFILES/tau_'+$
    strtrim(string(1d4*pars.lambda,format='(f10.1)'),2)+'micron'+$
    '_mlr'+strtrim(string(mdot,format='(e12.2)'),2)+'_'+$
    'f'+strtrim(string(pars.f,format='(f10.3)'),2)+'.ps'
    xsize=20
    ysize=16
    set_plot,'ps',/interpolate
    device,file=postscriptname,/portrait,/color,$
      font_size=16.,xsize=xsize,ysize=ysize,yoffset=0,xoffset=2
    charsize=0.6
    TVLCT, [0,255,255,0,0], [0,255,0,255,0], [0,255,0,0,255]
    ;; 0 = black
    ;; 1 = white
  endif else charsize=1.

  
  yrange=[0.25*total_tau[n_p-3],4*max(total_tau)]
  xrange=[1d12,max(p)]
  title=strtrim(string(1d4*pars.lambda,format='(f10.1)'),2)+' micron'
  plot,p,total_tau,/xlog,/ylog,yrange=yrange,xrange=xrange,$
    xtitle='p [cm]',title=title,$
    ytitle='!4s!3'
  oplot,p,total_tau_es,line=1
  oplot,p,total_tau_ff,line=2

  oplot,[Rstar,Rstar],[1d-100,1d100],line=2
  xyouts,1.1*Rstar,0.5*total_tau[n_p-3],'R!B*!N'
  oplot,[tau_p2_3,tau_p2_3],[1d-100,1d100],line=1
  xyouts,1.1*tau_p2_3,0.5*total_tau[n_p-3],'!4s!3!Bp!N=2/3'
  oplot,[tau_R2_3,tau_R2_3],[1d-100,1d100],line=1
  xyouts,1.1*tau_R2_3,0.5*total_tau[n_p-3],'!4s!3!BR!N=2/3'
  oplot,[tau_ff2_3,tau_ff2_3],[1d-100,1d100],line=3
  xyouts,1.1*tau_ff2_3,1.0*total_tau[n_p-3],'!4s!3!Bff,p!N=2/3'


  A=pars.mdot/(4.*!dpi*mu_a*pars.mH*pars.v_inf)

;  tau_es_theory=pars.sig_thom*gamma*A*!dpi/p ;for infinite wind
;  zmax=sqrt(abs(max(Rgrid)^2-p^2))
;  tau_es_theory=pars.sig_thom*gamma*A*2.*atan(zmax/p)/p ; for finite wind
;  oplot,p,tau_es_theory,line=1

;  tau_ff_theory=Kff*(gamma/pars.f)*A^2*(!dpi/2.)/p^3 ;for infinite wind
;  tau_ff_theory=Kff*(gamma/pars.f)*A^2*$
;    (zmax/(p^2*(max(Rgrid))^2)+(1./p^3)*atan(zmax/p)) ; for finite wind
;  oplot,p,tau_ff_theory,line=2

;  plot,p,total_tau_es/tau_es_theory,yrange=[0.95,1.001],/xlog,$
;    xrange=[p[1],max(p)]

;  plot,p,total_tau_es/tau_es_theory,/xlog,$
;    xrange=[p[1],max(p)],yrange=[0.99,1.01]
;  oplot,p,total_tau_ff/tau_ff_theory

  if keyword_set(ps) then begin
    device,/close
    set_plot,'x'
    if (not keyword_set(silent)) then $
      print,'wrote ',postscriptname
  endif

  wset,0
  endif

  if keyword_set(ps) then begin
    postscriptname='POSTSCRIPTS/INTENSITY_PROFILES/intensity_'+$
    strtrim(string(1d4*pars.lambda,format='(f10.1)'),2)+'micron'+$
    '_mlr'+strtrim(string(mdot,format='(e12.2)'),2)+'_'+$
    'f'+strtrim(string(pars.f,format='(f10.3)'),2)+'.ps'
    xsize=20
    ysize=16
    set_plot,'ps',/interpolate
    device,file=postscriptname,/portrait,/color,$
      font_size=16.,xsize=xsize,ysize=ysize,yoffset=0,xoffset=2
    charsize=0.6
    TVLCT, [0,255,255,0,0], [0,255,0,255,0], [0,255,0,0,255]
    ;; 0 = black
    ;; 1 = white
  endif else charsize=1.

  yrange=[0.25*I[n_p-3],4*max(I)]
  title=strtrim(string(1d4*pars.lambda,format='(f10.1)'),2)+' micron'
  plot,p,I,xrange=xrange,yrange=yrange,/ystyle,/xlog,/ylog,$;psym=-1,$
    xtitle='p [cm]',$
    ytitle='!3I!7!Bm!3!N [erg s!A-1!Ncm!A-2!N Hz!A-1!N sr!A-1!N]',$
    title=title,charsize=charsize
  if (pars.plot_john ne '') then $
    plot_john_Ip,pars,silent=silent

  oplot,[Rstar,Rstar],[1d-100,1d100],line=2
  xyouts,1.1*Rstar,0.5*I[n_p-3],'R!B*!N'
  oplot,[tau_p2_3,tau_p2_3],[1d-100,1d100],line=1
  xyouts,1.1*tau_p2_3,0.5*I[n_p-3],'!4s!3!Bp!N=2/3'
  oplot,[tau_R2_3,tau_R2_3],[1d-100,1d100],line=1
  xyouts,1.1*tau_R2_3,0.5*I[n_p-3],'!4s!3!BR!N=2/3'
  oplot,[tau_ff2_3,tau_ff2_3],[1d-100,1d100],line=3
  xyouts,1.1*tau_ff2_3,1.0*I[n_p-3],'!4s!3!Bff,p!N=2/3'

  if not keyword_Set(silent) then $
    print,'p(tau=2/3)=',tau_p2_3,' cm'
;  print,(tau_p2_3/1.3600336e+14)/1.1334

  if keyword_set(ps) then begin
    device,/close
    set_plot,'x'
    if (not keyword_set(silent)) then $
      print,'wrote ',postscriptname
  endif
end
