pro overplot_all_vinci,pars
  a=read_ascii('ASYMMETRY/eta_car_vinci.txt',com='#')
  x=a.field1
  B=reform(x[3,*])
  V2=reform(x[5,*])
  eV2=reform(x[6,*])
  
  low=V2-eV2
  high=V2+eV2
  print,'bla!!!!!!!!!'

  k=B/(1d-2*pars.lambda)/(180.*3600./!dpi)
  plots,k,v2,psym=5
  errplot,k,low,high
end


pro compute_visibilities,uv,pars,ps=ps,chisq=chisq,silent=silent,demo=demo,$
                         john=john
  npix=n_elements(uv[*,0])
  center=floor(npix/2)

  grid=dindgen(center)
  trace=fltarr(2,center)
  trace[0,*]=grid*sin(pars.phi*!dpi/180)+center
  trace[1,*]=grid*cos(pars.phi*!dpi/180)+center
  vis=interpolate(uv,trace[0,*],trace[1,*],cubic=-0.5)
;  vjohn=vis
  vis=(1.-pars.resolved_f)*vis

  npix=n_elements(vis)
  k_pix=dindgen(npix)
  pixelsize_arcsec=pars.pixelsize*2.062648062d5
  k=k_pix/(pixelsize_arcsec*pars.npix_ft)

  mdot=pars.mdot*pars.year/pars.Msun
  if (pars.vis_ps ne '') then begin
    postscriptname='POSTSCRIPTS/VISIBILITY_CURVES/visibility_mlr'+$
    strtrim(string(mdot,format='(e12.2)'),2)+'_'+$
    'f'+strtrim(string(pars.f,format='(f10.3)'),2)+'.ps'
  endif else postscriptname='POSTSCRIPTS/visibility.ps'

  charsize=2.3
  if keyword_set(ps) then begin
    postscriptname=postscriptname
    xsize=18.
    set_plot,'ps',/interpolate
    x_over_y=1.25 ;; ratio x_size/y_size
    device,file=postscriptname,/portrait,/color,bits_per_pixel=24,$
      font_size=16.,xsize=xsize,ysize=(xsize/x_over_y),yoffset=1
    charsize=1.4
  endif else window,1,xsize=500,ysize=500,xpos=0,ypos=100000

  thick=3.
  !p.thick=thick
  !x.thick=thick
  !y.thick=thick
  !p.charthick=thick

  plot,k,vis^2,yrange=[0,0.4],xrange=[0,250],$
    xtitle='spatial frequency (cycles/arcsec)',$
    ytitle='V!A2!N'

;  kjohn=k ;; see above for vjohn!
;  save,kjohn,vjohn,filename='DATA_FILES/john150_vis.dat'

  ;; now plot the data

; new values sent by Markus on 21 11 2002:
;  B        v2      Ev2
;  96.35   4.80e-3  3.13e-4
;  96.35   4.78e-3  2.53e-4
;  95.91   9.94e-3  5.70e-4
;  95.86   8.92e-3  8.93e-4
;  14.26   2.00e-1  1.01e-2
;  14.14   2.04e-1  1.56e-2
;  85.22   2.22e-2  7.78e-4
;  85.03   1.85e-2  5.91e-4
;  62.12   2.49e-2  1.97e-3
;  62.23   2.72e-2  2.04e-3
;  62.23   3.13e-2  2.41e-3
;  62.21   2.47e-2  1.12e-3
;  62.21   2.79e-2  1.15e-3
;  62.19   2.92e-2  2.09e-3


;B_66=[62.12,62.23,62.23,62.21,62.21,62.19]
;V2_66=[2.49e-2,2.72e-2,3.13e-2,2.47e-2,2.79e-2,2.92e-2]
;eV2_66=[1.97e-3,2.04e-3,2.41e-3,1.12e-3,1.15e-3,2.09e-3]
;order=sort(B_66)
;B_66=B_66[order] & V2_66=V2_66[order] & eV2_66=eV2_66[order]
;plot,B_66,V2_66,psym=4,xrange=[62.1,62.3],yrange=[0.02,0.035]
;low=V2_66-eV2_66 & high=V2_66+eV2_66
;errplot,B_66,low,high
;print,stddev(V2_66) ;; 2.54e-3

;Mail from Markus 18.02.03:
;There is some scatter, but roughly the values are (as of Feb 13):

;8m, 14 measurements:
;baseline length: 7.93 - 7.98m
;V^2: 0.229-0.263
;e(V^2): 0.005-0.013

;24m, 17 measurements:
;baseline length: 19.63 - 23.99m
;V^2: 0.123-0.155
;e(V^2): 0.002-0.015


; siderostat data, averaged to 1 point per baseline
; 0.01 error in V2 assumed for all points
  B=[62.1983,14.20,7.955,21.81]
  v2=[0.02753,0.202,0.246,0.139]
  Ev2=[0.00178,0.0129,0.005,0.002]
;  Ev2=0.*B+0.01

;Data by Markus (12.3.03), V2 averages weighted by formal errors,
;B averages weighted by formal errors
;"error" value given here is stddev in occuring values,
;which overestimates especially the error in the 24m point,
;and underestimates the 16m point
;average V^2:       0.25113237 +/-      0.013628665, at B=       7.9050162 m
;average V^2:       0.20583063 +/-     0.0080610168, at B=       14.212582 m
;average V^2:       0.13679404 +/-      0.017410308, at B=       22.299488 m
;average V^2:      0.026057448 +/-     0.0026332451, at B=       62.197731 m
  B=[7.9050162,14.212582,22.299488,62.197731]
  v2=[0.25113237,0.20583063,0.13679404,0.02605744]
  Ev2=[0.013628665,0.008061016,0.017410308,0.002633245]
;  Ev2[2]=0.002 ;; put a smaller error on the 24m point
  Ev2[1]=0.013 ;; 16m point has much larger errors than the scatter (2 points)

  ;; New values and errors (15.3.2003)
  B=[7.9049683,14.205715,22.412300,62.191535]
  v2=[0.25115135,0.20548915,0.13785918,0.02566855]
  Ev2=[0.013622112,0.007778179,0.017587302,0.002640444]
  Ev2[1]=0.013 ;; 16m point has much larger errors than the scatter (2 points)


  ;; New values and errors (07.04.2003)
  B=[7.9046163,14.205558,22.125905,62.199575]
  v2=[0.25128050,0.20616964,0.13247845,0.02602200]
  Ev2=[0.013616442,0.008697413,0.011328906,0.002633462]
  Ev2[1]=0.015 ;; 16m point has much larger errors than the scatter (2 points)
  Ev2=[0.014,0.015,0.01,0.01]

  Ev2=[0.014,0.015,0.01,0.003]

  B=[B,8.458E+01] & v2=[v2,0.0111] & eV2=[Ev2,0.0037] ;; new 140m point

  datak=(B/(1d-2*pars.lambda))*!dpi/(3600.*180.)
  model_v2=interpol(vis^2,k,datak)

  low=v2-Ev2
  high=v2+Ev2

  plots,datak,v2,psym=5
  errplot,datak,low,high

  n=n_elements(v2)
  chisq=total((v2-model_v2)^2/Ev2^2)/(1d0*n)

  if (pars.vis_dataf ne '') then begin
    file='VIS_DATA_FILES/vis_'+$
    strtrim(string(mdot,format='(e12.2)'),2)+'_'+$
    'f'+strtrim(string(pars.f,format='(f10.4)'),2)+'.dat'
    data_v2=v2
    v2=vis^2
    if (not keyword_set(demo)) then $
      save,k,v2,datak,data_v2,Ev2,chisq,filename=file
    if (not keyword_set(silent)) then print,'wrote ',file
  endif

  if keyword_set(john) then begin
    file='VIS_DATA_FILES/vis_john.dat2'
    save,k,v2,datak,data_v2,Ev2,chisq,filename=file
    print,'wrote: ',file
  endif

  if (pars.plot_john ne '') then begin
    if (pars.john_file eq 'IP_2P2_1_25min3') then $
      restore,'DATA_FILES/john125_vis.dat'
    if (pars.john_file eq 'ip_2p2_mum1.5e-3.dat') then $
      restore,'DATA_FILES/john150_vis.dat'

    kjohn=kjohn/pars.john_scale ;; scaling trick in spatial direction(s)
    Vjohn=Vjohn*(1.-pars.resolved_f)
    v2john=vjohn^2
    oplot,kjohn,v2john,line=2

    john_v2=interpol(v2john,kjohn,datak)
    chisq_john=total((data_v2-john_v2)^2/Ev2^2)/(1d0*n)
    if not keyword_set(silent) then $
      print,'Chi square Johns model: ',chisq_john
  endif

  labelx=160
  labely=0.36
  labelystep=0.03
  xyouts,labelx,labely,'MLR: '+strtrim(string(mdot,format='(e12.2)'),2)
  labely=labely-labelystep
  xyouts,labelx,labely,'f: '+strtrim(string(pars.f,format='(f12.3)'),2)
  labely=labely-labelystep
;  xyouts,labelx,labely,'Chi^2: '+strtrim(string(chisq,format='(f12.2)'),2)

;  overplot_all_vinci,pars

  thick=1.
  !p.thick=thick
  !x.thick=thick
  !y.thick=thick
  !p.charthick=thick


  if keyword_set(ps) then begin
    device,/close
    set_plot,'x'
    if (not keyword_set(silent)) then $
    print,'wrote ',postscriptname
  endif

;; siderostat data

B_sids=[14.26,$
14.14,$
62.12,$
62.23,$
62.23,$
62.21,$
62.21,$
62.19,$
7.955,$
19.63,$
23.99]

V2_sids=[2.00e-1,$
2.04e-1,$
2.49e-2,$
2.72e-2,$
3.13e-2,$
2.47e-2,$
2.79e-2,$
2.92e-2,$
0.246,$
0.155,$
0.123]

eV2_sids=[1.01e-2,$
1.56e-2,$
1.97e-3,$
2.04e-3,$
2.41e-3,$
1.12e-3,$
1.15e-3,$
2.09e-3,$
0.01,$
0.01,$
0.01]

;UT data

B_UTs=[96.35,$
96.35,$
95.91,$
95.86,$
85.22,$
85.03]

V2_UTs=[4.80e-3,$
4.78e-3,$
9.94e-3,$
8.92e-3,$
2.22e-2,$
1.85e-2]

eV2_UTs=[3.13e-4,$
2.53e-4,$
5.70e-4,$
8.93e-4,$
7.78e-4,$
5.91e-4]
end
