function integrate,x,f,cumul=cumul,givecumul=givecumul
  n=n_elements(x)
  if(n_elements(f) ne n) then begin
     print,"Error in function integrate: x and f not equally long"
     stop 
  endif
  sign=2.d0*(x[n-1] gt x[0])-1.d0

  f_i=f[1:n-1]
  f_im1=f[0:n-2]
  x_i=x[1:n-1]
  x_im1=x[0:n-2]

  contritutions=0.5d0*(f_i+f_im1)*(x_i-x_im1)
  int=total(contritutions)

  if keyword_set(givecumul) then begin
    cumul=0.*contritutions
    cumul[0]=contritutions[0]
     for i=1,n-2 do cumul[i]=cumul[i-1]+contritutions[i]
  endif

  return,int*sign
end
