function integrate2,x,f,cumul=cumul,plot=plot
;; this function integrates f*exp(-x) over x !!!
;;
n=n_elements(x)
cumul=dblarr(n)
if(n_elements(f) ne n) then begin
   print,"Error in function integrate: x and f not equally long"
   stop 
endif
int=0.d0
  for i=1,n-1 do begin
    if ((x[i]-x[i-1]) eq 0.) then dI=0. else begin
      b=(f[i]-f[i-1])/(x[i]-x[i-1])
      a=f[i-1]-b*x[i-1]
      dI=(a+b)*(exp(-x[i-1])-exp(-x[i]))+$
               b*(x[i-1]*exp(-x[i-1])-x[i]*exp(-x[i]))
    endelse 
    int=int+dI

    if keyword_set(plot) then print,dI,b,x[i],x[i-1]
    cumul[i]=int
  endfor
  return,int
end
