@simple_model
@~/idl/find_opt

pro little_survey,first=first
  params=read_parameters('parameters.txt')
  params.vis_ps=''      
  params.make_im_uv='x'  ;; make sure to make images/vis curves!
  use_f_law=''           ;; constant clumping for now
  params.include_ff='x'    ;; \ make sure to use both ff
  params.include_es='x'    ;; / and es opacities

  mdotmin=1.3d-3
  mdotmax=1.8d-3

  nmdot=16
  mdot=mdotmin+(mdotmax-mdotmin)*dindgen(nmdot)/(nmdot-1.)
  chisquare=0.*mdot & flux=0.*mdot & half_light_r=0.*mdot
  

  filename='DATA_FILES/test_best_solution.dat'
  if keyword_set(first) then begin
    for i=0,nmdot-1 do begin
      print,i
      pars=params
      pars.mdot=mdot[i]
      pars.f=0.1*(pars.mdot*1000.)^2
      simple_model,pars=pars,chisq=chisq,/silent,/ps,hlr=hlr,Fnu=Fnu,/nodispl
      chisquare[i]=chisq
      flux[i]=Fnu*1d23
      half_light_r[i]=hlr
    endfor
    save,mdot,chisquare,filename=filename
  endif else restore,filename

  chisq=chisquare
  plot,mdot,chisq,yrange=[0,4],psym=-4
  c=poly_fit(mdot,chisq,2)
  x=dindgen(1000)/100.+1.
  y=poly(x,c)
  oplot,x,y,color=rgb(255,0,0)

  print,flux

end
