function make_p_grid,Rgrid,pars
  theta=(!dpi/2)*dindgen(pars.np_inRstar+1)/(pars.np_inRstar) ;;=p/Rstar
  cos_theta=cos(theta)
  p=cos_theta*pars.Rstar
  p=rotate(p,2)
  p[0]=0.
  p=p[0:n_elements(p)-2]
  p=[p,Rgrid]
  return,p
end

function make_R_grid,p
  real_nR=p.nR
  nextra=5
  p.nR=real_nR-nextra

  nfine=p.nR*p.Rfine_fac
  logRfine=alog(p.Rstar)+dindgen(nfine)*alog(p.Rout/p.Rstar)/(nfine-1)
  Rfine=exp(logRfine)

  Vfine=p.V0+(p.v_inf-p.V0)*(1.-Rfine/p.Rout)^p.beta
  rho_fine=p.mdot/(4.*!dpi*Rfine^2*Vfine)

  rho_min=min(rho_fine) & rho_max=max(rho_fine)
  log_rho=alog(rho_min)+dindgen(p.nR)*alog(rho_max/rho_min)/(p.nR-1)
  rho=exp(log_rho)
  rho=rotate(rho,2)

  R=interpol(Rfine,rho_fine,rho)
  logRextra=dindgen(nextra+2)*alog(R[p.nR-1]/R[p.nR-2])/(nextra+1.)+alog(R[p.nR-2])
  Rextra=exp(logRextra)
  R=[R[0:p.nR-3],Rextra]
  p.nR=real_nR
  R[p.nR-1]=p.Rout

  return,R
end

function make_z_grid,p,Rgrid,pars
  if (max(Rgrid) gt p) then begin 
    R=Rgrid[where(Rgrid gt p)]
    z=sqrt(abs(R^2-p^2))

    if ((p/pars.Rstar-1d0) gt -1d-10) then z=[-rotate(z,2),0.,z] $
    else z=-rotate(z,2)
  endif else begin
    z=[-1.,0,1.] ;; dummy grid [cm] for last point in model where z=0
  endelse
  if (z[1] le z[0]) then z[0]=z[1]-1d0

  return,z
end
