function make_grid,pars
  npix=pars.npix
  im=fltarr(npix,npix)
  center=floor(npix/2)

  dummy=dindgen(npix)
  im1=im
  im2=im
  for i=0,npix-1 do begin
    im1[*,i]=dummy
    im2[i,*]=dummy
  endfor

  im1=im1-center
  im2=im2-center
  im=sqrt(im1^2.+im2^2.) ;; contains distance to center in pixels
  im=im*pars.distance*pars.pixelsize ;; distance to center [cm]

  return,im
end

function make_uv,image,pars
  npix=pars.npix
  npix_ft=pars.npix_ft
  if (npix gt npix_ft) then begin
    npix_ft=npix
    pars.npix_ft=npix_ft
  endif

  big_image=fltarr(npix_ft,npix_ft)
  big_image[0:n_elements(image[*,0])-1,0:n_elements(image[0,*])-1]=image

  ft_image=fft(big_image,-1)
  ft_image=shift((abs(ft_image)/abs(ft_image[0,0])),$
                      npix_ft/2,npix_ft/2)

  low=floor(npix_ft/2)-floor(npix/2)
  high=floor(npix_ft/2)+floor(npix/2)-1
  uv=ft_image[low:high,low:high]
  return,uv
end


function make_image,p,I,pars,uv=uv,silent=silent
  grid=make_grid(pars)
  if (not keyword_set(silent)) then begin
    pmax_grid=max(grid)/sqrt(2.)
    print,'maximum p fully within image: ',pmax_grid,' cm'
    print,'maximum p in model: ',max(p)
  endif
  wind=interpol(I,p,grid) ;; intensities [erg/s/cm2/Hz/sr]
  wind=wind*1d23*pars.pixelsize^2 ;; I [Jy/pix]
  wind[where(grid gt max(p))]=0d0
  
  uv=make_uv(wind,pars)   ;; the uv plane
;  mwrfits,wind,'wind.fits'
  return,wind
end
