function planck,nu,T,cgs=cgs
  ;; input: frequency (scalar or array) [Hz]
  ;;        T [K]
  ;;
  ;; output: B_nu [W/m2/Hz/sr]
  ;; or erg/s/cm2/Hz/sr, if keyword /cgs is set

  ;; the planck function:
  ;; B_nu=(2*h*nu^3/c^2)*(1/(exp(h*nu/k*T)-1))
  h=6.6262d-34
  k=1.3807d-23
  c=2.9979d8
  if keyword_set(cgs) then begin
    h=6.6262d-27
    k=1.3807d-16
    c=2.9979d10
  endif

  B_nu=(2d0*h*nu^3d0/c^2d0)*(1d0/(exp(h*nu/(k*T))-1d0))
  return,B_nu
end
