function check_number,value
  n=strlen(value)
  a='0123456789.de-' ;; 
  na=strlen(a)
  if (n ne 0) then result='true' $
    else result='false';; assume that value is a valid number

  for i=0,n-1 do begin
    value_i=strmid(value,i,1)
    i_number='false'
    for j=0,na-1 do begin
      a_i=strmid(a,j,1)
      if (value_i eq a_i) then i_number='true' ;; ith element is a number
    endfor
    ;; can be a minus sign!
    if (i_number eq 'false') then result='false'
  endfor

  return,result
end

function read_parameters,parameter_file

  openr,lun,parameter_file,/get_lun
  
  line=''
  i=0
  while (not eof(lun)) do begin
    readf,lun,format='(a0)',line
    if (((line eq '') or (strtrim(strmid(line,0,1),2) eq ';')) $
    and (not eof(lun))) then begin
      readf,lun,format='(a0)',line
      while (((line eq '') or (strtrim(strmid(line,0,1),2) eq ';')) $
      and (not eof(lun))) do readf,lun,format='(a0)',line
    endif
    if ((line eq '') and eof(lun)) then begin
      close,lun
      free_lun,lun
      return,params
    endif
    ispos=strpos(line,'=')   ;; position of the = sign
    compos=strpos(line,';')  ;; position of the beginning of the comments (;)
    if (compos eq -1) then compos=strlen(line)
    name=strtrim(strmid(line,0,ispos),2)
    value=strtrim(strmid(line,ispos+1,compos-ispos-1),2)

    if (check_number(value) eq 'false') then begin
      value=string(value)
    endif else begin
      value=double(value)
    endelse
    if (i eq 0) then params=create_struct(name,value) else $
    params=create_struct(params,name,value)
    i=i+1
  endwhile

  close,lun
  free_lun,lun
  return,params
end
