pro plot_john_Ip,pars,silent=silent
  a=read_ascii('DATA_FILES/IP_2P2_1_25min3',data_start=6)
  x=a.field1
  logp=reform(x[0,*])
  logI=reform(x[1,*])
  p=10d0^logp
  I=10d0^logI  ; [erg/cm2/s/Hz/sr]
  Rc=417.6e10
  p=p*Rc     ; [cm]
  p=p*pars.john_scale ;; scaling trick applied to johns 1.25e-3 model!!!
  ;; in order to match the visibilities

  oplot,p,I,line=4

  prad=p/pars.distance ; [radians] ,OK
  Fnu=integrate(prad,2.*!dpi*prad*I,cumul=cumul_Fnu,/givecumul)
  cumul_Fnu=[0.,cumul_Fnu]
  p50=interpol(p,cumul_Fnu,0.5*Fnu) ; [cm]

  oplot,[Rc,Rc],[1d-100,1d100],line=4

  if not keyword_set(silent) then begin
    print,'Flux in Johns model: ',Fnu*1d23,' Jy'
    print,'In Johns model 50% of the flux is within ',p50/pars.au,' AU'
  endif
end


function convert_to_cgs,p
  p.Mdot=p.Mdot*p.Msun/p.year ;; [g/s]
  p.v_inf=p.v_inf*1d5         ;; [cm/s]
  p.v0=p.v0*1d5               ;; [cm/s]
  p.Rstar=p.Rstar*p.Rsun      ;; [cm]
  p.Rin=p.Rin*p.Rstar         ;; [cm]
  p.Rout=p.Rout*p.Rsun        ;; [cm]
  p.lambda=p.lambda*1d-4      ;; [cm]
  p.Lstar=p.Lstar*p.Lsun      ;; [erg/s]
  p.distance=p.distance*p.pc  ;; [cm]
  p.pixelsize=p.pixelsize/2.062648062d8 ;; [rad]
  p.v_cl=p.v_cl*1d5           ;; [cm/s]

  return,p
end

function get_Tstar,pars
  T4=pars.Lstar/(4.*!dpi*pars.Rstar^2*pars.sig_SB)
  T=T4^0.25
  return,T
end

function B,nu,T
  ;; gives the planck function in cgs units
  Bnu=planck(nu,T) ;; [W/m2/Hz/sr]
  return,Bnu*1d3   ;; [erg/s/cm2/Hz/sr]
end
