@simple_model
@~/idl/find_opt

pro order,reduced_chisq,mdot,f
  n=25
  ;n_elements(reduced_chisq)-1
  for i=0,n do begin
    min=find_opt(reduced_chisq,min_max='min')
    print,i,reduced_chisq[min[0],min[1]],format='(i4,f8.2,$)'
    print,strtrim(string(mdot[min[0]],format='(e12.2)'),2),format='(a10,$)'
    print,strtrim(string(f[min[1]],format='(f10.3)'),2),format='(a10)'
    reduced_chisq[min[0],min[1]]=1d100
  endfor
end

pro survey,first=first,ps=ps,smooth=smooth,size=size,mas=mas,flux=flux,$
           order=order
  params=read_parameters('parameters.txt')
  params.vis_ps='x'      ;; make postscript files for all models
  params.make_im_uv='x'  ;; make sure to make images/vis curves!
  use_f_law=''           ;; constant clumping for now
  params.include_ff='x'    ;; \ make sure to use both ff
  params.include_es='x'    ;; / and es opacities

  fmin=0.001
  fmax=1.0
  nf=64

  mdotmin=0.1e-3
  mdotmax=3.0e-3
  nmdot=64

  logf=dindgen(nf)*alog(fmax/fmin)/(nf-1)+alog(fmin)
  f=exp(logf)
  mdot=dindgen(nmdot)*(mdotmax-mdotmin)/(nmdot-1)+mdotmin

  filename='DATA_FILES/chisquare.dat'

  if keyword_set(first) then begin
    chisquare=fltarr(nmdot,nf) & half_light_r=fltarr(nmdot,nf)
    Flux_Jy=fltarr(nmdot,nf)
    for i=0,nmdot-1 do begin
      for j=0,nf-1 do begin
        print,i,j
        pars=params
        pars.mdot=mdot[i]
        pars.f=f[j]
        simple_model,pars=pars,chisq=chisq,/silent,/ps,hlr=hlr,Fnu=Fnu,/nodispl
        chisquare[i,j]=chisq
        half_light_r[i,j]=hlr
        flux_Jy[i,j]=Fnu*1d23
      endfor
    endfor
    save,mdot,f,params,chisquare,half_light_r,flux_Jy,filename=filename
  endif else restore,filename

  ndata=4
  nparams=2
  reduced_chisq=chisquare*1d0*ndata/(1d0*ndata-1d0*nparams)

  if keyword_set(order) then begin
    order,reduced_chisq,mdot,f
    return
  endif

  min=find_opt(reduced_chisq,min_max='min')
  print,'Lowest chi-square that occurs: ',reduced_chisq(min[0],min[1])
  print,'for mdot=',mdot[min[0]],' and f=',f[min[1]]

 
  landscape=1
  if (landscape eq 1) then begin
    xoffset=0.5
    yoffset=28
    xsize=25
  endif else begin
    xoffset=0
    yoffset=1
    xsize=18
  endelse

  if keyword_set(ps) then begin
    postscriptname='POSTSCRIPTS/chi_square_contours.ps'
    xsize=xsize
    set_plot,'ps',/interpolate
    x_over_y=1.25 ;; ratio x_size/y_size
    device,file=postscriptname,landscape=landscape,/color,bits_per_pixel=24,$
      font_size=16.,xsize=xsize,ysize=(xsize/x_over_y),yoffset=yoffset,$
      xoffset=xoffset
    charsize=1.
    c_charsize=0.5
  endif else begin
    charsize=1.2
    c_charsize=0.8
  endelse

  mdot=mdot*1d3 ;; in units of 10^-3 msun/yr

  if keyword_set(smooth) then begin ;; smooth the contours
    x=0.*chisquare & y=x
    for i=0,n_elements(x[0,*])-1 do x[*,i]=mdot
    for i=0,n_elements(y[*,0])-1 do y[i,*]=f
    chisquare=MIN_CURVE_SURF(chisquare,x,y,xout=mdot,yout=f)
  endif

;  chisq_LEVELS=[0.5,0.8,1.3,2.5,5.0,10.0,20.,40.,80.,160.]
  chisq_LEVELS=[0.6,1.0,1.5,2.0,5.0,10.0,20.,40.,80.,160.,320.]
  chisq_C_labels=fix(0.*chisq_levels+1)
  CONTOUR,reduced_chisq,mdot,f,levels=chisq_LEVELS,C_LABELS=chisq_C_LABELS,$
    xtitle='Mass Loss Rate [10!A-3!N M!B!9n!3!N yr!A-1!N]',$
    ytitle='Clumping factor',/ylog,c_charsize=c_charsize,charsize=charsize,$
    title='reduced !4v!3!A2!N of fit',xrange=[0.1,2.]

;  plots,1.43,0.2045,psym=4
;  plots,1.5,0.225,psym=4
  plots,1.6,0.256,psym=4
  john_f=0.1*(mdot)^2
  oplot,mdot,john_f,line=2

  if keyword_set(ps) then begin
    device,/close
    set_plot,'x'
    if (not keyword_set(silent)) then $
    print,'wrote ',postscriptname
  endif

  min=find_opt(reduced_chisq,min_max='min')
  print,'Lowest chi-square that occurs: ',reduced_chisq(min[0],min[1])
  print,'for mdot=',mdot[min[0]],' and f=',f[min[1]]

  if keyword_set(size) then begin
    grey=165
    if keyword_set(ps) then begin
      if keyword_set(mas) then begin 
        postscriptname='POSTSCRIPTS/half_light_radii_mas.ps' 
        title='Half light radius of model [mas]'
      endif else begin
        postscriptname='POSTSCRIPTS/half_light_radii_cm.ps'
        title='Half light radius of model [cm]'
      endelse
      xsize=xsize
      set_plot,'ps',/interpolate
      x_over_y=1.25 ;; ratio x_size/y_size
      device,file=postscriptname,landscape=landscape,/color,bits_per_pixel=24,$
        font_size=16.,xsize=xsize,ysize=(xsize/x_over_y),yoffset=yoffset,$
        xoffset=xoffset
      charsize=1.
      c_charsize=0.5
      TVLCT, [0,255,grey], [0,255,grey], [0,255,grey]
      ;; 0 = black
      ;; 1 = white
      ;; 2 = grey
    endif else begin
      charsize=1.2
      c_charsize=0.8
    endelse

    if keyword_set(mas) then begin
      half_light_r=half_light_r/params.au ;; in AU
      half_light_r=half_light_r/params.distance ;; in arcsec
      half_light_r=half_light_r*1000. ;; in mas
    endif

    mwrfits,half_light_r,'hlr.fits',/create
    print,'wrote hlr.fits'

    if keyword_set(ps) then color=2 else color=rgb(grey,grey,grey)
    CONTOUR,reduced_chisq,mdot,f,levels=chisq_LEVELS,C_LABELS=chisq_C_LABELS,$
      xtitle='Mass Loss Rate [10!A-3!N M!B!9n!3!N yr!A-1!N]',$
      ytitle='Clumping factor',/ylog,c_charsize=c_charsize,charsize=charsize,$
      color=color,xrange=[0.1,2.]

    plots,1.43,0.2045,psym=4,color=color
    john_f=0.1*(mdot)^2
    oplot,mdot,john_f,line=2,color=color


    if keyword_set(mas) then levels=[0.5,1.,1.5,2.,2.5,3.,4.,5.,6.,7.,8.] $
      else $
    levels=1d13*[1.,2.,3.,4.,5.,6.,7.,8.,9.,10.,12.,14.,16.,18.,20.,22.,24.]

    C_LABELS=fix(0.*levels+1)

    CONTOUR,half_light_r,mdot,f,levels=levels,C_LABELS=C_LABELS,$
      xtitle='Mass Loss Rate [10!A-3!N M!B!9n!3!N yr!A-1!N]',$
      ytitle='Clumping factor',/ylog,c_charsize=c_charsize,charsize=charsize,$
      title=title,xrange=[0.1,2.],/noerase


    if keyword_set(ps) then begin
      device,/close
      set_plot,'x'
      if (not keyword_set(silent)) then $
      print,'wrote ',postscriptname
    endif
  endif

  if keyword_set(flux) then begin
    grey=165
    if keyword_set(ps) then begin
      postscriptname='POSTSCRIPTS/fluxes_Jy.ps'
      title='!3F!7!Bm,!3!N [Jy]'
      xsize=xsize
      set_plot,'ps',/interpolate
      x_over_y=1.25 ;; ratio x_size/y_size
      device,file=postscriptname,landscape=landscape,/color,bits_per_pixel=24,$
        font_size=16.,xsize=xsize,ysize=(xsize/x_over_y),yoffset=yoffset,$
        xoffset=xoffset
      charsize=1.
      c_charsize=0.5
      TVLCT, [0,255,grey], [0,255,grey], [0,255,grey]
      ;; 0 = black
      ;; 1 = white
      ;; 2 = grey
    endif else begin
      charsize=1.2
      c_charsize=0.8
    endelse

    if keyword_set(ps) then color=2 else color=rgb(grey,grey,grey)
    CONTOUR,reduced_chisq,mdot,f,levels=chisq_LEVELS,C_LABELS=chisq_C_LABELS,$
      xtitle='Mass Loss Rate [10!A-3!N M!B!9n!3!N yr!A-1!N]',$
      ytitle='Clumping factor',/ylog,c_charsize=c_charsize,charsize=charsize,$
      color=color,xrange=[0.1,2.]

    plots,1.43,0.2045,psym=4,color=color
    john_f=0.1*(mdot)^2
    oplot,mdot,john_f,line=2,color=color


    levels=[1e2,2e2,3e2,4e2,5e2,6e2,8e2,1e3,1.5e3,2e3,3e3,5e3,1e4]
    C_LABELS=fix(0.*levels+1)

    CONTOUR,flux_Jy,mdot,f,levels=levels,C_LABELS=C_LABELS,$
      xtitle='Mass Loss Rate [10!A-3!N M!B!9n!3!N yr!A-1!N]',$
      ytitle='Clumping factor',/ylog,c_charsize=c_charsize,charsize=charsize,$
      title=title,xrange=[0.1,2.],/noerase

    if keyword_set(ps) then begin
      device,/close
      set_plot,'x'
      if (not keyword_set(silent)) then $
      print,'wrote ',postscriptname
    endif
  endif


end
