pro test_scaling_laws
  ;; only free-free opacity switched on
  ;; mdot = 1e-3

  ;v0=5 km/s
  ;result:
  ;r50 scales as f to the power:     -0.329946 (should be -1/3)
  ;Fnu scales as f to the power:     -0.627230 (should be -2/3)
  f=[0.05,0.1,0.2,0.4]
  r50=[2.937,2.336,1.858,1.479]
  Fnu=[694.75,447.32,289.47,188.56]

  ;v0=v_inf=500 km/s
  ;result:
  ;r50 scales as f to the power:     -0.331400 (should be -1/3)
  ;Fnu scales as f to the power:     -0.664958 (should be -2/3)
  f=[0.05,0.1,0.2,0.4]
  r50=[2.9403208,2.3376019,1.8579096,1.4760665]
  Fnu=[642.42153,405.29642,255.61886,161.17882]

;  plot,f,r50,/xlog,/ylog,psym=-4
;  plot,f,Fnu,/xlog,/ylog,psym=-4

  logf=alog(f)
  logr=alog(r50)
  logFnu=alog(Fnu)

  c=poly_fit(logf,logr,1)
  print,'r50 scales as f to the power: ',c[1],' (should be -1/3)'

  c2=poly_fit(logf,logFnu,1)
  print,'Fnu scales as f to the power: ',c2[1],' (should be -2/3)'

end






