;------------------------------------------------------------------
function recog_station, name
letter=' '
letter=strmid(name,0,1)
number=fix(strmid(name,1,1))

case letter of
'A': let=1
'B': let=3
'C': let=9
'D': let=13
'E': let=16
'G': let=17
'H': let=20
'I': let=20
'J': let=21
'K': let=28
'L': let=29
'M': let=30

endcase

pos=number+let
return, pos
end
;------------------------------------------------------------------
pro check_vig, stat1,stat2,ra,dec,date,time,exptime,norun=norun
if N_PARAMS() lt 7 then begin
    print, 'USE:'
    print, 'check_vig stat1,stat22,ra,dec,date,time,exptime'
    print, 'EXAMPLE:'
    print, '-----------------------------------------------------------------'
    print, 'check_vig, ''A1'',''E2'',[18,17,37],[-36,45,40],[2003,09,23],[1,20],60.'
    print, '-----------------------------------------------------------------'
    return
endif
loadct, 3
if not keyword_set(norun) then norun=0
openw, lun, 'param.txt',/get_lun
printf, lun, 5,',',recog_station(stat1),',',recog_station(stat2),',',10,',',10
close, lun
free_lun, lun
plot_vig, norun=norun
star_position,ra,dec,date,time,exptime 
end
;------------------------------------------------------------------

pro plot_vig, norun=norun
if not keyword_set(norun) then spawn, './a.out'
a=read_ascii('output_idl.1.txt',comment=";")
tab1=a.field1
a=read_ascii('output_idl.2.txt',comment=";")
tab2=a.field1

r=90.-tab1[1,*]
theta=(tab1[0,*]-90.)*!pi/180.

z=(1.-tab1[2,*])*(1-tab2[2,*])
for i=0,n_elements(z)-1 do begin
z[i]=max([tab1[2,i],tab2[2,i]])
endfor
z=1.-z

;print, z
lev=findgen(30)/30.
polar_contour,z,theta,r,levels=lev,fill=1,xrange=[-90,90],yrange=[-90,90],xstyle=1,ystyle=1,/isotropic
circ_theta=(findgen(9)+1)*10.
circ_r=90.-circ_theta
r1=theta
for i=10,80,10 do begin
r1[*]=i
;r1=reform(r1,n_elements(r1))
;theta=reform(theta,n_elements(r1))

;help, r1, theta
oplot, /polar, r1,theta,psym=-3,color=150
xyouts, -14.,r1[0]+2,string(fix(90-r1[0])),color=150
endfor
oplot, [0,0],[-90,90],psym=-3,color=150
oplot, [-90,90],[0,0],psym=-3,color=150
end
;------------------------------------------------------------------
pro star_position,ra,dec,date,time,exptime
time_h=(time[0]*60.+time[1])/60.
jdcnv, date[0],date[1],date[2],time_h,julian1
jdcnv, date[0],date[1],date[2],time_h+exptime/60.,julian2
julian=(findgen(10)/9.)*(julian2-julian1)+julian1

print, 'runing issshadow....'
plot_vig, /norun
print, 'done'
plotsym, 0, 4, FILL=1
for i=0,9 do begin

if i eq 0 or i eq 9 then begin 
eq2hor, ten(ra[0],ra[1],ra[2])*15.,ten(dec[0],dec[1],dec[2]),julian[i],alt,az,lat=ten(-24.,40.,0.),lon=ten(-70.,25.,0.),altitude=2400.,/verbose;,pres=980.,temp=283.0
endif else begin
eq2hor, ten(ra[0],ra[1],ra[2])*15.,ten(dec[0],dec[1],dec[2]),julian[i],alt,az,lat=ten(-24.,40.,0.),lon=ten(-70.,25.,0.),altitude=2400.;,pres=980.,temp=283.0
endelse
oplot, /polar, [90.-alt],[(90.-az)*!pi/180.],psym=8,color=150
endfor

end
;------------------------------------------------------------------

