/*******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: issshadowConstants.h,v 1.8 2001/09/13 09:12:34 vltsccm Exp $"
*
* who       when        what
* --------  ----------  ----------------------------------------------
* nhousen   2001-07-11  added issshadowMOD
* rwilhelm  2001-07-10  created 
*/

/************************************************************************
*   NAME
*   issshadowConstants.h
*
*   SYNOPSIS
*
*
*   DESCRIPTION
*   Contains all constant definitions for the package 'issshadow'.
*
*   PARENT CLASS
*
*
*   DESCRIPTION
*   
*
*   PUBLIC METHODS
*
*   PUBLIC DATA MEMBERS
*
*
*   PROTECTED METHODS
*
*
*   PROTECTED DATA MEMBERS
*
*
*   PRIVATE METHODS
*
*
*   PRIVATE DATA MEMBERS
*
*
*   FILES
*
*   ENVIRONMENT
*
*   COMMANDS
*
*   RETURN VALUES
*
*   CAUTIONS
*
*   EXAMPLES
*
*   SEE ALSO
*
*   BUGS
*
*------------------------------------------------------------------------
*/

#define issshadowMOD "issshadow"

#define MAXIMUM_STRING_LENGTH 255
/* maximum length of different strings */

#define MAXIMUM_NUMBER_OF_SURFACES 100

#define PI        3.141592653589793238e+00
/* value taken from MATHEMATICA, -set to a higher precision on June 22, 1999.
   Why? Example: Phase k*z with k=2*pi/lambda, lambda = 1e-06 m and z = 1km
   We should get a Phase of zero, as a multiple of 1e-06 fits exactly inside 1km. 
   (1) if we take pi = 3.141592654 --> Phase = 6.283185308000000e+09
              --> (cos(Phase),sin(Phase)) = (6.819186241461076e-01, 7.314280484385868e-01)
   (2) if we take pi = 3.141592653589793 --> Phase = 6.283185307179587e+09
              --> (cos(Phase),sin(Phase)) = (9.999999999993591e-01, 1.132200850406420e-06)
   The correct (cos,sin) pair would be (1,0) --> (2) is much better than (1) */
#define TWO_PI    6.283185307179586477e+00

#define SITE_ANGLE 18.984
/* angle (deg) between North direction and positive v-axis */

#define RADIUS_M1_UT  4.09
#define RADIUS_M1_AT  0.91
#define RADIUS_M1_SID 0.20
/* radii (in units of meter) of the primary mirrors (M1) of UT, AT and SID */

/* ---------------------------------------------------------- */
/* Constants for angle unit conversion                        */
/* ---------------------------------------------------------- */
#define DEG_2_RAD 1.745329251994330e-02 /* Pi/180 */
#define RAD_2_DEG 5.729577951308232e+01 /* 180/Pi */


