/*******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: issshadowMain.c,v 1.8 2001/09/13 09:12:40 vltsccm Exp $"
*
* who      when        what
* -------- ----------  ----------------------------------------------
* nhousen  2001-09-05  corrected representation of shadowing 
*                      (a value of 0 means no shadowing instead of full shadowing)
*                      reduced number of included header files
* nhousen  2001-07-11  adapted error handling to VLT standard
* rwilhelm 2001-07-10  created 
*/

/************************************************************************
*   NAME
*   issshadowMain.c
*
*   SYNOPSIS
*
*
*   DESCRIPTION
*   Contains the source code of the 'issshadowAltAz' library.
*   For a description of input and output variables, see below.
*
*   PARENT CLASS
*
*
*   DESCRIPTION
*   
*
*   PUBLIC METHODS
*
*   PUBLIC DATA MEMBERS
*
*
*   PROTECTED METHODS
*
*
*   PROTECTED DATA MEMBERS
*
*
*   PRIVATE METHODS
*
*
*   PRIVATE DATA MEMBERS
*
*
*   FILES
*
*   ENVIRONMENT
*
*   COMMANDS
*
*   RETURN VALUES
*
*   CAUTIONS
*
*   EXAMPLES
*
*   SEE ALSO
*
*   BUGS
*
*------------------------------------------------------------------------
*/

/* #define _POSIX_SOURCE 1 */
/* #include "vltPort.h" */
/*
static char *rcsId="@(#) $Id: issshadowMain.c,v 1.8 2001/09/13 09:12:40 vltsccm Exp $";
static void *use_rcsId = ((void)&use_rcsId,(void *) &rcsId);
*/


/* Standard ANSI C Includes */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>

#include "issshadowDefines.h"
#include "issshadowErrors.h"
/*
#include "err.h"
*/
#include "issshadowDummy.h"

ccsCOMPL_STAT tamere;

ccsCOMPL_STAT issshadowAltAz(/* INPUT ARGUMENTS                            */
                    /* ------------------------------------------ */
                    double alt,
                    /* Altitude angle in degrees (range: 0...90 deg) */
                    double az,
                    /* Azimuth angle in degrees (range: 0...360 deg);
                       Azimuth is zero when pointing towards the South;
                       Azimuth is increasing Eastwards. */
                    int teltype,
                    /* Indicates the type of telescope:
                       UT = 1, AT = 4, SID = 5 */
                    int location,
                    /* Indicates the station where the telescope is located:
                       A0 = 1, A1 = 2, ..., M0 = 30, U1 = 31, ..., U4 = 34 */
                    int noofRayRadial,
                    int noofRayAngular,
                    /* These 2 parameters define the ray grid that is used
                       for the ray tracing:
                       'noofRayRadial' ==> defines the number of radial
                                           segments in the ray grid.
                                           Minimum value = 0 (ray grid consists
                                                              of one single ray)
                       'noofRayAngular' ==> defines the number of angular segments
                                            ('cake pieces') of the ray grid.
                                            Minimum value = 1 (one single ray) */
                    
                    /* OUTPUT ARGUMENTS                           */
                    /* ------------------------------------------ */
                    double *shadow,
                    /* Value between 0 and 1 that defines the percentage of
                       partial vignetting: 0 ==> NO VIGNETTING, 1 ==> FULL VIGNETTING;
                       Note that the 'resolution' (i.e. the step size with which
                       'shadow' can vary, depends on the total number of rays used. */
		    ccsERROR *error
                    )
{
    /* LOCAL VARIABLES */
    /* --------------- */
    float u_Axis[3],
          v_Axis[3],
          w_Axis[3];
    /* The 3 axes setting up the VLTI site coordinate system {u, v, w} */
    TelescopeStruct *Telescope;
    /* Holds the telescope data (Type, Station, Location in (u, v)-plane) */
    SurfaceStruct *Surface;
    /* Contains the list of obstructing surfaces. The list is filled below in
       the routine 'DefineVignettingSurfaces'. */
    long NumberOfSurfaces;
    /* The number of obstructing surfaces. This number contains also 'not active'
       surfaces! (if there are some ...). The number is set in the
       routine 'DefineVignettingSurfaces'. */
    BeamStruct *Beam;
    /* Holds information on the ray grid used for the ray tracing */
    float East_Axis[3],
          North_Axis[3],
          Zenith_Axis[3];
    /* The East, North and Zenith axes defined w.r.t. the VLTI site coordinate system
       {u, v, w}. The positive North axis is obtained by rotating the positive v-axis
       in the {u, v}-plane by an angle of SITE_ANGLE = 18.984 (defined in the include
       file 'issshadowConstants.h' (rotation direction: clockwise) */

    /* Define the VLTI site coordinate system {u, v, w} */
    DefineVLTISiteCoordinateSystem(u_Axis, v_Axis, w_Axis);

    /* Allocate memory for pointers */
    Beam = AllocateMemoryForBeamPointer();
    Telescope = AllocateMemoryForTelescopePointer();
    Surface = AllocateMemoryForSurfaces();

    /* Parse input arguments */
    if ( ParseInputArguments(alt, az, teltype, location, noofRayRadial, noofRayAngular, Telescope, Beam, error) == FAILURE )
      {
        errAdd(error, issshadowMOD, issshadowERR_PARSING_INPUT, __FILE__, "", "");
        return(FAILURE);
      }

    /* Define the obstructing surfaces (telescope domes, walls etc.) */
    if ( DefineVignettingSurfaces(Surface, &NumberOfSurfaces, u_Axis, v_Axis, w_Axis, error) == FAILURE )
      {
        errAdd(error, issshadowMOD, issshadowERR_DEF_VIGNETTING_SURF, __FILE__, "", "");
        return(FAILURE);
      }

    /* If the chosen telescope is a UT, deactivate the respective UT obstructing surface */
    DeactivateUTCylinder(Telescope, Surface, NumberOfSurfaces);

    /* Set periscope cylinder of siderostat to 'defined' if the chosen telescope is
       a siderostat */
    ActivateSIDPeriscopeCylinder(Telescope, Surface, NumberOfSurfaces);

    /* Automatic completion of surface data */
      if ( CompleteSurfaceData(Surface, NumberOfSurfaces, u_Axis, v_Axis, w_Axis, error) == FAILURE )
      {
        errAdd(error, issshadowMOD, issshadowERR_AUTOMATIC_COMPLETION, __FILE__, "", "");
        return(FAILURE);
      }

    /* Initialize ray grid */
    InitializeRayGrid(Telescope, Beam);

    /* Compute East, North and Zenith axes */
    GetEastNorthZenithAxes(East_Axis, North_Axis, Zenith_Axis);

    /* Generate ray grid for current altitude / azimuth angle */
    GenerateRayGrid(u_Axis, v_Axis, w_Axis, Telescope, Beam, East_Axis, North_Axis, Zenith_Axis,
                    (float)alt, (float)az);

    /* Perform a ray tracing */
    if ( PerformRayTracing(Beam, Surface, NumberOfSurfaces, error) == FAILURE )
      {
	return(FAILURE);
      }

    *shadow = 1 - ((double)Beam->NumberOfActiveRays)/
              ((double)Beam->NumberOfRays);

 
    /* Free memory */
    FreeMemoryForSurfaces(Surface);
    FreeMemoryForRays(Beam->Ray);
    FreeMemoryForBeamPointer(Beam);
    FreeMemoryForTelescopePointer(Telescope);

    return(SUCCESS);
}
