/*******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: issshadowMemoryManagement.c,v 1.8 2001/09/13 09:12:38 vltsccm Exp $"
*
* who       when        what
* --------  ----------  ----------------------------------------------
* nhousen   2001-09-06  declared all ccsERROR type variables as static
* nhousen   2001-09-05  reduced number of included header files
* nhousen   2001-07-11  adapted error handling to VLT standards
* rwilhelm  2001-07-10  created 
*/

/************************************************************************
*   NAME
*   issshadowMemoryManagement.c
*
*   SYNOPSIS
*
*
*   DESCRIPTION
*   Contains routines for allocation and de-allocation (free) of memory
*   for use in the 'issshadowAltAz' library.
*
*   PARENT CLASS
*
*
*   DESCRIPTION
*   
*
*   PUBLIC METHODS
*
*   PUBLIC DATA MEMBERS
*
*
*   PROTECTED METHODS
*
*
*   PROTECTED DATA MEMBERS
*
*
*   PRIVATE METHODS
*
*
*   PRIVATE DATA MEMBERS
*
*
*   FILES
*
*   ENVIRONMENT
*
*   COMMANDS
*
*   RETURN VALUES
*
*   CAUTIONS
*   Error handling for the memory management routines is contained in the routines themselves.
*   Nothing is propagated.
*
*   EXAMPLES
*
*   SEE ALSO
*
*   BUGS
*
*------------------------------------------------------------------------
*/

/* #define _POSIX_SOURCE 1 */
/* #include "vltPort.h" */
/*
static char *rcsId="@(#) $Id: issshadowMemoryManagement.c,v 1.8 2001/09/13 09:12:38 vltsccm Exp $";
static void *use_rcsId = ((void)&use_rcsId,(void *) &rcsId);
*/

/* Standard ANSI C Includes */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>


#include "issshadowDefines.h"
#include "issshadowErrors.h"
/*
#include "err.h"
*/

SurfaceStruct* AllocateMemoryForSurfaces(void)
{
    SurfaceStruct *Surface;

    if((Surface = (SurfaceStruct*)
                 calloc(MAXIMUM_NUMBER_OF_SURFACES,
                 sizeof(SurfaceStruct))) == NULL) 
		 { 
      /*fprintf(stderr, "*** ERROR Message ***\n");
        fprintf(stderr, "Not enough memory available for surfaces.\n");
        fprintf(stderr, "You tried to allocate memory for %d surfaces.\n",
                MAXIMUM_NUMBER_OF_SURFACES);
        fprintf(stderr, "This corresponds to %d bytes.\n",
	MAXIMUM_NUMBER_OF_SURFACES*sizeof(SurfaceStruct));*/
        static ccsERROR *error;
        errResetStack(error);
        errAdd(error,issshadowMOD,issshadowERR_NEM_SURFACES,__FILE__,"","");
	errDisplay(error,ccsTRUE);
	errCloseStack(error);
        exit(1); 
    }
    return Surface;
}

void FreeMemoryForSurfaces(SurfaceStruct *Surface)
{
    free(Surface);
    return;
}

BeamStruct* AllocateMemoryForBeamPointer(void)
{
    BeamStruct *Beam;

    if((Beam = (BeamStruct*)
                calloc(1, sizeof(BeamStruct))) == NULL) 
    { 
      /*fprintf(stderr, "*** ERROR Message ***\n");
        fprintf(stderr, "Not enough memory available for 'Beam' pointer.\n");
        fprintf(stderr, "The memory needed is %d bytes.\n",
	sizeof(BeamStruct));*/
        static ccsERROR *error;
        errResetStack(error);
        errAdd(error,issshadowMOD,issshadowERR_NEM_BEAM,__FILE__,"","");
	errDisplay(error,ccsTRUE);
	errCloseStack(error);
        exit(1); 
    }
    return Beam;
}

void FreeMemoryForBeamPointer(BeamStruct *Beam)
{
    free(Beam);
    return;
}

PointingStruct* AllocateMemoryForPointingPointer(void)
{
    PointingStruct *Pointing;

    if((Pointing = (PointingStruct*)
                   calloc(1, sizeof(PointingStruct))) == NULL) 
    { 
      /*fprintf(stderr, "*** ERROR Message ***\n");
        fprintf(stderr, "Not enough memory available for 'Pointing' pointer.\n");
        fprintf(stderr, "The memory needed is %d bytes.\n",
	sizeof(PointingStruct));*/
        static ccsERROR *error;
        errResetStack(error);
        errAdd(error,issshadowMOD,issshadowERR_NEM_POINTING,__FILE__,"","");
        errDisplay(error, ccsTRUE);
	errCloseStack(error);
        exit(1); 
    }
    return Pointing;
}

void FreeMemoryForPointingPointer(PointingStruct *Pointing)
{
    free(Pointing);
    return;
}


RayStruct* AllocateMemoryForRays(long NumberOfRays)
{
    RayStruct *Ray;

    if((Ray = (RayStruct*)
              calloc(NumberOfRays,
              sizeof(RayStruct))) == NULL) 
    { 
      /*fprintf(stderr, "*** ERROR Message ***\n");
        fprintf(stderr, "Not enough memory available for rays.\n");
        fprintf(stderr, "You tried to allocate memory for %d rays.\n",
                NumberOfRays);
        fprintf(stderr, "This corresponds to %d bytes.\n",
	NumberOfRays*sizeof(RayStruct));*/
        static ccsERROR *error;
        errResetStack(error);
        errAdd(error,issshadowMOD,issshadowERR_NEM_RAYS,__FILE__,"","");
	errDisplay(error,ccsTRUE);
	errCloseStack(error);
        exit(1);
    }
    return Ray;
}

void FreeMemoryForRays(RayStruct *Ray)
{
    free(Ray);
    return;
}


TelescopeStruct* AllocateMemoryForTelescopePointer(void)
{
    TelescopeStruct *Telescope;

    if((Telescope = (TelescopeStruct*)
                    calloc(1, sizeof(TelescopeStruct))) == NULL) 
    { 
      /*fprintf(stderr, "*** ERROR Message ***\n");
        fprintf(stderr, "Not enough memory available for 'Telescope' pointer.\n");
        fprintf(stderr, "The memory needed is %d bytes.\n",
	sizeof(TelescopeStruct));*/
        static ccsERROR *error;
        errResetStack(error);
        errAdd(error,issshadowMOD,issshadowERR_NEM_TEL,__FILE__,"","");
	errDisplay(error,ccsTRUE);
	errCloseStack(error);
        exit(1); 
    }
    return Telescope;
}

void FreeMemoryForTelescopePointer(TelescopeStruct *Telescope)
{
    free(Telescope);
    return;
}


float *AllocMemForFloatVector(long Dimension)
/* allocates memory for a vector of "float" numbers; the vector has the
   length "Dimension". */
{   
    float *Vector;
    
    if ((Vector = (float*)calloc(Dimension, sizeof(float))) == NULL)
    { 
      /*fprintf(stderr, "*** ERROR Message ***\n");
        fprintf(stderr, "Not enough memory available for allocation of a float vector\n");
        fprintf(stderr, "of dimension %d. You need %d bytes.\n",Dimension, Dimension*sizeof(float));*/
        static ccsERROR *error;
        errResetStack(error);
        errAdd(error,issshadowMOD,issshadowERR_NEM_FLOAT_VECTOR,__FILE__,"","");
	errDisplay(error,ccsTRUE);
	errCloseStack(error);
        exit(1);
    }
    
    return Vector;
}

void FreeMemForFloatVector(float* Vector)
{   
    free (Vector);  
    return;
}

float** AllocMemForFloatMatrix(long Dimension1,long Dimension2)
/* Allocates memory for the 2d-field "Matrix" from the type "float".
   The dimension of this field is given by "Dimension1 x Dimension2".
   Dimension1 should be the number of lines. Dimension2 should
   be the number of columns */
{   
    long i;
    float **Matrix;
    long MemoryIncrement;
    
    /* compute the needed amount of memory in bytes  */
    MemoryIncrement = Dimension1*Dimension2*sizeof(float);
    
    /* allocation */
    if((Matrix = (float **)calloc(Dimension1, sizeof(float *))) == NULL)
    {
      /*fprintf(stderr, "*** ERROR Message ***\n");
        fprintf(stderr, "Not enough memory available for allocation of a 'float' matrix pointer\n");*/
        static ccsERROR *error;
        errResetStack(error);
        errAdd(error,issshadowMOD,issshadowERR_NEM_FLOAT_MATRIX,__FILE__,"","");
        errDisplay(error,ccsTRUE);
	errCloseStack(error);
	exit(1);
     }
    
    for (i = 0; i<Dimension1; i++) 
    { 
      if ((Matrix[i] = (float *)calloc(Dimension2, sizeof(float))) == NULL)
      {
	  /*fprintf(stderr, "*** ERROR Message ***\n");
            fprintf(stderr, "Not enough memory available for allocation of a float matrix\n");
            fprintf(stderr, "of dimension %d X %d. You need %d bytes.\n", Dimension1, Dimension2, MemoryIncrement);*/
            static ccsERROR *error;
            errResetStack(error);
	    errAdd(error,issshadowMOD,issshadowERR_NEM_FLOAT_MATRIX,__FILE__,"","");
	    errDisplay(error,ccsTRUE);
            errCloseStack(error);
            exit(1); 
      }
    }
    return Matrix;
}

void FreeMemForFloatMatrix(float **Matrix, long Dimension1)
/* frees allocated memory for the 2d-field "Matrix" from the type "float". 
   The 2d-field "Matrix" has been allocated with the function 
   "AllocMemForFloatMatrix(GlobalStruct *G, long Dimension1, long Dimension2)". The dimension 
   of this field is given by "Dimension1 x Dimension2".
   Dimension1 should be the number of lines. Dimension2 should
   be the number of columns */
{   
    long i;
    
    /* free memory */
    for (i = 0; i<Dimension1; i++) free (Matrix[i]);
    free (Matrix);
    
    return;
}
