/*******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: issshadowPrototypes.h,v 1.8 2001/09/13 09:12:35 vltsccm Exp $"
*
* who      when       what
* -------- ---------- ----------------------------------------------
* nhousen  2001-09-13 corrected small typo (#ifdef __cpluslplus)
* nhousen  2001-09-06 declared all functions as extern C
* nhousen  2001-07-11 adapted error handling to VLT standards
* rwilhelm 2001-07-10 created 
*/

/************************************************************************
*   NAME
*   issshadowPrototypes.h
*
*   SYNOPSIS
*
*
*   DESCRIPTION
*   Contains prototypes of all ANSI C functions used in the 'issshadowAltAz'
*   routine and the issshadowTest program.
*
*   PARENT CLASS
*
*
*   DESCRIPTION
*   
*
*   PUBLIC METHODS
*
*   PUBLIC DATA MEMBERS
*
*
*   PROTECTED METHODS
*
*
*   PROTECTED DATA MEMBERS
*
*
*   PRIVATE METHODS
*
*
*   PRIVATE DATA MEMBERS
*
*
*   FILES
*
*   ENVIRONMENT
*
*   COMMANDS
*
*   RETURN VALUES
*
*   CAUTIONS
*
*   EXAMPLES
*
*   SEE ALSO
*
*   BUGS
*
*------------------------------------------------------------------------
*/

#ifdef __cplusplus
extern "C" {
#endif
/*
#include "err.h"
*/

/* MAIN */
ccsCOMPL_STAT issshadowAltAz(/* INPUT ARGUMENTS                            */
                    /* ------------------------------------------ */
                    double alt,
                    /* Altitude angle in degrees (range: 0...90 deg) */
                    double az,
                    /* Azimuth angle in degrees (range: 0...360 deg);
                       Azimuth is zero when pointing towards the South;
                       Azimuth is increasing Eastwards. */
                    int teltype,
                    /* Indicates the type of telescope:
                       UT = 1, AT = 4, SID = 5 */
                    int location,
                    /* Indicates the station where the telescope is located:
                       A0 = 1, A1 = 2, ..., M0 = 30, U1 = 31, ..., U4 = 34 */
                    int noofRayRadial,
                    int noofRayAngular,
                    /* These 2 parameters define the ray grid that is used
                       for the ray tracing:
                       'noofRayRadial' ==> defines the number of radial
                                           segments in the ray grid.
                                           Minimum value = 0 (ray grid consists
                                                              of one single ray)
                       'noofRayAngular' ==> defines the number of angular segments
                                            ('cake pieces') of the ray grid.
                                            Minimum value = 1 (one single ray) */
                    
                    /* OUTPUT ARGUMENTS                           */
                    /* ------------------------------------------ */
                    double *shadow,
                    /* Value between 0 and 1 that defines the percentage of
                       partial vignetting: 0 ==> NO VIGNETTING, 1 ==> FULL VIGNETTING;
                       Note that the 'resolution' (i.e. the step size with which
                       'shadow' can vary, depends on the total number of rays used. */
		    ccsERROR *error
		    );


/* Especially for the test program: */
ccsCOMPL_STAT ParseCLIArguments(int argc, char* argv[],
                       int *teltype,
                       int *location,
                       int *noofRayRadial,
                       int *noofRayAngular,
                       PointingStruct *Pointing,
                       char *OutputFilename,
                       char *OutputFileFormat,
		       ccsERROR *error);
void issshadowTestUsage(void);
ccsCOMPL_STAT CheckPointingRange(PointingStruct *Pointing, ccsERROR *error);
ccsCOMPL_STAT CheckOutputFileFormat(char *OutputFileFormat, ccsERROR *error);
ccsCOMPL_STAT WriteOutputFile(char* OutputFilename, char *OutputFileFormat,
                     float **HorizonMap, PointingStruct *Pointing,
		     ccsERROR *error);


/* Memory Management */
SurfaceStruct* AllocateMemoryForSurfaces(void);
void FreeMemoryForSurfaces(SurfaceStruct *Surface);
BeamStruct* AllocateMemoryForBeamPointer(void);
void FreeMemoryForBeamPointer(BeamStruct *Beam);
RayStruct* AllocateMemoryForRays(long NumberOfRays);
void FreeMemoryForRays(RayStruct *Ray);
TelescopeStruct* AllocateMemoryForTelescopePointer(void);
void FreeMemoryForTelescopePointer(TelescopeStruct *Telescope);
float *AllocMemForFloatVector(long Dimension);
void FreeMemForFloatVector(float* Vector);
float** AllocMemForFloatMatrix(long Dimension1, long Dimension2);
void FreeMemForFloatMatrix(float **Matrix, long Dimension1);
PointingStruct* AllocateMemoryForPointingPointer(void);
void FreeMemoryForPointingPointer(PointingStruct *Pointing);



/* Program flow */
void DefineVLTISiteCoordinateSystem(float *u_Axis, float *v_Axis, float *w_Axis);
ccsCOMPL_STAT ParseInputArguments(double alt,
                         double az,
                         int teltype,
                         int location,
                         int noofRayRadial,
                         int noofRayAngular,
                         TelescopeStruct *Telescope,
                         BeamStruct *Beam,
			 ccsERROR *error);
ccsCOMPL_STAT DefineVignettingSurfaces(SurfaceStruct *Surface, long *NumberOfSurfaces,
                              float *u_Axis, float *v_Axis, float *w_Axis,
			      ccsERROR *error);
ccsCOMPL_STAT CompleteSurfaceData(SurfaceStruct *Surface, long NumberOfSurfaces,
                         float *u_Axis, float *v_Axis, float *w_Axis, 
			 ccsERROR *error);
void ActivateSIDPeriscopeCylinder(TelescopeStruct *Telescope, SurfaceStruct *Surface,
                                  long NumberOfSurfaces);
void DeactivateUTCylinder(TelescopeStruct *Telescope, SurfaceStruct *Surface,
                                  long NumberOfSurfaces);
ccsCOMPL_STAT SetStationCharacteristics(int location, TelescopeStruct *Telescope,
					ccsERROR *error);



/* Mathematical library */
long TestEquality(float Number1, float Number2, float Epsilon);
long TestPerpendicular(float *Vector1, float *Vector2, long Dimension, float Epsilon);
void EquateVectors(float *Vector, long Dimension, float *OtherVector);
void AbsValueOfVector(float *Vector, long Dimension, float *AbsValue);
void InvertVector(float *Vector, long Dimension);
void NormalizeVector(float *Vector, long Dimension);
void SetVector_3D(float *Vector, float Component_1, float Component_2, float Component_3);
void VectorAddition(float *Vector1, float *Vector2, long Dimension, float *VectorResult);
void VectorSubtraction(float *Vector1, float *Vector2, long Dimension, float *VectorResult);
void ScalarProduct(float *Vector1, float *Vector2, long Dimension, float *ScalarResult);
void VectorProduct(float *Vector1, float *Vector2, float *VectorResult);
void MultiplyVectorWithScalar (float *Vector, float Scalar, long Dimension, float *VectorResult);
void MatrixVectorProduct(float **Matrix, float *Vector, long Dimension1, long Dimension2, 
			 float *VectorResult);
void TransformVector_Local_a1a2a3_To_Global_xyz(float *LocalAxis1, float *LocalAxis2, 
						float *LocalAxis3,
                                                float *Vector_Local, float *Vector_Global);
void TransformPoint_Local_a1a2a3_To_Global_xyz(float *LocalAxis1, float *LocalAxis2, 
					       float *LocalAxis3,
                                               float *LocalOrigin, float *Point_Local, 
					       float *Point_Global);
void GetTransformationMatrix_Local3_To_Global3(float *LocalAxis1, float *LocalAxis2, 
					       float *LocalAxis3,
                                               float **TransformMatrix);
void GetTransformationMatrix_Global3_To_Local2(float *LocalAxis1, float *LocalAxis2,
                                               float **TransformMatrix);
void TransformPoint_Global_xyz_To_Local_a1a2(float *LocalAxis1, float *LocalAxis2, 
					     float *LocalOrigin,
                                             float *Point_Global, float *Point_Local);
void RotateVector(float *Vector, float *RotationAxis, float Angle);
void RotatePoint(float *Point, float *RotationAxis, float *RotationCenter, float Angle);
void SetUpTemporaryCoordinateSystem(float *Axis_3, float *Axis_1, float *Axis_2);
void QuadraticEquationSolutionSelect(float a, float b, float c, long *NumberOfSolutions, 
				     float *PathLength);

/* Ray tracing */
void InitializeRayGrid(TelescopeStruct *Telescope, BeamStruct *Beam);
void GenerateRayGrid(float *u_Axis, float *v_Axis, float *w_Axis,
                     TelescopeStruct *Telescope, BeamStruct *Beam,
                     float *East_Axis, float *North_Axis, float *Zenith_Axis,
                     float Altitude_Deg, float Azimuth_Deg);
void ComputePrimaryVertex(float *u_Axis, float *v_Axis, float *w_Axis,
                          TelescopeStruct *Telescope, float Altitude_Deg, float Azimuth_Deg,
                          float *Vertex);
void GetRayDirection(float *East_Axis, float *North_Axis, float *Zenith_Axis,
                     float Altitude_Deg, float Azimuth_Deg, float *Direction);
void GetEastNorthZenithAxes(float *East_Axis, float *North_Axis, float *Zenith_Axis);
ccsCOMPL_STAT PerformRayTracing(BeamStruct *Beam, SurfaceStruct *Surface,
                       long NumberOfSurfaces, ccsERROR *error);
ccsCOMPL_STAT TraceRay(BeamStruct *Beam, long RayIndex, SurfaceStruct *Surface, long SurfaceIndex,
              float *PathLength, long *NumberOfSolutions, ccsERROR *error);
void FindPathLength_FlatSurface(BeamStruct *Beam, long RayIndex, SurfaceStruct *Surface, 
				long SurfaceIndex,
                                long *NumberOfSolutions, float *PathLength);
void FindPathLength_CylindricalSurface(BeamStruct *Beam, long RayIndex, SurfaceStruct *Surface, 
				       long SurfaceIndex,
                                       long *NumberOfSolutions, float *PathLength);
void Calculate_abc_CylindricalSurface(SurfaceStruct *Surface, long SurfaceIndex, 
				      float *RayDirection, float *RayPosition_wrt_Vertex,
                                      float *a, float *b, float *c);
ccsCOMPL_STAT CheckIfRayObscured(BeamStruct *Beam, long RayIndex,
                        SurfaceStruct *Surface, long SurfaceIndex,
                        float *PathLength, long NumberOfSolutions,
			ccsERROR *error);
ccsCOMPL_STAT CheckSurfaceHit(float *RayPosition, SurfaceStruct *Surface, long SurfaceIndex, 
			      long *HitFlag, ccsERROR *error);


#ifdef __cplusplus
}
#endif
