/*******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: issshadowTypes.h,v 1.8 2001/09/13 09:12:35 vltsccm Exp $"
*
* who       when        what
* --------  ----------  ----------------------------------------------
* rwilhelm  2001-07-10  created 
*/

/************************************************************************
*   NAME
*   issshadowTypes.h
*
*   SYNOPSIS
*
*
*   DESCRIPTION
*   Contains all type (struct) definitions for the package 'issshadow'.
*
*   PARENT CLASS
*
*
*   DESCRIPTION
*   
*
*   PUBLIC METHODS
*
*   PUBLIC DATA MEMBERS
*
*
*   PROTECTED METHODS
*
*
*   PROTECTED DATA MEMBERS
*
*
*   PRIVATE METHODS
*
*
*   PRIVATE DATA MEMBERS
*
*
*   FILES
*
*   ENVIRONMENT
*
*   COMMANDS
*
*   RETURN VALUES
*
*   CAUTIONS
*
*   EXAMPLES
*
*   SEE ALSO
*
*   BUGS
*
*------------------------------------------------------------------------
*/

/* ======================================================= */
/* OBSTRUCTING SURFACES                                    */
/* ======================================================= */
typedef struct
{
    char Type[MAXIMUM_STRING_LENGTH];
    /* can be either 'Cylinder' or 'Wall' */
    char Name[MAXIMUM_STRING_LENGTH];
    /* the name of the obstructing surface */
    float CylinderCenter_uv[2];
    /* In case of a 'Cylinder'-type surface: the center of
       the cylinder in the (u, v)-plane. It is assumed that
       the symmetry axis of the cylinder is parallel to the
       w-axis, i.e. the cylinder has its symmetry axis
       perpendicular to the (u, v)-plane.

       'CylinderCenter_uv' is a 2 x 1 vector with its
       2 components holding the u- and v-coordinate of
       the center, respectively. */
    
    float VertexPoint[3];
    /* The vertex point of the surface which is used in
       the 'BeamWarrior'-style ray tracing. For a 'Cylinder'-type
       surface, the vertex is located on the cylinder surface.
       Its location on the cylinder surface is somehow arbitrary;
       in the program it is computed by going from the cylinder
       center (defined above, with w = 0) in the direction of
       the positive u-axis.

       In case of a 'Wall'-type surface (i.e. a rectangular
       surface), the vertex defines the lower left corner of
       the rectangle. ('lower left' if one is facing the
       wall.) */
    float Axis1[3];
    float Axis2[3];
    float Axis3[3]; 
    /* {Axis1, Axis2, Axis3} defines the surface-related local
       coordinate system. Axis3 always defines the NORMAL to the
       surface evaulated at the vertex.

       In case of a 'Cylinder'-type surface, the following
       definition holds:
       {Axis1, Axis2, Axis3} = {w, v, u}.

       In case of a 'Wall'-type surface, Axis1 and Axis2 define
       the two axes that set up the plane of the wall. Axis3 is
       pointing perpendicular to the wall. */
    float Height;
    float Width;
    /* These 2 values define the size of the obstructing surface.
       (Both are measured in units of meter!).

       In case of a 'Cylinder'-type surface, 'Height' defines the
       height of the cylinder, measured from the ground (at w=0).
       'Width' defines the diameter of the cylinder.       
      
       In case of a 'Wall'-type surface, the 2 parameters 'Height'
       and 'Width' define the dimensions of the recatngular wall
       defined w.r.t. the local axes Axis1 and Axis2. (see above). */
    long Defined;
    /* This flag can either be 0 or 1. It is used to decide whether
       the surface is taken into account for the ray tracing or not. */

} SurfaceStruct;

/* ======================================================= */
/* TELESCOPE                                               */
/* ======================================================= */

typedef struct
{
    char Type[MAXIMUM_STRING_LENGTH];
    /* can be either 'UT', 'AT' or 'SID' */
    long StationNumber;
    /* runs from 1 ... 34 (1 = U1, 2 = U2, ..., 5 = A0, ..., 34 = K0 */
    char StationName[MAXIMUM_STRING_LENGTH];
    /* name of station where telescope
       is located (e.g. "A0", "U3", "J6") */
    float StationPosition_uv[2];
    /* station position in (u, v) plane (VLTI site coordinate system) */
} TelescopeStruct;

/* ======================================================= */
/* RAY AND LIGHT BEAM (GRID OF RAYS)                       */ 
/* ======================================================= */


typedef struct
{
    float Position[3];
    float Direction[3];
    float PathLength[3];
    long Active;
} RayStruct;

typedef struct
{
    RayStruct *Ray;
    long NumberOfRays;
    long NumberOfActiveRays;
    long RadialIncrementation;
    long AngularIncrementation;
    float Delta_R; /* radial spacing between two adjacent ray 'rings' */
    float Delta_Phi; /* angular spacing (rad) */
} BeamStruct;

/* ======================================================= */
/* TELESCOPE POINTING RANGE (used only in 'issshadowTest'  */
/* ======================================================= */

typedef struct
{
    float Altitude_Min;
    float Altitude_Max;
    float Altitude_Increment;
    float Azimuth_Min;
    float Azimuth_Max;
    float Azimuth_Increment;
    float *AltitudeVector;
    long Dimension_Altitude;
    float *AzimuthVector;
    long Dimension_Azimuth;
} PointingStruct;


