function boxconv,x,y,width
;+
; NAME:
;           BOXCONV
;
; PURPOSE:
;           This function smooths an array by convolving with a Gaussian profile.
;
; CALLING SEQUENCE:
;           smoothed_y = BOXCONV(X, Y, Fwhm)
;
; INPUTS:
;           X:	   Array (double or float) of the values of the x-axis in ascending
;		   order.
;           Y:	   Array (double or float) of same size as x of the y-axis values.
;           Width: Width in units of the x-axis of the boxcar profile.
;
; OUTPUTS:
;           Array (double or float) of same size as x containing smoothed y.
;
; EXAMPLE:
;           flux_smoothed = BOXCONV(wavelength,flux,0.75)
;
; MODIFICATION HISTORY:
; 	Written by:	Christian Hummel, December 2018.
;-
; Copyright (C) 2018 Christian Hummel
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
; The above copyright notice and this permission notice shall be included in all
; copies or substantial portions of the Software.
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE.
;-
; check the input parameters
if n_params() lt 3 then begin
    message,/info,'Syntax: smoothed_y = BOXCONV(X, Y, Fwhm)'
    retall
endif

return,smooth(y,nint(width/median(x-shift(x,1))))

end
