function create_standard_parinfo
;+
; NAME:
;	CREATE_STANDARD_PARINFO
;
; PURPOSE:
;	This function creates a parameter info structure for use with fittell
;	containing appropriate values.
;
; CALLING SEQUENCE:
;	Result = CREATE_STANDARD_PARINFO()
;
; INPUTS:
;	None.
;
; OUTPUTS:
;	This function returns a parameter info structure for use with fittell
;	and in the format expected by MPFIT.
;
; EXAMPLE:
;       parinfo = CREATE_STANDARD_PARINFO()
;
; MODIFICATION HISTORY:
; 	Written by:	Natascha Rudolf, October 2013.
;-
; Copyright (C) 2013 Natascha Rudolf
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
; The above copyright notice and this permission notice shall be included in all
; copies or substantial portions of the Software.
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE.
;-

; assign parameters: p[0]=smooth, p[1]=v, p[2]=slope, p[3]=b, p[4]=wat, p[5]=meth, p[6]=co2
parinfo = replicate({value:0.D, fixed:0, limited:[0,0],limits:[0.D,0],step:0.d},8)

; smooth, i.e. width of boxcar
parinfo[0].value=8.0
parinfo[0].fixed=0
parinfo[0].limited[0]=1
parinfo[0].limited[1]=1
parinfo[0].limits[0]=4.0
parinfo[0].limits[1]=12.0
parinfo[0].step=0.5d
; smooth, i.e. width of lorentzian
parinfo[0].value=5.0
parinfo[0].fixed=0
parinfo[0].limited[0]=1
parinfo[0].limited[1]=1
parinfo[0].limits[0]=4.0
parinfo[0].limits[1]=8.0
parinfo[0].step=0.5d
; smooth, i.e. width of gaussian
parinfo[0].value=4.5
parinfo[0].fixed=0
parinfo[0].limited[0]=1
parinfo[0].limited[1]=1
parinfo[0].limits[0]=3.5
parinfo[0].limits[1]=5.5
parinfo[0].step=0.1d
; v, i.e. for shift in wavelength [km/s]
parinfo[1].value=-45.0	; corresponds to -3.6 AA
parinfo[1].fixed=0
parinfo[1].limited[0]=1
parinfo[1].limited[1]=1
parinfo[1].limits[0]=-55.d
parinfo[1].limits[1]=-35.d
parinfo[1].step=1.0
; y-intercept of line that is used to adapt observed spectrum
parinfo[2].value=1.d
parinfo[2].fixed=0
parinfo[2].limited[0]=1
parinfo[2].limited[1]=1
parinfo[2].limits[0]=0.2
parinfo[2].limits[1]=1.2
parinfo[2].step=0.02d
; slope of line that is used to adapt to observed spectrum
parinfo[3].value=0
parinfo[3].fixed=0
parinfo[3].limited=[1,1]
parinfo[3].limits=[-0.001,0.001]
parinfo[3].step=[0.0001]
; curvature of line that is used to adapt to observed spectrum
parinfo[4].value=0
parinfo[4].fixed=0
parinfo[4].limited=[1,1]
parinfo[4].limits=[-0.000005,0.000005]
parinfo[4].step=[0.000001]
; wat, i.e. abundance factor for water
parinfo[5].value=1.0d
parinfo[5].fixed=1
parinfo[5].limited=[1,1]
parinfo[5].limits[0]=0.4
parinfo[5].limits[1]=1.5
parinfo[5].step=0.1d
; meth, i.e. abundance factor for methane
parinfo[6].value=1.0d
parinfo[6].fixed=1
parinfo[6].limited=[1,1]
parinfo[6].limits[0]=0.4
parinfo[6].limits[1]=1.5
parinfo[6].step=0.1d
; co2, i.e. abundance factor for carbondioxide
parinfo[7].value=1.0d
parinfo[7].fixed=1
parinfo[7].limited=[1,1]
parinfo[7].limits[0]=0.4
parinfo[7].limits[1]=1.5
parinfo[7].step=0.1d

return,parinfo
end
