pro idlplottitlechanger,filename
;+
; NAME:
;	IDLPLOTTITLECHANGER
;
; PURPOSE:
;	This procedure replaces the IDL standard plot title "Graphics produced
;	by IDL" with the file name in the specified postscript file.
;
; CALLING SEQUENCE:
;	IDLPLOTTITLECHANGER, Filename
;
; INPUTS:
;	Filename:   Name of the postscript file to work on (scalar string).
;
; OUTPUTS:
;	None.
;
; EXAMPLE:
;	IDLPLOTTITLECHANGER,'plotfileXYZ.ps'
;
; MODIFICATION HISTORY:
; 	Written by:	Natascha Rudolf, October 2013.
;-
; Copyright (C) 2013 Natascha Rudolf
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
; The above copyright notice and this permission notice shall be included in all
; copies or substantial portions of the Software.
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE.
;-
; check the input parameters
if n_params() lt 1 then begin
    message,/info,'Syntax: IDLPLOTTITLECHANGER,filename'
    retall
endif

spawn,'cat '+filename+'| sed "s|Graphics produced by IDL|'+filename+'|" >  idltemp.ps; mv idltemp.ps '+filename
end
