pro loadtellreminfo,file
;+
; NAME:
;	LOADTELLREMINFO
;
; PURPOSE:
;	This procedure loads the information necessary to run the procedures
;	of the tellrem package and creates the common block TELLREM_INFO. An example file
;	called 'info_for_tellrem' you can adjust for your needs is
;	provided with the package. Run this procedure before any of the other
;	functions or procedure of the tellrem package.
;
; CALLING SEQUENCE:
;	LOADTELLREMINFO, filename
;
; INPUTS:
;	Filename:  Absolute path to file containing the inforamtion as string.
;
; OUTPUTS:
;	None. But creates the common block TELLREM_INFO. This common block
;	contains the variables Gdasfolder, Modelatmosphere, Executeablename,
;	Spectrafolder, and Obstype. All of them are scalar strings. Gdasfolder
;	contains the absolute path of the folder containing the GDAS files,
;	Modelatmosphere contains the absolute  path to the MIPAS model
;	atmosphere, Executeablename contains the name of LBLRTM executable,
;	Spectrafolder contains the absolute path to the folder containing the
;	reduced spectra (in individual subfolders therein), and Obstype contains
;	the prefix specifying the type of observation (i.e., SCI, FLUX, or TELL)
;	the X-Shooter pipeline assigns to the .fits files.
;
; COMMON BLOCKS:
;       TELLREM_INFO: This common block contains relevant folder names and strings
;	              for running tellrem. It is created by this procedure.
;
; EXAMPLE:
;	LOADTELLREMINFO,'/here/lies/info_for_tellrem'
;
; MODIFICATION HISTORY:
; 	Written by:	Natascha Rudolf, October 2013.
;-
; Copyright (C) 2013 Natascha Rudolf
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
; The above copyright notice and this permission notice shall be included in all
; copies or substantial portions of the Software.
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE.
;-
common tellrem_info,gdasfolder,modelatmosphere,executeablename,spectrafolder,obstype

; check the input parameters
if n_params() lt 1 then begin
    message,/info,'Syntax: LOADTELLREMINFO, filename'
    retall
endif

; open the file
openr,unit,file,/get_lun
; read the lines and fill the variables
n=numlines(file)
cont=strarr(n)
readf,unit,cont
gdasfolder=strsplit(cont[0],/extract)
gdasfolder=gdasfolder[0]
modelatmosphere=strsplit(cont[1],/extract)
modelatmosphere=modelatmosphere[0]
executeablename=strsplit(cont[2],/extract)
executeablename=executeablename[0]
spectrafolder=strsplit(cont[3],/extract)
spectrafolder=spectrafolder[0]
obstype=strsplit(cont[4],/extract)
obstype=obstype[0]
free_lun,unit
end
