function create_standard_parinfo
;+
; NAME:
;	CREATE_STANDARD_PARINFO
;
; PURPOSE:
;	This function creates a parameter info structure for use with fittell
;	containing appropriate values.
;
; CALLING SEQUENCE:
;	Result = CREATE_STANDARD_PARINFO()
;
; INPUTS:
;	None.
;
; OUTPUTS:
;	This function returns a parameter info structure for use with fittell
;	and in the format expected by MPFIT.
;
; EXAMPLE:
;       parinfo = CREATE_STANDARD_PARINFO()
;
; MODIFICATION HISTORY:
; 	Written by:	Natascha Rudolf, October 2013.
;-
; Copyright (C) 2013 Natascha Rudolf
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
; The above copyright notice and this permission notice shall be included in all
; copies or substantial portions of the Software.
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE.
;-

; assign parameters: p[0]=smooth, p[1]=v, p[2]=slope, p[3]=b, p[4]=wat, p[5]=meth, p[6]=co2
parinfo = replicate({value:0.D, fixed:0, limited:[0,0],limits:[0.D,0],step:0.d},5)

; smooth, i.e. width of gaussian
parinfo[0].value=0.5d
parinfo[0].limited[0]=1
parinfo[0].limits[0]=1.d-4
parinfo[0].limited[1]=1
parinfo[0].limits[1]=10.d  
parinfo[0].step=0.1d

; v, i.e. shift in wavelength
parinfo[1].value=0.1d
parinfo[1].step=0.1d

; slope, i.e. slope of straight line that is used to adapt to slope of observed spectrum
parinfo[2].value=-5.8d
parinfo[2].step=0.1d

; b, i.e. y-intercept of straight line that is used to adapt to slope of observed spectrum
parinfo[3].value=2.d
parinfo[3].step=0.1d

; wat, i.e. abundance factor for water
parinfo[4].value=1.0d
parinfo[4].fixed=0
parinfo[4].limited=[1,1]
parinfo[4].limits[0]=1.d-20
parinfo[4].limits[1]=10.d
parinfo[4].step=0.1d

return,parinfo
end
