pro getabundances,wavenir,specnir,errnir,gdasdata,obsaltitude, $
	ab_h2o,ab_h2o_str,silent=silent,plot=plot
;+
; NAME:
;	GETABUNDANCES
;
; PURPOSE:
;	This procedure determines the abundances of the main molecules (H2O,
;	CO2, CH4) producing telluric lines in the GRAVITY spectral range.
;
; CALLING SEQUENCE:
;	GETABUNDANCES, Wavenir, Specnir, Errnir,
;	Gdasdata, Obsaltitude, Ab_h2o, Ab_co2, Ab_ch4, Ab_h2o_str,
;	Ab_co2_str, Ab_ch4_str
;
; INPUTS:
;	Wavenir:	Wavelength array of NIR data
;	Specnir:	Flux array of NIR data
;	Errnir:		Error array of NIR data
;	Gdasdata:	Scalar string containing absolute path to GDAS file
;	Obsaltitude:	Altitude angle observation was taken at in deg
;	
; KEYWORD PARAMETERS:
;	SILENT:		Set this keyword to suppress informational messages
;	PLOT:		Set this keyword to get a plot of the result.
;
; OUTPUTS:
;	Ab_h2o:		Abundance of H2O in this observation
;	Ab_co2:		Abundance of CO2 in this observation
;	Ab_ch4:		Abundance of CH4 in this observation
;	Ab_h2o_str:	Structure containing the fit results for the
;			individual regions used to determine the abundance
;			of H20
;	Ab_co2_str:	Structure containing the fit results for the
;			individual regions used to determine the abundance
;			of CO2
;	Ab_ch4_str:	Structure containing the fit results for the
;			individual regions used to determine the abundance
;			of CH4
;
; EXAMPLE:
;	GETABUNDANCES, Wavenir, Specnir, Errnir,
;	'/here/lies/the/Gdasdata',87.2, Ab_h2o, Ab_co2, Ab_ch4,
;	Ab_h2o_str, Ab_co2_str, Ab_ch4_str
;
; MODIFICATION HISTORY:
; 	Written by:	Natascha Rudolf, October 2013.
;	N. Rudolf, October 2014, Adapted parameter borders
;	N. Rudolf, November 2014, Added output to save the fit results of
;	the individual regions used to determine the abundances of the
;	main telluric contributors.
;-
; Copyright (C) 2013 Natascha Rudolf
; Permission is hereby granted, free of charge, to any person obtaining a copy
; of this software and associated documentation files (the "Software"), to deal
; in the Software without restriction, including without limitation the rights
; to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
; copies of the Software, and to permit persons to whom the Software is
; furnished to do so, subject to the following conditions:
; The above copyright notice and this permission notice shall be included in all
; copies or substantial portions of the Software.
; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
; IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
; FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
; AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
; LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
; SOFTWARE.
;-
; check the input parameters
if n_params() lt 5 then begin
    message,/info,'Syntax: GETABUNDANCES,wavenir,specnir,errnir,gdasdata,obsaltitude,ab_h2o,ab_co2,ab_ch4,ab_h2o_str,ab_co2_str,ab_ch4_str,silent=silent,plot=plot'
    retall
endif
if not keyword_set(plot) then plot=0

abund={range:dblarr(2),p:dblarr(5),pe:dblarr(5)}
ab_h2o_str=replicate(abund,2)

if not keyword_set(silent) then print,'Fitting abundances:'

; set up parinfo structure for H2O
parw = replicate({value:0.D, fixed:0, limited:[0,0],limits:[0.D,0],step:0.d},5)
; smooth, i.e. width of gaussian
parw[0].value=5.d
parw[0].fixed=0
parw[0].limited[0]=1
parw[0].limited[1]=1
parw[0].limits[0]=5.
parw[0].limits[1]=20.d  
parw[0].step=1.d
; v, i.e. shift in wavelength
parw[1].value=0
parw[1].fixed=0
parw[1].limited[0]=1
parw[1].limited[1]=1
parw[1].limits[0]=-90.d
parw[1].limits[1]=50.d
parw[1].step=1.d
; slope, i.e. slope of straigth line that is used to adapt to slope of observed spectrum
parw[2].value=0
parw[2].fixed=1
; b, i.e. y-intercept of straigth line that is used to adapt to slope of observed spectrum
parw[3].value=1.0
parw[3].fixed=0
parw[3].limited[0]=1
parw[3].limited[1]=1
parw[3].limits[0]=0.8
parw[3].limits[1]=1.2
parw[3].step=0.05d
; wat, i.e. abundance factor for water
parw[4].value=1.0d
parw[4].fixed=0
parw[4].limited=[1,1]
parw[4].limits[0]=0.4
parw[4].limits[1]=2.d
parw[4].step=0.1d
if not keyword_set(silent) then print,'Fit H2O'
fittell,wavenir,specnir,errnir,[24100.,24500.],gdasdata,obsaltitude, $
	pw1,pew1,wrw1,rw1,clw1,parinfo=parw,/silent,plot=plot,titleplot='Fit H2O:'
ab_h2o_str[0].range=[24100.,24500.]
ab_h2o_str[0].p=pw1
ab_h2o_str[0].pe=pew1

ab_h2o_str[1].range=[24100.,24500.]
ab_h2o_str[1].p=pw1
ab_h2o_str[1].pe=pew1

; abundance used is mean of all abundances
; ab_h2o=mean([pw1[4],pw2[4],pw3[4],pw4[4],pw5[4]])
ab_h2o=pw1[4]

end
