c  Main program for computing light and radial velocity curves                10
c                                                                             20
c  Version of May 20, 1993                                                    30
C                                                                             40
C     TO PRINT VELOCITIES IN KM/SEC, SET VUNIT=1.                             50
C     TO PRINT NORMALIZED VELOCITIES IN SAME COLUMNS, SET VUNIT EQUAL TO      60
C     DESIRED VELOCITY UNIT IN KM/SEC.                                        70
C                                                                             80
C     PARAMETER PSHIFT IS DEFINED AS THE PHASE AT WHICH PRIMARY               90
C     CONJUNCTION (STAR 1 AWAY FROM OBSERVER) WOULD OCCUR IF THE             100
C     ARGUMENT OF PERIASTRON WERE 90 DEGREES. SINCE THE NOMINAL VALUE        110
C     OF THIS QUANTITY IS ZERO, PSHIFT MAY BE USED TO INTRODUCE AN           120
C     ARBITRARY PHASE SHIFT.                                                 130
C                                                                            140
      dimension rad(4),drdo(4),xtha(4),xfia(4),po(2)                         150
      dimension rv(3011),grx(3011),gry(3011),grz(3011),rvq(3011),            160
     $grxq(3011),gryq(3011),grzq(3011),slump1(3011),slump2(3011),            170
     $fr1(3011),fr2(3011),glump1(3011),glump2(3011),xx1(3011),               180
     $xx2(3011),yy1(3011),yy2(3011),zz1(3011),zz2(3011),grv1(3011),          190
     $grv2(3011),rftemp(3011),rf1(3011),rf2(3011),csbt1(3011),               200
     $csbt2(3011),gmag1(3011),gmag2(3011),hld(3200),snfi(6400),              210
     $csfi(6400),tld(6400),snth(260),csth(260),theta(520),rho(520),          220
     $aa(07),bb(07),mmsave(124)                                              230
      DIMENSION XLAT(2,100),xlong(2,100)                                     240
      COMMON /FLVAR/ PER,PSHIFT,DP,DS,EF,EFC,ECOS,PERR,PHPER,PCONJ,          250
     $PHPERI,VSUM1,VSUM2,VRA1,VRA2,VKM1,VKM2,VUNIT,vfvu,trc                  260
      COMMON /DPDX/ DPDX1,DPDX2,PHSV,PCSV                                    270
      COMMON /ECCEN/ E,A,PERIOD,VGA,SINI,VF,VFAC,VGAM,VOL1,VOL2,IFC          280
      COMMON /KFAC/ KFF1,KFF2,kfo1,kfo2                                      290
      COMMON /INVAR/ KH,IPB,IRTE,NREF,IRVOL1,IRVOL2,mref,ifsmv1,ifsmv2,      300
     $icor1,icor2,ld                                                         310
      COMMON /SPOTS/SINLAT(2,100),COSLAT(2,100),SINLNG(2,100),COSLNG         320
     $(2,100),RADSP(2,100),temsp(2,100),xlng(2,100)                          330
      COMMON /NSPT/ NSP1,NSP2,IFAT1,IFAT2                                    340
      data xtha(1),xtha(2),xtha(3),xtha(4),xfia(1),xfia(2),xfia(3),          350
     $xfia(4)/0.,1.570796,1.570796,1.570796,0.,0.,1.570796,3.141593/         360
   96 FORMAT('   Phase   lite 1  lite 2  tot lt  nrm lt    dist   mag+K      370
     $  VR1    VR2    DV1    DV2  r1pol  r1pt r1sid r1bak r2pol  r2pt r2     380
     $sid r2bak')                                                            390
   45 FORMAT('   Phase    light 1    light 2    (1+2+3)  norm lite     d     400
     $ist    mag+K     V RAD 1   V RAD 2    del V1    del V2  V km/s 1       410
     $V km/s 2')                                                             420
   65 FORMAT('   Phase    light 1    light 2    (1+2+3)  norm lite     d     430
     $ist   mag+K    V RAD 1   V RAD 2    del V1    del V2   VNORM 1  VN     440
     $ORM 2')                                                                450
   97 FORMAT(1X,F8.4,6F8.4,4F7.3,8(1X,F5.4))                                 460
   47 FORMAT(' wv lth    L1       L2      x1     x2     y1     y2     el     470
     $3    m zero  factor')                                                  480
   48 FORMAT('  ecc  lng per   s-m axis     F1       F2      V gam  Pshi     490
     $ft    Incl      g1      g2    Nspot1    Nspot2')                       500
   54 FORMAT('    T1      T2     Alb 1   Alb 2    Pot 1    Pot 2    M2/M     510
     $1   x1(bolo)  x2(bolo)  y1(bolo)  y2(bolo)')                           520
   33 FORMAT(3X,I2,4X,I1,5X,I1,5X,I1,4X,I2,2X,I2,3X,E10.5,1X,F5.4,2X,        530
     $F8.3,2X,E14.4,2X,F4.3,3f10.4)                                          540
   74 FORMAT(' DIMENSIONLESS RADIAL VELOCITIES CONTAIN FACTOR P/(2PI*A)'     550
     $)                                                                      560
   46 FORMAT(4X,'GRID1/4    GRID2/4',7X,'POLAR SBR 1',8X,'POLAR SBR 2'       570
     $,7X,'SURF. AREA 1',7X,'SURF. AREA 2',6X,'PERI. PH.',6X,'CONJ. PH.      580
     $')                                                                     590
   50 FORMAT(40H PRIMARY COMPONENT EXCEEDS CRITICAL LOBE)                    600
   51 FORMAT(42H SECONDARY COMPONENT EXCEEDS CRITICAL LOBE)                  610
   43 FORMAT(1H1)                                                            620
   42 FORMAT(1H )                                                            630
   41 FORMAT(1X,9HCOMPONENT,3X,6HR POLE,8X,5HDERIV,8X,7HR POINT,8X,          640
     $5HDERIV,9X,6HR SIDE,8X,5HDERIV,9X,6HR BACK,8X,5HDERIV)                 650
   80 FORMAT(1X,F6.4,1X,F7.5)                                                660
    2 FORMAT(F5.4,1X,F6.2,1X,F7.3,1X,2(F6.3,1X),F7.4,1X,F5.4,1X,f7.3,        670
     $2(1X,F6.3))                                                            680
    6 FORMAT(2(F6.4,1X),2(F6.3,1X),2(F7.4,1X),F8.5,4(1X,F5.3))               690
    3 FORMAT(1X,F8.4,1X,4(F9.6,2X),2(F7.4,1x),4F10.6,2(1X,E10.4))            700
    1 FORMAT(I2,1X,I1,1X,I1,1X,I1,1X,I2,1X,I2,1X,E9.5,1X,F5.4,1X,F7.3,       710
     $1X,F4.3,3(1x,f9.4))                                                    720
    4 FORMAT(F6.4,2(1X,F7.4),4(1X,F5.3),1X,F6.4,1X,F6.3,1X,F6.4)             730
    5 FORMAT(1X,F5.4,1X,F7.2,2X,F9.4,2(2X,F7.4),2X,F7.4,2X,F6.4,2X,f7.3,     740
     $2(2X,F6.3),2(5X,I3))                                                   750
   34 FORMAT(1X,F6.4,2(2X,F7.4),4(2x,f5.3),2X,F6.4,2X,F6.3,2X,F6.4)          760
   49 FORMAT(' PROGRAM SHOULD NOT BE USED IN MODE 1 OR 3 WITH NON-ZERO E     770
     $CCENTRICITY')                                                          780
   10 FORMAT(' MODE   IPB  IFAT1 IFAT2  N1  N2    Period     THE    VUNI     790
     $T(km/s)   V FAC       PHN    PHstrt    PHstop     Phin')               800
  148 format('   ifrad  nref   mref   ifsmv1   ifsmv2   icor1   icor2        810
     $ld')                                                                   820
  149 format(5x,i1,2(6x,i1),7x,i1,8x,i1,i9,i8,i6)                            830
   40 FORMAT(4X,I1,8(2X,F12.5))                                              840
   94 FORMAT(1X,2(I8,2X),F20.9,F19.9,F19.9,F18.9,F14.5,F15.5)                850
    8 FORMAT(2(2X,F6.4),2(2X,F6.3),2(2X,F7.4),2X,F8.5,2f9.3,2f10.3)          860
   84 FORMAT(1X,I4,4F12.3)                                                   870
   85 FORMAT(3F7.2,F8.3)                                                     880
   83 FORMAT(1X,'STAR  CO-LATITUDE  LONGITUDE  SPOT RADIUS  TEMP. FACTOR     890
     $')                                                                     900
  150 format(' Star     M/Msun   (Mean Radius)/Rsun   M Bol    Log g (cg     910
     $s)')                                                                   920
  250 format(4x,I1,4x,f6.2,11x,f7.2,7x,f5.2,5x,f5.2)                         930
  350 format(' Primary star exceeds outer contact surface')                  940
  351 format(' Secondary star exceeds outer contact surface')                950
   22 format(8(i1,1x))                                                       960
      ot=1./3.                                                               970
      KH=17                                                                  980
      PI=3.141593                                                            990
      twopi=pi+pi                                                           1000
      DTR=1.745329E-2                                                       1010
      DO 1000 IT=1,1000                                                     1020
      WRITE(6,43)                                                           1030
      read(5,22)ifrad,nref,mref,ifsmv1,ifsmv2,icor1,icor2,ld                1040
      if(ifrad.eq.9) stop                                                   1050
      READ(5,1)MODE,IPB,IFAT1,IFAT2,N1,N2,PERIOD,THE,VUNIT,PHN,PHSTRT,      1060
     $PHSTOP,PHIN                                                           1070
      READ(5,2)E,PER,A,F1,F2,VGA,PSHIFT,XINCL,GR1,GR2                       1080
      read(5,6) tavh,tavc,alb1,alb2,poth,potc,rm,xbol1,xbol2,ybol1,         1090
     $ybol2                                                                 1100
      READ(5,4)WL,HLUM,CLUM,XH,xc,yh,yc,EL3,ZERO,FACTOR                     1110
      NSP1=0                                                                1120
      NSP2=0                                                                1130
      DO 88 KP=1,2                                                          1140
      DO 87 I=1,100                                                         1150
      READ(5,85)XLAT(KP,I),XLONG(KP,I),RADSP(KP,I),TEMSP(KP,I)              1160
      xlng(kp,i)=dtr*xlong(kp,i)                                            1170
      IF(XLAT(KP,I).GE.200.) GOTO 88                                        1180
      SINLAT(KP,I)=SIN(DTR*XLAT(KP,I))                                      1190
      COSLAT(KP,I)=COS(DTR*XLAT(KP,I))                                      1200
      SINLNG(KP,I)=SIN(DTR*XLONG(KP,I))                                     1210
      COSLNG(KP,I)=COS(DTR*XLONG(KP,I))                                     1220
      IF(KP.EQ.1)NSP1=NSP1+1                                                1230
   87 IF(KP.EQ.2)NSP2=NSP2+1                                                1240
   88 CONTINUE                                                              1250
      dint1=pi*(1.-xbol1/3.)                                                1260
      dint2=pi*(1.-xbol2/3.)                                                1270
      if(ld.eq.2) DINT1=dint1+PI*2.*ybol1/9.                                1280
      if(ld.eq.2) DINT2=dint2+PI*2.*ybol2/9.                                1290
      if(ld.eq.3) dint1=dint1-.2*pi*ybol1                                   1300
      if(ld.eq.3) dint2=dint2-.2*pi*ybol2                                   1310
      NSTOT=NSP1+NSP2                                                       1320
      NP1=N1+1                                                              1330
      NP2=N1+N2+2                                                           1340
      PERR=DTR*PER                                                          1350
      IRTE=0                                                                1360
      IRVOL1=0                                                              1370
      IRVOL2=0                                                              1380
      CALL SINCOS(1,N1,N1,SNTH,CSTH,SNFI,CSFI,MMSAVE)                       1390
      CALL SINCOS(2,N2,N1,SNTH,CSTH,SNFI,CSFI,MMSAVE)                       1400
      CALL modlog(RV,GRX,GRY,GRZ,RVQ,GRXQ,GRYQ,GRZQ,MMSAVE,FR1,FR2,HLD,     1410
     $rm,poth,potc,gr1,gr2,alb1,alb2,n1,n2,f1,f2,mod,xincl,the,mode,        1420
     $snth,csth,snfi,csfi,grv1,grv2,xx1,yy1,zz1,xx2,yy2,zz2,glump1,         1430
     $glump2,csbt1,csbt2,gmag1,gmag2)                                       1440
      CALL VOLUME(VOL1,RM,POTH,DP,F1,N1,N1,1,RV,GRX,GRY,GRZ,RVQ,            1450
     $GRXQ,GRYQ,GRZQ,MMSAVE,FR1,FR2,HLD,SNTH,CSTH,SNFI,CSFI,SUMMD,SMD,      1460
     $GRV1,GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,CSBT1,CSBT2,GLUMP1,GLUMP2,          1470
     $GMAG1,GMAG2,GR1,1)                                                    1480
      CALL VOLUME(VOL2,RM,POTC,DP,F2,N2,N1,2,RV,GRX,GRY,GRZ,RVQ,            1490
     $GRXQ,GRYQ,GRZQ,MMSAVE,FR1,FR2,HLD,SNTH,CSTH,SNFI,CSFI,SUMMD,SMD,      1500
     $GRV1,GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,CSBT1,CSBT2,GLUMP1,GLUMP2,          1510
     $GMAG1,GMAG2,GR2,1)                                                    1520
      if(e.eq.0.) goto 117                                                  1530
      DAP=1.+E                                                              1540
      P1AP=POTH-2.*E*RM/(1.-E*E)                                            1550
      VL1=VOL1                                                              1560
      CALL VOLUME(VL1,RM,P1AP,DAP,F1,N1,N1,1,RV,GRX,GRY,GRZ,RVQ,            1570
     $GRXQ,GRYQ,GRZQ,MMSAVE,FR1,FR2,HLD,SNTH,CSTH,SNFI,CSFI,SUMMD,SMD,      1580
     $GRV1,GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,CSBT1,CSBT2,GLUMP1,GLUMP2,          1590
     $GMAG1,GMAG2,GR1,2)                                                    1600
      DPDX1=(POTH-P1AP)*(1.-E*E)*.5/E                                       1610
      P2AP=POTC-2.*E/(1.-E*E)                                               1620
      VL2=VOL2                                                              1630
      CALL VOLUME(VL2,RM,P2AP,DAP,F2,N2,N1,2,RV,GRX,GRY,GRZ,RVQ,            1640
     $GRXQ,GRYQ,GRZQ,MMSAVE,FR1,FR2,HLD,SNTH,CSTH,SNFI,CSFI,SUMMD,SMD,      1650
     $GRV1,GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,CSBT1,CSBT2,GLUMP1,GLUMP2,          1660
     $GMAG1,GMAG2,GR2,2)                                                    1670
      DPDX2=(POTC-P2AP)*(1.-E*E)*.5/E                                       1680
  117 CONTINUE                                                              1690
      PHSV=POTH                                                             1700
      PCSV=POTC                                                             1710
      IF(E.EQ.0.) GOTO 61                                                   1720
      IF(MOD.EQ.1) WRITE(6,49)                                              1730
   61 CONTINUE                                                              1740
      CALL BBL(RV,GRX,GRY,GRZ,RVQ,GRXQ,GRYQ,GRZQ,MMSAVE,FR1,FR2,HLD,        1750
     $SLUMP1,SLUMP2,THETA,RHO,AA,BB,POTH,POTC,N1,N2,F1,F2,D,HLUM            1760
     $,clum,xh,xc,yh,yc,gr1,gr2,wl,sm1,sm2,tpolh,tpolc,sbrh,sbrc,ifat1,     1770
     $ifat2,tavh,tavc,alb1,alb2,xbol1,xbol2,ybol1,ybol2,phn,rm,xincl,       1780
     $hot,cool,snth,csth,snfi,csfi,tld,glump1,glump2,xx1,xx2,yy1,yy2,       1790
     $zz1,zz2,dint1,dint2,grv1,grv2,rftemp,rf1,rf2,csbt1,csbt2,gmag1,       1800
     $gmag2,mode)                                                           1810
      KH=0                                                                  1820
      if(kfo1.eq.0) goto 380                                                1830
      write(6,350)                                                          1840
      goto 381                                                              1850
  380 IF(KFF1.EQ.1) WRITE(6,50)                                             1860
  381 if(kfo2.eq.0) goto 382                                                1870
      write(6,351)                                                          1880
      goto 383                                                              1890
  382 IF(KFF2.EQ.1) WRITE(6,51)                                             1900
  383 IF((KFF1+KFF2+kfo1+kfo2).GT.0) WRITE(6,42)                            1910
      write(6,42)                                                           1920
      write(6,148)                                                          1930
      write(6,149) ifrad,nref,mref,ifsmv1,ifsmv2,icor1,icor2,ld             1940
      write(6,42)                                                           1950
      WRITE(6,10)                                                           1960
      WRITE(6,33)MODE,IPB,IFAT1,IFAT2,N1,N2,PERIOD,THE,VUNIT,VFAC,PHN,      1970
     $PHstrt,PHstop,Phin                                                    1980
      WRITE(6,42)                                                           1990
      WRITE(6,48)                                                           2000
      WRITE(6,5)E,PER,A,F1,F2,VGA,PSHIFT,XINCL,GR1,GR2,NSP1,NSP2            2010
      WRITE(6,42)                                                           2020
      WRITE(6,54)                                                           2030
      WRITE(6,8)TAVH,TAVC,ALB1,ALB2,PHSV,PCSV,RM,XBOL1,xbol2,ybol1,ybol2    2040
      WRITE(6,42)                                                           2050
      WRITE(6,47)                                                           2060
      WRITE(6,34)WL,HLUM,CLUM,XH,XC,yh,yc,el3,ZERO,FACTOR                   2070
      WRITE(6,42)                                                           2080
      IF(NSTOT.GT.0) WRITE(6,83)                                            2090
      DO 188 KP=1,2                                                         2100
      IF((NSP1+KP-1).EQ.0) GOTO 188                                         2110
      IF((NSP2+(KP-2)**2).EQ.0) GOTO 188                                    2120
      NSPOT=NSP1                                                            2130
      IF(KP.EQ.2) NSPOT=NSP2                                                2140
      DO 187 I=1,NSPOT                                                      2150
  187 WRITE(6,84)KP,XLAT(KP,I),XLONG(KP,I),RADSP(KP,I),TEMSP(KP,I)          2160
  188 WRITE(6,42)                                                           2170
      write(6,150)                                                          2180
      rr1=.6203505*vol1**ot                                                 2190
      rr2=.6203505*vol2**ot                                                 2200
      tav1=10000.*tavh                                                      2210
      tav2=10000.*tavc                                                      2220
      call mlrg(a,period,rm,rr1,rr2,tav1,tav2,sms1,sms2,sr1,sr2,            2230
     $bolm1,bolm2,xlg1,xlg2)                                                2240
      ns1=1                                                                 2250
      ns2=2                                                                 2260
      write(6,250) ns1,sms1,sr1,bolm1,xlg1                                  2270
      write(6,250) ns2,sms2,sr2,bolm2,xlg2                                  2280
      write(6,42)                                                           2290
      WRITE(6,46)                                                           2300
      WRITE(6,94) MMSAVE(NP1),MMSAVE(NP2),SBRH,SBRC,SM1,SM2,PHPERI,         2310
     $PCONJ                                                                 2320
      WRITE(6,42)                                                           2330
      ALL=HOT+COOL+EL3                                                      2340
      IF(MODE.EQ.-1) ALL=COOL+EL3                                           2350
      IF(IFRAD.EQ.0) GOTO 71                                                2360
      WRITE(6,96)                                                           2370
      GOTO 77                                                               2380
   71 IF(VUNIT.EQ.1.) WRITE(6,45)                                           2390
      IF(VUNIT.NE.1.) WRITE(6,65)                                           2400
   77 CONTINUE                                                              2410
      LL1=MMSAVE(N1)+1                                                      2420
      NPP2=NP2-1                                                            2430
      LL2=MMSAVE(NPP2)+1                                                    2440
      LLL1=MMSAVE(NP1)                                                      2450
      LLL2=MMSAVE(NP2)                                                      2460
      LLLL1=(LL1+LLL1)/2                                                    2470
      LLLL2=(LL2+LLL2)/2                                                    2480
      POTH=PHSV                                                             2490
      POTC=PCSV                                                             2500
      PO(1)=POTH                                                            2510
      PO(2)=POTC                                                            2520
      IF(E.EQ.0.) IRVOL1=1                                                  2530
      IF(E.EQ.0.) IRVOL2=1                                                  2540
      IF(E.EQ.0.) IRTE=1                                                    2550
      do 20 phas=phstrt,phstop,phin                                         2560
      CALL BBL(RV,GRX,GRY,GRZ,RVQ,GRXQ,GRYQ,GRZQ,MMSAVE,FR1,FR2,HLD,        2570
     $SLUMP1,SLUMP2,THETA,RHO,AA,BB,POTH,POTC,N1,N2,F1,F2,D,hlum,           2580
     $clum,xh,xc,yh,yc,gr1,gr2,wl,sm1,sm2,tpolh,tpolc,sbrh,sbrc,ifat1,      2590
     $ifat2,tavh,tavc,alb1,alb2,xbol1,xbol2,ybol1,ybol2,phas,rm,xincl,      2600
     $hot,cool,snth,csth,snfi,csfi,tld,glump1,glump2,xx1,xx2,yy1,yy2,       2610
     $zz1,zz2,dint1,dint2,grv1,grv2,rftemp,rf1,rf2,csbt1,csbt2,gmag1,       2620
     $gmag2,mode)                                                           2630
      HTT=HOT                                                               2640
      IF(MODE.EQ.-1) HTT=0.                                                 2650
      TOTAL=HTT+COOL+EL3                                                    2660
      TOTALL=TOTAL/ALL                                                      2670
      TOT=TOTALL*FACTOR                                                     2680
      SMAGG=-1.085736*ALOG(TOTALL)+ZERO                                     2690
      IF(IFRAD.EQ.0) GOTO 82                                                2700
      WRITE(6,97)PHAS,HTT,COOL,TOTAL,TOT,D,SMAGG,VSUM1,VSUM2,VRA1,VRA2,     2710
     $RV(1),RV(LL1),RV(LLLL1),RV(LLL1),RVQ(1),RVQ(LL2),RVQ(LLLL2),RVQ(LL    2720
     $L2)                                                                   2730
      GOTO 20                                                               2740
   82 WRITE(6,3)PHAS,HTT,COOL,TOTAL,TOT,D,SMAGG,VSUM1,VSUM2,VRA1,VRA2,      2750
     $VKM1,VKM2                                                             2760
   20 CONTINUE                                                              2770
      WRITE(6,42)                                                           2780
      WRITE(6,41)                                                           2790
      WRITE(6,42)                                                           2800
      do 119 ii=1,2                                                         2810
      gt1=2-ii                                                              2820
      gt2=ii-1                                                              2830
      f=f1*gt1+f2*gt2                                                       2840
      do 118 i=1,4                                                          2850
      call romqsp(po(ii),rm,f,dp,e,xtha(i),xfia(i),rad(i),drdo(i),          2860
     $drdq,dodq,ii,mode)                                                    2870
  118 continue                                                              2880
      write(6,40) ii,rad(1),drdo(1),rad(2),drdo(2),rad(3),drdo(3),          2890
     $rad(4),drdo(4)                                                        2900
  119 continue                                                              2910
      WRITE(6,42)                                                           2920
      WRITE(6,74)                                                           2930
 1000 CONTINUE                                                              2940
      STOP                                                                  2950
      END                                                                   2960
c  This is the Differential Corrections Main Program.                       2970
c                                                                           2980
c  Version of January 5, 1994                                               2990
C                                                                           3000
C     PARAMETER NUMBER 9 IS A, THE RELATIVE ORBITAL SEMI-MAJOR AXIS, IF     3010
C     SIMULTANEOUS LIGHT AND VELOCITY SOLUTIONS ARE BEING DONE. HOWEVER,    3020
C     IF ONLY VELOCITY CURVES ARE BEING SOLVED, PARAMETER 9 WILL            3030
C     EFFECTIVELY BE A*SIN(I), PROVIDED AN INCLINATION OF 90 DEG. IS        3040
C     ENTERED. CONCEIVABLY,IN SOME RARE SITUATIONS IT MAY BE POSSIBLE TO    3050
C     FIND A AND I SEPARATELY, USING ONLY VELOCITY CURVES. THIS COULD BE    3060
C     THE CASE IF THE VELOCITY PROXIMITY EFFECTS ARE IMPORTANT.             3070
C                                                                           3080
C     ALTHOUGH THE LONGITUDE OF PERIASTRON IS ENTERED AND PRINTED IN        3090
C     DEGREES, THE COMPUTED CORRECTION IS IN RADIANS.                       3100
C                                                                           3110
C     OTHER PROGRAM UNITS: ORBITAL S-M AXIS IN SOLAR RADII (6.96E5 KM),     3120
C     PERIOD IN DAYS, PHASE IN 2 PI RADIANS, SYSTEMIC VELOCITY AND          3130
C     THIRD LIGHT IN SAME UNITS AS VELOCITY AND LIGHT OBSERVATIONS,         3140
C     INCLINATION IN DEGREES, TEMPERATURES IN 10000K., SPOT LATITUDES       3150
C     IN DEGREES (0=NORTH POLE, 180 DEG.=SOUTH POLE), SPOT LONGITUDES       3160
C     IN DEGREES (0=LINE OF CENTERS MERIDIAN, INCREASING COUNTER-           3170
C     CLOCKWISE AS SEEN FROM NORTH POLE TO 360 DEGREES),                    3180
C     SPOT ANGULAR RADII IN DEGREES. SPOT TEMPERATURE FACTOR IS             3190
C     DIMENSIONLESS.                                                        3200
C                                                                           3210
      dimension phas(3000),flux(3000),wt(3000),br(3000),bl(3000),           3220
     $obs(45000),hold(45000),cn(2025),cnn(2025),out(45),pe(45),ccl(45),     3230
     $ll(45),mm(45),hla(15),cla(15),x1a(15),x2a(15),y1a(15),y2a(15),        3240
     $el3a(15),wla(15),noise(15),sigma(15),knobs(17),mmsavh(124),           3250
     $mmsavl(124),theta(260),rho(260),aa(20),bb(20),hld(800),v(60),         3260
     $cnout(2025),snthh(65),csthh(65),snfih(1600),csfih(1600),              3270
     $snthl(65),csthl(65),snfil(1600),csfil(1600),tldh(1600),tldl(1600)     3280
      dimension rv(0762),grx(0762),gry(0762),grz(0762),rvq(0762),           3290
     $grxq(0762),gryq(0762),grzq(0762),slump1(0762),slump2(0762),           3300
     $srv(0762),sgrx(0762),sgry(0762),sgrz(0762),srvq(0762),sgrxq(0762)     3310
     $,sgryq(0762),sgrzq(0762),srvl(0762),sgrxl(0762),sgryl(0762),          3320
     $sgrzl(0762),srvql(0762),sgrxql(0762),sgryql(0762),sgrzql(0762),       3330
     $slmp1(0762),slmp2(0762),slmp1l(0762),slmp2l(0762),fr1(0762),          3340
     $fr2(0762),glump1(0762),glump2(0762),grv1(0762),grv2(0762),            3350
     $xx1(0762),xx2(0762),yy1(0762),yy2(0762),zz1(0762),zz2(0762),          3360
     $gmag1(0762),gmag2(0762),csbt1(0762),csbt2(0762),rf1(0762),            3370
     $rf2(0762),rftemp(0762),sxx1(0762),sxx2(0762),syy1(0762),              3380
     $syy2(0762),szz1(0762),szz2(0762),sgmg1(0762),sgmg2(0762),             3390
     $sgrv1(0762),sgrv2(0762),sglm1(0762),sglm2(0762),scsb1(0762),          3400
     $scsb2(0762),srf1(0762),srf2(0762),sglm1l(0762),sglm2l(0762),          3410
     $sgrv1l(0762),sgrv2l(0762),sxx1l(0762),sxx2l(0762),syy1l(0762),        3420
     $syy2l(0762),szz1l(0762),szz2l(0762),sgmg1l(0762),sgmg2l(0762),        3430
     $scsb1l(0762),scsb2l(0762),srf1l(0762),srf2l(0762)                     3440
      dimension erv(0762),egrx(0762),egry(0762),egrz(0762),                 3450
     $elmp1(0762),eglm1(0762),egrv1(0762),exx1(0762),eyy1(0762),            3460
     $ezz1(0762),egmg1(0762),ecsb1(0762),erf1(0762),ervq(0762),             3470
     $egrxq(0762),egryq(0762),egrzq(0762),elmp2(0762),eglm2(0762),          3480
     $egrv2(0762),exx2(0762),eyy2(0762),ezz2(0762),egmg2(0762),             3490
     $ecsb2(0762),erf2(0762),                                               3500
     $ervl(0762),egrxl(0762),egryl(0762),egrzl(0762),elmp1l(0762),          3510
     $eglm1l(0762),egrv1l(0762),exx1l(0762),eyy1l(0762),ezz1l(0762),        3520
     $egmg1l(0762),ecsb1l(0762),erf1l(0762),ervql(0762),egrxql(0762),       3530
     $egryql(0762),egrzql(0762),elmp2l(0762),eglm2l(0762),                  3540
     $egrv2l(0762),exx2l(0762),eyy2l(0762),ezz2l(0762),egmg2l(0762),        3550
     $ecsb2l(0762),erf2l(0762),sfr1(0762),sfr1l(0762),efr1(0762),           3560
     $efr1l(0762),sfr2(0762),sfr2l(0762),efr2(0762),efr2l(0762),            3570
     $stldh(1600),stldl(1600),etldh(1600),etldl(1600)                       3580
      dimension del(30),keep(31),kep(30),nshift(31),low(30),dlif(30),       3590
     $xtha(4),xfia(4),arad(4),xlat(2,100),xlong(2,100),radsp(2,100)         3600
     $,temsp(2,100),po(2),omcr(2)                                           3610
      COMMON /ECCEN/ EC,A,PERIOD,VGA,SINI,VF,VFAC,VGAM,VOL1,VOL2,IFC        3620
      COMMON /DPDX/ DPDX1,DPDX2,POT1,POT2                                   3630
      COMMON /SUMM/ SUMM1,SUMM2                                             3640
      COMMON /FLVAR/ PER,PSH,DP,DSDUM,EF,EFC,ECOS,PERT,PHPER,PCONJ,         3650
     $PHPERI,VSUM1,VSUM2,VRA1,VRA2,VKM1,VKM2,VUNIT,vfvu,trc                 3660
      COMMON /INVAR/ KH,IPB,IRTE,NREF,IRVOL1,IRVOL2,mref,ifsmv1,ifsmv2,     3670
     $icor1,icor2,ld                                                        3680
      COMMON /INCON/ IFVC1,IFVC2,NLC                                        3690
      COMMON /SPOTS/ SNLAT(2,100),CSLAT(2,100),SNLNG(2,100),CSLNG(2,100)    3700
     $,rdsp(2,100),tmsp(2,100),xlng(2,100)                                  3710
      COMMON /NSPT/ NSP1,NSP2,IFAT1,IFAT2                                   3720
      DOUBLE PRECISION CN,CCL,OUT,deter,CNN,V,ANSCH,CNOUT,ERR,ARAD          3730
      DATA ARAD(1),ARAD(2),ARAD(3),ARAD(4)/4HPOLE,5HPOINT,4HSIDE,4HBACK/    3740
   15 FORMAT(1X,16(F9.5))                                                   3750
   16 FORMAT(1X,18(F7.4))                                                   3760
   67 FORMAT(20A4)                                                          3770
   99 FORMAT(' SPECIFIED ECLIPSE DURATION INCONSISTENT WITH OTHER PARAME    3780
     $TERS')                                                                3790
   17 FORMAT(1X,22(F6.3))                                                   3800
   19 FORMAT(1X,26(F5.2))                                                   3810
   21 FORMAT(2(1X,F35.25),1X,E12.6)                                         3820
   55 FORMAT(10(3X,E8.1))                                                   3830
   56 FORMAT(10(1X,E7.1))                                                   3840
   20 format(1x,2(4i1,1x),7i1,1x,3(5i1,1x),i1,1x,i1,1x,i1)                  3850
  102 FORMAT('1')                                                           3860
  101 FORMAT(' ')                                                           3870
    1 FORMAT(3X,I2,5X,I1,5X,I1,6X,I1,4X,I2,2X,I2,2X,I2,2X,I2,3X,E10.5,3X    3880
     $,F5.4,8X,F8.3,5X,E9.4)                                                3890
    2 FORMAT(5(F6.4,F7.4,F3.1))                                             3900
    4 FORMAT(1X,5(F7.4,F7.4,F4.1))                                          3910
   85 FORMAT(1X,F6.4,2(1X,F7.4),4(1X,F5.3),1X,F6.4,1X,i5,f9.4)              3920
   18 format(1x,f6.4,2(1x,f7.4),4(1x,f5.3),1x,f6.4,1x,i1,1x,f6.4)           3930
  218 FORMAT(1X,F6.4,2(1X,F7.4),4(1X,F5.3),1X,F6.4)                         3940
   37 FORMAT(1X,11F12.7)                                                    3950
  137 FORMAT(1X,F11.7)                                                      3960
  138 FORMAT(1X,'SUM OF ABSOLUTE VALUES OF CHECKS IS',1X,D12.6)             3970
  181 FORMAT(7X,'NORMAL EQUATIONS')                                         3980
  183 FORMAT (7X,'CORRELATION COEFFICIENTS')                                3990
  184 FORMAT(7X,'NORMAL EQUATIONS TIMES INVERSE')                           4000
  185 FORMAT(1X,'CHECK OF COMPUTED DEPENDENT VARIABLES FROM NORMAL EQUAT    4010
     $IONS')                                                                4020
   82 FORMAT(7X,'UNWEIGHTED OBSERVATIONAL EQUATIONS')                       4030
   83 FORMAT(7X,'WEIGHTED OBSERVATIONAL EQUATIONS')                         4040
    9 FORMAT(33X,'OBSERVATIONS')                                            4050
  955 FORMAT('  PHASE  V RAD  WT  PHASE  V RAD  WT  PHASE  V RAD  WT  PH    4060
     $ASE  V RAD  WT  PHASE  V RAD  WT')                                    4070
   10 FORMAT('  PHASE  LIGHT  WT  PHASE  LIGHT  WT  PHASE  LIGHT  WT  PH    4080
     $ASE  LIGHT  WT  PHASE  LIGHT  WT')                                    4090
  149 FORMAT(' PROGRAM SHOULD NOT BE USED IN MODE 1 OR 3 WITH NON-ZERO E    4100
     $CCENTRICITY')                                                         4110
   43 FORMAT('   PARAMETER CORRECTIONS')                                    4120
   44 FORMAT('   PROBABLE ERRORS')                                          4130
   40 FORMAT('   SUM(W*RES**2) FOR INPUT VALUES       SUM(W*RES**2) PRED    4140
     $ICTED          DETERMINANT')                                          4150
   11 format(' Wave L    L1      L2     x1    x2  y1    y2    3rd lt  NO    4160
     $ISE  Sigma')                                                          4170
  111 FORMAT(' WAVE L    L1      L2     x1    x2    y1    y2   Sigma')      4180
   12 FORMAT(' MODE   IPB  IFAT1  IFAT2   N1  N2  N1L  N2L    PERIOD        4190
     $ TH E      V UNIT(KM/S)      V FAC')                                  4200
  206 FORMAT(1X,F5.4,1X,F7.2,2X,F9.4,2(2X,F7.4),1X,F8.4,2X,F6.4,2X,f7.3,    4210
     $2(2X,F6.3))                                                           4220
  205 FORMAT('  ECC  LNG PER   S-M AXIS     F1      F2     V GAM  PSHIFT    4230
     $    INCL      G1      G2')                                            4240
  402 FORMAT('    DEL EC     DEL PER    DEL F1     DEL F2     DEL PHS       4250
     $ DEL INCL    DEL G1     DEL G2     DEL T1     DEL T2')                4260
  403 FORMAT('    DEL ALB1   DEL ALB2   DEL POT1   DEL POT2   DEL Q         4270
     $ DEL L1     DEL L2     DEL X1     DEL X2')                            4280
  406 FORMAT(' ADJUSTMENT CONTROL INTEGERS; 1 SUPPRESSES ADJUSTMENT, 0 A    4290
     $LLOWS ADJUSTMENT.')                                                   4300
  701 FORMAT(I2,1X,I1,1X,I1,1X,I1,1X,4(I2,1X),E9.4,1X,F5.4,1X,F8.3)         4310
  702 FORMAT(F5.4,1X,F6.2,1X,F7.3,1X,2(F6.3,1X),F7.4,1X,F5.4,1X,f7.3,       4320
     $2(1X,F6.3))                                                           4330
  706 FORMAT(2(F6.4,1X),2(F6.3,1X),2(F7.4,1X),F8.5,4f6.3)                   4340
  705 FORMAT(I1,1X,I1,1X,I2,10(1X,I1))                                      4350
   54 FORMAT('     T1      T2     Alb 1   Alb 2   Pot 1    Pot 2    M2/M    4360
     $1    x1(bolo)   x2(bolo)   y1(bolo)   y2(bolo)')                      4370
  408 FORMAT(2(2X,F6.4),2(2X,F6.3),2(2X,F7.4),2X,F8.5,f9.3,3f11.3)          4380
  707 FORMAT('    IFVC1   IFVC2   NLC   KO   KDISK   ISYM   nref   mref     4390
     $   ifsmv1   ifsmv2    icor1    icor2     ld')                         4400
  708 FORMAT(8(4X,I3),5(8x,i1))                                             4410
  650 FORMAT(20X,'RADII AND RELATED QUANTITIES (FROM INPUT)')               4420
  651 FORMAT(5X,'DOM1/DQ',5X,'DOM2/DQ',5X,'OM1-Q CORR.',5X,'OM2-Q CORR.'    4430
     $,5X,'OM1 P.E.',4X,'OM2 P.E.',4X,'Q  P.E.')                            4440
  652 FORMAT(1X,3F12.6,4X,F12.6,4X,3F12.6)                                  4450
  653 FORMAT(' COMPONENT',11X,'R',9X,'DR/DOM',8X,'DR/DQ',11X,'P.E.')        4460
  654 FORMAT(2X,I1,1X,A6,4F14.6)                                            4470
  684 FORMAT(1X,I1,4F12.3)                                                  4480
  985 FORMAT(3(f6.2,1x),f7.3)                                               4490
  983 FORMAT(1X,'STAR  CO-LATITUDE  LONGITUDE  SPOT RADIUS  TEMP.FACTOR     4500
     $')                                                                    4510
  399 FORMAT('    DEL LAT    DEL LONG   DEL RAD    DEL TEMPF  DEL LAT       4520
     $ del LONG   del RAD    del TEMPF')                                    4530
   60 FORMAT(4I3)                                                           4540
   61 FORMAT(1X,4I6)                                                        4550
   66 FORMAT('   STAR  SPOT   STAR  SPOT')                                  4560
  166 FORMAT(' SPOTS TO BE ADJUSTED')                                       4570
  440 FORMAT(' AS1=FIRST ADJUSTED SPOT')                                    4580
  441 FORMAT(' AS2=SECOND ADJUSTED SPOT')                                   4590
  405 FORMAT(' ORDER OF PARAMETERS IS AS FOLLOWS:')                         4600
 1440 FORMAT('  (1) - AS1 LATITUDE')                                        4610
 1441 FORMAT('  (2) - AS1 LONGITUDE')                                       4620
 1442 FORMAT('  (3) - AS1 ANGULAR RADIUS')                                  4630
 1443 FORMAT('  (4) - AS1 TEMPERATURE FACTOR')                              4640
 1444 FORMAT('  (5) - AS2 LATITUDE')                                        4650
 1445 FORMAT('  (6) - AS2 LONGITUDE')                                       4660
 1446 FORMAT('  (7) - AS2 ANGULAR RADIUS')                                  4670
 1447 FORMAT('  (8) - AS2 TEMPERATURE FACTOR')                              4680
 1448 FORMAT('  (9) - A=ORBITAL SEMI-MAJOR AXIS')                           4690
 1449 FORMAT(' (10) - E=ORBITAL ECCENTRICITY')                              4700
 1450 FORMAT(' (11) - PER=LONGITUDE OF PERIASTRON')                         4710
 1451 FORMAT(' (12) - F1=STAR 1 ROTATION PARAMETER')                        4720
 1452 FORMAT(' (13) - F2=STAR 2 ROTATION PARAMETER')                        4730
 1453 FORMAT(' (14) - PHASE SHIFT= PHASE OF PRIMARY CONJUNCTION')           4740
 1454 FORMAT(' (15) - VGAM=SYSTEMIC RADIAL VELOCITY')                       4750
 1455 FORMAT(' (16) - INCL=ORBITAL INCLINATION')                            4760
 1456 FORMAT(' (17) - g1=STAR 1 GRAVITY DARKENING EXPONENT')                4770
 1457 FORMAT(' (18) - g2=STAR 2 GRAVITY DARKENING EXPONENT')                4780
 1458 FORMAT(' (19) - T1=STAR 1 AVERAGE SURFACE TEMPERATURE')               4790
 1459 FORMAT(' (20) - T2=STAR 2 AVERAGE SURFACE TEMPERATURE')               4800
 1460 FORMAT(' (21) - ALB1=STAR 1 BOLOMETRIC ALBEDO')                       4810
 1461 FORMAT(' (22) - ALB2=STAR 2 BOLOMETRIC ALBEDO')                       4820
 1462 FORMAT(' (23) - POT1=STAR 1 SURFACE POTENTIAL')                       4830
 1463 FORMAT(' (24) - POT2=STAR 2 SURFACE POTENTIAL')                       4840
 1464 FORMAT(' (25) - Q=MASS RATIO (STAR 2/STAR 1)')                        4850
 1465 FORMAT(' (26) - L1=STAR 1 RELATIVE MONOCHROMATIC LUMINOSITY')         4860
 1466 FORMAT(' (27) - L2=STAR 2 RELATIVE MONOCHROMATIC LUMINOSITY')         4870
 1467 FORMAT(' (28) - X1=STAR 1 LIMB DARKENING COEFFICIENT')                4880
 1468 FORMAT(' (29) - X2=STAR 2 LIMB DARKENING COEFFICIENT')                4890
 1469 FORMAT(' (30) - el3=third light')                                     4900
  119 format(1x,i6,i13,f18.8)                                               4910
  159 format(' Sums of squares of residuals for separate curves, includi    4920
     $ng only individual weights')                                          4930
  169 format('    Curve     No. of obs.   Sum of squares')                  4940
      DTR=1.745329E-2                                                       4950
      PI=3.141593                                                           4960
      twopi=pi+pi                                                           4970
      XTHA(1)=0.                                                            4980
      XTHA(2)=.5*PI                                                         4990
      XTHA(3)=.5*PI                                                         5000
      XTHA(4)=.5*PI                                                         5010
      XFIA(1)=0.                                                            5020
      XFIA(2)=0.                                                            5030
      XFIA(3)=.5*PI                                                         5040
      XFIA(4)=PI                                                            5050
      IBEF=0                                                                5060
      KFF1=0                                                                5070
      KFF2=0                                                                5080
      II=0                                                                  5090
      KH=25                                                                 5100
      NS=1                                                                  5110
      NI=0                                                                  5120
      NY=0                                                                  5130
      KNOBS(1)=0                                                            5140
      WRITE(6,102)                                                          5150
      WRITE(6,405)                                                          5160
      WRITE(6,101)                                                          5170
      WRITE(6,440)                                                          5180
      WRITE(6,441)                                                          5190
      WRITE(6,101)                                                          5200
      WRITE(6,1440)                                                         5210
      WRITE(6,1441)                                                         5220
      WRITE(6,1442)                                                         5230
      WRITE(6,1443)                                                         5240
      WRITE(6,1444)                                                         5250
      WRITE(6,1445)                                                         5260
      WRITE(6,1446)                                                         5270
      WRITE(6,1447)                                                         5280
      WRITE(6,1448)                                                         5290
      WRITE(6,1449)                                                         5300
      WRITE(6,1450)                                                         5310
      WRITE(6,1451)                                                         5320
      WRITE(6,1452)                                                         5330
      WRITE(6,1453)                                                         5340
      WRITE(6,1454)                                                         5350
      WRITE(6,1455)                                                         5360
      WRITE(6,1456)                                                         5370
      WRITE(6,1457)                                                         5380
      WRITE(6,1458)                                                         5390
      WRITE(6,1459)                                                         5400
      WRITE(6,1460)                                                         5410
      WRITE(6,1461)                                                         5420
      WRITE(6,1462)                                                         5430
      WRITE(6,1463)                                                         5440
      WRITE(6,1464)                                                         5450
      WRITE(6,1465)                                                         5460
      WRITE(6,1466)                                                         5470
      WRITE(6,1467)                                                         5480
      WRITE(6,1468)                                                         5490
      WRITE(6,1469)                                                         5500
      READ(5,56)(DEL(I),I=1,8)                                              5510
      READ(5,56)(DEL(I),I=10,14),(DEL(I),I=16,20)                           5520
      READ(5,56)(DEL(I),I=21,29)                                            5530
      READ(5,20)(KEP(I),I=1,30),IFDER,IFM,IFR                               5540
      READ(5,60) KSPA,NSPA,KSPB,NSPB                                        5550
      READ(5,705)IFVC1,IFVC2,NLC,KO,KDISK,ISYM,nref,mref,ifsmv1,ifsmv2,     5560
     $icor1,icor2,ld                                                        5570
      READ(5,701)MODE,IPB,IFAT1,IFAT2,N1,N2,N1L,N2L,PERIOD,THE,VUNIT        5580
      READ(5,702)E,PER,A,F1,F2,VGA,PSHIFT,XINCL,GR1,GR2                     5590
      READ(5,706) TAVH,TAVC,ALB1,ALB2,PHSV,PCSV,RM,xbol1,xbol2,ybol1,       5600
     $ybol2                                                                 5610
      CALL SINCOS(1,N1,N1,SNTHH,CSTHH,SNFIH,CSFIH,MMSAVH)                   5620
      CALL SINCOS(2,N2,N1,SNTHH,CSTHH,SNFIH,CSFIH,MMSAVH)                   5630
      CALL SINCOS(1,N1L,N1L,SNTHL,CSTHL,SNFIL,CSFIL,MMSAVL)                 5640
      CALL SINCOS(2,N2L,N1L,SNTHL,CSTHL,SNFIL,CSFIL,MMSAVL)                 5650
      dint1=pi*(1.-xbol1/3.)                                                5660
      if(ld.eq.2) dint1=dint1+pi*ybol1*2./9.                                5670
      if(ld.eq.3) dint1=dint1-pi*ybol1*.2                                   5680
      dint2=pi*(1.-xbol2/3.)                                                5690
      if(ld.eq.2) dint2=dint2+pi*ybol2*2./9.                                5700
      if(ld.eq.3) dint2=dint2-pi*ybol2*.2                                   5710
      IS=ISYM+1                                                             5720
      KEEP(31)=0                                                            5730
      MM1=N1+1                                                              5740
      MM2=N1+N2+2                                                           5750
      MM3=N1L+1                                                             5760
      MM4=N1L+N2L+2                                                         5770
      M1H=MMSAVH(MM1)                                                       5780
      M2H=MMSAVH(MM2)                                                       5790
      M1L=MMSAVL(MM3)                                                       5800
      M2L=MMSAVL(MM4)                                                       5810
      MTLH=M1H+M2H                                                          5820
      MTLL=M1L+M2L                                                          5830
      NVC=IFVC1+IFVC2                                                       5840
      NLVC=NLC+NVC                                                          5850
      NVCP=NVC+1                                                            5860
      IF(NVC.NE.0) GOTO 288                                                 5870
      KEP(9)=1                                                              5880
      KEP(15)=1                                                             5890
  288 CONTINUE                                                              5900
      DO 84 I=1,30                                                          5910
   84 KEEP(I)=KEP(I)                                                        5920
      DO 51 I=1,30                                                          5930
   51 LOW(I)=1                                                              5940
      LOW(1)=0                                                              5950
      LOW(2)=0                                                              5960
      LOW(3)=0                                                              5970
      LOW(5)=0                                                              5980
      LOW(6)=0                                                              5990
      LOW(7)=0                                                              6000
      LOW(10)=0                                                             6010
      LOW(11)=0                                                             6020
      LOW(12)=0                                                             6030
      LOW(13)=0                                                             6040
      LOW(14)=0                                                             6050
      LOW(16)=0                                                             6060
      LOW(23)=0                                                             6070
      LOW(24)=0                                                             6080
      LOW(25)=0                                                             6090
      KOSQ=(KO-2)*(KO-2)                                                    6100
      IF(NVC.EQ.0) GOTO 195                                                 6110
      DO 90 I=1,NVC                                                         6120
   90 READ(5,218) WLA(I),HLA(I),CLA(I),X1A(I),X2A(I),y1a(i),y2a(i),         6130
     $sigma(i)                                                              6140
  195 CONTINUE                                                              6150
      IF(NLVC.EQ.NVC) GOTO 194                                              6160
      DO 190 I=NVCP,NLVC                                                    6170
  190 read(5,18)wla(i),hla(i),cla(i),x1a(i),x2a(i),y1a(i),y2a(i),           6180
     $el3a(i),noise(i),sigma(i)                                             6190
  194 CONTINUE                                                              6200
      NSP1=0                                                                6210
      NSP2=0                                                                6220
      DO 988 KP=1,2                                                         6230
      DO 987 I=1,100                                                        6240
      READ(5,985)XLAT(KP,I),XLONG(KP,I),RADSP(KP,I),TEMSP(KP,I)             6250
      xlng(kp,i)=dtr*xlong(kp,i)                                            6260
      IF(XLAT(KP,I).GE.200.) GOTO 988                                       6270
      SNLAT(KP,I)=SIN(DTR*XLAT(KP,I))                                       6280
      CSLAT(KP,I)=COS(DTR*XLAT(KP,I))                                       6290
      SNLNG(KP,I)=SIN(DTR*XLONG(KP,I))                                      6300
      CSLNG(KP,I)=COS(DTR*XLONG(KP,I))                                      6310
      RDSP(KP,I)=RADSP(KP,I)                                                6320
      TMSP(KP,I)=TEMSP(KP,I)                                                6330
      IF(KP.EQ.1) NSP1=NSP1+1                                               6340
  987 IF(KP.EQ.2) NSP2=NSP2+1                                               6350
  988 CONTINUE                                                              6360
      NSTOT=NSP1+NSP2                                                       6370
      PERR=PER*DTR                                                          6380
      PERT=PERR                                                             6390
      EC=E                                                                  6400
      PSH=PSHIFT                                                            6410
      IRTE=0                                                                6420
      IRVOL1=0                                                              6430
      IRVOL2=0                                                              6440
      CALL MODLOG(RV,GRX,GRY,GRZ,RVQ,GRXQ,GRYQ,GRZQ,MMSAVH,FR1,FR2,HLD,     6450
     $RM,PHSV,PCSV,GR1,GR2,ALB1,ALB2,N1,N2,F1,F2,MOD,XINCL,THE,MODE,        6460
     $SNTHH,CSTHH,SNFIH,CSFIH,GRV1,GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,GLUMP1,     6470
     $GLUMP2,CSBT1,CSBT2,GMAG1,GMAG2)                                       6480
      call ellone(f1,dp,rm,xld,omcr(1),xldd,omd)                            6490
      rmr=1./rm                                                             6500
      call ellone(f2,dp,rmr,xld,omcr(2),xldd,omd)                           6510
      omcr(2)=rm*omcr(2)+(1.-rm)*.5                                         6520
      po(1)=phsv                                                            6530
      po(2)=pcsv                                                            6540
      IF(E.EQ.0.) GOTO 134                                                  6550
      CALL VOLUME(VOL1,RM,PHSV,DP,F1,N1,N1,1,RV,GRX,GRY,GRZ,RVQ,            6560
     $GRXQ,GRYQ,GRZQ,MMSAVH,FR1,FR2,HLD,SNTHH,CSTHH,SNFIH,CSFIH,SUMMD       6570
     $,SMD,GRV1,GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,CSBT1,CSBT2,GLUMP1,GLUMP2      6580
     $,GMAG1,GMAG2,GR1,1)                                                   6590
      CALL VOLUME(VOL2,RM,PCSV,DP,F2,N2,N1,2,RV,GRX,GRY,GRZ,RVQ,            6600
     $GRXQ,GRYQ,GRZQ,MMSAVH,FR1,FR2,HLD,SNTHH,CSTHH,SNFIH,CSFIH,SUMMD       6610
     $,SMD,GRV1,GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,CSBT1,CSBT2,GLUMP1,GLUMP2      6620
     $,GMAG1,GMAG2,GR2,1)                                                   6630
      DAP=1.+E                                                              6640
      P1AP=PHSV-2.*E*RM/(1.-E*E)                                            6650
      VL1=VOL1                                                              6660
      CALL VOLUME(VL1,RM,P1AP,DAP,F1,N1,N1,1,RV,GRX,GRY,GRZ,RVQ,            6670
     $GRXQ,GRYQ,GRZQ,MMSAVH,FR1,FR2,HLD,SNTHH,CSTHH,SNFIH,CSFIH,SUMMD       6680
     $,SMD,GRV1,GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,CSBT1,CSBT2,GLUMP1,GLUMP2      6690
     $,GMAG1,GMAG2,GR1,2)                                                   6700
      DPDX1=(PHSV-P1AP)*(1.-E*E)*.5/E                                       6710
      P2AP=PCSV-2.*E/(1.-E*E)                                               6720
      VL2=VOL2                                                              6730
      CALL VOLUME(VL2,RM,P2AP,DAP,F2,N2,N1,2,RV,GRX,GRY,GRZ,RVQ,            6740
     $GRXQ,GRYQ,GRZQ,MMSAVH,FR1,FR2,HLD,SNTHH,CSTHH,SNFIH,CSFIH,SUMMD       6750
     $,SMD,GRV1,GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,CSBT1,CSBT2,GLUMP1,GLUMP2      6760
     $,GMAG1,GMAG2,GR2,2)                                                   6770
      DPDX2=(PCSV-P2AP)*(1.-E*E)*.5/E                                       6780
  134 CONTINUE                                                              6790
      PHP=PHPER                                                             6800
      POTH=PHSV                                                             6810
      POTC=PCSV                                                             6820
      POT1=PHSV                                                             6830
      POT2=PCSV                                                             6840
      DO 24 I=1,NLVC                                                        6850
   24 CALL BBL(RV,GRX,GRY,GRZ,RVQ,GRXQ,GRYQ,GRZQ,MMSAVH,FR1,FR2,HLD,        6860
     $SLUMP1,SLUMP2,THETA,RHO,AA,BB,POTH,POTC,N1,N2,F1,F2,d,hla(i),         6870
     $cla(i),x1a(i),x2a(i),y1a(i),y2a(i),gr1,gr2,wla(i),sm1,sm2,tpolh,      6880
     $tpolc,sbrh,sbrc,ifat1,ifat2,tavh,tavc,alb1,alb2,xbol1,xbol2,          6890
     $ybol1,ybol2,php,rm,xincl,hot,cool,snthh,csthh,snfih,csfih,tldh,       6900
     $glump1,glump2,xx1,xx2,yy1,yy2,zz1,zz2,dint1,dint2,grv1,grv2,          6910
     $rftemp,rf1,rf2,csbt1,csbt2,gmag1,gmag2,mode)                          6920
      NCF=1                                                                 6930
      DEL(9)=0.                                                             6940
      DEL(15)=0.                                                            6950
      DEL(30)=0.                                                            6960
      WRITE(6,101)                                                          6970
      WRITE(6,399)                                                          6980
      WRITE(6,55)(DEL(I),I=1,8)                                             6990
      WRITE(6,101)                                                          7000
      WRITE(6,402)                                                          7010
      WRITE(6,55)(DEL(I),I=10,14),(DEL(I),I=16,20)                          7020
      WRITE(6,101)                                                          7030
      WRITE(6,403)                                                          7040
      WRITE(6,55)(DEL(I),I=21,29)                                           7050
      DO 80 I=1,2                                                           7060
      IA=I+4                                                                7070
      DEL(I)=DEL(I)*DTR                                                     7080
   80 DEL(IA)=DEL(IA)*DTR                                                   7090
      WRITE(6,101)                                                          7100
      WRITE(6,406)                                                          7110
      WRITE(6,20)(KEP(I),I=1,30),IFDER,IFM,IFR                              7120
      WRITE(6,101)                                                          7130
      WRITE(6,166)                                                          7140
      WRITE(6,66)                                                           7150
      WRITE(6,61) KSPA,NSPA,KSPB,NSPB                                       7160
      WRITE(6,101)                                                          7170
      WRITE(6,707)                                                          7180
      WRITE(6,708)IFVC1,IFVC2,NLC,KO,KDISK,ISYM,nref,mref,ifsmv1,ifsmv2     7190
     $,icor1,icor2,ld                                                       7200
      WRITE(6,101)                                                          7210
      WRITE(6,12)                                                           7220
      WRITE(6,1)MODE,IPB,IFAT1,IFAT2,N1,N2,N1L,N2L,PERIOD,THE,VUNIT,VFAC    7230
      WRITE(6,101)                                                          7240
      WRITE(6,205)                                                          7250
      WRITE(6,206) E,PER,A,F1,F2,VGA,PSHIFT,XINCL,GR1,GR2                   7260
      WRITE(6,101)                                                          7270
      WRITE(6,54)                                                           7280
      WRITE(6,408) TAVH,TAVC,ALB1,ALB2,PHSV,PCSV,RM,xbol1,xbol2,ybol1,      7290
     $ybol2                                                                 7300
      IF(NVC.EQ.0) GOTO 196                                                 7310
      WRITE(6,101)                                                          7320
      WRITE(6,111)                                                          7330
      DO 91 I=1,NVC                                                         7340
   91 WRITE(6,218)WLA(I),HLA(I),CLA(I),X1A(I),X2A(I),y1a(i),y2a(i),         7350
     $sigma(i)                                                              7360
  196 CONTINUE                                                              7370
      IF(NLVC.EQ.NVC) GOTO 197                                              7380
      WRITE(6,101)                                                          7390
      WRITE(6,11)                                                           7400
      DO 92 I=NVCP,NLVC                                                     7410
   92 write(6,85)wla(i),hla(i),cla(i),x1a(i),x2a(i),y1a(i),y2a(i),          7420
     $el3a(i),noise(i),sigma(i)                                             7430
  197 CONTINUE                                                              7440
      WRITE(6,101)                                                          7450
      IF(NSTOT.GT.0) WRITE(6,983)                                           7460
      DO 688 KP=1,2                                                         7470
      IF((NSP1+KP-1).EQ.0) GOTO 688                                         7480
      IF((NSP2+(KP-2)**2).EQ.0) GOTO 688                                    7490
      NSPOT=NSP1                                                            7500
      IF(KP.EQ.2) NSPOT=NSP2                                                7510
      DO 687 I=1,NSPOT                                                      7520
  687 WRITE(6,684)KP,XLAT(KP,I),XLONG(KP,I),RADSP(KP,I),TEMSP(KP,I)         7530
  688 WRITE(6,101)                                                          7540
      WRITE(6,101)                                                          7550
      WRITE(6,9)                                                            7560
      DO 75 LCV=1,NLVC                                                      7570
      WRITE(6,101)                                                          7580
      IF(LCV.LE.NVC) WRITE(6,955)                                           7590
      IF(LCV.GT.NVC) WRITE(6,10)                                            7600
      DO 74 I=NS,7000                                                       7610
      I1=5*(I-1)+NY+1                                                       7620
      I2=I1+1                                                               7630
      I3=I2+1                                                               7640
      I4=I3+1                                                               7650
      I5=I4+1                                                               7660
      READ(5,2)PHAS(I1),FLUX(I1),WT(I1),PHAS(I2),FLUX(I2),WT(I2),PHAS(I3    7670
     $),FLUX(I3),WT(I3),PHAS(I4),FLUX(I4),WT(I4),PHAS(I5),FLUX(I5),WT(I5    7680
     $)                                                                     7690
      WRITE(6,4)PHAS(I1),FLUX(I1),WT(I1),PHAS(I2),FLUX(I2),WT(I2),PHAS(I    7700
     $3),FLUX(I3),WT(I3),PHAS(I4),FLUX(I4),WT(I4),PHAS(I5),FLUX(I5),WT(I    7710
     $5)                                                                    7720
      IF(PHAS(I1).LT.10.) GOTO 74                                           7730
      NI=PHAS(I1)-10.                                                       7740
      NY=NY+NI                                                              7750
      NOBS=5*(I-NS-1)+NI                                                    7760
      GOTO 150                                                              7770
   74 CONTINUE                                                              7780
  150 NS=I-1                                                                7790
      LC1=LCV+1                                                             7800
   75 KNOBS(LC1)=NOBS+KNOBS(LCV)                                            7810
      MATRIX=26-KEEP(1)-KEEP(2)-KEEP(3)-KEEP(4)-KEEP(5)-KEEP(6)-KEEP(7)-    7820
     $KEEP(8)-KEEP(9)-KEEP(10)-KEEP(11)-KEEP(12)-KEEP(13)-KEEP(14)-KEEP     7830
     $(15)-KEEP(16)-KEEP(17)-KEEP(18)-KEEP(19)-KEEP(20)-KEEP(21)-           7840
     $KEEP(22)-KEEP(23)-KEEP(24)-KEEP(25)+NLC*(5-KEEP(26)-KEEP(27)-         7850
     $KEEP(28)-KEEP(29)-KEEP(30))                                           7860
      MAT=MATRIX-1                                                          7870
      EM=MATRIX-15                                                          7880
      KTR=.24*EM+2.2                                                        7890
      IF(EM.LE.1.5) KTR=1                                                   7900
      IF(EM.GT.12.) KTR=5                                                   7910
      NCOEFF=MATRIX*KNOBS(LC1)                                              7920
      NMAT=MAT*KNOBS(LC1)                                                   7930
      NCOF=NCOEFF                                                           7940
      DO 63 J=1,NCOF                                                        7950
   63 HOLD(J)=0.                                                            7960
      IF(KOSQ.EQ.1) GOTO 71                                                 7970
      DO 416 IOBS=1,NCOEFF                                                  7980
  416 OBS(IOBS)=0.                                                          7990
      KSMAX=32                                                              8000
      KSSMAX=32                                                             8010
      IF(E.EQ.0.) KSMAX=1                                                   8020
      IF(E.NE.0.) KSSMAX=1                                                  8030
      DO 419 KSS=1,KSSMAX                                                   8040
      IF(KSSMAX.EQ.1) GOTO 520                                              8050
      KH=KSS-2                                                              8060
      IF(KH.LE.0) GOTO 510                                                  8070
      IF(KEEP(KH).EQ.1) GOTO 419                                            8080
  510 CONTINUE                                                              8090
  520 DO 417 IB=1,NLVC                                                      8100
      VC1=0.                                                                8110
      VC2=0.                                                                8120
      ELIT=0.                                                               8130
      IF(IB.GT.NVC) ELIT=1.                                                 8140
      IF(IB.EQ.IFVC1) VC1=1.                                                8150
      IF(IB.EQ.(IFVC2*(1+IFVC1))) VC2=1.                                    8160
      IST=KNOBS(IB)+1                                                       8170
      IB1=IB+1                                                              8180
      ISP=KNOBS(IB1)                                                        8190
      DO 418 IX=IST,ISP                                                     8200
      DO 420 KS=1,KSMAX                                                     8210
      IRTE=0                                                                8220
      IRVOL1=0                                                              8230
      IRVOL2=0                                                              8240
      IF(E.NE.0.) GOTO 297                                                  8250
      IF(IX.NE.IST) IRTE=1                                                  8260
      IF(IX.EQ.1) GOTO 297                                                  8270
      IRVOL1=1                                                              8280
      IRVOL2=1                                                              8290
  297 CONTINUE                                                              8300
      KSR=KS                                                                8310
      IF(E.EQ.0.) KSR=KSS                                                   8320
      IF(ISYM.NE.1) GOTO 1110                                               8330
      IF(KSR.EQ.1) GOTO 420                                                 8340
 1110 CONTINUE                                                              8350
      KH=KSR-2                                                              8360
      if(kh.le.25) goto 1119                                                8370
      if(ib.le.nvc) goto 420                                                8380
 1119 continue                                                              8390
      IF(KH.GT.0) GOTO 740                                                  8400
      KH=1                                                                  8410
      GOTO 941                                                              8420
  740 CONTINUE                                                              8430
      IF(KEEP(KH).EQ.1) GOTO 420                                            8440
      IF(E.EQ.0.) GOTO 889                                                  8450
      IF(KSR.LE.2) GOTO 889                                                 8460
      IF(KH.LE.9) IRTE=1                                                    8470
      IF(KH.LE.9) IRVOL1=1                                                  8480
      IF(KH.LE.9) IRVOL2=1                                                  8490
      IF(KH.EQ.12) IRVOL2=1                                                 8500
      IF(KH.EQ.13) IRVOL1=1                                                 8510
      IF(KH.EQ.15) IRTE=1                                                   8520
      IF(KH.EQ.15) IRVOL1=1                                                 8530
      IF(KH.EQ.15) IRVOL2=1                                                 8540
      IF(KH.EQ.16) IRTE=1                                                   8550
      IF(KH.EQ.16) IRVOL1=1                                                 8560
      IF(KH.EQ.16) IRVOL2=1                                                 8570
      IF(KH.EQ.17) IRVOL2=1                                                 8580
      IF(KH.EQ.18) IRVOL1=1                                                 8590
      IF(KH.EQ.19) IRVOL1=1                                                 8600
      IF(KH.EQ.19) IRVOL2=1                                                 8610
      IF(KH.EQ.20) IRVOL1=1                                                 8620
      IF(KH.EQ.20) IRVOL2=1                                                 8630
      IF(KH.EQ.21) IRVOL1=1                                                 8640
      IF(KH.EQ.21) IRVOL2=1                                                 8650
      IF(KH.EQ.22) IRVOL1=1                                                 8660
      IF(KH.EQ.22) IRVOL2=1                                                 8670
      IF(KH.EQ.23) IRVOL2=1                                                 8680
      IF(KH.EQ.24) IRVOL1=1                                                 8690
      IF(KH.GE.26) IRVOL1=1                                                 8700
      IF(KH.GE.26) IRVOL2=1                                                 8710
  889 CONTINUE                                                              8720
      LCF=0                                                                 8730
      IF(KH.GT.25) LCF=IB-NVC                                               8740
      KPCT1=0                                                               8750
      KPCT2=0                                                               8760
      KSP=KH                                                                8770
      IF(KH.GT.25) KSP=25                                                   8780
      IF(KH.LT.2) GOTO 808                                                  8790
      DO 804 ICT=1,KSP                                                      8800
  804 KPCT1=KPCT1+1-KEEP(ICT)                                               8810
      GOTO 809                                                              8820
  808 KPCT1=1                                                               8830
  809 CONTINUE                                                              8840
      IF(KH.LT.26) GOTO 806                                                 8850
      DO 805 ICT=26,KH                                                      8860
  805 KPCT2=KPCT2+1-KEEP(ICT)                                               8870
      GOTO 807                                                              8880
  806 KPCT2=1                                                               8890
  807 CONTINUE                                                              8900
      II=(KPCT1+NLC*(KPCT2-1)+LCF-1)*KNOBS(LC1)+IX                          8910
      IF(KH.EQ.9) GOTO 300                                                  8920
      IF(KH.EQ.15) GOTO 308                                                 8930
      IF(KH.EQ.30) GOTO 301                                                 8940
      IF(KH.NE.26) GOTO 941                                                 8950
      IF(MODE.LE.0) GOTO 941                                                8960
      IF(IPB.EQ.1) GOTO 941                                                 8970
      IF(IB.GT.NVC) OBS(II)=(BR(IX)-EL3A(IB))/HLA(IB)                       8980
      GOTO 420                                                              8990
  941 CONTINUE                                                              9000
      DL=DEL(KH)                                                            9010
      IF(ISYM.EQ.1) DL=.5*DEL(KH)                                           9020
      SIGN=1.                                                               9030
      ISS=1                                                                 9040
      if(e.ne.0.) iss=is                                                    9050
      DO 421 IH=1,30                                                        9060
  421 DLIF(IH)=0.                                                           9070
      IF(KSR.LE.2) GOTO 777                                                 9080
      ISS=IS                                                                9090
      DLIF(KH)=1.                                                           9100
  777 CONTINUE                                                              9110
      DO 319 IL=1,ISS                                                       9120
      IF(E.NE.0.) GOTO 4011                                                 9130
      IF(ISYM.EQ.1) GOTO 4012                                               9140
      GOTO 940                                                              9150
 4011 IF(KSR.LE.2) GOTO 940                                                 9160
 4012 IF(IL.EQ.2) GOTO 4016                                                 9170
      IF(LOW(KH).EQ.1) GOTO 314                                             9180
      VOL1=SVOL1                                                            9190
      VOL2=SVOL2                                                            9200
      SUMM1=SSUM1                                                           9210
      SUMM2=SSUM2                                                           9220
      SM1=SSM1                                                              9230
      SM2=SSM2                                                              9240
      DO 851 IRE=1,MTLH                                                     9250
  851 TLDH(IRE)=STLDH(IRE)                                                  9260
      DO 508 IRE=1,M1H                                                      9270
      RV(IRE)=SRV(IRE)                                                      9280
      GRX(IRE)=SGRX(IRE)                                                    9290
      GRY(IRE)=SGRY(IRE)                                                    9300
      GRZ(IRE)=SGRZ(IRE)                                                    9310
      GLUMP1(IRE)=SGLM1(IRE)                                                9320
      GRV1(IRE)=SGRV1(IRE)                                                  9330
      XX1(IRE)=SXX1(IRE)                                                    9340
      YY1(IRE)=SYY1(IRE)                                                    9350
      ZZ1(IRE)=SZZ1(IRE)                                                    9360
      GMAG1(IRE)=SGMG1(IRE)                                                 9370
      CSBT1(IRE)=SCSB1(IRE)                                                 9380
      RF1(IRE)=SRF1(IRE)                                                    9390
      FR1(IRE)=SFR1(IRE)                                                    9400
  508 SLUMP1(IRE)=SLMP1(IRE)                                                9410
      DO 309 IRE=1,M2H                                                      9420
      RVQ(IRE)=SRVQ(IRE)                                                    9430
      GRXQ(IRE)=SGRXQ(IRE)                                                  9440
      GRYQ(IRE)=SGRYQ(IRE)                                                  9450
      GRZQ(IRE)=SGRZQ(IRE)                                                  9460
      GLUMP2(IRE)=SGLM2(IRE)                                                9470
      GRV2(IRE)=SGRV2(IRE)                                                  9480
      XX2(IRE)=SXX2(IRE)                                                    9490
      YY2(IRE)=SYY2(IRE)                                                    9500
      ZZ2(IRE)=SZZ2(IRE)                                                    9510
      GMAG2(IRE)=SGMG2(IRE)                                                 9520
      CSBT2(IRE)=SCSB2(IRE)                                                 9530
      RF2(IRE)=SRF2(IRE)                                                    9540
      FR2(IRE)=SFR2(IRE)                                                    9550
  309 SLUMP2(IRE)=SLMP2(IRE)                                                9560
      GOTO 940                                                              9570
 4016 IF(LOW(KH).EQ.1) GOTO 4018                                            9580
      VOL1=EVOL1                                                            9590
      VOL2=EVOL2                                                            9600
      SUMM1=ESUM1                                                           9610
      SUMM2=ESUM2                                                           9620
      SM1=ESM1                                                              9630
      SM2=ESM2                                                              9640
      DO 852 IRE=1,MTLH                                                     9650
  852 TLDH(IRE)=ETLDH(IRE)                                                  9660
      DO 1508 IRE=1,M1H                                                     9670
      RV(IRE)=ERV(IRE)                                                      9680
      GRX(IRE)=EGRX(IRE)                                                    9690
      GRY(IRE)=EGRY(IRE)                                                    9700
      GRZ(IRE)=EGRZ(IRE)                                                    9710
      GLUMP1(IRE)=EGLM1(IRE)                                                9720
      GRV1(IRE)=EGRV1(IRE)                                                  9730
      XX1(IRE)=EXX1(IRE)                                                    9740
      YY1(IRE)=EYY1(IRE)                                                    9750
      ZZ1(IRE)=EZZ1(IRE)                                                    9760
      GMAG1(IRE)=EGMG1(IRE)                                                 9770
      CSBT1(IRE)=ECSB1(IRE)                                                 9780
      RF1(IRE)=ERF1(IRE)                                                    9790
      FR1(IRE)=EFR1(IRE)                                                    9800
 1508 SLUMP1(IRE)=ELMP1(IRE)                                                9810
      DO 1309 IRE=1,M2H                                                     9820
      RVQ(IRE)=ERVQ(IRE)                                                    9830
      GRXQ(IRE)=EGRXQ(IRE)                                                  9840
      GRYQ(IRE)=EGRYQ(IRE)                                                  9850
      GRZQ(IRE)=EGRZQ(IRE)                                                  9860
      GLUMP2(IRE)=EGLM2(IRE)                                                9870
      GRV2(IRE)=EGRV2(IRE)                                                  9880
      XX2(IRE)=EXX2(IRE)                                                    9890
      YY2(IRE)=EYY2(IRE)                                                    9900
      ZZ2(IRE)=EZZ2(IRE)                                                    9910
      GMAG2(IRE)=EGMG2(IRE)                                                 9920
      CSBT2(IRE)=ECSB2(IRE)                                                 9930
      RF2(IRE)=ERF2(IRE)                                                    9940
      FR2(IRE)=EFR2(IRE)                                                    9950
 1309 SLUMP2(IRE)=ELMP2(IRE)                                                9960
      GOTO 940                                                              9970
 4018 CONTINUE                                                              9980
      VOL1=EVOL1L                                                           9990
      VOL2=EVOL2L                                                          10000
      SUMM1=ESUM1L                                                         10010
      SUMM2=ESUM2L                                                         10020
      SM1=ESM1L                                                            10030
      SM2=ESM2L                                                            10040
      DO 853 IRE=1,MTLL                                                    10050
  853 TLDL(IRE)=ETLDL(IRE)                                                 10060
      DO 310 IRE=1,M1L                                                     10070
      RV(IRE)=ERVL(IRE)                                                    10080
      GRX(IRE)=EGRXL(IRE)                                                  10090
      GRY(IRE)=EGRYL(IRE)                                                  10100
      GRZ(IRE)=EGRZL(IRE)                                                  10110
      GLUMP1(IRE)=EGLM1L(IRE)                                              10120
      GRV1(IRE)=EGRV1L(IRE)                                                10130
      XX1(IRE)=EXX1L(IRE)                                                  10140
      YY1(IRE)=EYY1L(IRE)                                                  10150
      ZZ1(IRE)=EZZ1L(IRE)                                                  10160
      GMAG1(IRE)=EGMG1L(IRE)                                               10170
      CSBT1(IRE)=ECSB1L(IRE)                                               10180
      RF1(IRE)=ERF1L(IRE)                                                  10190
      FR1(IRE)=EFR1L(IRE)                                                  10200
  310 SLUMP1(IRE)=ELMP1L(IRE)                                              10210
      DO 311 IRE=1,M2L                                                     10220
      RVQ(IRE)=ERVQL(IRE)                                                  10230
      GRXQ(IRE)=EGRXQL(IRE)                                                10240
      GRYQ(IRE)=EGRYQL(IRE)                                                10250
      GRZQ(IRE)=EGRZQL(IRE)                                                10260
      GLUMP2(IRE)=EGLM2L(IRE)                                              10270
      GRV2(IRE)=EGRV2L(IRE)                                                10280
      XX2(IRE)=EXX2L(IRE)                                                  10290
      YY2(IRE)=EYY2L(IRE)                                                  10300
      ZZ2(IRE)=EZZ2L(IRE)                                                  10310
      GMAG2(IRE)=EGMG2L(IRE)                                               10320
      CSBT2(IRE)=ECSB2L(IRE)                                               10330
      RF2(IRE)=ERF2L(IRE)                                                  10340
      FR2(IRE)=EFR2L(IRE)                                                  10350
  311 SLUMP2(IRE)=ELMP2L(IRE)                                              10360
      GOTO 940                                                             10370
  314 CONTINUE                                                             10380
      VOL1=SVOL1L                                                          10390
      VOL2=SVOL2L                                                          10400
      SUMM1=SSUM1L                                                         10410
      SUMM2=SSUM2L                                                         10420
      SM1=SSM1L                                                            10430
      SM2=SSM2L                                                            10440
      DO 854 IRE=1,MTLL                                                    10450
  854 TLDL(IRE)=STLDL(IRE)                                                 10460
      DO 1310 IRE=1,M1L                                                    10470
      RV(IRE)=SRVL(IRE)                                                    10480
      GRX(IRE)=SGRXL(IRE)                                                  10490
      GRY(IRE)=SGRYL(IRE)                                                  10500
      GRZ(IRE)=SGRZL(IRE)                                                  10510
      GLUMP1(IRE)=SGLM1L(IRE)                                              10520
      GRV1(IRE)=SGRV1L(IRE)                                                10530
      XX1(IRE)=SXX1L(IRE)                                                  10540
      YY1(IRE)=SYY1L(IRE)                                                  10550
      ZZ1(IRE)=SZZ1L(IRE)                                                  10560
      GMAG1(IRE)=SGMG1L(IRE)                                               10570
      CSBT1(IRE)=SCSB1L(IRE)                                               10580
      RF1(IRE)=SRF1L(IRE)                                                  10590
      FR1(IRE)=SFR1L(IRE)                                                  10600
 1310 SLUMP1(IRE)=SLMP1L(IRE)                                              10610
      DO 1311 IRE=1,M2L                                                    10620
      RVQ(IRE)=SRVQL(IRE)                                                  10630
      GRXQ(IRE)=SGRXQL(IRE)                                                10640
      GRYQ(IRE)=SGRYQL(IRE)                                                10650
      GRZQ(IRE)=SGRZQL(IRE)                                                10660
      GLUMP2(IRE)=SGLM2L(IRE)                                              10670
      GRV2(IRE)=SGRV2L(IRE)                                                10680
      XX2(IRE)=SXX2L(IRE)                                                  10690
      YY2(IRE)=SYY2L(IRE)                                                  10700
      ZZ2(IRE)=SZZ2L(IRE)                                                  10710
      GMAG2(IRE)=SGMG2L(IRE)                                               10720
      CSBT2(IRE)=SCSB2L(IRE)                                               10730
      RF2(IRE)=SRF2L(IRE)                                                  10740
      FR2(IRE)=SFR2L(IRE)                                                  10750
 1311 SLUMP2(IRE)=SLMP2L(IRE)                                              10760
  940 CONTINUE                                                             10770
      DELS=DL*SIGN                                                         10780
      SIGN=-1.                                                             10790
      IF(NSPA.EQ.0) GOTO 470                                               10800
      xlt=dtr*xlat(kspa,nspa)+dels*dlif(1)                                 10810
      xlng(kspa,nspa)=dtr*xlong(kspa,nspa)+dels*dlif(2)                    10820
      snlat(kspa,nspa)=sin(xlt)                                            10830
      cslat(kspa,nspa)=cos(xlt)                                            10840
      snlng(kspa,nspa)=sin(xlng(kspa,nspa))                                10850
      cslng(kspa,nspa)=cos(xlng(kspa,nspa))                                10860
      RDSP(KSPA,NSPA)=RADSP(KSPA,NSPA)+DELS*DLIF(3)                        10870
      TMSP(KSPA,NSPA)=TEMSP(KSPA,NSPA)+DELS*DLIF(4)                        10880
  470 CONTINUE                                                             10890
      IF(NSPB.EQ.0) GOTO 471                                               10900
      xlt=dtr*xlat(kspb,nspb)+dels*dlif(5)                                 10910
      xlng(kspb,nspb)=dtr*xlong(kspb,nspb)+dels*dlif(6)                    10920
      snlat(kspb,nspb)=sin(xlt)                                            10930
      cslat(kspb,nspb)=cos(xlt)                                            10940
      snlng(kspb,nspb)=sin(xlng(kspb,nspb))                                10950
      cslng(kspb,nspb)=cos(xlng(kspb,nspb))                                10960
      RDSP(KSPB,NSPB)=RADSP(KSPB,NSPB)+DELS*DLIF(7)                        10970
      TMSP(KSPB,NSPB)=TEMSP(KSPB,NSPB)+DELS*DLIF(8)                        10980
  471 CONTINUE                                                             10990
      EC=E+DELS*DLIF(10)                                                   11000
      PERT=PERR+DELS*DLIF(11)                                              11010
      FF1=F1+DELS*DLIF(12)                                                 11020
      FF2=F2+DELS*DLIF(13)                                                 11030
      PSH=PSHIFT+DELS*DLIF(14)                                             11040
      XINC=XINCL+DELS*DLIF(16)                                             11050
      G1=GR1+DELS*DLIF(17)                                                 11060
      G2=GR2+DELS*DLIF(18)                                                 11070
      T1=TAVH+DELS*DLIF(19)                                                11080
      T2=TAVC+DELS*DLIF(20)                                                11090
      A1=ALB1+DELS*DLIF(21)                                                11100
      A2=ALB2+DELS*DLIF(22)                                                11110
      POT1=PHSV+DELS*DLIF(23)                                              11120
      POT2=PCSV+DELS*DLIF(24)                                              11130
      RMASS=RM+DELS*DLIF(25)                                               11140
      HL=HLA(IB)+DELS*DLIF(26)                                             11150
      CL=CLA(IB)+DELS*DLIF(27)                                             11160
      X1=X1A(IB)+DELS*DLIF(28)                                             11170
      X2=X2A(IB)+DELS*DLIF(29)                                             11180
      y1=y1a(ib)                                                           11190
      y2=y2a(ib)                                                           11200
      IF(KSR.EQ.1) GOTO 802                                                11210
      IF(KSR.EQ.2) GOTO 872                                                11220
      IF(LOW(KH).EQ.1) GOTO 802                                            11230
  872 CALL MODLOG(RV,GRX,GRY,GRZ,RVQ,GRXQ,GRYQ,GRZQ,MMSAVH,FR1,FR2,HLD,    11240
     $RMASS,POT1,POT2,G1,G2,A1,A2,N1,N2,FF1,FF2,MOD,XINC,THE,MODE,         11250
     $SNTHH,CSTHH,SNFIH,CSFIH,GRV1,GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,GLUMP1,    11260
     $GLUMP2,CSBT1,CSBT2,GMAG1,GMAG2)                                      11270
      CALL BBL(RV,GRX,GRY,GRZ,RVQ,GRXQ,GRYQ,GRZQ,MMSAVH,FR1,FR2,HLD,       11280
     $SLUMP1,SLUMP2,THETA,RHO,AA,BB,POT1,POT2,N1,N2,FF1,FF2,d,hl,cl,x1,    11290
     $x2,y1,y2,g1,g2,wla(ib),sm1,sm2,tph,tpc,sbrh,sbrc,ifat1,ifat2,t1,     11300
     $t2,a1,a2,xbol1,xbol2,ybol1,ybol2,phas(ix),rmass,xinc,hot,cool,       11310
     $snthh,csthh,snfih,csfih,tldh,glump1,glump2,xx1,xx2,yy1,yy2,zz1,      11320
     $zz2,dint1,dint2,grv1,grv2,rftemp,rf1,rf2,csbt1,csbt2,gmag1,gmag2,    11330
     $mode)                                                                11340
      GOTO 801                                                             11350
  802 CONTINUE                                                             11360
      CALL MODLOG(RV,GRX,GRY,GRZ,RVQ,GRXQ,GRYQ,GRZQ,MMSAVL,FR1,FR2,HLD,    11370
     $RMASS,POT1,POT2,G1,G2,A1,A2,N1L,N2L,FF1,FF2,MOD,XINC,THE,MODE,       11380
     $SNTHL,CSTHL,SNFIL,CSFIL,GRV1,GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,GLUMP1,    11390
     $GLUMP2,CSBT1,CSBT2,GMAG1,GMAG2)                                      11400
      CALL BBL(RV,GRX,GRY,GRZ,RVQ,GRXQ,GRYQ,GRZQ,MMSAVL,FR1,FR2,HLD,       11410
     $SLUMP1,SLUMP2,THETA,RHO,AA,BB,POT1,POT2,N1L,N2L,FF1,FF2,d,hl,cl,     11420
     $x1,x2,y1,y2,g1,g2,wla(ib),sm1,sm2,tph,tpc,sbrh,sbrc,ifat1,ifat2,     11430
     $t1,t2,a1,a2,xbol1,xbol2,ybol1,ybol2,phas(ix),rmass,xinc,hot,cool,    11440
     $snthl,csthl,snfil,csfil,tldl,glump1,glump2,xx1,xx2,yy1,yy2,zz1,      11450
     $zz2,dint1,dint2,grv1,grv2,rftemp,rf1,rf2,csbt1,csbt2,gmag1,gmag2,    11460
     $mode)                                                                11470
  801 CONTINUE                                                             11480
      IF(E.NE.0.) GOTO 4111                                                11490
      IF(ISYM.EQ.0) GOTO 602                                               11500
      IF(IX.NE.IST) GOTO 602                                               11510
      IF(KSR.EQ.1) GOTO 602                                                11520
      IF(KSR.EQ.2) GOTO 4119                                               11530
      IF(LOW(KH).EQ.1) GOTO 4112                                           11540
      GOTO 4119                                                            11550
 4111 IF(IRTE.EQ.1) GOTO 602                                               11560
      IF(KSR.GE.3) GOTO 602                                                11570
      IF(KSR.EQ.2) GOTO 4119                                               11580
 4112 IF(IL.EQ.2) GOTO 4116                                                11590
      SVOL1L=VOL1                                                          11600
      SVOL2L=VOL2                                                          11610
      SSUM1L=SUMM1                                                         11620
      SSUM2L=SUMM2                                                         11630
      SSM1L=SM1                                                            11640
      SSM2L=SM2                                                            11650
      DO 855 IHL=1,MTLL                                                    11660
  855 STLDL(IHL)=TLDL(IHL)                                                 11670
      DO 603 IHL=1,M1L                                                     11680
      SRVL(IHL)=RV(IHL)                                                    11690
      SGRXL(IHL)=GRX(IHL)                                                  11700
      SGRYL(IHL)=GRY(IHL)                                                  11710
      SGRZL(IHL)=GRZ(IHL)                                                  11720
      SLMP1L(IHL)=SLUMP1(IHL)                                              11730
      SGLM1L(IHL)=GLUMP1(IHL)                                              11740
      SGRV1L(IHL)=GRV1(IHL)                                                11750
      SXX1L(IHL)=XX1(IHL)                                                  11760
      SYY1L(IHL)=YY1(IHL)                                                  11770
      SZZ1L(IHL)=ZZ1(IHL)                                                  11780
      SGMG1L(IHL)=GMAG1(IHL)                                               11790
      SCSB1L(IHL)=CSBT1(IHL)                                               11800
      SRF1L(IHL)=RF1(IHL)                                                  11810
      SFR1L(IHL)=FR1(IHL)                                                  11820
  603 CONTINUE                                                             11830
      DO 606 IHL=1,M2L                                                     11840
      SRVQL(IHL)=RVQ(IHL)                                                  11850
      SGRXQL(IHL)=GRXQ(IHL)                                                11860
      SGRYQL(IHL)=GRYQ(IHL)                                                11870
      SGRZQL(IHL)=GRZQ(IHL)                                                11880
      SLMP2L(IHL)=SLUMP2(IHL)                                              11890
      SGLM2L(IHL)=GLUMP2(IHL)                                              11900
      SGRV2L(IHL)=GRV2(IHL)                                                11910
      SXX2L(IHL)=XX2(IHL)                                                  11920
      SYY2L(IHL)=YY2(IHL)                                                  11930
      SZZ2L(IHL)=ZZ2(IHL)                                                  11940
      SGMG2L(IHL)=GMAG2(IHL)                                               11950
      SCSB2L(IHL)=CSBT2(IHL)                                               11960
      SRF2L(IHL)=RF2(IHL)                                                  11970
      SFR2L(IHL)=FR2(IHL)                                                  11980
  606 CONTINUE                                                             11990
      GOTO 602                                                             12000
 4116 CONTINUE                                                             12010
      EVOL1L=VOL1                                                          12020
      EVOL2L=VOL2                                                          12030
      ESUM1L=SUMM1                                                         12040
      ESUM2L=SUMM2                                                         12050
      ESM1L=SM1                                                            12060
      ESM2L=SM2                                                            12070
      DO 856 IHL=1,MTLL                                                    12080
  856 ETLDL(IHL)=TLDL(IHL)                                                 12090
      DO 1603 IHL=1,M1L                                                    12100
      ERVL(IHL)=RV(IHL)                                                    12110
      EGRXL(IHL)=GRX(IHL)                                                  12120
      EGRYL(IHL)=GRY(IHL)                                                  12130
      EGRZL(IHL)=GRZ(IHL)                                                  12140
      ELMP1L(IHL)=SLUMP1(IHL)                                              12150
      EGLM1L(IHL)=GLUMP1(IHL)                                              12160
      EGRV1L(IHL)=GRV1(IHL)                                                12170
      EXX1L(IHL)=XX1(IHL)                                                  12180
      EYY1L(IHL)=YY1(IHL)                                                  12190
      EZZ1L(IHL)=ZZ1(IHL)                                                  12200
      EGMG1L(IHL)=GMAG1(IHL)                                               12210
      ECSB1L(IHL)=CSBT1(IHL)                                               12220
      ERF1L(IHL)=RF1(IHL)                                                  12230
      EFR1L(IHL)=FR1(IHL)                                                  12240
 1603 CONTINUE                                                             12250
      DO 1606 IHL=1,M2L                                                    12260
      ERVQL(IHL)=RVQ(IHL)                                                  12270
      EGRXQL(IHL)=GRXQ(IHL)                                                12280
      EGRYQL(IHL)=GRYQ(IHL)                                                12290
      EGRZQL(IHL)=GRZQ(IHL)                                                12300
      ELMP2L(IHL)=SLUMP2(IHL)                                              12310
      EGLM2L(IHL)=GLUMP2(IHL)                                              12320
      EGRV2L(IHL)=GRV2(IHL)                                                12330
      EXX2L(IHL)=XX2(IHL)                                                  12340
      EYY2L(IHL)=YY2(IHL)                                                  12350
      EZZ2L(IHL)=ZZ2(IHL)                                                  12360
      EGMG2L(IHL)=GMAG2(IHL)                                               12370
      ECSB2L(IHL)=CSBT2(IHL)                                               12380
      ERF2L(IHL)=RF2(IHL)                                                  12390
      EFR2L(IHL)=FR2(IHL)                                                  12400
 1606 CONTINUE                                                             12410
      GOTO 602                                                             12420
 4119 IF(IL.EQ.2) GOTO 4120                                                12430
      SVOL1=VOL1                                                           12440
      SVOL2=VOL2                                                           12450
      SSUM1=SUMM1                                                          12460
      SSUM2=SUMM2                                                          12470
      SSM1=SM1                                                             12480
      SSM2=SM2                                                             12490
      DO 857 IHH=1,MTLH                                                    12500
  857 STLDH(IHH)=TLDH(IHH)                                                 12510
      DO 601 IHH=1,M1H                                                     12520
      SRV(IHH)=RV(IHH)                                                     12530
      SGRX(IHH)=GRX(IHH)                                                   12540
      SGRY(IHH)=GRY(IHH)                                                   12550
      SGRZ(IHH)=GRZ(IHH)                                                   12560
      SLMP1(IHH)=SLUMP1(IHH)                                               12570
      SGLM1(IHH)=GLUMP1(IHH)                                               12580
      SGRV1(IHH)=GRV1(IHH)                                                 12590
      SXX1(IHH)=XX1(IHH)                                                   12600
      SYY1(IHH)=YY1(IHH)                                                   12610
      SZZ1(IHH)=ZZ1(IHH)                                                   12620
      SGMG1(IHH)=GMAG1(IHH)                                                12630
      SCSB1(IHH)=CSBT1(IHH)                                                12640
      SRF1(IHH)=RF1(IHH)                                                   12650
      SFR1(IHH)=FR1(IHH)                                                   12660
  601 CONTINUE                                                             12670
      DO 605 IHH=1,M2H                                                     12680
      SRVQ(IHH)=RVQ(IHH)                                                   12690
      SGRXQ(IHH)=GRXQ(IHH)                                                 12700
      SGRYQ(IHH)=GRYQ(IHH)                                                 12710
      SGRZQ(IHH)=GRZQ(IHH)                                                 12720
      SLMP2(IHH)=SLUMP2(IHH)                                               12730
      SGLM2(IHH)=GLUMP2(IHH)                                               12740
      SGRV2(IHH)=GRV2(IHH)                                                 12750
      SXX2(IHH)=XX2(IHH)                                                   12760
      SYY2(IHH)=YY2(IHH)                                                   12770
      SZZ2(IHH)=ZZ2(IHH)                                                   12780
      SGMG2(IHH)=GMAG2(IHH)                                                12790
      SCSB2(IHH)=CSBT2(IHH)                                                12800
      SRF2(IHH)=RF2(IHH)                                                   12810
      SFR2(IHH)=FR2(IHH)                                                   12820
  605 CONTINUE                                                             12830
      GOTO 602                                                             12840
 4120 CONTINUE                                                             12850
      EVOL1=VOL1                                                           12860
      EVOL2=VOL2                                                           12870
      ESUM1=SUMM1                                                          12880
      ESUM2=SUMM2                                                          12890
      ESM1=SM1                                                             12900
      ESM2=SM2                                                             12910
      DO 858 IHH=1,MTLH                                                    12920
  858 ETLDH(IHH)=TLDH(IHH)                                                 12930
      DO 1601 IHH=1,M1H                                                    12940
      ERV(IHH)=RV(IHH)                                                     12950
      EGRX(IHH)=GRX(IHH)                                                   12960
      EGRY(IHH)=GRY(IHH)                                                   12970
      EGRZ(IHH)=GRZ(IHH)                                                   12980
      ELMP1(IHH)=SLUMP1(IHH)                                               12990
      EGLM1(IHH)=GLUMP1(IHH)                                               13000
      EGRV1(IHH)=GRV1(IHH)                                                 13010
      EXX1(IHH)=XX1(IHH)                                                   13020
      EYY1(IHH)=YY1(IHH)                                                   13030
      EZZ1(IHH)=ZZ1(IHH)                                                   13040
      EGMG1(IHH)=GMAG1(IHH)                                                13050
      ECSB1(IHH)=CSBT1(IHH)                                                13060
      ERF1(IHH)=RF1(IHH)                                                   13070
      EFR1(IHH)=FR1(IHH)                                                   13080
 1601 CONTINUE                                                             13090
      DO 1605 IHH=1,M2H                                                    13100
      ERVQ(IHH)=RVQ(IHH)                                                   13110
      EGRXQ(IHH)=GRXQ(IHH)                                                 13120
      EGRYQ(IHH)=GRYQ(IHH)                                                 13130
      EGRZQ(IHH)=GRZQ(IHH)                                                 13140
      ELMP2(IHH)=SLUMP2(IHH)                                               13150
      EGLM2(IHH)=GLUMP2(IHH)                                               13160
      EGRV2(IHH)=GRV2(IHH)                                                 13170
      EXX2(IHH)=XX2(IHH)                                                   13180
      EYY2(IHH)=YY2(IHH)                                                   13190
      EZZ2(IHH)=ZZ2(IHH)                                                   13200
      EGMG2(IHH)=GMAG2(IHH)                                                13210
      ECSB2(IHH)=CSBT2(IHH)                                                13220
      ERF2(IHH)=RF2(IHH)                                                   13230
      EFR2(IHH)=FR2(IHH)                                                   13240
 1605 CONTINUE                                                             13250
  602 CONTINUE                                                             13260
      HTT=HOT                                                              13270
      IF(MODE.EQ.-1) HTT=0.                                                13280
      XR=(HTT+COOL+EL3A(IB))*ELIT+VKM1*VC1+VKM2*VC2                        13290
      IF(KSR.NE.1) GOTO 710                                                13300
      BL(IX)=XR                                                            13310
      GOTO 420                                                             13320
  710 CONTINUE                                                             13330
      IF(KSR.NE.2) GOTO 711                                                13340
      BR(IX)=XR                                                            13350
      II=NMAT+IX                                                           13360
      OBS(II)=FLUX(IX)-XR                                                  13370
      if(iss.eq.2) goto 319                                                13380
      GOTO 420                                                             13390
  711 CONTINUE                                                             13400
      XLR=BR(IX)                                                           13410
      IF(LOW(KH).EQ.1) XLR=BL(IX)                                          13420
      IF(IL.NE.2) GOTO 388                                                 13430
      XLR=XR                                                               13440
      GOTO 87                                                              13450
  388 XNR=XR                                                               13460
   87 OBS(II)=(XNR-XLR)/DEL(KH)                                            13470
  319 CONTINUE                                                             13480
      GOTO 420                                                             13490
  300 IF(IB.LE.NVC) OBS(II)=(BR(IX)-VGA)/A                                 13500
      GOTO 420                                                             13510
  308 IF(IB.LE.NVC) OBS(II)=1.                                             13520
      GOTO 420                                                             13530
  301 IF(IB.GT.NVC) OBS(II)=1.                                             13540
  420 CONTINUE                                                             13550
  418 CONTINUE                                                             13560
  417 CONTINUE                                                             13570
  419 CONTINUE                                                             13580
      write(6,101)                                                         13590
      write(6,101)                                                         13600
      write(6,101)                                                         13610
      write(6,159)                                                         13620
      write(6,101)                                                         13630
      write(6,169)                                                         13640
      do 298 icv=1,nlvc                                                    13650
      icvp=icv+1                                                           13660
      nbs=knobs(icvp)-knobs(icv)                                           13670
      iw=knobs(icv)+1                                                      13680
      jstart=nmat+iw                                                       13690
      jstop=jstart+nbs-1                                                   13700
      resq=0.                                                              13710
      do 299 jres=jstart,jstop                                             13720
  299 resq=resq+wt(iw)*obs(jres)**2                                        13730
      write(6,119) icv,nbs,resq                                            13740
  298 continue                                                             13750
      write(6,101)                                                         13760
      write(6,101)                                                         13770
      GOTO 65                                                              13780
   71 JF=0                                                                 13790
      IF(KO.EQ.0) stop                                                     13800
      DO 261 J=1,NCOF                                                      13810
  261 OBS(J)=HOLD(J)                                                       13820
      IF(KDISK.EQ.0) GOTO 72                                               13830
      REWIND 9                                                             13840
      READ(9,67)(OBS(J),J=1,NCOF)                                          13850
   72 READ(5,20)(KEEP(I),I=1,30),IFDER,IFM,IFR                             13860
      IF(KEEP(1).EQ.2) stop                                                13870
      DO 232 I=1,30                                                        13880
  232 IF(KEP(I).EQ.1) KEEP(I)=1                                            13890
      NOBS=KNOBS(LC1)                                                      13900
      MATRIX=26-KEEP(1)-KEEP(2)-KEEP(3)-KEEP(4)-KEEP(5)-KEEP(6)-KEEP(7)-   13910
     $KEEP(8)-KEEP(9)-KEEP(10)-KEEP(11)-KEEP(12)-KEEP(13)-KEEP(14)-KEEP    13920
     $(15)-KEEP(16)-KEEP(17)-KEEP(18)-KEEP(19)-KEEP(20)-KEEP(21)-KEEP      13930
     $(22)-KEEP(23)-KEEP(24)-KEEP(25)+NLC*(5-KEEP(26)-KEEP(27)-KEEP(28)    13940
     $-KEEP(29)-KEEP(30))                                                  13950
      MAT=MATRIX-1                                                         13960
      EM=MATRIX-15                                                         13970
      KTR=.24*EM+2.2                                                       13980
      IF(EM.LE.1.5) KTR=1                                                  13990
      IF(EM.GT.12.) KTR=5                                                  14000
      NCOEFF=MATRIX*NOBS                                                   14010
      KC=1                                                                 14020
      NSHIFT(1)=0                                                          14030
      DO 59 I=2,31                                                         14040
      IF(I.GT.26) KC=NLC                                                   14050
      KE=0                                                                 14060
      J=I-1                                                                14070
      IF(KEEP(J).GT.KEP(J)) KE=1                                           14080
   59 NSHIFT(I)=NOBS*KE*KC+NSHIFT(J)                                       14090
      NOBBS=NOBS                                                           14100
      DO 30 I=1,31                                                         14110
      IF(KEEP(I).EQ.1) GOTO 30                                             14120
      IF(I.GT.25) NOBBS=NOBS*NLC                                           14130
      IF(I.EQ.31) NOBBS=NOBS                                               14140
      DO 32 J=1,NOBBS                                                      14150
      JF=JF+1                                                              14160
      KX=JF+NSHIFT(I)                                                      14170
   32 OBS(JF)=OBS(KX)                                                      14180
   30 CONTINUE                                                             14190
   65 WRITE(6,102)                                                         14200
      WRITE(6,20)(KEEP(I),I=1,30),IFDER,IFM,IFR                            14210
      NOBS=KNOBS(LC1)                                                      14220
      WRITE(6,101)                                                         14230
      IF(IFDER.EQ.0) KTR=5                                                 14240
      WRITE(6,82)                                                          14250
      WRITE(6,101)                                                         14260
      DO 96 IB=1,NLVC                                                      14270
      IST=KNOBS(IB)+1                                                      14280
      IB1=IB+1                                                             14290
      ISP=KNOBS(IB1)                                                       14300
      DO 96 I=IST,ISP                                                      14310
      GOTO(5,6,7,8,96),KTR                                                 14320
    5 WRITE(6,15)(OBS(J),J=I,NCOEFF,NOBS)                                  14330
      GOTO 96                                                              14340
    6 WRITE(6,16)(OBS(J),J=I,NCOEFF,NOBS)                                  14350
      GOTO 96                                                              14360
    7 WRITE(6,17)(OBS(J),J=I,NCOEFF,NOBS)                                  14370
      GOTO 96                                                              14380
    8 WRITE(6,19)(OBS(J),J=I,NCOEFF,NOBS)                                  14390
   96 CONTINUE                                                             14400
   78 CONTINUE                                                             14410
      IF(KO.LE.1) GOTO 70                                                  14420
      IF(IBEF.EQ.1) GOTO 70                                                14430
      DO 62 J=1,NCOEFF                                                     14440
   62 HOLD(J)=OBS(J)                                                       14450
      IF(KDISK.EQ.0) GOTO 73                                               14460
      REWIND 9                                                             14470
      WRITE(9,67)(OBS(J),J=1,NCOEFF)                                       14480
   73 CONTINUE                                                             14490
   70 WRITE(6,101)                                                         14500
      DO 97 IB=1,NLVC                                                      14510
      IST=KNOBS(IB)+1                                                      14520
      IB1=IB+1                                                             14530
      ISP=KNOBS(IB1)                                                       14540
      NOIS=NOISE(IB)                                                       14550
      DO 97 I=IST,ISP                                                      14560
      IF(IB.GT.NVC) GOTO 444                                               14570
      ROOTWT=SQRT(WT(I))/(100.*SIGMA(IB))                                  14580
      GOTO 445                                                             14590
  444 ROOTWT=SQRT(WT(I))/(100.*SIGMA(IB)*SQRT(FLUX(I))**NOIS)              14600
  445 CONTINUE                                                             14610
      DO 97 LOB=I,NCOEFF,NOBS                                              14620
   97 OBS(LOB)=OBS(LOB)*ROOTWT                                             14630
      IF(IFDER.NE.0) WRITE(6,83)                                           14640
      IF(IFDER.NE.0) WRITE(6,101)                                          14650
      DO 98 I=1,NOBS                                                       14660
      GOTO(45,46,47,48,98),KTR                                             14670
   45 WRITE(6,15)(OBS(J),J=I,NCOEFF,NOBS)                                  14680
      GOTO 98                                                              14690
   46 WRITE(6,16)(OBS(J),J=I,NCOEFF,NOBS)                                  14700
      GOTO 98                                                              14710
   47 WRITE(6,17)(OBS(J),J=I,NCOEFF,NOBS)                                  14720
      GOTO 98                                                              14730
   48 WRITE(6,19)(OBS(J),J=I,NCOEFF,NOBS)                                  14740
   98 CONTINUE                                                             14750
   77 CALL SQUARE(OBS,NOBS,MAT,OUT,PE,deter,CN,CNN,S,CCL,LL,MM)            14760
      MSQ=MAT*MAT                                                          14770
      IF(IFM.EQ.0) GOTO 436                                                14780
      WRITE(6,101)                                                         14790
      WRITE(6,181)                                                         14800
      WRITE(6,101)                                                         14810
      DO 38 JR=1,MAT                                                       14820
   38 WRITE(6,37) (CN(JX),JX=JR,MSQ,MAT),CCL(JR)                           14830
      WRITE(6,101)                                                         14840
      WRITE(6,183)                                                         14850
      WRITE(6,101)                                                         14860
  436 CONTINUE                                                             14870
      NO1=23                                                               14880
      NO2=24                                                               14890
      NRM=25                                                               14900
      DO 334 IRM=1,24                                                      14910
      IF(IRM.LE.23) NO1=NO1-KEEP(IRM)                                      14920
      NO2=NO2-KEEP(IRM)                                                    14930
  334 NRM=NRM-KEEP(IRM)                                                    14940
      CORO1=1-KEEP(23)                                                     14950
      CORO2=1-KEEP(24)                                                     14960
      CORQ=1-KEEP(25)                                                      14970
      DO 34 JM=1,MAT                                                       14980
      DO 33 JQ=1,MAT                                                       14990
      JT=JM+MAT*(JQ-1)                                                     15000
      IJM=(MAT+1)*(JM-1)+1                                                 15010
      IJQ=(MAT+1)*(JQ-1)+1                                                 15020
   33 V(JQ)=CNN(JT)/DSQRT(CNN(IJM)*CNN(IJQ))                               15030
      if(jm.eq.nrm) co1q=v(no1)*corq*coro1                                 15040
      if(jm.eq.nrm) co2q=v(no2)*corq*coro2                                 15050
   34 WRITE(6,37)(V(IM),IM=1,MAT)                                          15060
      IF(IFM.EQ.0) GOTO 36                                                 15070
      WRITE(6,101)                                                         15080
      WRITE(6,184)                                                         15090
      WRITE(6,101)                                                         15100
      CALL DGMPRD(CN,CNN,CNOUT,MAT,MAT,MAT)                                15110
      DO 116 J8=1,MAT                                                      15120
  116 WRITE(6,37)(CNOUT(J7),J7=J8,MSQ,MAT)                                 15130
      WRITE(6,101)                                                         15140
      WRITE(6,185)                                                         15150
      WRITE(6,101)                                                         15160
      ANSCH=0.D0                                                           15170
      DO 118 J5=1,MAT                                                      15180
      V(J5)=0.D0                                                           15190
      DO 117 J6=1,MAT                                                      15200
      I9=J5+MAT*(J6-1)                                                     15210
  117 V(J5)=OUT(J6)*CN(I9)+V(J5)                                           15220
      ERR=V(J5)-CCL(J5)                                                    15230
  118 ANSCH=ANSCH+DABS(ERR)                                                15240
      WRITE(6,137)(V(J4),J4=1,MAT)                                         15250
      WRITE(6,101)                                                         15260
      WRITE(6,138) ANSCH                                                   15270
   36 CONTINUE                                                             15280
      WRITE(6,101)                                                         15290
      WRITE(6,101)                                                         15300
      IE=MAT                                                               15310
      IF(MAT.GT.16) IE=16                                                  15320
      WRITE(6,43)                                                          15330
      WRITE(6,15)(OUT(I),I=1,IE)                                           15340
      WRITE(6,101)                                                         15350
      WRITE(6,44)                                                          15360
      WRITE(6,15)(PE(I),I=1,IE)                                            15370
      IF(MAT.LE.16) GOTO 88                                                15380
      WRITE(6,101)                                                         15390
      WRITE(6,101)                                                         15400
      WRITE(6,43)                                                          15410
      WRITE(6,15)(OUT(I),I=17,MAT)                                         15420
      WRITE(6,101)                                                         15430
      WRITE(6,44)                                                          15440
      WRITE(6,15)(PE(I),I=17,MAT)                                          15450
   88 RESSQ=0.                                                             15460
      JST=MAT*NOBS+1                                                       15470
      DO 199 JRES=JST,NCOEFF                                               15480
  199 RESSQ=RESSQ+OBS(JRES)**2                                             15490
      WRITE(6,101)                                                         15500
      WRITE(6,40)                                                          15510
      WRITE(6,21) RESSQ,S,deter                                            15520
      IBEF=1                                                               15530
      IF(IFR.EQ.0) GOTO 71                                                 15540
      WRITE(6,102)                                                         15550
      WRITE(6,101)                                                         15560
      WRITE(6,101)                                                         15570
      WRITE(6,650)                                                         15580
      WRITE(6,101)                                                         15590
      WRITE(6,101)                                                         15600
      WRITE(6,653)                                                         15610
      WRITE(6,101)                                                         15620
      DO1=PE(NO1)*CORO1                                                    15630
      DO2=PE(NO2)*CORO2                                                    15640
      if(mod.eq.1) do2=do1                                                 15650
      if(mod.eq.1) co2q=co1q                                               15660
      DQ=PE(NRM)*CORQ                                                      15670
      COQ=CO1Q                                                             15680
      F=F1                                                                 15690
      DP=1.-E                                                              15700
      OME=PHSV                                                             15710
      DOM=DO1                                                              15720
      KOMP=0                                                               15730
  925 CONTINUE                                                             15740
      KOMP=KOMP+1                                                          15750
      DO 926 KD=1,4                                                        15760
      if(kd.ne.2) goto 928                                                 15770
      if(po(komp).ge.omcr(komp)) goto 928                                  15780
      goto 926                                                             15790
  928 continue                                                             15800
      TH=XTHA(KD)                                                          15810
      FI=XFIA(KD)                                                          15820
      CALL ROMQSP(OME,RM,F,DP,E,TH,FI,R,DRDO,DRDQ,DODQ,KOMP,MODE)          15830
      DR=SQRT(DRDQ**2*DQ**2+DRDO**2*DOM**2+2.*COQ*DRDQ*DRDO*DQ*DOM)        15840
      WRITE(6,654)KOMP,ARAD(KD),R,DRDO,DRDQ,DR                             15850
  926 CONTINUE                                                             15860
      DO2DQ=DODQ                                                           15870
      IF(KOMP.EQ.1)DO1DQ=DODQ                                              15880
      COQ=CO2Q                                                             15890
      F=F2                                                                 15900
      OME=PCSV                                                             15910
      DOM=DO2                                                              15920
      WRITE(6,101)                                                         15930
      IF(KOMP.EQ.1) GOTO 925                                               15940
      WRITE(6,101)                                                         15950
      WRITE(6,651)                                                         15960
      IF(KOMP.EQ.2) WRITE(6,652)DO1DQ,DO2DQ,CO1Q,CO2Q,DO1,DO2,DQ           15970
      GOTO 71                                                              15980
      END                                                                  15990
      Subroutine light(phs,xincl,xh,xc,yh,yc,n1,n2,sumhot,sumkul,rv,grx,   16000
     $gry,grz,rvq,grxq,gryq,grzq,mmsave,theta,rho,aa,bb,slump1,slump2,     16010
     $somhot,somkul,d,wl,snth,csth,snfi,csfi,tld,gmag1,gmag2)              16020
c   Version of August 23, 1993                                             16030
      DIMENSION RV(*),GRX(*),GRY(*),GRZ(*),RVQ(*),GRXQ(*),GRYQ(*),GRZQ(*   16040
     $),SLUMP1(*),SLUMP2(*),MMSAVE(*),THETA(*),RHO(*),AA(*),BB(*)          16050
      DIMENSION SNTH(*),CSTH(*),SNFI(*),CSFI(*),tld(*),gmag1(*),gmag2(*)   16060
      COMMON X1                                                            16070
      COMMON /KFAC/ KFF1,KFF2,kfo1,kfo2                                    16080
      COMMON /NSPT/ NSP1,NSP2,IFAT1,IFAT2                                  16090
      common /invar/ khdum,ipbdum,irtedm,nrefdm,irv1dm,irv2dm,mrefdm       16100
     $,ifs1dm,ifs2dm,icr1dm,icr2dm,ld                                      16110
      common /setest/ sefac                                                16120
      PHA=PHS*6.283185                                                     16130
      K=6                                                                  16140
      KK=K+1                                                               16150
      XLUMP=14384./WL                                                      16160
      XINC=XINCL*.0174533                                                  16170
      L=1                                                                  16180
      TEST=(PHS-.5)**2                                                     16190
      TESTS=(TEST-.071525)**2                                              16200
      SINI=SIN(XINC)                                                       16210
      COSPH=COS(PHA)                                                       16220
      SINPH=SIN(PHA)                                                       16230
      SINSQ=SINPH**2                                                       16240
      COSI=COS(XINC)                                                       16250
      NP1=N1+1                                                             16260
      NP2=N1+N2+2                                                          16270
      LLL1=MMSAVE(NP1)                                                     16280
      LLL2=MMSAVE(NP2)                                                     16290
      NPP2=NP2-1                                                           16300
      LL1=MMSAVE(N1)+1                                                     16310
      LL2=MMSAVE(NPP2)+1                                                   16320
      LLLL1=(LL1+LLL1)/2                                                   16330
      LLLL2=(LL2+LLL2)/2                                                   16340
      SINSQE=0.                                                            16350
      IF(SINI.GT.0.) SINSQE=((1.10*(RV(LLL1)+RVQ(LLL2))/D)**2-COSI**2)/    16360
     $SINI**2                                                              16370
      CICP=COSI*COSPH                                                      16380
      CISP=COSI*SINPH                                                      16390
      XLOS=COSPH*SINI                                                      16400
      YLOS=-SINPH*SINI                                                     16410
      ZLOS=COSI                                                            16420
      SUM=0.                                                               16430
      SOM=0.                                                               16440
      IF(TEST.LE..0625)GOTO 18                                             16450
      COMP=-1.                                                             16460
      CMP=1.                                                               16470
      COMPP=1.                                                             16480
      KOMP=2                                                               16490
      NSPOT=NSP2                                                           16500
      IFAT=IFAT2                                                           16510
      CMPP=0.                                                              16520
      X=XC                                                                 16530
      y=yc                                                                 16540
      EN=N2                                                                16550
      NPH=N2                                                               16560
      NP=2*N2                                                              16570
      GOTO 28                                                              16580
   18 X=XH                                                                 16590
      y=yh                                                                 16600
      COMP=1.                                                              16610
      KOMP=1                                                               16620
      NSPOT=NSP1                                                           16630
      IFAT=IFAT1                                                           16640
      CMP=0.                                                               16650
      COMPP=-1.                                                            16660
      CMPP=1.                                                              16670
      EN=N1                                                                16680
      NPH=N1                                                               16690
      NP=2*N1                                                              16700
   28 DELTH=1.570796/EN                                                    16710
      AR=CMPP*RV(LLLL1)+CMP*RVQ(LLLL2)                                     16720
      BR=CMPP*RV(1)+CMP*RVQ(1)                                             16730
      ASQ=AR*AR                                                            16740
      BSQ=BR*BR                                                            16750
      AB=AR*BR                                                             16760
      absq=ab*ab                                                           16770
      ASBS=ASQ-BSQ                                                         16780
      KF=(2-KOMP)*KFF1+(KOMP-1)*KFF2                                       16790
      CMPPD=CMPP*D                                                         16800
      CMPD=CMP*D                                                           16810
      NPP=NP+1                                                             16820
      TEMF=1.                                                              16830
      DO 36 I=1,NP                                                         16840
      IF(I.GT.NPH)GOTO 54                                                  16850
      UPDOWN=1.                                                            16860
      IK=I                                                                 16870
      GOTO 55                                                              16880
   54 UPDOWN=-1.                                                           16890
      IK=NPP-I                                                             16900
   55 CONTINUE                                                             16910
      IPN1=IK+(KOMP-1)*N1                                                  16920
      SINTH=SNTH(IPN1)                                                     16930
      COSTH=CSTH(IPN1)*UPDOWN                                              16940
      EM=SINTH*EN*1.3                                                      16950
      MM=EM+1.                                                             16960
      XM=MM                                                                16970
      MH=MM                                                                16980
      MM=2*MM                                                              16990
      DELFI=3.141593/XM                                                    17000
      IP=(KOMP-1)*NP1+IK                                                   17010
      IY=MMSAVE(IP)+1                                                      17020
      IF(TEST.LE..0625)GOTO 19                                             17030
      GX=GRXQ(IY)                                                          17040
      GY=-GRYQ(IY)                                                         17050
      GZ=UPDOWN*GRZQ(IY)                                                   17060
      grmag=gmag2(iy)                                                      17070
      GOTO 29                                                              17080
   19 GX=GRX(IY)                                                           17090
      GY=-GRY(IY)                                                          17100
      GZ=UPDOWN*GRZ(IY)                                                    17110
      grmag=gmag1(iy)                                                      17120
   29 COSSAV=(XLOS*GX+YLOS*GY+ZLOS*GZ)/GRMAG                               17130
      SUMJ=0.                                                              17140
      SOMJ=0.                                                              17150
      MPP=MM+1                                                             17160
      IY=IY-1                                                              17170
      DO 26 J=1,MM                                                         17180
      IF(J.GT.MH) GOTO 58                                                  17190
      RTLEFT=1.                                                            17200
      JK=J                                                                 17210
      GOTO 59                                                              17220
   58 RTLEFT=-1.                                                           17230
      JK=MPP-J                                                             17240
   59 CONTINUE                                                             17250
      IX=IY+JK                                                             17260
      IS=IX+(KOMP-1)*LLL1                                                  17270
      SINFI=SNFI(IS)*RTLEFT                                                17280
      COSFI=CSFI(IS)                                                       17290
      STSF=SINTH*SINFI                                                     17300
      STCF=SINTH*COSFI                                                     17310
      IF(TEST.LE..0625)GOTO 39                                             17320
      IF(RVQ(IX).EQ.-1.) GOTO 26                                           17330
      GX=GRXQ(IX)                                                          17340
      GY=RTLEFT*GRYQ(IX)                                                   17350
      GZ=UPDOWN*GRZQ(IX)                                                   17360
      R=RVQ(IX)                                                            17370
      grmag=gmag2(ix)                                                      17380
      GOTO 49                                                              17390
   39 IF(RV(IX).EQ.-1.) GOTO 26                                            17400
      GX=GRX(IX)                                                           17410
      GY=RTLEFT*GRY(IX)                                                    17420
      GZ=UPDOWN*GRZ(IX)                                                    17430
      R=RV(IX)                                                             17440
      grmag=gmag1(ix)                                                      17450
   49 COSGAM=(XLOS*GX+YLOS*GY+ZLOS*GZ)/GRMAG                               17460
      if(sinsq.gt.sinsqe) goto 27                                          17470
      IF(TESTS.LT.2.2562E-3) GOTO 170                                      17480
      IF((STCF*R).GT.(sefac*(CMP+COMP*X1))) GOTO 129                       17490
  170 PROD=COSSAV*COSGAM                                                   17500
      IF(PROD.GT.0.) GOTO 22                                               17510
      COSSAV=-COSSAV                                                       17520
      ZZ=R*COSTH                                                           17530
      YY=R*COMP*STSF                                                       17540
      XX=CMPD+COMP*STCF*R                                                  17550
      YSKY=XX*SINPH+YY*COSPH-cmpd*SINPH                                    17560
      ZSKY=-XX*CICP+yy*CISP+ZZ*SINI+CMPD*CICP                              17570
      RHO(L)=SQRT(YSKY**2+ZSKY**2)                                         17580
      THETA(L)=ARSIN(ZSKY/RHO(L))                                          17590
      IF(YSKY.LT.0.) GOTO 92                                               17600
      THETA(L)=6.283185+THETA(L)                                           17610
      GOTO 93                                                              17620
   92 THETA(L)=3.141593-THETA(L)                                           17630
   93 IF (THETA(L).GE.6.283185) THETA(L)=THETA(L)-6.283185                 17640
      L=L+1                                                                17650
      GOTO 27                                                              17660
   22 COSSAV=COSGAM                                                        17670
      GOTO 27                                                              17680
  129 COSSAV=COSGAM                                                        17690
      IF(KF.LE.0) GOTO 27                                                  17700
      ZZ=R*COSTH                                                           17710
      YY=R*COMP*STSF                                                       17720
      XX=CMPD+COMP*STCF*R                                                  17730
      YSKY=XX*SINPH+YY*COSPH-cmpd*SINPH                                    17740
      ZSKY=-XX*CICP+YY*CISP+ZZ*SINI+CMPD*CICP                              17750
      rptsq=YSKY**2+ZSKY**2                                                17760
      rtstsq=absq/(BSQ+ASBS*(ZSKY**2/rptsq))                               17770
      IF(rptsq.LE.rtstsq) GOTO 26                                          17780
   27 IF(COSGAM.GE.0.) GOTO 26                                             17790
      COSGAM=-COSGAM                                                       17800
      DARKEN=1.-X+X*COSGAM                                                 17810
      if(ld.ne.2) goto 141                                                 17820
      if(cosgam.eq.0.) goto 141                                            17830
      darken=darken-y*cosgam*alog(cosgam)                                  17840
      goto 147                                                             17850
  141 continue                                                             17860
      if(ld.eq.3) darken=darken-y*(1.-sqrt(cosgam))                        17870
  147 if(darken.lt.0.) darken=0.                                           17880
      ATRATN=1.                                                            17890
      ATRATO=1.                                                            17900
      CORFAC=1.                                                            17910
      IF(NSPOT.EQ.0) GOTO 640                                              17920
      CALL SPOT(KOMP,NSPOT,SINTH,COSTH,SINFI,COSFI,TEMF)                   17930
      IF(TEMF.EQ.1.) GOTO 640                                              17940
      TSP=TLD(IS)*TEMF                                                     17950
      IF(IFAT.EQ.0) GOTO 641                                               17960
      CALL ATM(TLD(IS),WL,ATRATO)                                          17970
      CALL ATM(TSP,WL,ATRATN)                                              17980
  641 CORFAC=ATRATN*(EXP(XLUMP/TLD(IS))-1.)/(ATRATO*(EXP(XLUMP/TSP)-1.))   17990
  640 CONTINUE                                                             18000
      DIF=COSGAM*DARKEN*CORFAC*(CMP*SLUMP2(IX)+CMPP*SLUMP1(IX))            18010
      v=-r*(STCF*YLOS-stsf*XLOS)*COMP                                      18020
      DIFF=DIF*V                                                           18030
      SOMJ=SOMJ+DIFF                                                       18040
   45 SUMJ=SUMJ+DIF                                                        18050
   26 CONTINUE                                                             18060
      SOMJ=SOMJ*DELFI                                                      18070
      SUMJ=SUMJ*DELFI                                                      18080
      SOM=SOM+SOMJ                                                         18090
   36 SUM=SUM+SUMJ                                                         18100
      IF(SINSQ.GE.SINSQE) GOTO 75                                          18110
      L=L-1                                                                18120
      CALL SORTER (L,THETA,RHO)                                            18130
      CALL FOUR (L,K,THETA,RHO,AA,BB)                                      18140
   75 IF(TEST.LE..0625)GOTO 118                                            18150
      SUMKUL=SUM*DELTH                                                     18160
      SOMKUL=SOM*DELTH                                                     18170
      X=XH                                                                 18180
      y=yh                                                                 18190
      KOMP=1                                                               18200
      NSPOT=NSP1                                                           18210
      IFAT=IFAT1                                                           18220
      EN=N1                                                                18230
      SAFTY=2.6*RV(LLL1)/EN                                                18240
      RMAX=RVQ(LLL2)+SAFTY                                                 18250
      RMIN=RVQ(1)-SAFTY                                                    18260
      NPH=N1                                                               18270
      NP=2*N1                                                              18280
      GOTO 128                                                             18290
  118 X=XC                                                                 18300
      y=yc                                                                 18310
      KOMP=2                                                               18320
      NSPOT=NSP2                                                           18330
      IFAT=IFAT2                                                           18340
      SUMHOT=SUM*DELTH                                                     18350
      SOMHOT=SOM*DELTH                                                     18360
      EN=N2                                                                18370
      SAFTY=2.6*RVQ(LLL2)/EN                                               18380
      RMAX=RV(LLL1)+SAFTY                                                  18390
      RMIN=RV(1)-SAFTY                                                     18400
      NPH=N2                                                               18410
      NP=2*N2                                                              18420
  128 DELTH=1.570796/EN                                                    18430
      SOM=0.                                                               18440
      SUM=0.                                                               18450
      NPP=NP+1                                                             18460
      TEMF=1.                                                              18470
      DO 136 I=1,NP                                                        18480
      IF(I.GT.NPH) GOTO 154                                                18490
      UPDOWN=1.                                                            18500
      IK=I                                                                 18510
      GOTO 155                                                             18520
  154 UPDOWN=-1.                                                           18530
      IK=NPP-I                                                             18540
  155 CONTINUE                                                             18550
      IPN1=IK+(KOMP-1)*N1                                                  18560
      SINTH=SNTH(IPN1)                                                     18570
      COSTH=CSTH(IPN1)*UPDOWN                                              18580
      EM=SINTH*EN*1.3                                                      18590
      MM=EM+1.                                                             18600
      XM=MM                                                                18610
      MH=MM                                                                18620
      MM=2*MM                                                              18630
      DELFI=3.141593/XM                                                    18640
      SOMJ=0.                                                              18650
      SUMJ=0.                                                              18660
      SIGN=0.                                                              18670
      DRHO=1.                                                              18680
      MPP=MM+1                                                             18690
      DO 126 J=1,MM                                                        18700
      IF(J.GT.MH) GOTO 158                                                 18710
      RTLEFT=1.                                                            18720
      JK=J                                                                 18730
      GOTO 159                                                             18740
  158 RTLEFT=-1.                                                           18750
      JK=MPP-J                                                             18760
  159 CONTINUE                                                             18770
      IP=(KOMP-1)*NP1+IK                                                   18780
      IX=MMSAVE(IP)+JK                                                     18790
      IS=IX+LLL1*(KOMP-1)                                                  18800
      SINFI=SNFI(IS)*RTLEFT                                                18810
      COSFI=CSFI(IS)                                                       18820
      STSF=SINTH*SINFI                                                     18830
      STCF=SINTH*COSFI                                                     18840
      IF(TEST.LE..0625)GOTO 139                                            18850
      IF(RV(IX).EQ.-1.) GOTO 126                                           18860
      GX=GRX(IX)                                                           18870
      GY=RTLEFT*GRY(IX)                                                    18880
      GZ=UPDOWN*GRZ(IX)                                                    18890
      R=RV(IX)                                                             18900
      grmag=gmag1(ix)                                                      18910
      GOTO 149                                                             18920
  139 IF(RVQ(IX).EQ.-1.) GOTO 126                                          18930
      GX=GRXQ(IX)                                                          18940
      GY=RTLEFT*GRYQ(IX)                                                   18950
      GZ=UPDOWN*GRZQ(IX)                                                   18960
      R=RVQ(IX)                                                            18970
      grmag=gmag2(ix)                                                      18980
  149 COSGAM=(XLOS*GX+YLOS*GY+ZLOS*GZ)/GRMAG                               18990
      IF(COSGAM.LT.0.) GOTO 104                                            19000
      SIGN=0.                                                              19010
      OLSIGN=0.                                                            19020
      GOTO 126                                                             19030
  104 COSGAM=-COSGAM                                                       19040
      ZZ=R*COSTH                                                           19050
      YY=R*COMPP*STSF                                                      19060
      XX=CMPPD+COMPP*STCF*R                                                19070
      DARKEN=1.-X+X*COSGAM                                                 19080
      if(ld.eq.1) goto 142                                                 19090
      if(cosgam.eq.0.) goto 142                                            19100
      darken=darken-y*cosgam*alog(cosgam)                                  19110
      goto 148                                                             19120
  142 continue                                                             19130
      if(ld.eq.3) darken=darken-y*(1.-sqrt(cosgam))                        19140
  148 if(darken.lt.0.) darken=0.                                           19150
      OLDIF=DIF                                                            19160
      ATRATN=1.                                                            19170
      ATRATO=1.                                                            19180
      CORFAC=1.                                                            19190
      IF(NSPOT.EQ.0) GOTO 660                                              19200
      CALL SPOT(KOMP,NSPOT,SINTH,COSTH,SINFI,COSFI,TEMF)                   19210
      IF(TEMF.EQ.1.) GOTO 660                                              19220
      TSP=TLD(IS)*TEMF                                                     19230
      IF(IFAT.EQ.0) GOTO 661                                               19240
      CALL ATM(TLD(IS),WL,ATRATO)                                          19250
      CALL ATM(TSP,WL,ATRATN)                                              19260
  661 CORFAC=ATRATN*(EXP(XLUMP/TLD(IS))-1.)/(ATRATO*(EXP(XLUMP/TSP)-1.))   19270
  660 CONTINUE                                                             19280
      DIF=COSGAM*DARKEN*CORFAC*(CMPP*SLUMP2(IX)+CMP*SLUMP1(IX))            19290
      v=R*(STCF*YLOS-STSF*XLOS)*COMP                                       19300
      DIFF=DIF*V                                                           19310
      IF(SINSQ.GT.SINSQE) GOTO 63                                          19320
      OLSIGN=SIGN                                                          19330
      OLDRHO=DRHO                                                          19340
      YSKY=XX*SINPH+YY*COSPH-cmpd*SINPH                                    19350
      ZSKY=-XX*CICP+yy*CISP+ZZ*SINI+CMPD*CICP                              19360
      RRHO=SQRT(YSKY**2+ZSKY**2)                                           19370
      IF(RRHO.GT.RMAX)GOTO 63                                              19380
      IF(RRHO.LT.RMIN)GOTO 126                                             19390
      THET=ARSIN(ZSKY/RRHO)                                                19400
      IF(YSKY.LT.0.) GOTO 192                                              19410
      THET=6.283185+THET                                                   19420
      GOTO 193                                                             19430
  192 THET=3.141593-THET                                                   19440
  193 IF(THET.GE.6.283185) THET=THET-6.283185                              19450
      RHHO=0.                                                              19460
      DO 52 N=1,KK                                                         19470
      ENNN=N-1                                                             19480
      ENTHET=ENNN*THET                                                     19490
   52 RHHO=RHHO+AA(N)*COS(ENTHET)+BB(N)*SIN(ENTHET)                        19500
      IF(RRHO.LE.RHHO) GOTO 80                                             19510
      SIGN=1.                                                              19520
      GOTO 81                                                              19530
   80 SIGN=-1.                                                             19540
   81 DRHO=ABS(RRHO-RHHO)                                                  19550
      IF((SIGN*OLSIGN).GE.0.) GOTO 60                                      19560
      SUMDR=DRHO+OLDRHO                                                    19570
      FACT=-(.5-DRHO/SUMDR)                                                19580
      IF(FACT.LT.0.) GOTO 198                                              19590
      RDIF=OLDIF                                                           19600
      GOTO 199                                                             19610
  198 RDIF=DIF                                                             19620
  199 CORR=FACT*RDIF*SIGN                                                  19630
      CORRR=CORR*V                                                         19640
      SUMJ=SUMJ+CORR                                                       19650
      SOMJ=SOMJ+CORRR                                                      19660
   60 IF(SIGN.LT.0.) GOTO 126                                              19670
   63 SUMJ=SUMJ+DIF                                                        19680
      SOMJ=SOMJ+DIFF                                                       19690
  126 CONTINUE                                                             19700
      SOMJ=SOMJ*DELFI                                                      19710
      SUMJ=SUMJ*DELFI                                                      19720
      SOM=SOM+SOMJ                                                         19730
  136 SUM=SUM+SUMJ                                                         19740
      IF(TEST.LE..0625)GOTO 120                                            19750
      SOMHOT=SOM*DELTH                                                     19760
      SUMHOT=SUM*DELTH                                                     19770
      GOTO 121                                                             19780
  120 SUMKUL=SUM*DELTH                                                     19790
      SOMKUL=SOM*DELTH                                                     19800
  121 RETURN                                                               19810
      END                                                                  19820
      SUBROUTINE SINCOS (KOMP,N,N1,SNTH,CSTH,SNFI,CSFI,MMSAVE)             19830
C     VERSION OF March 10, 1992. DESTROY EARLIER VERSIONS.                 19840
      DIMENSION SNTH(*),CSTH(*),SNFI(*),CSFI(*),MMSAVE(*)                  19850
      IP=(KOMP-1)*(N1+1)+1                                                 19860
      IQ=IP-1                                                              19870
      IS=0                                                                 19880
      IF(KOMP.EQ.2) IS=MMSAVE(IQ)                                          19890
      MMSAVE(IP)=0                                                         19900
      EN=N                                                                 19910
      DO 8 I=1,N                                                           19920
      EYE=I                                                                19930
      EYE=EYE-.5                                                           19940
      TH=1.570796*EYE/EN                                                   19950
      IPN1=I+N1*(KOMP-1)                                                   19960
      SNTH(IPN1)=SIN(TH)                                                   19970
      CSTH(IPN1)=COS(TH)                                                   19980
      EM=SNTH(IPN1)*EN*1.3                                                 19990
      MM=EM+1.                                                             20000
      XM=MM                                                                20010
      IP=(KOMP-1)*(N1+1)+I+1                                               20020
      IQ=IP-1                                                              20030
      MMSAVE(IP)=MMSAVE(IQ)+MM                                             20040
      DO 8 J=1,MM                                                          20050
      IS=IS+1                                                              20060
      XJ=J                                                                 20070
      FI=3.141593*(XJ-.5)/XM                                               20080
      CSFI(IS)=COS(FI)                                                     20090
      SNFI(IS)=SIN(FI)                                                     20100
    8 CONTINUE                                                             20110
      RETURN                                                               20120
      END                                                                  20130
      SUBROUTINE SURFAS(RMASS,POTENT,N,N1,KOMP,RV,GRX,GRY,GRZ,RVQ,         20140
     $GRXQ,GRYQ,GRZQ,MMSAVE,FR1,FR2,HLD,FF,D,SNTH,CSTH,SNFI,CSFI,GRV1,     20150
     $GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,CSBT1,CSBT2,GLUMP1,GLUMP2,GMAG1,        20160
     $GMAG2,GREXP)                                                         20170
c  Version of September 2, 1993                                            20180
      DIMENSION RV(*),GRX(*),GRY(*),GRZ(*),RVQ(*),GRXQ(*),GRYQ(*),GRZQ(*   20190
     $),MMSAVE(*),FR1(*),FR2(*),HLD(*),SNTH(*),CSTH(*),SNFI(*),CSFI(*)     20200
     $,GRV1(*),GRV2(*),XX1(*),YY1(*),ZZ1(*),XX2(*),YY2(*),ZZ2(*),GLUMP1    20210
     $(*),GLUMP2(*),CSBT1(*),CSBT2(*),GMAG1(*),GMAG2(*)                    20220
      common /radi/ R1H,RLH,R1C,RLC                                        20230
      COMMON X1                                                            20240
      COMMON /ECCEN/e,adum,perdum,vgadum,sindum,vfdum,vfadum,vgmdum,       20250
     $v1dum,v2dum,ifcdum                                                   20260
      DSQ=D*D                                                              20270
      RMAS=RMASS                                                           20280
      IF(KOMP.EQ.2) RMAS=1./RMASS                                          20290
      RF=FF**2                                                             20300
      RTEST=0.                                                             20310
      IP=(KOMP-1)*(N1+1)+1                                                 20320
      IQ=IP-1                                                              20330
      IS=0                                                                 20340
      ISX=(KOMP-1)*MMSAVE(IQ)                                              20350
      MMSAVE(IP)=0                                                         20360
      KFLAG=0                                                              20370
      CALL ELLONE (FF,D,RMAS,X1,OMEGA,XL2,OM2)                             20380
      IF(KOMP.EQ.2) OMEGA=RMASS*OMEGA+.5*(1.-RMASS)                        20390
      X2=X1                                                                20400
      IF(KOMP.EQ.2) X1=1.-X1                                               20410
      IF(E.NE.0.) GOTO 43                                                  20420
      IF(POTENT.LT.OMEGA) CALL NEKMIN(RMASS,POTENT,X1,ZZ)                  20430
      IF(POTENT.LT.OMEGA) X2=1.-X1                                         20440
   43 COMP=3-2*KOMP                                                        20450
      CMP=KOMP-1                                                           20460
      CMPD=CMP*D                                                           20470
      TESTER=CMPD+COMP*X1                                                  20480
      RM1=RMASS+1.                                                         20490
      RMS=RMASS                                                            20500
      RM1S=RM1                                                             20510
      IF(KOMP.NE.2) GOTO 15                                                20520
      POT=POTENT/RMASS+.5*(RMASS-1.)/RMASS                                 20530
      RM=1./RMASS                                                          20540
      RM1=RM+1.                                                            20550
      GOTO 20                                                              20560
   15 POT=POTENT                                                           20570
      RM=RMASS                                                             20580
   20 EN=N                                                                 20590
      RSAVE=1./POT                                                         20600
      DO 8 I=1,N                                                           20610
      IF(I.NE.2) GOTO 82                                                   20620
      IF(KOMP.EQ.1) RTEST=.3*RV(1)                                         20630
      IF(KOMP.EQ.2) RTEST=.3*RVQ(1)                                        20640
   82 CONTINUE                                                             20650
      IPN1=I+N1*(KOMP-1)                                                   20660
      SINTH=SNTH(IPN1)                                                     20670
      XNU=CSTH(IPN1)                                                       20680
      XNUSQ=XNU**2                                                         20690
      EM=SINTH*EN*1.3                                                      20700
      XLUMP=1.-XNUSQ                                                       20710
      MM=EM+1.                                                             20720
      DO 8 J=1,MM                                                          20730
      KOUNT=0                                                              20740
      IS=IS+1                                                              20750
      ISX=ISX+1                                                            20760
      DELR=0.                                                              20770
      COSFI=CSFI(ISX)                                                      20780
      XMU=SNFI(ISX)*SINTH                                                  20790
      XLAM=SINTH*COSFI                                                     20800
      R=RSAVE                                                              20810
   14 R=R+DELR                                                             20820
      KOUNT=KOUNT+1                                                        20830
      IF(KOUNT.LT.20) GOTO 70                                              20840
      KFLAG=1                                                              20850
      R=-1.                                                                20860
      GOTO 86                                                              20870
   70 RSQ=R*R                                                              20880
      PAR=DSQ-2.*XLAM*R*D+RSQ                                              20890
      RPAR=SQRT(PAR)                                                       20900
      OM=1./R+RM*((1./RPAR)-XLAM*R/DSQ)+RM1*.5*RSQ*XLUMP*RF                20910
      DOMR=1./(RF*RM1*XLUMP*R-1./RSQ-(RM*(R-XLAM*D))/(PAR*RPAR)-RM*XLAM/   20920
     $DSQ)                                                                 20930
      DELR=(POT-OM)*DOMR                                                   20940
      ABDELR=ABS(DELR)                                                     20950
      IF(ABDELR.GT..00001) GOTO 14                                         20960
      ABR=ABS(R)                                                           20970
      IF(R.GT.RTEST) GOTO 74                                               20980
      KFLAG=1                                                              20990
      R=-1.                                                                21000
      IF(KOMP.EQ.2) GOTO 98                                                21010
      GOTO 97                                                              21020
   74 IF(ABR.LT.TESTER) RSAVE=R                                            21030
      Z=R*XNU                                                              21040
      Y=COMP*R*XMU                                                         21050
      X2T=ABR*XLAM                                                         21060
      X=CMPD+COMP*X2T                                                      21070
      IF(KOMP.EQ.2) GOTO 62                                                21080
      IF(X.LT.X1) GOTO 65                                                  21090
      KFLAG=1                                                              21100
      R=-1.                                                                21110
      GOTO 97                                                              21120
   62 IF(X2T.LT.X2) GOTO 65                                                21130
      KFLAG=1                                                              21140
      R=-1.                                                                21150
      GOTO 98                                                              21160
   65 SUMSQ=Y**2+Z**2                                                      21170
      PAR1=X**2+SUMSQ                                                      21180
      RPAR1=SQRT(PAR1)                                                     21190
      XNUM1=1./(PAR1*RPAR1)                                                21200
      XL=D-X                                                               21210
      PAR2=XL**2+SUMSQ                                                     21220
      RPAR2=SQRT(PAR2)                                                     21230
      XNUM2=1./(PAR2*RPAR2)                                                21240
      OMZ=-Z*(XNUM1+RMS*XNUM2)                                             21250
      OMY=Y*(RM1S*RF-XNUM1-RMS*XNUM2)                                      21260
      OMX=RMS*XL*XNUM2-X*XNUM1+RM1S*X*RF-RMS/DSQ                           21270
      IF(KOMP.EQ.2)OMX=RMS*XL*XNUM2-X*XNUM1-RM1S*XL*RF+1./DSQ              21280
      GRMAG=SQRT(OMX*OMX+OMY*OMY+OMZ*OMZ)                                  21290
      IF(IS.EQ.1) GRPOLE=GRMAG                                             21300
      GRAV=(GRMAG/GRPOLE)**GREXP                                           21310
      A=COMP*XLAM*OMX                                                      21320
      B=COMP*XMU*OMY                                                       21330
      C=XNU*OMZ                                                            21340
      COSBET=-(A+B+C)/GRMAG                                                21350
      IF(COSBET.LT..7) COSBET=.7                                           21360
   86 IF(KOMP.EQ.2) GOTO 98                                                21370
   97 RV(IS)=R                                                             21380
      GRX(IS)=OMX                                                          21390
      GRY(IS)=OMY                                                          21400
      GRZ(IS)=OMZ                                                          21410
      GMAG1(IS)=SQRT(OMX*OMX+OMY*OMY+OMZ*OMZ)                              21420
      FR1(IS)=1.                                                           21430
      GLUMP1(IS)=R*R*SINTH/COSBET                                          21440
      GRV1(IS)=GRAV                                                        21450
      XX1(IS)=X                                                            21460
      YY1(IS)=Y                                                            21470
      ZZ1(IS)=Z                                                            21480
      CSBT1(IS)=COSBET                                                     21490
      GOTO 8                                                               21500
   98 RVQ(IS)=R                                                            21510
      GRXQ(IS)=OMX                                                         21520
      GRYQ(IS)=OMY                                                         21530
      GRZQ(IS)=OMZ                                                         21540
      GMAG2(IS)=SQRT(OMX*OMX+OMY*OMY+OMZ*OMZ)                              21550
      FR2(IS)=1.                                                           21560
      GLUMP2(IS)=R*R*SINTH/COSBET                                          21570
      GRV2(IS)=GRAV                                                        21580
      XX2(IS)=X                                                            21590
      YY2(IS)=Y                                                            21600
      ZZ2(IS)=Z                                                            21610
      CSBT2(IS)=COSBET                                                     21620
    8 CONTINUE                                                             21630
      IF(KFLAG.EQ.0) GOTO 53                                               21640
      ISS=IS-1                                                             21650
      IF(KOMP.NE.1) GOTO 50                                                21660
      CALL RING(RMASS,POTENT,1,N,FR1,HLD,R1H,RLH)                          21670
      DO 55 I=1,ISS                                                        21680
      IPL=I+1                                                              21690
      IF(RV(I).GE.0.)GOTO 55                                               21700
      FR1(IPL)=FR1(IPL)+FR1(I)                                             21710
      FR1(I)=0.                                                            21720
   55 CONTINUE                                                             21730
   53 IF(KOMP.EQ.2) GOTO 54                                                21740
      IS=0                                                                 21750
      DO 208 I=1,N                                                         21760
      IPN1=I+N1*(KOMP-1)                                                   21770
      EM=SNTH(IPN1)*EN*1.3                                                 21780
      MM=EM+1.                                                             21790
      DO 208 J=1,MM                                                        21800
      IS=IS+1                                                              21810
      GLUMP1(IS)=FR1(IS)*GLUMP1(IS)                                        21820
  208 CONTINUE                                                             21830
      RETURN                                                               21840
   50 CALL RING(RMASS,POTENT,2,N,FR2,HLD,R1C,RLC)                          21850
      DO 56 I=1,IS                                                         21860
      IPL=I+1                                                              21870
      IF(RVQ(I).GE.0.) GOTO 56                                             21880
      FR2(IPL)=FR2(IPL)+FR2(I)                                             21890
      FR2(I)=0.                                                            21900
   56 CONTINUE                                                             21910
   54 CONTINUE                                                             21920
      IS=0                                                                 21930
      DO 108 I=1,N                                                         21940
      IPN1=I+N1*(KOMP-1)                                                   21950
      EM=SNTH(IPN1)*EN*1.3                                                 21960
      MM=EM+1.                                                             21970
      DO 108 J=1,MM                                                        21980
      IS=IS+1                                                              21990
      GLUMP2(IS)=FR2(IS)*GLUMP2(IS)                                        22000
  108 CONTINUE                                                             22010
      RETURN                                                               22020
      END                                                                  22030
      SUBROUTINE BBL(RV,GRX,GRY,GRZ,RVQ,GRXQ,GRYQ,GRZQ,MMSAVE,FR1,FR2,     22040
     $HLD,SLUMP1,SLUMP2,THETA,RHO,AA,BB,PHSV,PCSV,N1,N2,F1,F2,d,hlum,      22050
     $clum,xh,xc,yh,yc,gr1,gr2,wl,sm1,sm2,tpolh,tpolc,sbrh,sbrc,ifat1      22060
     $,ifat2,tavh,tavc,alb1,alb2,xbol1,xbol2,ybol1,ybol2,phas,rm,          22070
     $xincl,hot,cool,snth,csth,snfi,csfi,tld,glump1,glump2,xx1,xx2,        22080
     $yy1,yy2,zz1,zz2,dint1,dint2,grv1,grv2,rftemp,rf1,rf2,csbt1,          22090
     $csbt2,gmag1,gmag2,mode)                                              22100
c  Experimental version of March 31, 1992                                  22110
      DIMENSION RV(*),GRX(*),GRY(*),GRZ(*),RVQ(*),GRXQ(*),GRYQ(*),         22120
     $GRZQ(*),MMSAVE(*),FR1(*),FR2(*),HLD(*),SLUMP1(*),SLUMP2(*),          22130
     $THETA(*),RHO(*),AA(*),BB(*),SNTH(*),CSTH(*),SNFI(*),CSFI(*),TLD(*)   22140
     $,GLUMP1(*),GLUMP2(*),XX1(*),XX2(*),YY1(*),YY2(*),ZZ1(*),ZZ2(*),      22150
     $GRV1(*),GRV2(*),RFTEMP(*),RF1(*),RF2(*),CSBT1(*),CSBT2(*)            22160
     $,GMAG1(*),GMAG2(*)                                                   22170
      COMMON /INVAR/ KH,IPBDUM,IRTE,NREF,IRVOL1,irvol2,mref,ifsmv1,        22180
     $ifsmv2,icor1,icor2,ld                                                22190
      COMMON /FLVAR/ PER,PSHIFT,DP,DS,EF,EFC,ECOS,PERR,PHPER,PCONJ,        22200
     $PHPERI,VSUM1,VSUM2,VRA1,VRA2,VKM1,VKM2,VUNIT,vfvu,trc                22210
      common /nspt/ nsp1,nsp2,ifdum1,ifdum2                                22220
      common /spots/ snlat(2,100),cslat(2,100),snlng(2,100),               22230
     $cslng(2,100),rdsp(2,100),tmsp(2,100),xlng(2,100)                     22240
      COMMON /ECCEN/ E,A,PERIOD,VGA,SINI,VF,VFAC,VGAM,VOL1,VOL2,IFC        22250
      pi=3.141593                                                          22260
      twopi=pi+pi                                                          22270
      MOD=(MODE-2)**2                                                      22280
      IF(MOD.EQ.1) XC=XH                                                   22290
      if(mod.eq.1) yc=yh                                                   22300
      PSFT=PHAS-PHPERI                                                     22310
   29 if(PSFT.GT.1.) PSFT=PSFT-1.                                          22320
      if(psft.gt.1.) goto 29                                               22330
   30 if(PSFT.LT.0.) PSFT=PSFT+1.                                          22340
      if(psft.lt.0.) goto 30                                               22350
      XMEAN=PSFT*6.283185                                                  22360
      tr=xmean                                                             22370
      do 60 kp=1,2                                                         22380
      nsp=nsp1*(2-kp)+nsp2*(kp-1)                                          22390
      ff=f1*(2-kp)+f2*(kp-1)                                               22400
      ifsmv=ifsmv1*(2-kp)+ifsmv2*(kp-1)                                    22410
      if(ifsmv.eq.0) goto 60                                               22420
      do 61 i=1,nsp                                                        22430
      xlg=xlng(kp,i)+twopi*ff*(phas-pconj)-(tr-trc)                        22440
      snlng(kp,i)=sin(xlg)                                                 22450
      cslng(kp,i)=cos(xlg)                                                 22460
   61 continue                                                             22470
   60 continue                                                             22480
      if(e.ne.0.) call KEPLER(XMEAN,E,DUM,TR)                              22490
      U=TR+PERR                                                            22500
      COSU=COS(U)                                                          22510
      GPHA=U*.1591549-.25                                                  22520
   40 if(GPHA.lt.0.) GPHA=GPHA+1.                                          22530
      if(gpha.lt.0.) goto 40                                               22540
   50 if(GPHA.GE.1.) GPHA=GPHA-1.                                          22550
      if(gpha.ge.1.) goto 50                                               22560
      D=EF/(1.+E*COS(TR))                                                  22570
      IF(IRTE.EQ.1) GOTO 19                                                22580
      CALL LCR(RV,GRX,GRY,GRZ,RVQ,GRXQ,GRYQ,GRZQ,MMSAVE,FR1,FR2,HLD,SLUM   22590
     $P1,SLUMP2,RM,PHSV,PCSV,N1,N2,F1,F2,D,HLUM,CLUM,xh,xc,yh,yc,gr1,gr2   22600
     $,wl,SM1,SM2,TPOLH,TPOLC,SBRH,SBRC,IFAT1,IFAT2,TAVH,TAVC,alb1,alb2,   22610
     $xbol1,xbol2,ybol1,ybol2,vol1,vol2,snth,csth,snfi,csfi,tld,glump1,    22620
     $glump2,xx1,xx2,yy1,yy2,zz1,zz2,dint1,dint2,grv1,grv2,csbt1,csbt2,    22630
     $rftemp,rf1,rf2,gmag1,gmag2,mode,ifc)                                 22640
   19 CONTINUE                                                             22650
      VO1=RM*SINI*(ECOS+COSU)/((1.+RM)*EFC)+VGAM                           22660
      VO2=-SINI*(ECOS+COSU)/((1.+RM)*EFC)+VGAM                             22670
      call light(gpha,xincl,xh,xc,yh,yc,n1,n2,hot,cool,rv,grx,gry,grz,     22680
     $rvq,grxq,gryq,grzq,mmsave,theta,rho,aa,bb,slump1,slump2,somhot,      22690
     $somkul,d,wl,snth,csth,snfi,csfi,tld,gmag1,gmag2)                     22700
      VRA1=0.                                                              22710
      VRA2=0.                                                              22720
      IF(HOT.GT.0.) VRA1=F1*SOMHOT/HOT                                     22730
      IF(COOL.GT.0.) VRA2=F2*SOMKUL/COOL                                   22740
      vsum1=vo1                                                            22750
      vsum2=vo2                                                            22760
      if(icor1.eq.1) vsum1=vo1+vra1                                        22770
      if(icor2.eq.1) vsum2=vo2+vra2                                        22780
      VKM1=VSUM1*VFVU                                                      22790
      VKM2=VSUM2*VFVU                                                      22800
      RETURN                                                               22810
      END                                                                  22820
      SUBROUTINE DURA(F,XINCL,RM,DD,THE,OMEG,R)                            22830
C     VERSION OF 4/10/78. DESTROY EARLIER VERSIONS.                        22840
C                                                                          22850
C     PARAMETER 'THE' IS THE SEMI-DURATION OF X-RAY ECLIPSE, AND SHOULD    22860
C     BE IN CIRCULAR MEASURE.                                              22870
      IMPLICIT REAL*8(A-H,O-Z)                                             22880
      REAL F,XINCL,RM,THE,OMEG,R,DD                                        22890
      DELX=0.D0                                                            22900
      FSQ=F*F                                                              22910
      RMD=1./RM                                                            22920
      RMD1=RMD+1.D0                                                        22930
      XINC=.0174533*XINCL                                                  22940
      TH=6.283185*THE                                                      22950
      CI=DCOS(XINC)                                                        22960
      SI=DSIN(XINC)                                                        22970
      D=DD                                                                 22980
      DSQ=D*D                                                              22990
      ST=DSIN(TH)                                                          23000
      CT=DCOS(TH)                                                          23010
      COTI=CI/SI                                                           23020
      TT=ST/CT                                                             23030
      C1=CT*SI                                                             23040
      C2=TT*ST*SI                                                          23050
      C3=C1+C2                                                             23060
      C4=COTI*CI/CT                                                        23070
      C5=C3+C4                                                             23080
      C6=C2+C4                                                             23090
      C7=(ST*ST+COTI*COTI)/CT**2                                           23100
      X=D*(SI*SI*ST*ST+CI*CI)+.00001D0                                     23110
   15 X=X+DELX                                                             23120
      PAR=X*X+C7*(D-X)**2                                                  23130
      RPAR=DSQRT(PAR)                                                      23140
      PAR32=PAR*RPAR                                                       23150
      PAR52=PAR*PAR32                                                      23160
      FC=(C6*D-C5*X)/PAR32+C1**3*C5*RMD/(D-X)**2+C3*FSQ*RMD1*X-C2*FSQ*D*   23170
     $RMD1-C1*RMD/DSQ                                                      23180
      DFCDX=(-C5*PAR-3.D0*(C6*D-C5*X)*((1.D0+C7)*X-C7*D))/PAR52+2.D0*C1    23190
     $**3*C5*RMD/(D-X)**3+C3*FSQ*RMD1                                      23200
      DELX=-FC/DFCDX                                                       23210
      ABDELX=DABS(DELX)                                                    23220
      IF(ABDELX.GT..00001D0) GOTO 15                                       23230
      Y=-(D-X)*TT                                                          23240
      Z=-(D-X)*COTI/CT                                                     23250
      YZ2=Y*Y+Z*Z                                                          23260
      OMEG=1.D0/DSQRT(X*X+YZ2)+RMD/DSQRT((D-X)**2+YZ2)+.5D0*RMD1*FSQ*      23270
     $(X*X+Y*Y)-RMD*X/DSQ                                                  23280
      OMEG=RM*OMEG+.5*(1.-RM)                                              23290
      R=DSQRT(X*X+YZ2)                                                     23300
      RETURN                                                               23310
      END                                                                  23320
      SUBROUTINE LCR(RV,GRX,GRY,GRZ,RVQ,GRXQ,GRYQ,GRZQ,MMSAVE,FR1,FR2,HL   23330
     $D,SLUMP1,SLUMP2,RM,POTH,POTC,N1,N2,F1,F2,D,HLUM,CLUM,xh,xc,yh,yc,    23340
     $GR1,GR2,WL,SM1,SM2,TPOLH,TPOLC,SBRH,SBRC,IFAT1,IFAT2,TAVH,TAVC,      23350
     $alb1,alb2,xbol1,xbol2,ybol1,ybol2,vol1,vol2,snth,csth,snfi,csfi,     23360
     $tld,glump1,glump2,xx1,xx2,yy1,yy2,zz1,zz2,dint1,dint2,grv1,grv2,     23370
     $csbt1,csbt2,rftemp,rf1,rf2,gmag1,gmag2,mode,ifc)                     23380
c  Version of August 17, 1993                                              23390
      DIMENSION RV(*),GRX(*),GRY(*),GRZ(*),RVQ(*),GRXQ(*),GRYQ(*),GRZQ(*   23400
     $),SLUMP1(*),SLUMP2(*),MMSAVE(*),FR1(*),FR2(*),HLD(*),SNTH(*),        23410
     $CSTH(*),SNFI(*),CSFI(*),TLD(*),GLUMP1(*),GLUMP2(*),XX1(*),XX2(*)     23420
     $,YY1(*),YY2(*),ZZ1(*),ZZ2(*),GRV1(*),GRV2(*),RFTEMP(*),RF1(*),       23430
     $RF2(*),CSBT1(*),CSBT2(*),GMAG1(*),GMAG2(*)                           23440
      COMMON /DPDX/ DPDX1,DPDX2,PHSV,PCSV                                  23450
      COMMON /ECCEN/ E,dum1,dum2,dum3,dum4,dum5,dum6,dum7,dum8,dum9,idum   23460
      COMMON /SUMM/ SUMM1,SUMM2                                            23470
      COMMON /INVAR/ KHDUM,IPB,IRTE,NREF,IRVOL1,IRVOL2,mref,ifsmv1,        23480
     $ifsmv2,icor1,icor2,ld                                                23490
      XLUMP=1.4384/WL                                                      23500
      VL1=VOL1                                                             23510
      VL2=VOL2                                                             23520
      DP=1.-E                                                              23530
      IF(IRVOL1.EQ.1) GOTO 88                                              23540
      CALL VOLUME(VL1,RM,POTH,DP,F1,N1,N1,1,RV,GRX,GRY,GRZ,RVQ,GRXQ,       23550
     $GRYQ,GRZQ,MMSAVE,FR1,FR2,HLD,SNTH,CSTH,SNFI,CSFI,SUMM1,SM1,GRV1,     23560
     $GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,CSBT1,CSBT2,GLUMP1,GLUMP2,GMAG1,GMAG2   23570
     $,GR1,1)                                                              23580
      IF(E.EQ.0.) GOTO 88                                                  23590
      POTHD=PHSV                                                           23600
      IF(IFC.EQ.2) POTHD=PHSV+DPDX1*(1./D-1./(1.-E))                       23610
      CALL VOLUME(VL1,RM,POTHD,D,F1,N1,N1,1,RV,GRX,GRY,GRZ,RVQ,GRXQ,       23620
     $GRYQ,GRZQ,MMSAVE,FR1,FR2,HLD,SNTH,CSTH,SNFI,CSFI,SUMM1,SM1,GRV1,     23630
     $GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,CSBT1,CSBT2,GLUMP1,GLUMP2,GMAG1,GMAG2   23640
     $,GR1,IFC)                                                            23650
   88 CONTINUE                                                             23660
      IF(IRVOL2.EQ.1) GOTO 86                                              23670
      CALL VOLUME(VL2,RM,POTC,DP,F2,N2,N1,2,RV,GRX,GRY,GRZ,RVQ,GRXQ,       23680
     $GRYQ,GRZQ,MMSAVE,FR1,FR2,HLD,SNTH,CSTH,SNFI,CSFI,SUMM2,SM2,GRV1,     23690
     $GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,CSBT1,CSBT2,GLUMP1,GLUMP2,GMAG1,GMAG2   23700
     $,GR2,1)                                                              23710
      IF(E.EQ.0.) GOTO 86                                                  23720
      POTCD=PCSV                                                           23730
      IF(IFC.EQ.2) POTCD=PCSV+DPDX2*(1./D-1./(1.-E))                       23740
      CALL VOLUME(VL2,RM,POTCD,D,F2,N2,N1,2,RV,GRX,GRY,GRZ,RVQ,GRXQ,       23750
     $GRYQ,GRZQ,MMSAVE,FR1,FR2,HLD,SNTH,CSTH,SNFI,CSFI,SUMM2,SM2,GRV1,     23760
     $GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,CSBT1,CSBT2,GLUMP1,GLUMP2,GMAG1,GMAG2   23770
     $,GR2,IFC)                                                            23780
   86 CONTINUE                                                             23790
      TPOLH=TAVH*SQRT(SQRT(SM1/SUMM1))                                     23800
      TPOLC=TAVC*SQRT(SQRT(SM2/SUMM2))                                     23810
      g1=gmag1(1)                                                          23820
      g2=gmag2(1)                                                          23830
      IF(MODE.EQ.1)TPOLC=TPOLH*SQRT(SQRT((G2/G1)**GR1))                    23840
      IF(MODE.EQ.1)TAVC=TPOLC/SQRT(SQRT(SM2/SUMM2))                        23850
      RATH=1.                                                              23860
      RATC=1.                                                              23870
      tph=10000.*tpolh                                                     23880
      tpc=10000.*tpolc                                                     23890
      IF(IFAT1.NE.0) CALL ATM(tph,WL,RATH)                                 23900
      IF(IFAT2.NE.0) CALL ATM(tpc,WL,RATC)                                 23910
      RATCH=RATC/RATH                                                      23920
      call lum(hlum,xh,yh,gr1,wl,tpolh,n1,n1,1,sbrh,rv,rvq,glump1,         23930
     $glump2,grv1,grv2,mmsave,summ1d,fr1,sm1d,ifat1,vold,rm,poth,          23940
     $f1,d,hld,snth)                                                       23950
      sbrc=ratch*sbrh*(9.-3.*xh+2.*yh)*(exp(xlump/tpolh)-1.)/              23960
     $((9.-3.*xc+2.*yc)*(exp(xlump/tpolc)-1.))                             23970
      call lum(clum,xc,yc,gr2,wl,tpolc,n2,n1,2,sbrt,rv,rvq,glump1,         23980
     $glump2,grv1,grv2,mmsave,summ2d,fr2,sm2d,ifat2,vold,rm,potc,          23990
     $f2,d,hld,snth)                                                       24000
      IF(IPB.EQ.1) SBRC=SBRT                                               24010
      IF(MODE.GT.0)CLUM=CLUM*SBRC/SBRT                                     24020
      IF(MODE.LE.0)SBRC=SBRT                                               24030
      if(mref.eq.2) goto 30                                                24040
      ratlum=hlum/clum                                                     24050
      call bolo(ratlum,tavh,tavc,wl,ifat1,ifat2,ratbol)                    24060
      rb=1./ratbol                                                         24070
      call olump(rv,grx,gry,grz,rvq,grxq,gryq,grzq,slump1,slump2,mmsave    24080
     $,gr1,alb1,rb,wl,tpolh,sbrh,summ1,n1,n2,1,ifat1,fr1,xc,yc,d,snth      24090
     $,csth,snfi,csfi,tld,glump1,glump2)                                   24100
      rb=ratbol                                                            24110
      call olump(rv,grx,gry,grz,rvq,grxq,gryq,grzq,slump1,slump2,mmsave    24120
     $,gr2,alb2,rb,wl,tpolc,sbrc,summ2,n1,n2,2,ifat2,fr2,xh,yh,d,snth      24130
     $,csth,snfi,csfi,tld,glump1,glump2)                                   24140
      return                                                               24150
   30 continue                                                             24160
      sbr1b=tpolh**4/dint1                                                 24170
      sbr2b=tpolc**4/dint2                                                 24180
      LT=N1+1                                                              24190
      IMAX1=MMSAVE(LT)                                                     24200
      DO 80 I=1,IMAX1                                                      24210
      RFTEMP(I)=1.                                                         24220
   80 RF1(I)=1.                                                            24230
      LT=N1+N2+2                                                           24240
      IMAX2=MMSAVE(LT)                                                     24250
      DO 81 I=1,IMAX2                                                      24260
   81 RF2(I)=1.                                                            24270
      DO 93 NR=1,NREF                                                      24280
      CALL LUMP(GRX,GRY,GRZ,GRXQ,GRYQ,GRZQ,SLUMP1,SLUMP2,MMSAVE,           24290
     $gr1,alb1,wl,tpolh,sbrh,summ1,n1,n2,1,ifat1,fr1,snth,csth,snfi,       24300
     $csfi,tld,glump1,glump2,xx1,xx2,yy1,yy2,zz1,zz2,xbol2,ybol2,grv1,     24310
     $grv2,sbr1b,sbr2b,rftemp,rf2,gmag1,gmag2,dint1)                       24320
      CALL LUMP(GRX,GRY,GRZ,GRXQ,GRYQ,GRZQ,SLUMP1,SLUMP2,MMSAVE,           24330
     $GR2,ALB2,WL,TPOLC,SBRC,SUMM2,N1,N2,2,IFAT2,fr2,snth,csth,snfi,       24340
     $csfi,tld,glump1,glump2,xx1,xx2,yy1,yy2,zz1,zz2,xbol1,ybol1,          24350
     $grv1,grv2,sbr1b,sbr2b,rf2,rf1,gmag1,gmag2,dint2)                     24360
      DO 70 I=1,IMAX1                                                      24370
   70 RF1(I)=RFTEMP(I)                                                     24380
   93 CONTINUE                                                             24390
      RETURN                                                               24400
      END                                                                  24410
      SUBROUTINE VOLUME(V,Q,P,D,FF,N,N1,KOMP,RV,GRX,GRY,GRZ,RVQ,           24420
     $GRXQ,GRYQ,GRZQ,MMSAVE,FR1,FR2,HLD,SNTH,CSTH,SNFI,CSFI,SUMM,SM,       24430
     $GRV1,GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,CSBT1,CSBT2,GLUMP1,GLUMP2,GMAG1    24440
     $,GMAG2,GREXP,IFC)                                                    24450
c  Experimental version of April 9, 1992                                   24460
      DIMENSION RV(*),GRX(*),GRY(*),GRZ(*),RVQ(*),GRXQ(*),GRYQ(*),GRZQ(*   24470
     $),MMSAVE(*),FR1(*),FR2(*),HLD(*),SNTH(*),CSTH(*),SNFI(*),CSFI(*)     24480
     $,GRV1(*),GRV2(*),GLUMP1(*),GLUMP2(*),XX1(*),YY1(*),ZZ1(*),XX2(*),    24490
     $YY2(*),ZZ2(*),CSBT1(*),CSBT2(*),GMAG1(*),GMAG2(*)                    24500
      DP=1.E-3*P                                                           24510
      IF (IFC.EQ.1) DP=0.                                                  24520
      TOL=1.E-6*P**2                                                       24530
      DELP=0.                                                              24540
      KNTR=0                                                               24550
   16 P=P+DELP                                                             24560
      KNTR=KNTR+1                                                          24570
      IF(KNTR.GE.20) TOL=TOL+TOL                                           24580
      PS=P                                                                 24590
      DO 17 I=1,IFC                                                        24600
      P=PS                                                                 24610
      IF(I.EQ.1) P=P+DP                                                    24620
      CALL SURFAS(Q,P,N,N1,KOMP,RV,GRX,GRY,GRZ,RVQ,GRXQ,GRYQ,GRZQ,         24630
     $MMSAVE,FR1,FR2,HLD,FF,D,SNTH,CSTH,SNFI,CSFI,GRV1,GRV2,XX1,YY1,ZZ1,   24640
     $XX2,YY2,ZZ2,CSBT1,CSBT2,GLUMP1,GLUMP2,GMAG1,GMAG2,GREXP)             24650
      IF(KOMP.EQ.2) GOTO 14                                                24660
      call lum(1.,1.,0.,grexp,1.,1.,n,n1,1,sbrd,rv,rvq,glump1,glump2,      24670
     $grv1,grv2,mmsave,summ,fr1,sm,0,vol,q,p,ff,d,hld,snth)                24680
      GOTO 15                                                              24690
   14 call lum(1.,1.,0.,grexp,1.,1.,n,n1,2,sbrd,rv,rvq,glump1,glump2,      24700
     $grv1,grv2,mmsave,summ,fr2,sm,0,vol,q,p,ff,d,hld,snth)                24710
   15 CONTINUE                                                             24720
      IF(I.EQ.1) VOLS=VOL                                                  24730
      VOL2=VOLS                                                            24740
   17 VOL1=VOL                                                             24750
      IF(IFC.EQ.1) V=VOL                                                   24760
      IF(IFC.EQ.1) RETURN                                                  24770
      DPDV=DP/(VOL2-VOL1)                                                  24780
      DELP=(V-VOL1)*DPDV                                                   24790
      ABDELP=ABS(DELP)                                                     24800
      IF(ABDELP.GT.TOL) GOTO 16                                            24810
      P=PS                                                                 24820
      RETURN                                                               24830
      END                                                                  24840
      SUBROUTINE ATM(TEMP,WAVE,RATIO)                                      24850
C     VERSION OF OCTOBER 30, 1987. DESTROY EARLIER VERSIONS.               24860
C     THIS SUBROUTINE COMPUTES THE RATIO OF STELLAR ATMOSPHERE TO          24870
C     PLANCKIAN FLUX FOR MAIN SEQUENCE STARS.                              24880
C     WARNING: LIMITS OF APPLICABILITY OF THIS SUBROUTINE AS FOLLOWS.      24890
C     IN TEMP RANGE 4,000 TO 25,000 K, WAVE LENGTH LIMITS .0912 TO         24900
C     6.5647 MICRONS. IN TEMP RANGE 25,000 TO 50,000 K, WAVE LENGTH        24910
C     LIMITS .0912 TO 2.2794 MICRONS. SUBROUTINE SHOULD NOT BE USED        24920
C     OUTSIDE THESE RANGES UNDER ANY CIRCUMSTANCES. WARNING MESSAGES       24930
C     ARE PRINTED IF RANGES EXCEEDED.                                      24940
      DIMENSION A(500),AA(196),AB(182),AC(105)                             24950
      EQUIVALENCE (A(1),AA(1)),(A(197),AB(1)),(A(379),AC(1))               24960
      DATA AA/.907883,-1.66066,.691436,4*0.0,.280961,-.447328,.130532,     24970
     $4*0.0,.142757,-.248947,.0620680,4*0.0,1.20223,-2.33426,1.07589,      24980
     $4*0.0,.403049,-.586521,.171767,4*0.0,.161172,-.260420,.0640562,      24990
     $4*0.0,1.78103,-3.64231,1.70609,4*0.0,.667290,-1.06532,.341809,       25000
     $4*0.0,.181770,-.345798,.0830478,4*0.0,-.329302E+2,.598843E+3,        25010
     $-.418910E+4,.146768E+5,-.274273E+5,.26093E+5,-.992741E+4,            25020
     $.442164,-1.17612,.558862,4*0.0,-.0671895,-.114919,.0244139,4*0.0,    25030
     $-.207863E+3,.243857E+4,-.115507E+5,.283797E+5,-.38233E+5,            25040
     $.268213E+5,-.76661E+4,.44286,-.984141,.391429,4*0.0,-.0128738,       25050
     $-.165689,.0419392,4*0.0,-.245193E+3,.287031E+4,-.135822E+5,.333606   25060
     $E+5,-.449465E+5,.315396E+5,-.901805E+4,.542751,-1.13157,.450211,     25070
     $4*0.0,.0371818,-.212137,.0551231,4*0.0,-.276230E+3,.322251E+4,       25080
     $-.1522E+5,.373523E+5,-.503142E+5,.353117E+5,-.101001E+5,             25090
     $.685486,-1.3322,.527152,4*0.0,.099154,-.266633,.0700431,4*0.0,       25100
     $-.280198E+3,.324071E+4,-.152149E+5,.371972E+5,-.499884E+5,           25110
     $.350354E+5,-.100136E+5,.912472,-1.64954,.647666,4*0.0,.192641,       25120
     $-.345623,.0898134,4*0.0,-.649967,.332897E+2,-.395009E+3,             25130
     $.229755E+4,-.701922E+4,.105395E+5,-.609668E+4,.66853,-1.55813,       25140
     $.773398,4*0.0,.202931,-.391874,.117945,4*0.0,-1.25062,.246184E+2,    25150
     $-.934153E+2,-.358292E+2,.745529E+3,-.133152E+4,.738503E+3/           25160
      DATA AB/.779381,-1.72595,.842554,4*0.0,.269815,-.455823,.135618,     25170
     $4*0.0,-1.86875,-.233737E+1,.435333E+3,-.330973E+4,.100351E+5,        25180
     $-.137955E+5,.714497E+4,.234313,-.196784,-.142740,4*0.0,.341826,      25190
     $-.513333,.149367,4*0.0,                                              25200
     $        -1.97002,-.28814E+2,.778254E+3,-.498095E+4,.139559E+5,       25210
     $-.182625E+5,.913243E+4,.607074,-.994799,.290486,4*0.0,.360036,       25220
     $-.520072,.147628,4*0.0,-1.99412,-.300984E+2,.735863E+3,-.448795E+4   25230
     $,.121397E+5,-.154572E+5,.756405E+4,.6119,-.976964,.278779,4*0.0,     25240
     $.346578,-.487175,.136367,4*0.0,-.227562E+1,-.734396E+1,              25250
     $.250026E+3,-.110376E+4,.179596E+4,-.947930E+3,-.903513E+2,           25260
     $.650197,-1.01937,.297332,4*0.0,.295735,-.382176,.09522,4*0.0,        25270
     $-.242829E+1,.26082E+2,-495.932,.400884E+4,-.135251E+5,.201766E+5,    25280
     $-.110779E+5,.515008,-.840408,.268146,4*0.0,.0567424,-.0326554,       25290
     $-.0248079,4*0.0,-1.98073,5.89063,.923565E+2,-.180606E+2,-.324872E+   25300
     $4,.106725E+5,-.981050E+4,.696006,-.158377E+1,.840335,4*0.0,          25310
     $-.0372941,.113422,-.0827454,4*0.0,-2.20129,2.57431,.954215E+2,       25320
     $.140538E+3,-.358564E+4,.10078E+5,-.843473E+4,.877022,-2.11887,       25330
     $.123868E+1,4*0.0,-.157214,.322907,-.162776,4*0.0,-2.28223,           25340
     $1.88918,.906366E+2,.182422E+3,-.344699E+4,.915905E+4,-.736667E+4,    25350
     $.422139,-.673966,.13635,4*0.0,-.269755,.515384,-.234871,4*0.0/       25360
      DATA AC/-1.72294,.111136E+2,.546943E+2,-.26662E+3,-.827417E+3,       25370
     $.463518E+4,-.501896E+4,.750032,-1.87636,1.12717,4*0.0,-.327529,      25380
     $.664143,-.307411,4*0.0,-1.82965,7.19243,.333359E+2,-.189727E+2,      25390
     $-.567324E+3,.71019E+3,.553124E+3,.968157,-.249486E+1,1.57956,4*0.0   25400
     $,-.413511,.836881,-.379774,4*0.0,-2.12746,5.72613,.206067E+2,        25410
     $.103493E+3,-.379424E+3,-.115088E+4,.285070E+4,1.30615,-3.49355,      25420
     $2.31489,4*0.0,-.551384,.109752E+1,-.485262,4*0.0,-2.44968,           25430
     $5.38777,.918011E+1,.156549E+3,-.162539E+3,-.191797E+4,.316283E+4,    25440
     $.184856E+1,-.512211E+1,.348495E+1,4*0.0,-.860859,.163724E+1,         25450
     $-.699413,4*0.0,-2.36238,6.98545,.340574E+2,.139450E+3,               25460
     $-.680221E+3,-.155574E+4,.462879E+4,.18498E+1,-.579597E+1,            25470
     $.43628E+1,4*0.0,-.111754E+1,.214057E+1,-.924189,4*0.0/               25480
   51 FORMAT(' TEMPERATURE RANGE EXCEEDED IN SUBROUTINE ATM')              25490
   52 FORMAT(' WAVE LENGTH RANGE EXCEEDED IN SUBROUTINE ATM')              25500
      IF (TEMP.GT.50000.) WRITE(6,51)                                      25510
      IF (TEMP.LT.4000.) WRITE (6,51)                                      25520
      IF (WAVE.LT..0912) WRITE(6,52)                                       25530
      IF(TEMP.LE.25000.) GOTO 53                                           25540
      IF(WAVE.GT.2.2794) WRITE(6,52)                                       25550
      GOTO 54                                                              25560
   53 IF(WAVE.GT.6.5647) WRITE(6,52)                                       25570
   54 CONTINUE                                                             25580
      IF (WAVE.GT..3647) GOTO 15                                           25590
      NWAVE=0                                                              25600
      GOTO 30                                                              25610
   15 IF (WAVE.GT..8206) GOTO 25                                           25620
      NWAVE=1                                                              25630
      GOTO 30                                                              25640
   25 NWAVE=2                                                              25650
   30 IF (TEMP.LT.40000.) GOTO 300                                         25660
      FRACT=(TEMP-40000.)/10000.                                           25670
      DIV1=.0203                                                           25680
      DIV2=.0280                                                           25690
      NUMBER=0                                                             25700
      GOTO 500                                                             25710
  300 IF (TEMP.LT.30000.) GOTO 305                                         25720
      FRACT=(TEMP-30000.)/10000.                                           25730
      DIV1=.0280                                                           25740
      DIV2=.0302                                                           25750
      NUMBER=1                                                             25760
      GOTO 500                                                             25770
  305 IF (TEMP.LT.25000.) GOTO 310                                         25780
      FRACT=(TEMP-25000.)/5000.                                            25790
      DIV1=.0302                                                           25800
      DIV2=.0701                                                           25810
      NUMBER=2                                                             25820
      GOTO 500                                                             25830
  310 IF (TEMP.LT.20000.) GOTO 315                                         25840
      FRACT=(TEMP-20000.)/5000.                                            25850
      DIV1=.0701                                                           25860
      DIV2=.0504                                                           25870
      NUMBER=3                                                             25880
      GOTO 500                                                             25890
  315 IF (TEMP.LT.18000.) GOTO 320                                         25900
      FRACT=(TEMP-18000.)/2000.                                            25910
      DIV1=.0504                                                           25920
      DIV2=.0504                                                           25930
      NUMBER=4                                                             25940
      GOTO 500                                                             25950
  320 IF (TEMP.LT.16000.) GOTO 325                                         25960
      FRACT=(TEMP-16000.)/2000.                                            25970
      DIV1=.0504                                                           25980
      DIV2=.0504                                                           25990
      NUMBER=5                                                             26000
      GOTO 500                                                             26010
  325 IF (TEMP.LT.14000.) GOTO 330                                         26020
      FRACT=(TEMP-14000.)/2000.                                            26030
      DIV1=.0504                                                           26040
      DIV2=.0504                                                           26050
      NUMBER=6                                                             26060
      GOTO 500                                                             26070
  330 IF (TEMP.LT.12000.) GOTO 335                                         26080
      FRACT=(TEMP-12000.)/2000.                                            26090
      DIV1=.0504                                                           26100
      DIV2=.1000                                                           26110
      NUMBER=7                                                             26120
      GOTO 500                                                             26130
  335 IF (TEMP.LT.11000.) GOTO 340                                         26140
      FRACT=(TEMP-11000.)/1000.                                            26150
      DIV1=.1000                                                           26160
      DIV2=.1000                                                           26170
      NUMBER=8                                                             26180
      GOTO 500                                                             26190
  340 IF (TEMP.LT.10000.) GOTO 345                                         26200
      FRACT=(TEMP-10000.)/1000.                                            26210
      DIV1=.1000                                                           26220
      DIV2=.0912                                                           26230
      NUMBER=9                                                             26240
      GOTO 500                                                             26250
  345 IF (TEMP.LT.9500.) GOTO 350                                          26260
      FRACT=(TEMP-9500.)/500.                                              26270
      DIV1=.0912                                                           26280
      DIV2=.0912                                                           26290
      NUMBER=10                                                            26300
      GOTO 500                                                             26310
  350 IF (TEMP.LT.9000.) GOTO 355                                          26320
      FRACT=(TEMP-9000.)/500.                                              26330
      DIV1=.0912                                                           26340
      DIV2=.0912                                                           26350
      NUMBER=11                                                            26360
      GOTO 500                                                             26370
  355 IF (TEMP.LT.8500.) GOTO 360                                          26380
      FRACT=(TEMP-8500.)/500.                                              26390
      DIV1=.0912                                                           26400
      DIV2=.0912                                                           26410
      NUMBER=12                                                            26420
      GOTO 500                                                             26430
  360 IF (TEMP.LT.8000.) GOTO 365                                          26440
      FRACT=(TEMP-8000.)/500.                                              26450
      DIV1=.0912                                                           26460
      DIV2=.0912                                                           26470
      NUMBER=13                                                            26480
      GOTO 500                                                             26490
  365 IF (TEMP.LT.7500.) GOTO 370                                          26500
      FRACT=(TEMP-7500.)/500.                                              26510
      DIV1=.0912                                                           26520
      DIV2=.1239                                                           26530
      NUMBER=14                                                            26540
      GOTO 500                                                             26550
  370 IF (TEMP.LT.7000.) GOTO 375                                          26560
      FRACT=(TEMP-7000.)/500.                                              26570
      DIV1=.1239                                                           26580
      DIV2=.1239                                                           26590
      NUMBER=15                                                            26600
      GOTO 500                                                             26610
  375 IF (TEMP.LT.6500.) GOTO 380                                          26620
      FRACT=(TEMP-6500.)/500.                                              26630
      DIV1=.1239                                                           26640
      DIV2=.1239                                                           26650
      NUMBER=16                                                            26660
      GOTO 500                                                             26670
  380 IF (TEMP.LT.6000.) GOTO 385                                          26680
      FRACT=(TEMP-6000.)/500.                                              26690
      DIV1=.1239                                                           26700
      DIV2=.1444                                                           26710
      NUMBER=17                                                            26720
      GOTO 500                                                             26730
  385 IF (TEMP.LT.5500.) GOTO 390                                          26740
      FRACT=(TEMP-5500.)/500.                                              26750
      DIV1=.1444                                                           26760
      DIV2=.1444                                                           26770
      NUMBER=18                                                            26780
      GOTO 500                                                             26790
  390 IF (TEMP.LT.5000.) GOTO 395                                          26800
      FRACT=(TEMP-5000.)/500.                                              26810
      DIV1=.1444                                                           26820
      DIV2=.1444                                                           26830
      NUMBER=19                                                            26840
      GOTO 500                                                             26850
  395 IF (TEMP.LT.4500.) GOTO 400                                          26860
      FRACT=(TEMP-4500.)/500.                                              26870
      DIV1=.1444                                                           26880
      DIV2=.1444                                                           26890
      NUMBER=20                                                            26900
      GOTO 500                                                             26910
  400 FRACT=(TEMP-4000.)/500.                                              26920
      DIV1=.1444                                                           26930
      DIV2=.1623                                                           26940
      NUMBER=21                                                            26950
  500 M=NUMBER*21+NWAVE*7+1                                                26960
      N=(NUMBER+1)*21+NWAVE*7+1                                            26970
      SUM1=A(M)                                                            26980
      SUM2=A(N)                                                            26990
      ALWAV1=ALOG10(WAVE/DIV1)                                             27000
      ALWAV2=ALOG10(WAVE/DIV2)                                             27010
      DO 20 I=1,6                                                          27020
      M1=M+I                                                               27030
      SUM1=SUM1+A(M1)*ALWAV1**I                                            27040
      N1=N+I                                                               27050
      SUM2=SUM2+A(N1)*ALWAV2**I                                            27060
   20 CONTINUE                                                             27070
      ALRATI=SUM2*(1.-FRACT)+SUM1*FRACT                                    27080
      RATIO=10.**ALRATI                                                    27090
      RETURN                                                               27100
      END                                                                  27110
      SUBROUTINE FOUR (L,K,THETA,RHO,AA,BB)                                27120
c   Version of April 9, 1992                                               27130
      DIMENSION THETA(*),RHO(*),AA(*),BB(*)                                27140
      KK=K+1                                                               27150
      EL=L                                                                 27160
      DEL=2./EL                                                            27170
      KST=2                                                                27180
      FAC=6.2831852/EL                                                     27190
      DO 65 N=1,KK                                                         27200
      AA(N)=0.                                                             27210
   65 BB(N)=0.                                                             27220
      THETA(L)=3.1415927*(2.-1./EL)                                        27230
      DO 29 J=1,L                                                          27240
      XJ=J-1                                                               27250
      TH=FAC*XJ                                                            27260
      KT=KST                                                               27270
      DO 50 M=KT,L                                                         27280
      IF(TH.LT.THETA(M)) GOTO 22                                           27290
      GOTO 50                                                              27300
   22 MP=M-1                                                               27310
      P=(TH-THETA(MP))/(THETA(M)-THETA(MP))                                27320
      RRO=(1.-P)*RHO(MP)+P*RHO(M)                                          27330
      KST=M                                                                27340
      GOTO 25                                                              27350
   50 CONTINUE                                                             27360
   25 DO 29 N=1,KK                                                         27370
      EN=N-1                                                               27380
      ENTHET=EN*TH                                                         27390
      AA(N)=AA(N)+RRO*COS(ENTHET)*DEL                                      27400
   29 BB(N)=BB(N)+RRO*SIN(ENTHET)*DEL                                      27410
      AA(1)=AA(1)*.5                                                       27420
      RETURN                                                               27430
      END                                                                  27440
      SUBROUTINE SORTER (L,THETA,RHO)                                      27450
c  Version of April 9, 1992                                                27460
      DIMENSION THETA(*),RHO(*)                                            27470
      M=1                                                                  27480
      DO 1 I=1,L                                                           27490
      M=M+M                                                                27500
      IF((M-L).GT.0) GOTO 2                                                27510
    1 CONTINUE                                                             27520
    2 M=(M-1)/2                                                            27530
    3 IF(M.EQ.0) RETURN                                                    27540
      NN=L-M                                                               27550
      DO 5 J=1,NN                                                          27560
      DO 5 I=1,J,M                                                         27570
      IL=J+1-I                                                             27580
      IML=IL+M                                                             27590
      IF((THETA(IML)-THETA(IL)).GE.0.) GOTO 5                              27600
      X=THETA(IML)                                                         27610
      Y=RHO(IML)                                                           27620
      THETA(IML)=THETA(IL)                                                 27630
      RHO(IML)=RHO(IL)                                                     27640
      THETA(IL)=X                                                          27650
      RHO(IL)=Y                                                            27660
    5 CONTINUE                                                             27670
      M=M/2                                                                27680
      GOTO 3                                                               27690
      END                                                                  27700
      SUBROUTINE ELLONE(FFF,DD,RMSP,XL1,OM1,XL2,OM2)                       27710
C     VERSION OF 4/8/82                                                    27720
C     XL2 AND OM2 VALUES ASSUME SYNCHRONOUS ROTATION AND CIRCULAR ORBIT.   27730
C     THEY ARE NOT NEEDED FOR NON-SYNCHRONOUS OR NON-CIRCULAR CASES.       27740
      IMPLICIT REAL*8(A-H,O-Z)                                             27750
      REAL RMSP,XL1,OM1,XL2,OM2,FFF,DD                                     27760
      RMASS=RMSP                                                           27770
      FF=FFF                                                               27780
      D=DD                                                                 27790
      XL=.5D0*D                                                            27800
      DO 5 I=1,2                                                           27810
      RFAC=FF**2                                                           27820
      IF(I.EQ.2) RFAC=1.D0                                                 27830
      IF(I.EQ.2) D=1.D0                                                    27840
      DSQ=D*D                                                              27850
      DELXL=0.D0                                                           27860
      RM1=RMASS+1.D0                                                       27870
   88 XL=XL+DELXL                                                          27880
      XSQ=XL*XL                                                            27890
      P=(D-XL)**2                                                          27900
      RP=DABS(D-XL)                                                        27910
      PRP=P*RP                                                             27920
      F=RFAC*RM1*XL-1.D0/XSQ-RMASS*(XL-D)/PRP-RMASS/DSQ                    27930
      DXLDF=1.D0/(RFAC*RM1+2.D0/(XSQ*XL)+2.D0*RMASS/PRP)                   27940
      DELXL=-F*DXLDF                                                       27950
      ABDEL=DABS(DELXL)                                                    27960
      IF(ABDEL.GT..000001D0) GOTO 88                                       27970
      IF(I.EQ.2) GOTO 8                                                    27980
      XL1=XL                                                               27990
      OM1=1.D0/XL+RMASS*((1.D0/RP)-XL/DSQ)+RM1*.5D0*XSQ*RFAC               28000
      IF(RMSP.GT.1.)RMASS=1.D0/RMASS                                       28010
      XMU3=RMASS/(3.D0*(RMASS+1.D0))                                       28020
      XMU3CR=XMU3**.33333333333D0                                          28030
    5 XL=1.D0+XMU3CR+XMU3CR*XMU3CR/3.D0+XMU3/9.D0                          28040
    8 IF(RMSP.GT.1.)XL=D-XL                                                28050
      RMASS=RMSP                                                           28060
      XL2=XL                                                               28070
      OM2=1.D0/DABS(XL)+RMASS*((1.D0/DSQRT(1.D0-XL-XL+XL*XL))-XL)+RM1*     28080
     $.5D0*XL*XL                                                           28090
      RETURN                                                               28100
      END                                                                  28110
      SUBROUTINE RING(QSP,OMSP,KOMP,L,FR,HLD,R1SP,RLSP)                    28120
c  Version of April 9, 1992                                                28130
      IMPLICIT REAL*8(A-H,O-Z)                                             28140
      REAL QSP,OMSP,FR,HLD,Z,XLSP,OM1SP,XL2SP,OM2SP,EMSP,EYSP,THESP,ELSP   28150
     $,R1SP,RLSP                                                           28160
      DIMENSION RAD(100),THET(100),AA(3),BB(3),FI(150),THA(150),FR(*),     28170
     $HLD(*)                                                               28180
      IA=1                                                                 28190
      IX=0                                                                 28200
      LR=L+1                                                               28210
      DO 92 I=1,LR                                                         28220
      THA(I)=0.D0                                                          28230
   92 FI(I)=-.1D0                                                          28240
      Q=QSP                                                                28250
      OMEGA=OMSP                                                           28260
      K=3                                                                  28270
      EL=L                                                                 28280
      ELSP=L                                                               28290
      DEL=2.D0/EL                                                          28300
      CALL ELLONE(1.,1.,QSP,XLSP,OM1SP,XL2SP,OM2SP)                        28310
      CALL NEKMIN(QSP,OMSP,XLSP,Z)                                         28320
      XL=XLSP                                                              28330
      OM1=OM1SP                                                            28340
      XL2=XL2SP                                                            28350
      OM2=OM2SP                                                            28360
      QQ=Q                                                                 28370
      XLSQ=XL*XL                                                           28380
      IF(Q.GT.1.D0) QQ=1.D0/Q                                              28390
      RMAX=DEXP(.345D0*DLOG(QQ)-1.125D0)                                   28400
      R=RMAX*(OM1-OMEGA)/(OM1-OM2)                                         28410
      DO 22 IT=1,L                                                         28420
      EYT=IT                                                               28430
      TH=EYT*1.5707963D0/EL                                                28440
      COSQ=DCOS(TH)**2                                                     28450
      DELR=0.D0                                                            28460
   14 R=DABS(R+DELR)                                                       28470
      RSQ=R*R                                                              28480
      X2R2=XLSQ+RSQ                                                        28490
      RX2R2=DSQRT(X2R2)                                                    28500
      XM2R2=(XL-1.D0)**2+RSQ                                               28510
      RXM2R2=DSQRT(XM2R2)                                                  28520
      OM=1.D0/RX2R2+Q*(1.D0/RXM2R2-XL)+.5D0*(Q+1.D0)*(XLSQ+RSQ*COSQ)       28530
      DOMDR=-R/(X2R2*RX2R2)-Q*R/(XM2R2*RXM2R2)+(Q+1.D0)*COSQ*R             28540
      DELR=(OMEGA-OM)/DOMDR                                                28550
      ABDELR=DABS(DELR)                                                    28560
      IF(ABDELR.GT..00001D0) GOTO 14                                       28570
      RAD(IT)=R                                                            28580
   22 THET(IT)=TH*4.D0                                                     28590
      R1=RAD(1)                                                            28600
      RL=RAD(L)                                                            28610
      R1SP=R1                                                              28620
      RLSP=RL                                                              28630
      R90SQ=RL*RL                                                          28640
      DO 18 IJ=1,L                                                         28650
      EYJ=IJ                                                               28660
      RAD(IJ)=RAD(IJ)-(RL-R1)*(EYJ-1.D0)/EL                                28670
   18 CONTINUE                                                             28680
      DO 65 N=1,K                                                          28690
      AA(N)=0.D0                                                           28700
   65 BB(N)=0.D0                                                           28710
      DO 29 J=1,L                                                          28720
      DO 29 N=1,K                                                          28730
      EN=N-1                                                               28740
      ENTHET=EN*THET(J)                                                    28750
      AA(N)=AA(N)+RAD(J)*DCOS(ENTHET)*DEL                                  28760
   29 BB(N)=BB(N)+RAD(J)*DSIN(ENTHET)*DEL                                  28770
      AA(1)=AA(1)*.5D0                                                     28780
      IF(KOMP.EQ.2) XL=1.-XLSP                                             28790
      XLSQ=XL*XL                                                           28800
      DIS=RL/XL-.0005D0                                                    28810
      DO 42 IR=1,L                                                         28820
      LL=IR-1                                                              28830
      EY=L+1-IR                                                            28840
      THA(IR)=1.5707963D0*EY/EL                                            28850
      IF(THA(IR).LT.1.57079D0) GOTO 82                                     28860
      COT=0.D0                                                             28870
      GOTO 83                                                              28880
   82 COT=1.D0/DTAN(THA(IR))                                               28890
   83 IF(COT.GE.DIS) GOTO 50                                               28900
      COSSQ=DCOS(THA(IR))**2                                               28910
      A0=AA(1)                                                             28920
      A1=AA(2)                                                             28930
      A2=AA(3)                                                             28940
      B1=BB(2)                                                             28950
      B2=BB(3)                                                             28960
      DELSIN=0.D0                                                          28970
      KNTR=0                                                               28980
      SINTH=DSQRT(COSSQ*(XLSQ+R90SQ)/R90SQ)                                28990
   88 SINTH=SINTH+DELSIN                                                   29000
      KNTR=KNTR+1                                                          29010
      IF(SINTH.GT.1.D0)SINTH=1.D0/SINTH                                    29020
      CSQ=1.D0-SINTH*SINTH                                                 29030
      COSTH=DSQRT(CSQ)                                                     29040
      SINSQ=SINTH*SINTH                                                    29050
      SIN4=8.D0*COSTH**3*SINTH-4.D0*COSTH*SINTH                            29060
      COS4=8.D0*CSQ*(CSQ-1.D0)+1.D0                                        29070
      C4SQ=COS4*COS4                                                       29080
      SINCOS=SIN4*COS4                                                     29090
      RRR=A0+A1*COS4+A2*(C4SQ+C4SQ-1.D0)+B1*SIN4+(B2+B2)*SINCOS            29100
      ARC=DARSIN(SINTH)                                                    29110
      RR=RRR+(RL-R1)*(2.D0*ARC/3.1415926536D0-1.D0/EL)                     29120
      IF(KNTR.GT.30) GOTO 42                                               29130
      P=RR*SINTH                                                           29140
      DRDSIN=-A1*SINTH/COSTH-4.D0*A2*SINTH+B1-(B2+B2)*SINSQ/COSTH+(B2+B2   29150
     $)*COSTH+(RL+RL-R1-R1)/(3.1415926536D0*COSTH)                         29160
      DPDSIN=RR+SINTH*DRDSIN                                               29170
      F=P*P/COSSQ-RR*RR-XLSQ                                               29180
      DFDSIN=(P+P)*DPDSIN/COSSQ-(RR+RR)*DRDSIN                             29190
      DELSIN=-F/DFDSIN                                                     29200
      ABDEL=DABS(DELSIN)                                                   29210
      IF(ABDEL.GT..00001D0)  GOTO 88                                       29220
   42 FI(IR)=DATAN(RR*COSTH/XL)                                            29230
   50 LL1=LL+1                                                             29240
      DELTH=1.5707963D0/EL                                                 29250
      DO 75 I=1,L                                                          29260
      EY=L+1-I                                                             29270
      EY=EY-.5D0                                                           29280
      THE=1.5707963D0*EY/EL                                                29290
      SNTH=DSIN(THE)                                                       29300
      EYSP=L+1-I                                                           29310
      EYSP=EYSP-.5                                                         29320
      THESP=THE                                                            29330
      CSTH=DCOS(THE)                                                       29340
      EMSP=SIN(THESP)*ELSP*1.3                                             29350
      MM=EMSP+1.                                                           29360
      XM=MM                                                                29370
      DELFI=3.1415926D0/XM                                                 29380
      HDELFI=1.5707963D0/XM                                                29390
      DO 75 J=1,MM                                                         29400
      IX=IX+1                                                              29410
      IF(I.LE.LL1) GOTO 43                                                 29420
      HLD(IX)=1.                                                           29430
      GOTO 75                                                              29440
   43 XJ=MM+1-J                                                            29450
      FE=3.1415926D0*(XJ-.5D0)/XM                                          29460
      PH2=FE+HDELFI                                                        29470
      PHB=PH2                                                              29480
      IF(FI(I).GT.(FE-HDELFI)) GOTO 51                                     29490
      HLD(IX)=1.                                                           29500
      GOTO 75                                                              29510
   51 IPL=I+1                                                              29520
      IF(FI(IPL).GT.0.D0) GOTO 66                                          29530
      RR=A0+A1-A2+(RL-R1)*(1.D0-1.D0/EL)                                   29540
      PH1=DELFI*(XJ-1.D0)                                                  29550
      TH1=DATAN(XL/RR)                                                     29560
      GOTO 56                                                              29570
   66 IF(FI(IPL).LT.(FE+HDELFI)) GOTO 52                                   29580
      HLD(IX)=0.                                                           29590
      GOTO 75                                                              29600
   52 IF(FI(IPL).LT.(FE-HDELFI)) GOTO 53                                   29610
      PH1=FI(IPL)                                                          29620
      TH1=THA(IPL)                                                         29630
      GOTO 56                                                              29640
   53 DELSIN=0.D0                                                          29650
      SINTH=DSQRT(COSSQ*(XLSQ+R90SQ)/R90SQ)                                29660
      TANFE=DTAN(FE-HDELFI)                                                29670
   77 SINTH=SINTH+DELSIN                                                   29680
      IF(SINTH.GT.1.D0) SINTH=1.D0/SINTH                                   29690
      SINSQ=SINTH*SINTH                                                    29700
      CSQ=1.D0-SINSQ                                                       29710
      COSTH=DSQRT(CSQ)                                                     29720
      SIN4=8.D0*COSTH**3*SINTH-4.D0*COSTH*SINTH                            29730
      COS4=8.D0*CSQ*(CSQ-1.D0)+1.D0                                        29740
      C4SQ=COS4*COS4                                                       29750
      SINCOS=SIN4*COS4                                                     29760
      RRR=A0+A1*COS4+A2*(C4SQ+C4SQ-1.D0)+B1*SIN4+(B2+B2)*SINCOS            29770
      ARC=DARSIN(SINTH)                                                    29780
      RR=RRR+(RL-R1)*(2.D0*ARC/3.1415926536D0-1.D0/EL)                     29790
      DRDSIN=-A1*SINTH/COSTH-4.D0*A2*SINTH+B1-(B2+B2)*SINSQ/COSTH+(B2+B2   29800
     $)*COSTH+(RL+RL-R1-R1)/(3.1415926536D0*COSTH)                         29810
      F=RR*COSTH-XL*TANFE                                                  29820
      DFDSIN=COSTH*DRDSIN-RR*SINTH/COSTH                                   29830
      DELSIN=-F/DFDSIN                                                     29840
      ABDEL=DABS(DELSIN)                                                   29850
      IF(ABDEL.GT..00001D0)  GOTO 77                                       29860
      PH1=FE-HDELFI                                                        29870
      TH1=DATAN(XL/(RR*SINTH*DCOS(PH1)))                                   29880
   56 IF(FI(I).GT.(FE+HDELFI)) GOTO 57                                     29890
      PHB=FI(I)                                                            29900
      TH2=THA(I)                                                           29910
      GOTO 60                                                              29920
   57 DELSIN=0.D0                                                          29930
      SINTH=DSQRT(COSSQ*(XLSQ+R90SQ)/R90SQ)                                29940
      TANFE=DTAN(FE+HDELFI)                                                29950
   78 SINTH=SINTH+DELSIN                                                   29960
      IF(SINTH.GT.1.D0) SINTH=1.D0/SINTH                                   29970
      SINSQ=SINTH*SINTH                                                    29980
      CSQ=1.D0-SINSQ                                                       29990
      COSTH=DSQRT(CSQ)                                                     30000
      SIN4=8.D0*COSTH**3*SINTH-4.D0*COSTH*SINTH                            30010
      COS4=8.D0*CSQ*(CSQ-1.D0)+1.D0                                        30020
      C4SQ=COS4*COS4                                                       30030
      SINCOS=SIN4*COS4                                                     30040
      RRR=A0+A1*COS4+A2*(C4SQ+C4SQ-1.D0)+B1*SIN4+(B2+B2)*SINCOS            30050
      ARC=DARSIN(SINTH)                                                    30060
      RR=RRR+(RL-R1)*(2.D0*ARC/3.1415926536D0-1.D0/EL)                     30070
      DRDSIN=-A1*SINTH/COSTH-4.D0*A2*SINTH+B1-(B2+B2)*SINSQ/COSTH+(B2+B2   30080
     $)*COSTH+(RL+RL-R1-R1)/(3.1415926536D0*COSTH)                         30090
      F=RR*COSTH-XL*TANFE                                                  30100
      DFDSIN=COSTH*DRDSIN-RR*SINTH/COSTH                                   30110
      DELSIN=-F/DFDSIN                                                     30120
      ABDEL=DABS(DELSIN)                                                   30130
      IF(ABDEL.GT..00001D0)  GOTO 78                                       30140
      TH2=DATAN(XL/(RR*SINTH*DCOS(PH2)))                                   30150
   60 CTHT=DCOS(THA(IPL))                                                  30160
      CTH1=DCOS(TH1)                                                       30170
      CTH2=DCOS(TH2)                                                       30180
      STH1=DSIN(TH1)                                                       30190
      STH2=DSIN(TH2)                                                       30200
      DTH=TH2-TH1                                                          30210
      DCTH=CTH1-CTH2                                                       30220
      OMDP=PH2*DCTH-.5D0*(PH1*STH1+PHB*STH2)*DTH                           30230
      OMP=DELFI*(CTHT-CTH1)                                                30240
      OMN=OMP+OMDP                                                         30250
      HLD(IX)=OMN/(DELTH*DELFI*SNTH)                                       30260
   75 CONTINUE                                                             30270
      DO 94 JB=1,IX                                                        30280
      JA=IX+1-JB                                                           30290
   94 FR(JB)=HLD(JA)                                                       30300
      RETURN                                                               30310
      END                                                                  30320
      SUBROUTINE MODLOG(RV,GRX,GRY,GRZ,RVQ,GRXQ,GRYQ,GRZQ,MMSAVE,FR1,FR2   30330
     $,HLD,RM,POTH,POTC,GR1,GR2,ALB1,ALB2,N1,N2,F1,F2,MOD,XINCL,THE,       30340
     $MODE,SNTH,CSTH,SNFI,CSFI,GRV1,GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,GLUMP1    30350
     $,GLUMP2,CSBT1,CSBT2,GMAG1,GMAG2)                                     30360
c    Version of August 26, 1993                                            30370
      DOUBLE PRECISION RES,DRR,ANS,DUMM                                    30380
      DIMENSION RV(*),GRX(*),GRY(*),GRZ(*),RVQ(*),GRXQ(*),GRYQ(*),GRZQ     30390
     $(*),MMSAVE(*),FR1(*),FR2(*),HLD(*),GRV1(*),GRV2(*),XX1(*),YY1(*),    30400
     $ZZ1(*),XX2(*),YY2(*),ZZ2(*),GLUMP1(*),GLUMP2(*),CSBT1(*),CSBT2(*)    30410
     $,GMAG1(*),GMAG2(*)                                                   30420
      DIMENSION DRR(4),RES(2),ANS(2),LX(2),MX(2)                           30430
      DIMENSION SNTH(*),CSTH(*),SNFI(*),CSFI(*)                            30440
      common /kfac/ kff1,kff2,kfo1,kfo2                                    30450
      common /setest/ sefac                                                30460
      COMMON /FLVAR/ PER,PSHIFT,DP,DS,EF,EFC,ECOS,PERR,PHPER,PCONJ,        30470
     $PHPERI,VSUM1,VSUM2,VRA1,VRA2,VKM1,VKM2,VUNIT,vfvu,trc                30480
      COMMON /ECCEN/ E,A,PERIOD,VGA,SINI,VF,VFAC,VGAM,VOL1,VOL2,IFC        30490
      COMMON /INVAR/ KH,IPBDUM,IRTE,NREF,IRVOL1,IRVOL2,mref,ifsmv1,        30500
     $ifsmv2,icor1,icor2,ld                                                30510
   95 FORMAT(' WARNING: ALTHOUGH COMPONENT 2 DOES NOT EXCEED ITS LIMITIN   30520
     $G LOBE AT THE END OF ECLIPSE, IT DOES EXCEED THE LOBE AT PERIASTRO   30530
     $N')                                                                  30540
   99 FORMAT(' SPECIFIED ECLIPSE DURATION INCONSISTENT WITH OTHER PARAME   30550
     $TERS')                                                               30560
      DP=1.-E                                                              30570
      DS=DP*DP                                                             30580
      MOD=(MODE-2)**2                                                      30590
      IF(MOD.EQ.1) GR2=GR1                                                 30600
      IF(MOD.EQ.1) ALB2=ALB1                                               30610
      IF(MOD.EQ.1) POTC=POTH                                               30620
      MD4=(MODE-5)**2                                                      30630
      MD5=(2*MODE-11)**2                                                   30640
      call ellone(f1,dp,rm,xl1,po1cr,xl2,omo1)                             30650
      sefac=.8712                                                          30660
      doc=(po1cr-poth)/(po1cr-omo1)                                        30670
      if(doc.gt.0.) sefac=.201*doc*doc-.386*doc+.8712                      30680
      RMR=1./RM                                                            30690
      CALL ELLONE(F2,DP,RMR,XL1,po2c,XL2,omo2)                             30700
      po2cr=rm*po2c+(1.-rm)*.5                                             30710
      if(md4.eq.1) poth=po1cr                                              30720
      if(md5.eq.1) potc=po2cr                                              30730
      kff1=0                                                               30740
      kff2=0                                                               30750
      if(poth.lt.po1cr) kff1=1                                             30760
      if(potc.lt.po2cr) kff2=1                                             30770
      kfo1=0                                                               30780
      kfo2=0                                                               30790
      if(e.ne.0.) goto 100                                                 30800
      if(f1.ne.1.) goto 105                                                30810
      if(poth.lt.omo1) kfo1=1                                              30820
  105 if(f2.ne.1.) goto 100                                                30830
      if(potc.lt.omo1) kfo2=1                                              30840
  100 continue                                                             30850
      SINI=SIN(.0174533*XINCL)                                             30860
      VF=50.61455/PERIOD                                                   30870
      VFAC=VF*A                                                            30880
      VGAM=VGA*VUNIT/VFAC                                                  30890
      VFVU=VFAC/VUNIT                                                      30900
      IFC=2                                                                30910
      IF(E.NE.0.) GOTO 60                                                  30920
      PERR=1.570796                                                        30930
      IFC=1                                                                30940
   60 CONTINUE                                                             30950
      TRC=1.570796-PERR                                                    30960
   39 if(TRC.LT.0.) TRC=TRC+6.283185                                       30970
      if(trc.lt.0.) goto 39                                                30980
   40 if(trc.ge.6.283185) trc=trc-6.283185                                 30990
      if(trc.ge.6.283185) goto 40                                          31000
      HTRC=.5*TRC                                                          31010
      IF(ABS(1.570796-HTRC).LT.7.E-6) GOTO 101                             31020
      IF(ABS(4.712389-HTRC).LT.7.E-6) GOTO 101                             31030
      ECAN=2.*ATAN(SQRT((1.-E)/(1.+E))*TAN(HTRC))                          31040
      GOTO 103                                                             31050
  101 ECAN=3.141593                                                        31060
  103 XMC=ECAN-E*SIN(ECAN)                                                 31070
      IF(XMC.LT.0.) XMC=XMC+6.283185                                       31080
      PHPER=1.-XMC/6.283185                                                31090
      PCONJ=(XMC+PERR)/6.283185-.25+PSHIFT                                 31100
   38 if(pconj.ge.1.) pconj=pconj-1.                                       31110
      if(pconj.ge.1.) goto 38                                              31120
   41 if(pconj.lt.0.) pconj=pconj+1.                                       31130
      if(pconj.lt.0.) goto 41                                              31140
      PHPERI=PHPER+PCONJ                                                   31150
      EF=1.-E*E                                                            31160
      EFC=SQRT(EF)                                                         31170
      ECOS=E*COS(PERR)                                                     31180
      IF(MODE.NE.-1) RETURN                                                31190
      if(kh.eq.17) goto 241                                                31200
      if((kh-12)**2.eq.1) goto 241                                         31210
      if((kh-12)**2.eq.4) goto 241                                         31220
      IF((KH-11)**2.LE.1) GOTO 241                                         31230
      IF((2*KH-41)**2.EQ.81) GOTO 241                                      31240
      RETURN                                                               31250
  241 CONTINUE                                                             31260
      EFCC=SQRT((1.-E)/(1.+E))                                             31270
      THER=THE*6.283185                                                    31280
      DELTR=.001                                                           31290
      DTR1=0.                                                              31300
      DTR2=0.                                                              31310
      VOLTOL=5.E-6                                                         31320
      DXMTOL=5.E-6                                                         31330
      TR0=1.570796-PERR                                                    31340
      HTR0=.5*TR0                                                          31350
      IF((1.570796-ABS(HTR0)).LT.7.E-6) GOTO 201                           31360
      IF((4.712389-ABS(HTR0)).LT.7.E-6) GOTO 201                           31370
      ECAN0=2.*ATAN(SQRT((1.-E)/(1.+E))*TAN(HTR0))                         31380
      GOTO 203                                                             31390
  201 ECAN0=3.141593                                                       31400
  203 XM0=ECAN0-E*SIN(ECAN0)                                               31410
      XM1=XM0-THER*(1.-.2*E)                                               31420
      XM2=XM0+THER*(1.-.2*E)                                               31430
      CALL KEPLER(XM1,E,DUM,TRR1)                                          31440
      CALL KEPLER(XM2,E,DUM,TRR2)                                          31450
  160 TRR1=TRR1+DTR1                                                       31460
      TRR2=TRR2+DTR2                                                       31470
      DO 161 IB=1,3                                                        31480
      TR1=TRR1                                                             31490
      TR2=TRR2                                                             31500
      IF(IB.EQ.2) TR1=TRR1+DELTR                                           31510
      IF(IB.EQ.3) TR2=TRR2+DELTR                                           31520
      IF(TR1.GT.TR0) TR0=TR0+6.283185                                      31530
      IF(TR0.GT.TR2) TR2=TR2+6.283185                                      31540
      DS1=EF/(1.+E*COS(TR1))                                               31550
      DS2=EF/(1.+E*COS(TR2))                                               31560
      RD1=DS1*SIN(ABS(TR1-TR0))                                            31570
      RD2=DS2*SIN(ABS(TR2-TR0))                                            31580
      TRE1=(TR0-TR1)/6.283185                                              31590
      TRE2=(TR2-TR0)/6.283185                                              31600
      CALL DURA(F2,XINCL,RM,DS1,TRE1,POTR,RA)                              31610
      CALL VOLUME(VS1,RM,POTR,DS1,F2,N2,N1,2,RV,GRX,GRY,GRZ,RVQ,GRXQ       31620
     $,GRYQ,GRZQ,MMSAVE,FR1,FR2,HLD,SNTH,CSTH,SNFI,CSFI,SUMMD,SMD,GRV1,    31630
     $GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,CSBT1,CSBT2,GLUMP1,GLUMP2,GMAG1,        31640
     $GMAG2,GR1,1)                                                         31650
      CALL DURA(F2,XINCL,RM,DS2,TRE2,POTR,RA)                              31660
      CALL VOLUME(VS2,RM,POTR,DS2,F2,N2,N1,2,RV,GRX,GRY,GRZ,RVQ,GRXQ       31670
     $,GRYQ,GRZQ,MMSAVE,FR1,FR2,HLD,SNTH,CSTH,SNFI,CSFI,SUMMD,SMD,GRV1,    31680
     $GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,CSBT1,CSBT2,GLUMP1,GLUMP2,GMAG1,        31690
     $GMAG2,GR2,1)                                                         31700
      IF(IB.NE.1) GOTO 185                                                 31710
      ECAN1=2.*ATAN(SQRT((1.-E)/(1.+E))*TAN(.5*TR1))                       31720
      ECAN2=2.*ATAN(SQRT((1.-E)/(1.+E))*TAN(.5*TR2))                       31730
      POTC=POTR                                                            31740
      DTHE=DS2                                                             31750
      DVOL=VS2-VS1                                                         31760
      XM1=ECAN1-E*SIN(ECAN1)                                               31770
      XM2=ECAN2-E*SIN(ECAN2)                                               31780
      IF(XM1.LT.0.) XM1=XM1+6.283185                                       31790
      IF(XM2.LT.0.) XM2=XM2+6.283185                                       31800
      DXM=XM2-XM1-2.*THER                                                  31810
      DDMDN1=-EFCC*(1.-E*COS(ECAN1))*COS(.5*ECAN1)**2/COS(.5*TR1)**2       31820
      DDMDN2=EFCC*(1.-E*COS(ECAN2))*COS(.5*ECAN2)**2/COS(.5*TR2)**2        31830
  185 CONTINUE                                                             31840
      IF(IB.NE.2) GOTO 162                                                 31850
      DRR(1)=(VS2-VS1-DVOL)/DELTR                                          31860
      DRR(2)=DDMDN1                                                        31870
  162 CONTINUE                                                             31880
      IF(IB.NE.3) GOTO 161                                                 31890
      DRR(3)=(VS2-VS1-DVOL)/DELTR                                          31900
      DRR(4)=DDMDN2                                                        31910
  161 CONTINUE                                                             31920
      RES(1)=-DVOL                                                         31930
      RES(2)=-DXM                                                          31940
      CALL DMINV(DRR,2,DUMM,LX,MX)                                         31950
      CALL DGMPRD(DRR,RES,ANS,2,2,1)                                       31960
      DTR1=ANS(1)                                                          31970
      DTR2=ANS(2)                                                          31980
      IF(ABS(DTR1).GT.VOLTOL) GOTO 160                                     31990
      IF(ABS(DTR2).GT.DXMTOL) GOTO 160                                     32000
      POTH=9999.99                                                         32010
      RMR=1./RM                                                            32020
      CALL ELLONE(F2,DTHE,RMR,XLA,OM1,XL2,OM2)                             32030
      OM1=RM*OM1+(1.-RM)*.5                                                32040
      IF(POTC.LT.OM1) GOTO 22                                              32050
      IF(RA.LE.XLA) GOTO 28                                                32060
   22 WRITE(6,99)                                                          32070
      RETURN                                                               32080
   28 CONTINUE                                                             32090
      IF(E.NE.0.) CALL VOLUME(VTHE,RM,POTC,DTHE,F2,N2,N1,2,RV,GRX,         32100
     $GRY,GRZ,RVQ,GRXQ,GRYQ,GRZQ,MMSAVE,FR1,FR2,HLD,SNTH,CSTH,SNFI,CSFI,   32110
     $SUMMD,SMD,GRV1,GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,CSBT1,CSBT2,GLUMP1,      32120
     $GLUMP2,GMAG1,GMAG2,GR2,1)                                            32130
      IF(E.NE.0.) CALL VOLUME(VTHE,RM,POTC,DP,F2,N2,N1,2,RV,GRX,           32140
     $GRY,GRZ,RVQ,GRXQ,GRYQ,GRZQ,MMSAVE,FR1,FR2,HLD,SNTH,CSTH,SNFI,CSFI,   32150
     $SUMMD,SMD,GRV1,GRV2,XX1,YY1,ZZ1,XX2,YY2,ZZ2,CSBT1,CSBT2,GLUMP1,      32160
     $GLUMP2,GMAG1,GMAG2,GR2,2)                                            32170
      CALL ELLONE(F2,DP,RMR,XLD,OMP,XL2,OM2)                               32180
      OMP=RM*OMP+(1.-RM)*.5                                                32190
      IF(POTC.LT.OMP) WRITE(6,95)                                          32200
      RETURN                                                               32210
      END                                                                  32220
      SUBROUTINE KEPLER(XMSP,ECSP,ECANSP,TRSP)                             32230
C     ORIGINAL VERSION OF 3/23/78.                                         32240
      IMPLICIT REAL*8(A-H,O-Z)                                             32250
      REAL XMSP,ECSP,ECANSP,TRSP                                           32260
      TOL=.00000001D0                                                      32270
      XM=XMSP                                                              32280
      EC=ECSP                                                              32290
      DLECAN=0.D0                                                          32300
      ECAN=XM                                                              32310
   18 ECAN=ECAN+DLECAN                                                     32320
      XMC=ECAN-EC*DSIN(ECAN)                                               32330
      DEDM=1.D0/(1.D0-EC*DCOS(ECAN))                                       32340
      DLECAN=(XM-XMC)*DEDM                                                 32350
      ABDLEC=DABS(DLECAN)                                                  32360
      IF(ABDLEC.GT.TOL) GOTO 18                                            32370
      TRSP=2.D0*DATAN(DSQRT((1.D0+EC)/(1.D0-EC))*DTAN(.5D0*ECAN))          32380
      IF(TRSP.LT.0.) TRSP=TRSP+6.283185                                    32390
      ECANSP=ECAN                                                          32400
      RETURN                                                               32410
      END                                                                  32420
      SUBROUTINE DGMPRD(A,B,R,N,M,L)                                       32430
c  Version of April 9, 1992                                                32440
      DIMENSION A(*),B(*),R(*)                                             32450
      DOUBLE PRECISION A,B,R                                               32460
      IR=0                                                                 32470
      IK=-M                                                                32480
      DO 10 K=1,L                                                          32490
      IK=IK+M                                                              32500
      DO 10 J=1,N                                                          32510
      IR=IR+1                                                              32520
      JI=J-N                                                               32530
      IB=IK                                                                32540
      R(IR)=0.D0                                                           32550
      DO 10 I=1,M                                                          32560
      JI=JI+N                                                              32570
      IB=IB+1                                                              32580
   10 R(IR)=R(IR)+A(JI)*B(IB)                                              32590
      RETURN                                                               32600
      END                                                                  32610
      SUBROUTINE DMINV(A,N,D,L,M)                                          32620
c  Version of April 9, 1992                                                32630
      DIMENSION A(*),L(*),M(*)                                             32640
      DOUBLE PRECISION A,D,BIGA,HOLD                                       32650
      D=1.D0                                                               32660
      NK=-N                                                                32670
      DO 80 K=1,N                                                          32680
      NK=NK+N                                                              32690
      L(K)=K                                                               32700
      M(K)=K                                                               32710
      KK=NK+K                                                              32720
      BIGA=A(KK)                                                           32730
      DO 20 J=K,N                                                          32740
      IZ=N*(J-1)                                                           32750
      DO 20 I=K,N                                                          32760
      IJ=IZ+I                                                              32770
   10 IF(DABS(BIGA).GE.DABS(A(IJ))) GOTO 20                                32780
      BIGA=A(IJ)                                                           32790
      L(K)=I                                                               32800
      M(K)=J                                                               32810
   20 CONTINUE                                                             32820
      J=L(K)                                                               32830
      IF(J.LE.K) GOTO 35                                                   32840
      KI=K-N                                                               32850
      DO 30 I=1,N                                                          32860
      KI=KI+N                                                              32870
      HOLD=-A(KI)                                                          32880
      JI=KI-K+J                                                            32890
      A(KI)=A(JI)                                                          32900
   30 A(JI) =HOLD                                                          32910
   35 I=M(K)                                                               32920
      IF(I.LE.K) GOTO 45                                                   32930
      JP=N*(I-1)                                                           32940
      DO 40 J=1,N                                                          32950
      JK=NK+J                                                              32960
      JI=JP+J                                                              32970
      HOLD=-A(JK)                                                          32980
      A(JK)=A(JI)                                                          32990
   40 A(JI) =HOLD                                                          33000
   45 IF(BIGA.NE.0.D0) GOTO 48                                             33010
      D=0.D0                                                               33020
      RETURN                                                               33030
   48 DO 55 I=1,N                                                          33040
      IF(I.EQ.K) GOTO 55                                                   33050
      IK=NK+I                                                              33060
      A(IK)=A(IK)/(-BIGA)                                                  33070
   55 CONTINUE                                                             33080
      DO 65 I=1,N                                                          33090
      IK=NK+I                                                              33100
      HOLD=A(IK)                                                           33110
      IJ=I-N                                                               33120
      DO 65 J=1,N                                                          33130
      IJ=IJ+N                                                              33140
      IF(I.EQ.K) GOTO 65                                                   33150
      IF(J.EQ.K) GOTO 65                                                   33160
      KJ=IJ-I+K                                                            33170
      A(IJ)=HOLD*A(KJ)+A(IJ)                                               33180
   65 CONTINUE                                                             33190
      KJ=K-N                                                               33200
      DO 75 J=1,N                                                          33210
      KJ=KJ+N                                                              33220
      IF(J.EQ.K) GOTO 75                                                   33230
      A(KJ)=A(KJ)/BIGA                                                     33240
   75 CONTINUE                                                             33250
      D=D*BIGA                                                             33260
      A(KK)=1.D0/BIGA                                                      33270
   80 CONTINUE                                                             33280
      K=N                                                                  33290
  100 K=(K-1)                                                              33300
      IF(K.LE.0) RETURN                                                    33310
      I=L(K)                                                               33320
      IF(I.LE.K) GOTO 120                                                  33330
      JQ=N*(K-1)                                                           33340
      JR=N*(I-1)                                                           33350
      DO 110 J=1,N                                                         33360
      JK=JQ+J                                                              33370
      HOLD=A(JK)                                                           33380
      JI=JR+J                                                              33390
      A(JK)=-A(JI)                                                         33400
  110 A(JI) =HOLD                                                          33410
  120 J=M(K)                                                               33420
      IF(J.LE.K) GOTO 100                                                  33430
  125 KI=K-N                                                               33440
      DO 130 I=1,N                                                         33450
      KI=KI+N                                                              33460
      HOLD=A(KI)                                                           33470
      JI=KI-K+J                                                            33480
      A(KI)=-A(JI)                                                         33490
  130 A(JI) =HOLD                                                          33500
      GO TO 100                                                            33510
      END                                                                  33520
      SUBROUTINE NEKMIN(RMSP,OMEGSP,XSP,ZSP)                               33530
C     VERSION OF 2/19/75. DESTROY EARLIER VERSIONS.                        33540
      IMPLICIT REAL*8(A-H,O-Z)                                             33550
      REAL RMSP,OMEGSP,XSP,ZSP                                             33560
      DIMENSION DN(4),EN(2),OUT(2),LL(2),MM(2)                             33570
      RM=RMSP                                                              33580
      OMEG=OMEGSP                                                          33590
      X=XSP                                                                33600
      Z=ZSP                                                                33610
      Z=.05                                                                33620
   15 P1=X*X+Z*Z                                                           33630
      RP1=DSQRT(P1)                                                        33640
      P115=P1*RP1                                                          33650
      P2=(1.-X)**2+Z*Z                                                     33660
      RP2=DSQRT(P2)                                                        33670
      P215=P2*RP2                                                          33680
      DODZ=-Z/P115-RM*Z/P215                                               33690
      OM=1./RP1+RM/RP2+(1.+RM)*.5*X*X-RM*X                                 33700
      DELOM=OMEG-OM                                                        33710
      DELZ=DELOM/DODZ                                                      33720
      Z=DABS(Z+DELZ)                                                       33730
      ABDELZ=DABS(DELZ)                                                    33740
      IF(ABDELZ.GT..00001) GOTO 15                                         33750
   16 P1=X*X+Z*Z                                                           33760
      RP1=DSQRT(P1)                                                        33770
      P115=P1*RP1                                                          33780
      P125=P1*P115                                                         33790
      P2=(1.-X)**2+Z*Z                                                     33800
      RP2=DSQRT(P2)                                                        33810
      P215=P2*RP2                                                          33820
      P225=P2*P215                                                         33830
      DN(1)=-X/P115+RM*(1.-X)/P215+(1.+RM)*X-RM                            33840
      DN(2)=(3.*X*X-P1)/P125+(3.*RM*(1.-X)**2-RM*((1.-X)**2+Z*Z))/P225     33850
     $+(RM+1.)                                                             33860
      DN(3)=-Z/P115-RM*Z/P215                                              33870
      DN(4)=3.*X*Z/P125-3.*RM*Z*(1.-X)/P225                                33880
      OME=1./RP1+RM/RP2+(1.+RM)*.5*X*X-RM*X                                33890
      EN(1)=OMEG-OME                                                       33900
      EN(2)=-DN(1)                                                         33910
      CALL DMINV(DN,2,D,LL,MM)                                             33920
      CALL DGMPRD(DN,EN,OUT,2,2,1)                                         33930
      DT1=OUT(1)                                                           33940
      DT2=OUT(2)                                                           33950
      ABDX=DABS(DT1)                                                       33960
      X=X+DT1                                                              33970
      ABDZ=DABS(DT2)                                                       33980
      Z=Z+DT2                                                              33990
      IF(ABDX.GT..000001) GOTO 16                                          34000
      IF(ABDZ.GT..000001) GOTO 16                                          34010
      RMSP=RM                                                              34020
      OMEGSP=OMEG                                                          34030
      XSP=X                                                                34040
      ZSP=Z                                                                34050
      RETURN                                                               34060
      END                                                                  34070
      SUBROUTINE SQUARE(OBS,NOBS,ML,OUT,PE,D,CN,CNN,SS,CL,LL,MM)           34080
c  Version of April 9, 1992                                                34090
      DIMENSION OBS(*),OUT(*),PE(*),CN(*),CL(*),LL(*),MM(*),CNN(*)         34100
      DOUBLE PRECISION CN,D,CL,OUT,OBSII,OBSKK,CAY,S,CLL,OBSQQ,CNN         34110
      S=0.D0                                                               34120
      CLL=0.D0                                                             34130
      CAY=NOBS-ML                                                          34140
      JMAX=ML*ML                                                           34150
      DO 20 J=1,JMAX                                                       34160
   20 CN(J)=0.D0                                                           34170
      DO 21 J=1,ML                                                         34180
   21 CL(J)=0.D0                                                           34190
      DO 25 NOB=1,NOBS                                                     34200
      III=NOB+NOBS*ML                                                      34210
      OBSQQ=OBS(III)                                                       34220
      DO 23 K=1,ML                                                         34230
      DO 23 I=1,ML                                                         34240
      II=NOB+NOBS*(I-1)                                                    34250
      KK=NOB+NOBS*(K-1)                                                    34260
      J=I+(K-1)*ML                                                         34270
      OBSII=OBS(II)                                                        34280
      OBSKK=OBS(KK)                                                        34290
   23 CN(J)=CN(J)+OBSII*OBSKK                                              34300
      DO 24 I=1,ML                                                         34310
      II=NOB+NOBS*(I-1)                                                    34320
      OBSII=OBS(II)                                                        34330
   24 CL(I)=CL(I)+OBSQQ*OBSII                                              34340
   25 CLL=CLL+OBSQQ*OBSQQ                                                  34350
      DO 50 J=1,JMAX                                                       34360
   50 CNN(J)=CN(J)                                                         34370
      CALL DMINV(CNN,ML,D,LL,MM)                                           34380
      CALL DGMPRD(CNN,CL,OUT,ML,ML,1)                                      34390
      DO 26 I=1,ML                                                         34400
   26 S=S+CL(I)*OUT(I)                                                     34410
      S=CLL-S                                                              34420
      SS=S                                                                 34430
      SIGSQ=S/CAY                                                          34440
      DO 27 J=1,ML                                                         34450
      JJ=J*ML+J-ML                                                         34460
      CNJJ=CNN(JJ)                                                         34470
      ARG=SIGSQ*CNJJ                                                       34480
   27 PE(J)=.6745*SQRT(ARG)                                                34490
      RETURN                                                               34500
      END                                                                  34510
      Subroutine lum (xlum,x,y,grexp,wl,tpoll,n,n1,nstar,sbr,rv,rvq,       34520
     $glump1,glump2,grv1,grv2,mmsave,summ,fr,sm,ifat,vol,rm,om,f,d,        34530
     $hld,snth)                                                            34540
c   Version of August 18, 1993                                             34550
      dimension rv(*),rvq(*),mmsave(*),fr(*),hld(*),snth(*),glump1(*),     34560
     $glump2(*),grv1(*),grv2(*)                                            34570
      common /radi/ R1H,RLH,R1C,RLC                                        34580
      common /invar/ khdum,ipbdum,irtedm,nrefdm,irv1dm,irv2dm,mrefdm,      34590
     $is1dm,is2dm,ic1dm,ic2dm,ld                                           34600
      TPOLE=10000.*TPOLL                                                   34610
      KR=0                                                                 34620
      RAT=1.                                                               34630
      RATPOL=1.                                                            34640
      IF(IFAT.NE.0) CALL ATM(TPOLE,WL,RATPOL)                              34650
      XLUMP=14384./WL                                                      34660
      COMP=3-2*NSTAR                                                       34670
      POLFAC=EXP(XLUMP/TPOLE)-1.                                           34680
      EN=N                                                                 34690
      DELTH=1.570796/EN                                                    34700
      IQ=(NSTAR-1)*(N1+1)                                                  34710
      IS=(NSTAR-1)*MMSAVE(IQ)                                              34720
      SUM=0.                                                               34730
      SUMM=0.                                                              34740
      SM=0.                                                                34750
      VOL=0.                                                               34760
      DO 36 I=1,N                                                          34770
      IPN1=I+N1*(NSTAR-1)                                                  34780
      SINTH=SNTH(IPN1)                                                     34790
      EM=SINTH*EN*1.3                                                      34800
      MM=EM+1.                                                             34810
      XM=MM                                                                34820
      DELFI=3.141593/XM                                                    34830
      DFST=DELFI*SINTH                                                     34840
      SUMJ=0.                                                              34850
      SUMMJ=0.                                                             34860
      SMJ=0.                                                               34870
      VOLJ=0.                                                              34880
      DO 26 J=1,MM                                                         34890
      IS=IS+1                                                              34900
      IP=(NSTAR-1)*(N1+1)+I                                                34910
      IX=MMSAVE(IP)+J                                                      34920
      IF(NSTAR.EQ.1) GOTO 39                                               34930
      IF(RVQ(IX).EQ.-1.) GOTO 25                                           34940
      R=RVQ(IX)                                                            34950
      GOTO 49                                                              34960
   39 IF(RV(IX).EQ.-1.) GOTO 25                                            34970
      R=RV(IX)                                                             34980
   49 grav=(2-nstar)*grv1(ix)+(nstar-1)*grv2(ix)                           34990
      TLOCAL=TPOLE*SQRT(SQRT(GRAV))                                        35000
      IF(IFAT.NE.0) CALL ATM(TLOCAL,WL,RAT)                                35010
      GRAVM=RAT*POLFAC/(EXP(XLUMP/TLOCAL)-1.)                              35020
      di=(2-nstar)*glump1(ix)+(nstar-1)*glump2(ix)                         35030
      DIF=DI*GRAVM                                                         35040
      DIFF=DI*GRAV                                                         35050
      SMJ=SMJ+DI                                                           35060
      SUMJ=SUMJ+DIF                                                        35070
      SUMMJ=SUMMJ+DIFF                                                     35080
      VOLJ=VOLJ+R*R*R*FR(IX)                                               35090
      GOTO 26                                                              35100
   25 KR=1                                                                 35110
   26 CONTINUE                                                             35120
      SMJ=SMJ*DELFI                                                        35130
      SUMJ=SUMJ*DELFI                                                      35140
      SUMMJ=SUMMJ*DELFI                                                    35150
      SM=SM+SMJ                                                            35160
      SUMM=SUMM+SUMMJ                                                      35170
      VOL=VOL+VOLJ*DFST                                                    35180
   36 SUM=SUM+SUMJ                                                         35190
      darkin=3.141593*(1.-x/3.)                                            35200
      if(ld.eq.2) darkin=darkin+.6981317*y                                 35210
      if(ld.eq.3) darkin=darkin-.6283185*y                                 35220
      SBR=.25*RATPOL*XLUM/(SUM*DELTH*DARKIN)                               35230
      SM=SM*DELTH*4.                                                       35240
      SUMM=SUMM*DELTH*4.                                                   35250
      VOL=VOL*1.333333*DELTH                                               35260
      IF(KR.EQ.0) RETURN                                                   35270
      CALL ELLONE(F,D,RM,XL1,OMD,XLD,OMD)                                  35280
      CALL NEKMIN(RM,OM,XL1,ZD)                                            35290
      IF(NSTAR.EQ.2) XL1=D-XL1                                             35300
      R1=(2-nstar)*R1H+(nstar-1)*R1C                                       35310
      RL=(2-nstar)*RLH+(nstar-1)*RLC                                       35320
      VOL=VOL+1.047198*XL1*R1*RL                                           35330
      RETURN                                                               35340
      END                                                                  35350
      SUBROUTINE LUMP(GRX,GRY,GRZ,GRXQ,GRYQ,GRZQ,SLUMP1,SLUMP2,            35360
     $MMSAVE,GREXP,ALB,WL,TPOLL,SBR,SUMM,N1,N2,KOMP,IFAT,fr,snth,          35370
     $CSTH,SNFI,CSFI,TLD,GLUMP1,GLUMP2,XX1,XX2,YY1,YY2,ZZ1,ZZ2,xbol,ybol   35380
     $,GRV1,GRV2,SBR1B,SBR2B,RF,RFO,GMAG1,GMAG2,DINT)                      35390
c   Version of August 18, 1993                                             35400
      DIMENSION GRX(*),GRY(*),GRZ(*),GRXQ(*),GRYQ(*),grzq(*),              35410
     $SLUMP1(*),SLUMP2(*),MMSAVE(*),FR(*),SNTH(*),CSTH(*),                 35420
     $SNFI(*),CSFI(*),TLD(*),GLUMP1(*),GLUMP2(*),XX1(*),XX2(*),YY1(*)      35430
     $,YY2(*),ZZ1(*),ZZ2(*),GRV1(*),GRV2(*),RF(*),RFO(*),                  35440
     $GMAG1(*),GMAG2(*)                                                    35450
      common /invar/ khdum,ipbdum,irtedm,nrefdm,irv1dm,irv2dm,mrefdm       35460
     $,ifs1dm,ifs2dm,icr1dm,icr2dm,ld                                      35470
      IQ=(KOMP-1)*(N1+1)                                                   35480
      IS=(KOMP-1)*MMSAVE(IQ)                                               35490
      ATRAT=1.                                                             35500
      RATPOL=1.                                                            35510
      PI=3.141593                                                          35520
      PIH=.5D0*PI                                                          35530
      TPOLE=10000.*TPOLL                                                   35540
      IF(IFAT.NE.0) CALL ATM(tpole,WL,RATPOL)                              35550
      CMPP=2-KOMP                                                          35560
      COMPP=2*KOMP-3                                                       35570
      COMP=-COMPP                                                          35580
      CMP=KOMP-1                                                           35590
      N=(2-KOMP)*N1+(KOMP-1)*N2                                            35600
      NO=(2-KOMP)*N2+(KOMP-1)*N1                                           35610
      NOD=2*NO                                                             35620
      EN=N                                                                 35630
      ENO=NO                                                               35640
      DELTHO=PIH/ENO                                                       35650
      XLUMP=14384./WL                                                      35660
      POLFAC=EXP(XLUMP/TPOLE)-1.                                           35670
      CNST=ALB*DELTHO*SBR2B/(DINT*SBR1B)                                   35680
      IF(KOMP.EQ.2)CNST=ALB*DELTHO*SBR1B/(DINT*SBR2B)                      35690
      DO 191 I=1,N                                                         35700
      IPN1=I+N1*(KOMP-1)                                                   35710
      SINTH=SNTH(IPN1)                                                     35720
      EM=SINTH*EN*1.3                                                      35730
      MM=EM+1.                                                             35740
      IP=(KOMP-1)*(N1+1)+I                                                 35750
      IY=MMSAVE(IP)                                                        35760
      DO 193 J=1,MM                                                        35770
      IX=IY+J                                                              35780
      SUM=0.                                                               35790
      IF(FR(IX).EQ.0.) GOTO 193                                            35800
      DO 190 IOTH=1,NOD                                                    35810
      IOTHS=IOTH                                                           35820
      IF(IOTH.GT.NO) IOTHS=NOD-IOTH+1                                      35830
      IPNO=IOTHS+N1*(2-KOMP)                                               35840
      SINTHO=SNTH(IPNO)                                                    35850
      EMO=SINTHO*ENO*1.3                                                   35860
      MMO=EMO+1.                                                           35870
      MMOD=2*MMO                                                           35880
      IPO=(2-KOMP)*(N1+1)+IOTHS                                            35890
      IYO=MMSAVE(IPO)                                                      35900
      XMO=MMO                                                              35910
      DELFIO=PI/XMO                                                        35920
      DO 190 JOFI=1,MMOD                                                   35930
      JOFU=JOFI                                                            35940
      IF(JOFI.GT.MMO) JOFU=MMOD-JOFI+1                                     35950
      IXO=IYO+JOFU                                                         35960
      IX1=IX                                                               35970
      IX2=IXO                                                              35980
      IF(KOMP.EQ.1) GOTO 200                                               35990
      IF(GLUMP1(IXO).EQ.0.) GOTO 184                                       36000
      IX1=IXO                                                              36010
      IX2=IX                                                               36020
      GOTO 201                                                             36030
  200 CONTINUE                                                             36040
      IF(GLUMP2(IXO).EQ.0.) GOTO 179                                       36050
  201 RTL1=1.                                                              36060
      RTL2=1.                                                              36070
      UPD1=1.                                                              36080
      UPD2=1.                                                              36090
      IF(KOMP.EQ.2) GOTO 22                                                36100
      IF(JOFI.GT.MMO) RTL2=-1.                                             36110
      IF(IOTH.GT.NO) UPD2=-1.                                              36120
      GOTO 23                                                              36130
   22 IF(JOFI.GT.MMO) RTL1=-1.                                             36140
      IF(IOTH.GT.NO) UPD1=-1.                                              36150
   23 CONTINUE                                                             36160
      GX2=GRXQ(IX2)                                                        36170
      GY2=GRYQ(IX2)*RTL2                                                   36180
      GZ2=GRZQ(IX2)*UPD2                                                   36190
      X1C=XX1(IX1)                                                         36200
      X2C=XX2(IX2)                                                         36210
      Y1C=YY1(IX1)*RTL1                                                    36220
      Y2C=YY2(IX2)*RTL2                                                    36230
      Z1C=ZZ1(IX1)*UPD1                                                    36240
      Z2C=ZZ2(IX2)*UPD2                                                    36250
      DX=(X2C-X1C)*COMP                                                    36260
      DY=(Y2C-Y1C)*COMP                                                    36270
      DZ=(Z2C-Z1C)*COMP                                                    36280
      DLRSQ=DX*DX+DY*DY+DZ*DZ                                              36290
      CSNUM2=(DX*GX2+DY*GY2+DZ*GZ2)*COMPP                                  36300
      IF(CSNUM2.GE.0.) GOTO 190                                            36310
      GX1=GRX(IX1)                                                         36320
      GY1=GRY(IX1)*RTL1                                                    36330
      GZ1=GRZ(IX1)*UPD1                                                    36340
      CSNUM1=(DX*GX1+DY*GY1+DZ*GZ1)*COMP                                   36350
      IF(CSNUM1.GE.0.) GOTO 190                                            36360
      DMAG=SQRT(DLRSQ)                                                     36370
      CSGM1=-CSNUM1/(DMAG*GMAG1(IX1))                                      36380
      CSGM2=-CSNUM2/(DMAG*GMAG2(IX2))                                      36390
      IF(KOMP.EQ.2) GOTO 181                                               36400
      DGAM2=1.-XBOL+XBOL*CSGM2                                             36410
      if(ld.ne.2) goto 179                                                 36420
      if(csgm2.eq.0.) goto 179                                             36430
      dgam2=dgam2-ybol*csgm2*alog(csgm2)                                   36440
      goto 147                                                             36450
  179 continue                                                             36460
      if(ld.eq.3) dgam2=dgam2-ybol*(1.-sqrt(csgm2))                        36470
  147 if(dgam2.lt.0.) dgam2=0.                                             36480
      DSUM=GRV2(IXO)*GLUMP2(IXO)*RFO(IXO)*CSGM1*CSGM2*DGAM2/DLRSQ          36490
      GOTO 182                                                             36500
  181 DGAM1=1.-XBOL+XBOL*CSGM1                                             36510
      if(ld.ne.2) goto 184                                                 36520
      if(csgm1.eq.0.) goto 184                                             36530
      dgam1=dgam1-ybol*csgm1*alog(csgm1)                                   36540
      goto 148                                                             36550
  184 continue                                                             36560
      if(ld.eq.3) dgam1=dgam1-ybol*(1.-sqrt(csgm1))                        36570
  148 if(dgam1.lt.0.) dgam1=0.                                             36580
      DSUM=GRV1(IXO)*GLUMP1(IXO)*RFO(IXO)*CSGM2*CSGM1*DGAM1/DLRSQ          36590
  182 CONTINUE                                                             36600
      SUM=SUM+DSUM*DELFIO                                                  36610
  190 CONTINUE                                                             36620
      RF(IX)=(CNST*SUM/(CMPP*GRV1(IX)+CMP*GRV2(IX)))+1.                    36630
  193 CONTINUE                                                             36640
  191 CONTINUE                                                             36650
      DO 8 I=1,N                                                           36660
      IPN1=I+N1*(KOMP-1)                                                   36670
      SINTH=SNTH(IPN1)                                                     36680
      EM=SINTH*EN*1.3                                                      36690
      MM=EM+1.                                                             36700
      XM=MM                                                                36710
      DELFI=PI/XM                                                          36720
      IP=(KOMP-1)*(N1+1)+I                                                 36730
      IY=MMSAVE(IP)                                                        36740
      DO 8 J=1,MM                                                          36750
      IS=IS+1                                                              36760
      IX=IY+J                                                              36770
      IF(FR(IX).EQ.0.) GOTO 8                                              36780
      IF(KOMP.EQ.1) GRV=GRV1(IX)                                           36790
      IF(KOMP.EQ.2) GRV=GRV2(IX)                                           36800
      TNEW=TPOLE*SQRT(SQRT(GRV*RF(IX)))                                    36810
      TLD(IS)=TNEW                                                         36820
      IF(IFAT.EQ.0) GOTO 18                                                36830
      CALL ATM(TNEW,WL,RATNEW)                                             36840
      ATRAT=RATNEW/RATPOL                                                  36850
   18 GRREFL=POLFAC*ATRAT/(EXP(XLUMP/TNEW)-1.)                             36860
   37 IF(KOMP.EQ.1) GOTO 77                                                36870
      slump2(ix)=glump2(ix)*grrefl*sbr                                     36880
      GOTO 8                                                               36890
   77 slump1(ix)=glump1(ix)*grrefl*sbr                                     36900
    8 CONTINUE                                                             36910
      RETURN                                                               36920
      END                                                                  36930
      FUNCTION ARSIN(X)                                                    36940
      ARSIN=ASIN(X)                                                        36950
      RETURN                                                               36960
      END                                                                  36970
      FUNCTION ARCOS(X)                                                    36980
      ARCOS=ACOS(X)                                                        36990
      RETURN                                                               37000
      END                                                                  37010
      FUNCTION DARSIN(X)                                                   37020
      IMPLICIT REAL*8 (A-H,O-Z)                                            37030
      DARSIN=DASIN(X)                                                      37040
      RETURN                                                               37050
      END                                                                  37060
      SUBROUTINE ROMQSP(OME,Q,F,D,EC,TH,FI,R,DRDO,DRDQ,DODQ,KOMP,MODE)     37070
c  Version of August 24, 1993.                                             37080
      PI=3.141593                                                          37090
      theq=1.570796                                                        37100
      MOD46=(MODE-5)**2                                                    37110
      MOD56=(2*MODE-11)**2                                                 37120
      modkom=mode*(komp+komp-3)                                            37130
      DQ=1.E-4*Q                                                           37140
      QP=Q+DQ                                                              37150
      TOL=5.E-6                                                            37160
C     TH, FI SHOULD BE IN RADIANS.                                         37170
      XLAM=SIN(TH)*COS(FI)                                                 37180
      XNU=COS(TH)                                                          37190
      XNUSQ=1.-XNU*XNU                                                     37200
      RMA=Q                                                                37210
      QF=1.                                                                37220
      DP=1.-EC                                                             37230
      QFM=1.                                                               37240
      IF(KOMP.NE.2) GOTO 23                                                37250
      RMA=1./Q                                                             37260
      QF=1./Q                                                              37270
      QFM=-1./Q**2                                                         37280
   23 CONTINUE                                                             37290
      CALL ELLONE(F,DP,RMA,X,OMEG,XLD,OMD)                                 37300
      OM2SAV=OMEG                                                          37310
      RMAP=QP                                                              37320
      IF(KOMP.NE.2) GOTO 92                                                37330
      OMEG=OMEG*Q+(1.-Q)*.5                                                37340
      IF(MOD56.EQ.1) OME=OMEG                                              37350
      RMAP=1./QP                                                           37360
      GOTO 93                                                              37370
   92 CONTINUE                                                             37380
      IF(MOD46.EQ.1) OME=OMEG                                              37390
   93 CONTINUE                                                             37400
      POT=OME                                                              37410
      IF(KOMP.EQ.2) POT=OME/Q+.5*(Q-1.)/Q                                  37420
      CALL ELLONE(F,DP,RMAP,XP,OMP,XLD,OMD)                                37430
      DODQ=(OMP-OM2SAV)/DQ                                                 37440
      RM1=RMA+1.                                                           37450
      DS=D*D                                                               37460
      RF=F*F                                                               37470
      R=1./POT                                                             37480
      KOUNT=0                                                              37490
      DELR=0.                                                              37500
      IF(FI.NE.0.) GOTO 85                                                 37510
      IF(TH.NE.THEQ) GOTO 85                                               37520
      IF(MODE.EQ.6) GOTO 114                                               37530
      IF(MODE.NE.4) GOTO 80                                                37540
      IF(KOMP.EQ.1) GOTO 114                                               37550
      GOTO 85                                                              37560
   80 IF(MODE.NE.5) GOTO 85                                                37570
      IF(KOMP.EQ.2) GOTO 114                                               37580
   85 CONTINUE                                                             37590
   14 R=R+DELR                                                             37600
      KOUNT=KOUNT+1                                                        37610
      IF(KOUNT.LT.20) GOTO 70                                              37620
  217 if(mode.eq.6) goto 114                                               37630
      if(modkom.eq.-4) goto 114                                            37640
      if(modkom.eq.5) goto 114                                             37650
      DOMR=-1.E15                                                          37660
      R=-1.                                                                37670
      GOTO 116                                                             37680
   70 RSQ=R*R                                                              37690
      PAR=DS-2.*XLAM*R*D+RSQ                                               37700
      RPAR=SQRT(PAR)                                                       37710
      OM=1./R+RMA*(1./RPAR-XLAM*R/DS)+RM1*.5*RSQ*XNUSQ*RF                  37720
      DOMR=1./(RF*RM1*XNUSQ*R-1./RSQ-(RMA*(R-XLAM*D))/(PAR*RPAR)-          37730
     $RMA*XLAM/DS)                                                         37740
      DELR=(POT-OM)*DOMR                                                   37750
      ABDELR=ABS(DELR)                                                     37760
      IF(ABDELR.GT.TOL) GOTO 14                                            37770
      DOMRSV=DOMR                                                          37780
      IF(R.GE.1.) GOTO 217                                                 37790
      IF(FI.NE.0.) GO TO 116                                               37800
      IF(TH.NE.THEQ)GO TO 116                                              37810
      IF(OME-OMEG) 217,114,116                                             37820
  114 DOMR=1.E15                                                           37830
      R=X                                                                  37840
      goto 118                                                             37850
  116 DRDQ=(1./RPAR-R*XLAM/DS+.5*RF*RSQ*XNUSQ)/(1./RSQ+RMA*((1.            37860
     $/(PAR*RPAR))*(R-XLAM*D)+XLAM/DS)-RF*XNUSQ*RM1*R)                     37870
      DRDQ=DRDQ*QFM                                                        37880
  118 drdo=domr*qf                                                         37890
      IF(MODE.EQ.6) GOTO 215                                               37900
      IF(MODE.NE.4) GOTO 180                                               37910
      IF(KOMP.EQ.1) GOTO 215                                               37920
      RETURN                                                               37930
  180 IF(MODE.NE.5) RETURN                                                 37940
      IF(KOMP.EQ.2) GOTO 215                                               37950
      RETURN                                                               37960
  215 IF(FI.NE.0.) GOTO 230                                                37970
      IF(TH.NE.THEQ) GOTO 230                                              37980
      DRDQ=(XP-X)/DQ                                                       37990
      RETURN                                                               38000
  230 DRDQ=DRDQ+DOMRSV*DODQ                                                38010
      RETURN                                                               38020
      END                                                                  38030
      SUBROUTINE SPOT(KOMP,N,SINTH,COSTH,SINFI,COSFI,TEMF)                 38040
C                                                                          38050
c   If a surface point is in more than one spot, this subroutine           38060
c      adopts the product of the spot temperature factors.                 38070
C                                                                          38080
c   "Latitudes" here are actually co-latitudes (running from 0 at one      38090
c      pole to 180 deg. at the other.                                      38100
C                                                                          38110
c   Version of August 23, 1993                                             38120
C                                                                          38130
      COMMON /SPOTS/ SINLAT(2,100),COSLAT(2,100),SINLNG(2,100),COSLNG      38140
     $(2,100),RAD(2,100),TEMSP(2,100),xlng(2,100)                          38150
      TEMF=1.                                                              38160
      DO 15 I=1,N                                                          38170
      COSDFI=COSFI*COSLNG(KOMP,I)+SINFI*SINLNG(KOMP,I)                     38180
      S=ARCOS(COSTH*COSLAT(KOMP,I)+SINTH*SINLAT(KOMP,I)*COSDFI)*57.29578   38190
      IF(S.GT.RAD(KOMP,I)) GOTO 15                                         38200
      TEMF=TEMF*TEMSP(KOMP,I)                                              38210
   15 CONTINUE                                                             38220
      RETURN                                                               38230
      END                                                                  38240
      SUBROUTINE OLUMP(RV,GRX,GRY,GRZ,RVQ,GRXQ,GRYQ,GRZQ,SLUMP1,SLUMP2,    38250
     $MMSAVE,GREXP,ALB,RB,WL,TPOLL,SBR,SUMM,N1,N2,KOMP,IFAT,FR,x,y,D,      38260
     $SNTH,CSTH,SNFI,CSFI,tld,glump1,glump2)                               38270
c   Version of May 19, 1993                                                38280
      DIMENSION RV(*),GRX(*),GRY(*),GRZ(*),RVQ(*),GRXQ(*),GRYQ(*),GRZQ(*   38290
     $),SLUMP1(*),SLUMP2(*),MMSAVE(*),FR(*),F(3),W(3),SNTH(*),CSTH(*),     38300
     $SNFI(*),CSFI(*),tld(*),glump1(*),glump2(*)                           38310
      common /invar/ khdum,ipbdum,irtedm,nrefdm,irv1dm,irv2dm,mrefdm,      38320
     $ifs1dm,ifs2dm,icr1dm,icr2dm,ld                                       38330
      IQ=(KOMP-1)*(N1+1)                                                   38340
      IS=(KOMP-1)*MMSAVE(IQ)                                               38350
      FP=7.957747E-2                                                       38360
      ATRAT=1.                                                             38370
      RATPOL=1.                                                            38380
      RAT=1.                                                               38390
      PI=3.141593                                                          38400
      PIH=1.570796                                                         38410
      PI32=4.712389                                                        38420
      F(1)=.1127017                                                        38430
      F(2)=.5                                                              38440
      F(3)=.8872983                                                        38450
      W(1)=.2777778                                                        38460
      W(2)=.4444444                                                        38470
      W(3)=.2777778                                                        38480
      TPOLE=10000.*TPOLL                                                   38490
      IF(IFAT.NE.0) CALL ATM(tpole,WL,RATPOL)                              38500
      CMPP=2-KOMP                                                          38510
      COMPP=2*KOMP-3                                                       38520
      COMP=-COMPP                                                          38530
      CMP=KOMP-1                                                           38540
      CMPD=CMP*D                                                           38550
      CMPPD=CMPP*D                                                         38560
      N=(2-KOMP)*N1+(KOMP-1)*N2                                            38570
      ENN=(15.+X)*(1.+GREXP)/(15.-5.*X)                                    38580
      NP=N1+1+(2-KOMP)*(N2+1)                                              38590
      NPP=N1*(KOMP-1)+(NP-1)*(2-KOMP)                                      38600
      LL=MMSAVE(NPP)+1                                                     38610
      LLL=MMSAVE(NP)                                                       38620
      LLLL=(LL+LLL)/2                                                      38630
      AR=RV(LLL)*CMP+RVQ(LLL)*CMPP                                         38640
      BR=RV(LLLL)*CMP+RVQ(LLLL)*CMPP                                       38650
      CR=RV(1)*CMP+RVQ(1)*CMPP                                             38660
      BOA=BR/AR                                                            38670
      BOAL=1.-BOA*BOA                                                      38680
      BOC2=(BR/CR)**2                                                      38690
      CC=1./(1.-.25*ENN*(1.-BOA**2)*(.9675-.3008*BOA))                     38700
      HCN=.5*CC*ENN                                                        38710
      DF=1.-X/3.                                                           38720
      if(ld.eq.2) df=df+2.*y/9.                                            38730
      if(ld.eq.3) df=df-.2*y                                               38740
      XLUMP=14384./WL                                                      38750
      POLFAC=EXP(XLUMP/TPOLE)-1.                                           38760
      IF(KOMP.EQ.1) GOTO 82                                                38770
      GRPOLE=SQRT(GRXQ(1)**2+GRYQ(1)**2+GRZQ(1)**2)                        38780
      GOTO 83                                                              38790
   82 GRPOLE=SQRT(GRX(1)**2+GRY(1)**2+GRZ(1)**2)                           38800
   83 EN=N                                                                 38810
      DO 8 I=1,N                                                           38820
      IPN1=I+N1*(KOMP-1)                                                   38830
      SINTH=SNTH(IPN1)                                                     38840
      COSTH=CSTH(IPN1)                                                     38850
      EM=SINTH*EN*1.3                                                      38860
      MM=EM+1.                                                             38870
      XM=MM                                                                38880
      DELFI=3.141593/XM                                                    38890
      IP=(KOMP-1)*(N1+1)+I                                                 38900
      IY=MMSAVE(IP)                                                        38910
      DO 8 J=1,MM                                                          38920
      IS=IS+1                                                              38930
      STCF=SINTH*CSFI(IS)                                                  38940
      STSF=SINTH*SNFI(IS)                                                  38950
      IX=IY+J                                                              38960
      IF(KOMP.EQ.1) GOTO 39                                                38970
      IF(RVQ(IX).EQ.-1.) GOTO 8                                            38980
      GX=GRXQ(IX)                                                          38990
      GY=GRYQ(IX)                                                          39000
      GZ=GRZQ(IX)                                                          39010
      R=RVQ(IX)                                                            39020
      GOTO 49                                                              39030
   39 IF(RV(IX).EQ.-1.)GOTO 8                                              39040
      GX=GRX(IX)                                                           39050
      GY=GRY(IX)                                                           39060
      GZ=GRZ(IX)                                                           39070
      R=RV(IX)                                                             39080
   49 GRMAG=SQRT(GX*GX+GY*GY+GZ*GZ)                                        39090
      ZZ=R*COSTH                                                           39100
      YY=R*COMP*STSF                                                       39110
      XX=CMPD+COMP*STCF*R                                                  39120
      XXREF=(CMPPD+COMPP*XX)*COMPP                                         39130
      GRAV=(GRMAG/GRPOLE)**GREXP                                           39140
      TLOCAL=TPOLE*SQRT(SQRT(GRAV))                                        39150
      DIST=SQRT(XXREF*XXREF+YY*YY+ZZ*ZZ)                                   39160
      RMX=ARSIN(.5*(BR+CR)/DIST)                                           39170
      XCOS=XXREF/DIST                                                      39180
      YCOS=YY/DIST                                                         39190
      ZCOS=ZZ/DIST                                                         39200
      COSINE=(XCOS*GX+YCOS*GY+ZCOS*GZ)/GRMAG                               39210
      RC=PIH-ARCOS(COSINE)                                                 39220
      AH=RC/RMX                                                            39230
      RP=ABS(AH)                                                           39240
      IF(AH.LE..99999) GOTO 22                                             39250
      P=1.                                                                 39260
      GOTO 16                                                              39270
   22 IF(AH.GE.-.99999) GOTO 24                                            39280
      ALBEP=0.                                                             39290
      GOTO 19                                                              39300
   24 SUM=0.                                                               39310
      FIST=ARSIN(RP)                                                       39320
      FII=PIH-FIST                                                         39330
      DO 15 IT=1,3                                                         39340
      FE=FII*F(IT)+FIST                                                    39350
      PAR=1.-(RP/SIN(FE))**2                                               39360
      RPAR=SQRT(PAR)                                                       39370
      SUM=PAR*RPAR*W(IT)+SUM                                               39380
   15 CONTINUE                                                             39390
      FTRI=(1.-X)*RP*SQRT(1.-RP**2)+.6666667*X*FII-.6666667*X*SUM*FII      39400
      FSEC=(PIH+FIST)*DF                                                   39410
      P=(FTRI+FSEC)/(PI*DF)                                                39420
      IF(COSINE.LT.0.) P=1.-P                                              39430
      RTF=SQRT(1.-AH**2)                                                   39440
      DENO=PI32-3.*(AH*RTF+ARSIN(AH))                                      39450
      IF(DENO.NE.0.) GOTO 117                                              39460
      ABAR=1.                                                              39470
      GOTO 116                                                             39480
  117 ABAR=2.*RTF**3/DENO                                                  39490
  116 COSINE=COS(PIH-RMX*ABAR)                                             39500
   16 COSQ=1./(1.+(YY/XXREF)**2)                                           39510
      COT2=(ZZ/XXREF)**2                                                   39520
      Z=BOAL/(1.+BOC2*COT2)                                                39530
      E=CC-HCN*COSQ*Z                                                      39540
      ALBEP=ALB*E*P                                                        39550
   19 IF(COSINE.LE.0.) ALBEP=0.                                            39560
      TNEW=TLOCAL*SQRT(SQRT(1.+(FP*SUMM/(DIST*DIST*GRAV))*COSINE*RB*       39570
     $ALBEP))                                                              39580
      TLD(IS)=TNEW                                                         39590
      IF(IFAT.EQ.0) GOTO 18                                                39600
      CALL ATM(TNEW,WL,RATNEW)                                             39610
      ATRAT=RATNEW/RATPOL                                                  39620
   18 GRREFL=POLFAC*ATRAT/(EXP(XLUMP/TNEW)-1.)                             39630
   37 IF(KOMP.EQ.1) GOTO 77                                                39640
      slump2(ix)=glump2(ix)*grrefl*sbr                                     39650
      GOTO 8                                                               39660
   77 slump1(ix)=glump1(ix)*grrefl*sbr                                     39670
    8 CONTINUE                                                             39680
      RETURN                                                               39690
      END                                                                  39700
      SUBROUTINE BOLO (RATLUM,T1,T2,WL,IFAT1,IFAT2,RATBOL)                 39710
C     VERSION OF 3/29/77. DESTROY EARLIER VERSIONS.                        39720
C     BOLO USES HARRIS CALIBRATION FROM T=3970 TO 5800, MORTON-ADAMS       39730
C     FROM T=5800 TO 37500, AND BLACK BODY LAWS BELOW 3970 AND ABOVE       39740
C     37500.                                                               39750
      VT1=1.                                                               39760
      VT2=1.                                                               39770
      WLT1=1.                                                              39780
      WLT2=1.                                                              39790
      TP1=10000.*T1                                                        39800
      TP2=10000.*T2                                                        39810
      IF(IFAT1.EQ.0) GOTO 95                                               39820
      CALL ATM(TP1,.5500,VT1)                                              39830
      CALL ATM(TP1,WL,WLT1)                                                39840
   95 IF(IFAT2.EQ.0) GOTO 90                                               39850
      CALL ATM(TP2,.5500,VT2)                                              39860
      CALL ATM(TP2,WL,WLT2)                                                39870
   90 RAT12=VT1*WLT2/(VT2*WLT1)                                            39880
      RATV=RAT12*RATLUM*(EXP(1.4384/(WL*T1))-1.)*(EXP(1.4384/(.5500*T2))   39890
     $-1.)/((EXP(1.4384/(.5500*T1))-1.)*(EXP(1.4384/(WL*T2))-1.))          39900
      DELMV=1.0857362*ALOG(RATV)                                           39910
      X1=ALOG10(T1)+.14                                                    39920
      X2=ALOG10(T2)+.14                                                    39930
      IF(T1.GT.3.75) GOTO 22                                               39940
      IF(T1.LT..397) GOTO 22                                               39950
      IF(T1.GT.1.07) GOTO 18                                               39960
      BC1=.0004964+X1*(.184549+X1*(-7.25068+X1*(-26.4889+X1*(-198.069+X1   39970
     $*(-73.801+652.95*X1)))))                                             39980
      GOTO 19                                                              39990
   18 BC1=.868864+X1*(-14.8735+X1*(70.1318+X1*(-227.706+X1*(386.7+X1*(     40000
     $-339.447+121.8*X1)))))                                               40010
      GOTO 19                                                              40020
   22 BC1=-2.5*ALOG10((T1/.6700)**4*(EXP(1.4384/(.5450*T1))-1.)/(EXP(      40030
     $1.4384/.36515)-1.))                                                  40040
   19 IF(T2.GT.3.75) GOTO 32                                               40050
      IF(T2.LT..397) GOTO 32                                               40060
      IF(T2.GT.1.07) GOTO 28                                               40070
      BC2=.0004964+X2*(.184549+X2*(-7.25068+X2*(-26.4889+X2*(-198.069+X2   40080
     $*(-73.801+652.95*X2)))))                                             40090
      GOTO 29                                                              40100
   28 BC2=.868864+X2*(-14.8735+X2*(70.1318+X2*(-227.706+X2*(386.7+X2*(     40110
     $-339.447+121.8*X2)))))                                               40120
      GOTO 29                                                              40130
   32 BC2=-2.5*ALOG10((T2/.6700)**4*(EXP(1.4384/(.5450*T2))-1.)/(EXP(      40140
     $1.4384/.36515)-1.))                                                  40150
   29 DELMB=DELMV+BC2-BC1                                                  40160
      RATBOL=10.**(.4*DELMB)                                               40170
      RETURN                                                               40180
      END                                                                  40190
      subroutine mlrg(a,p,q,r1,r2,t1,t2,sm1,sm2,sr1,sr2,bolm1,             40200
     $bolm2,xlg1,xlg2)                                                     40210
c  This subroutine computes absolute dimensions and other quantities       40220
c  for the stars of a binary star system.                                  40230
c  a = orbital semi-major axis, the sum of the two a's for the two         40240
c  stars. The unit is a solar radius.                                      40250
c  r1,r2 = relative mean (equivalent sphere) radii for stars 1 and 2. Th   40260
c  unit is the orbital semimajor axis.                                     40270
c  p = orbit period in days.                                               40280
c  q = mass ratio, m2/m1.                                                  40290
c  t1,t2= flux-weighted mean surface temperatures for stars 1 and 2,in K   40300
c  sm1,sm2= masses of stars 1 and 2 in solar units.                        40310
c  sr1,sr2= mean radii of stars 1 and 2 in solar units.                    40320
c  bolm1, bolm2= absolute bolometric magnitudes of stars 1, 2.             40330
c  xlg1, xlg2= log (base 10) of mean surface acceleration (effective gra   40340
c  for stars 1 and 2.                                                      40350
c                                                                          40360
      G=6.668e-8                                                           40370
      tsun=5800.                                                           40380
      rsunau=214.8                                                         40390
      sunmas=1.991e33                                                      40400
      sunrad=6.960e10                                                      40410
      gmr=G*sunmas/sunrad**2                                               40420
      sunmb=4.77                                                           40430
      sr1=r1*a                                                             40440
      sr2=r2*a                                                             40450
      yrsid=365.2564                                                       40460
      tmass=(a/rsunau)**3/(p/yrsid)**2                                     40470
      sm1=tmass/(1.+q)                                                     40480
      sm2=tmass*q/(1.+q)                                                   40490
      bol1=(t1/tsun)**4*sr1**2                                             40500
      bol2=(t2/tsun)**4*sr2**2                                             40510
      bolm1=sunmb-2.5*alog10(bol1)                                         40520
      bolm2=sunmb-2.5*alog10(bol2)                                         40530
      xlg1=alog10(gmr*sm1/sr1**2)                                          40540
      xlg2=alog10(gmr*sm2/sr2**2)                                          40550
      return                                                               40560
      end                                                                  40570
