# -*- coding: utf-8 -*-
"""
This file is part of the Matisse pipeline GUI series
Copyright (C) 2017- Observatoire de la Côte d'Azur

Created on Tue Nov 19 13:50:34 2019
@author: ame

MATISSE BCD treatment tools

This software is a computer program whose purpose is to show oifits
files from the MATISSE instrument.

This software is governed by the CeCILL license under French law and
abiding by the rules of distribution of free software.

You can use, modify and/ or redistribute the software under the
terms of the CeCILL license as circulated by CEA, CNRS and INRIA at
the following URL "http://www.cecill.info". You have a copy of the
licence in the LICENCE.md file.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

Modified by C.A. Hummel for use in OYSTER
"""
#!/usr/local/miniconda2/bin/python

import sys
import getopt
from astropy.io import fits
import numpy as np
import os

BCD=[[0,1,2,3,4,5],  #OUT-OUT (0)
     [0,1,4,5,2,3],  #OUT-IN  (1)
     [0,1,3,2,5,4],  #IN-OUT  (2)
     [0,1,5,4,3,2]]  #IN-IN  (3)

BCDsign=[[1,1,1,1,1,1],   #OUT-OUT (0)
         [1,-1,1,1,1,1],  #OUT-IN  (1)
         [-1,1,1,1,1,1], #IN-OUT  (2) => Pourquoi?
         [-1,-1,1,1,1,1]] #IN-IN  (3)

BCDcp=[[0, 1, 2, 3], #OUT-OUT (0)
       [3, 1, 2, 0], #OUT-IN  (1)
       [0, 2, 1, 3], #IN-OUT  (2)
       [3, 2, 1, 0]] #IN-IN  (3)


sta_index_cp=[[1,2,3],
           [0,1,2],
           [0,1,3],
           [0,2,3]]

uv1=[2,1,1,4]
uv2=[0,2,3,0]

BCDcpsign=[[ 1,  1,  1,  1], #OUT-OUT (0)
           [1,  -1,  -1, 1], #OUT-IN  (1)
           [ -1, 1, 1,  -1], #IN-OUT  (2)
           [-1, -1, -1, -1]] #IN-IN  (3)

BCDfluxL=[[0,1,3,2],
          [0,1,2,3],
          [1,0,3,2],
          [1,0,2,3]]

BCDfluxN=[[3,2,0,1],
          [3,2,1,0],
          [2,3,0,1],
          [2,3,1,0]]

####################### removing BCD in an oifits files ########################

def main(argv):

    inputfile=''

    try:
        opts, args=getopt.getopt(argv,"hi:o:",["file="])
    except getopt.GetOptError:
        print 'mat_removeBCD.py -i <inputfile>' 
        sys.exit(2)
    for opt, arg in opts:
        if opt == '-h':
            print 'mat_removeBCD.py -i <input file>' 
            sys.exit()
        elif opt in ("-i", "--ifile"):
            inputfile = arg

    data=fits.open(inputfile)

    bcd1=data[0].header["ESO INS BCD1 NAME"]
    bcd2=data[0].header["ESO INS BCD2 NAME"]
    bcd=(bcd2 == "IN") + 2*(bcd1 == "IN")
    if bcd==0:
        return

    extnames=[hdu.name for hdu in data]

    #------------------OI_VIS2-------------------------
    if "OI_VIS2" in extnames:

        temp=data["OI_VIS2"].copy()

        nB=len(temp.data)
        for iB in range(nB):
            iB2=iB % 6
            shift0 = (iB / 6)*6
            temp.data[iB2+shift0]=data["OI_VIS2"].data[BCD[bcd][iB2]+shift0]
            temp.data[iB2+shift0]["UCOORD"]*=BCDsign[bcd][iB2]
            temp.data[iB2+shift0]["VCOORD"]*=BCDsign[bcd][iB2]
            if BCDsign[bcd][iB2]==-1:
                temp.data[iB2+shift0]["STA_INDEX"]=np.flip(temp.data[iB2+shift0]["STA_INDEX"],axis=0)

        data["OI_VIS2"]=temp
    #------------------OI_VIS--------------------------
    if "OI_VIS" in extnames:

        temp=data["OI_VIS"].copy()

        nB=len(temp.data)
        for iB in range(nB):
            iB2=iB % 6
            shift0 = (iB / 6)*6
            temp.data[iB2+shift0]=data["OI_VIS"].data[BCD[bcd][iB2]+shift0]
            temp.data[iB2+shift0]["VISPHI"]*=BCDsign[bcd][iB2]
            temp.data[iB2+shift0]["UCOORD"]*=BCDsign[bcd][iB2]
            temp.data[iB2+shift0]["VCOORD"]*=BCDsign[bcd][iB2]
            if BCDsign[bcd][iB2]==-1:
                temp.data[iB2+shift0]["STA_INDEX"]=np.flip(temp.data[iB2+shift0]["STA_INDEX"],axis=0)

        data["OI_VIS"]=temp

    #------------------OI_T3---------------------------
    if "OI_T3" in extnames:
        sta_index=data["OI_ARRAY"].data["STA_INDEX"]
        temp=data["OI_T3"].copy()

        nB=len(temp.data)
        for iB in range(nB):
            iB2=iB % 4
            shift0 = (iB / 4)*4
            data["OI_T3"].data[BCDcp[bcd][iB2]+shift0]["T3PHI"]*=BCDcpsign[bcd][iB2]
            temp.data[iB2+shift0]=data["OI_T3"].data[BCDcp[bcd][iB2]+shift0]
            temp.data[iB2+shift0]["U1COORD"]=data["OI_VIS2"].data["UCOORD"][uv1[iB2]]
            temp.data[iB2+shift0]["V1COORD"]=data["OI_VIS2"].data["VCOORD"][uv1[iB2]]
            temp.data[iB2+shift0]["U2COORD"]=data["OI_VIS2"].data["UCOORD"][uv2[iB2]]
            temp.data[iB2+shift0]["V2COORD"]=data["OI_VIS2"].data["VCOORD"][uv2[iB2]]
            temp.data[iB2+shift0]["STA_INDEX"]=np.array([sta_index[sta_index_cp[iB2][i]] for i in range(3)])

        data["OI_T3"]=temp

    #------------------OI_FLUX-------------------------
    if "OI_FLUX" in extnames:
        if data[0].header["ESO DET CHIP NAME"]=="HAWAII-2RG":
            BCDflux=BCDfluxL
        else:
            BCDflux=BCDfluxN

        temp=data["OI_FLUX"].copy()

        nB=len(temp.data)
        for iB in range(nB):
            iB2=iB % 4
            shift0 = (iB / 4)*4
            temp.data[iB2+shift0]=data["OI_FLUX"].data[BCDflux[bcd][iB2]+shift0]

        data["OI_FLUX"]=temp


    #------------------TF2-------------------------
    if "TF2" in extnames:

        temp=data["TF2"].copy()

        nB=len(temp.data)
        for iB in range(nB):
            iB2=iB % 6
            shift0 = (iB / 6)*6
            temp.data[iB2+shift0]=data["TF2"].data[BCD[bcd][iB2]+shift0]
            if BCDsign[bcd][iB2]==-1:
                temp.data[iB2+shift0]["STA_INDEX"]=np.flip(temp.data[iB2+shift0]["STA_INDEX"],axis=0)

        data["TF2"]=temp

    #------------------END------------------------

    data[0].header["ESO INS BCD1 NAME"]="OUT"
    data[0].header["ESO INS BCD2 NAME"]="OUT"

    data.writeto(data.filename(),overwrite=True)

if __name__ == "__main__":
    main(sys.argv[1:])

#=============================================================================
