/* This take the Hour Angle of the observation, the Declination of the
 * star and the baselines as projected on the (X,Y,Z) plane and projects
 * them on the star (still in meters).
 */

#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "roche.h"

int GetUVW(Observatory * O, Roche * R, float HA) {

  int i, j, k;
  float afRotate[3][3], cHA, sHA, cDec, sDec;
  char sU[5], sTh[5];

  //printf("\nRA=%8.3f HA=%6.3f Dec=%7.3f\n",R->fRA,HA,R->fDec);
  cHA = cos((float)RADDEG*15.*HA); // HA in decimal hours
  sHA = sin((float)RADDEG*15.*HA);
  cDec = cos((float)RADDEG*R->fDec);
  sDec = sin((float)RADDEG*R->fDec);
  /*
  printf("cosHA=%8.5f sinHA=%8.5f cosDec=%8.5f sinDec=%8.5f\n",cHA,sHA,
	 cDec,sDec);
  */

  afRotate[0][0] = sHA;
  afRotate[0][1] = cHA;
  afRotate[0][2] = 0.;
  afRotate[1][0] = -sDec*cHA;
  afRotate[1][1] = sDec*sHA;
  afRotate[1][2] = cDec;
  afRotate[2][0] = cDec*cHA;
  afRotate[2][1] = -cDec*sHA;
  afRotate[2][2] = sDec;
  /*
  for (i=0; i<3; i++) {
    printf("afR[%i][0]=%8.5f afR[%i][1]=%8.5f afR[%i][2]=%8.5f\n",i,
	   afRotate[i][0],i,afRotate[i][1],i,afRotate[i][2]);
  }
  */

  for (i=0; i<O->iBaselines; i++) {

    /* UVW and |UVW|*/
    O->fUTheta[i][0] = 0.;
    for (j=0; j<3; j++) {
      O->fUVW[i][j] = 0.;
      for (k=0; k<3; k++) {
	O->fUVW[i][j] += afRotate[j][k]*O->fXYZ[i][k];
      }
      /* Only want the UV components in the projected baseline length */
      if (j < 2) O->fUTheta[i][0] += O->fUVW[i][j]*O->fUVW[i][j];
    }
    O->fUTheta[i][0] =   sqrt(O->fUTheta[i][0]);

    /* p.a. (Position Angle, N->E) */
    O->fUTheta[i][1] = PI2 - atan2(O->fUVW[i][1],O->fUVW[i][0]); // atan2(y,x)

    /*
    printf("i=%i |U|=%4.3g Th=%2.0f\n",i,O->fUTheta[i][0],
	   (float)DEGRAD*O->fUTheta[i][1]);
    */
  }
  //printf("\n");

  /* Augment sBaselinesNames.  Do for both directions. */
  for (i=0; i<O->iBaselines; i++) {
    for (k=0; k<2; k++) {
      sprintf(sU,"%4.3g",O->fUTheta[i][0]);
      sprintf(sTh,"%2.0f",DEGRAD*O->fUTheta[i][1]);
      strcpy(O->sUThNames[i][k],O->sBaselineNames[i][k]);
      strcat(O->sUThNames[i][k]," U=");
      strcat(O->sUThNames[i][k],sU);
      strcat(O->sUThNames[i][k]," \\gh=");
      //strcat(O->sUThNames[i][k],"m \\gh=");
      strcat(O->sUThNames[i][k],sTh);
      strcat(O->sUThNames[i][k],"\\u\\go\\d");
    }
  }

  return EXIT_SUCCESS;
}
