/***********************************************************************
 Volume: Calculates the Volume of a Roche Spheroid.  As a bonus you get 
 the equatorial projected Area.

 Assumes R(theta) is already pretabulated.
************************************************************************/
#include <stddef.h>
#include <stdlib.h>
#include <math.h>

#include "rochechi2.h"

int Volume (Roche * R) {

  float V = 0., A = 0.;
  float w, w2, s2, c2, r, r2, fDelB;
  float afLat[100], affR[100];
  int iNb, i;
  iNb = 91; // Number of latitude bands
  fDelB = 90./iNb; // Latitude increments in degrees
  w = R->fwOmega;
  w2 = w*w;

  /* Initialize Latitude Band boundaries and radii */
  for (i=0; i < iNb; i++){
    afLat[i] = i * (float)RADDEG; // convert degrees to radians
    s2 = sin(afLat[i]);
    s2 *= s2; // sin^2(theta))
    c2 = cos(afLat[i]);
    c2 *= c2; // cos^2(theta))
    r = FractRadius(w*w, s2);
    r2 = r*r;
    affR[i] = r;
  }

  for (i=1; i<iNb; i++){
    A += affR[i-1]*affR[i]*(afLat[i]-afLat[i-1]);
    V += (affR[i-1]*cos(afLat[i-1]) + affR[i]*cos(afLat[i]))
      *(affR[i-1]*cos(afLat[i-1]) + affR[i]*cos(afLat[i]))
      *(affR[i]*sin(afLat[i]) - affR[i-1]*sin(afLat[i-1]));
  }
  /* Assume Latitude angles cover only first quadrant. */
  R->feqArea = 2.*A*R->fRpB*R->fRpB; 
  R->fVol=PI*V/2.*R->fRpB*R->fRpB*R->fRpB;
  return (EXIT_SUCCESS);
}
