; GUI frontend to VINCI analysis
;  The communication of the current Obsfile is by a pointer attached
;  as the user value of the message window.
;  Extensive use is made of the user value to store and pass information.

PRO VINCI_gui_event, ev
;********************************************************************
;#procedure#
; VINCI_gui_event
;#call#
; VINCI_gui_event, ev
;#description#
; Handle events for VINCI GUI
;#inputs#
;\anArg{ ev }{ event }{ event to be processed }
;#end_procedure#
;********************************************************************
WIDGET_CONTROL, ev.id, GET_UVALUE=info
label = info.label
;print,"event handler ",label
CASE label OF
  'ignore': 
  'DONE': WIDGET_CONTROL, ev.top, /DESTROY
  'SELECT_OUT' : begin
    WIDGET_CONTROL, info.message, GET_UVALUE=ObsFile
    ; suggest name
    inname= (*ObsFile).infile
    last = strpos(inname, '.', /REVERSE_SEARCH)
    base = strmid(inname,0,last+1)
    WIDGET_CONTROL, info.output, $
      SET_VALUE=dialog_pickfile(file=Base+info.type,/WRITE)
    end
  'SELECT_IN'  :  WIDGET_CONTROL, info.input, $
      SET_VALUE=dialog_pickfile(/MUST_EXIST,/READ)
  'Read' : begin
      WIDGET_CONTROL, info.input,GET_VALUE=filename
      if (STRLEN(filename[0]) GT 0) then begin
        WIDGET_CONTROL, info.message, SET_VALUE="I'm working on it"
        ObsFile = vinci_of_read(filename[0])
        WIDGET_CONTROL, info.message, SET_VALUE="read "+filename
        x=size(ObsFile) ; extremely obscure usage, test if structure
        if (x[2] NE 8) then begin
          WIDGET_CONTROL, info.message, SET_VALUE="Could not read "+filename[0]
          return
        endif
        WIDGET_CONTROL, info.message, SET_UVALUE=PTR_NEW(ObsFile)
        ; update index
        WIDGET_CONTROL, info.index, SET_VALUE=vinci_index(ObsFile)
        ; update source lists
        VINCI_gui_sourcelist, info.plotScan, Obsfile
        VINCI_gui_sourcelist, info.plotBatch, Obsfile
        endif else begin
          WIDGET_CONTROL, info.message, SET_VALUE="No file selected"
        endelse
       end
  'Write' : begin
      WIDGET_CONTROL, info.output,GET_VALUE=filename
      if (STRLEN(filename[0]) GT 0) then begin
        WIDGET_CONTROL, info.message, GET_UVALUE=ObsFile
        if (N_ELEMENTS(ObsFile) GT 0) then begin
          WIDGET_CONTROL, info.message, SET_VALUE="I'm working on it"
          vinci_OF_write,filename[0],*Obsfile
	  WIDGET_CONTROL, info.message, SET_VALUE="write "+filename
        endif else begin
          WIDGET_CONTROL, info.message, SET_VALUE="No active data"
        endelse
      endif else begin
        WIDGET_CONTROL, info.message, SET_VALUE="No file selected"
      endelse
      end
  'Report' : begin
      WIDGET_CONTROL, info.output,GET_VALUE=filename
      if (STRLEN(filename[0]) GT 0) then begin
        WIDGET_CONTROL, info.message, GET_UVALUE=ObsFile
        if (N_ELEMENTS(ObsFile) GT 0) then begin
          WIDGET_CONTROL, info.message, SET_VALUE="I'm working on it"
          vinci_report,filename[0],*Obsfile
          WIDGET_CONTROL, info.message, SET_VALUE="write report "+filename
         endif else begin
           WIDGET_CONTROL, info.message, SET_VALUE="No active data"
         endelse
      endif else begin
        WIDGET_CONTROL, info.message, SET_VALUE="No file selected"
      endelse
      end
  'EditScans' : begin
      WIDGET_CONTROL, info.message, GET_UVALUE=ObsFile
      if (N_ELEMENTS(ObsFile) GT 0) then begin
        WIDGET_CONTROL, info.minWt, GET_VALUE=minWt
        WIDGET_CONTROL, info.minSNRP, GET_VALUE=minSNRP
        WIDGET_CONTROL, info.maxVel, GET_VALUE=maxOPDvel
        WIDGET_CONTROL, info.maxMom2, GET_VALUE=maxMom2
	WIDGET_CONTROL, info.sigEdit, GET_VALUE=sigEdit
        WIDGET_CONTROL, info.message, SET_VALUE="I'm working on it"
        vinci_of_process_batch,*Obsfile, /clear, $
      minWt=minWt, minSNRP=minSNRP, maxOPDvel=maxOPDvel, maxMom2=maxMom2, sigedit=sigedit
        WIDGET_CONTROL, info.message, $
          SET_VALUE="Edit Scans, minWt="+string(minWt)+$
          ", minSNRP="+string(minSNRP)+$
          ", maxOPDvel="+string(maxOPDVel)+$
          ", maxMom2="+string(maxMom2)+$
          ", sigEdit="+string(sigEdit)
        endif else begin
          WIDGET_CONTROL, info.message, SET_VALUE="No active data"
        endelse
      end
  'BatchEdit' : begin
      WIDGET_CONTROL, info.message, GET_UVALUE=ObsFile
      if (N_ELEMENTS(ObsFile) GT 0) then begin
        WIDGET_CONTROL, info.maxChi2, GET_VALUE=maxChi2
        WIDGET_CONTROL, info.minSNR, GET_VALUE=minSNR
        WIDGET_CONTROL, info.maxOPDvsd, GET_VALUE=maxOPDvsd
        WIDGET_CONTROL, info.minScan, GET_VALUE=minScan
        WIDGET_CONTROL, info.message, SET_VALUE="I'm working on it"
        vinci_of_edit,*Obsfile, /clear, $
          maxChi2=maxChi2, minSNR=minSNR, $
          maxOPDvsd=maxOPDvsd, minScan=minScan
        WIDGET_CONTROL, info.message, $
          SET_VALUE="Edit Batches, maxChi2="+string(maxChi2)+$
          ", minSNR="+string(minSNR)+$
          ", maxOPDvsd="+string(maxOPDvsd)+$
          ", minScan="+string(minScan)
        ; update index
        WIDGET_CONTROL, info.index, SET_VALUE=vinci_index(*ObsFile)
        endif else begin
          WIDGET_CONTROL, info.message, SET_VALUE="No active data"
        endelse
      end
  'RmBatch' : begin
      WIDGET_CONTROL, info.message, GET_UVALUE=ObsFile
      if (N_ELEMENTS(ObsFile) GT 0) then begin
        WIDGET_CONTROL, info.batch, GET_VALUE=batch
        WIDGET_CONTROL, info.message, SET_VALUE="I'm working on it"
        vinci_OF_flag_batch, batch, *ObsFile
        WIDGET_CONTROL, info.message, $
          SET_VALUE="Flag Batch "+string(batch)
        ; update index
        WIDGET_CONTROL, info.index, SET_VALUE=vinci_index(*ObsFile)
      endif else begin
        WIDGET_CONTROL, info.message, SET_VALUE="No active data"
      endelse
      end
  'RmScans' : begin
      WIDGET_CONTROL, info.message, GET_UVALUE=ObsFile
      if (N_ELEMENTS(ObsFile) GT 0) then begin
        WIDGET_CONTROL, info.batch, GET_VALUE=batch
        WIDGET_CONTROL, info.first, GET_VALUE=first
        WIDGET_CONTROL, info.last, GET_VALUE=last
        WIDGET_CONTROL, info.message, SET_VALUE="I'm working on it"
        vinci_OF_edit_scans, *ObsFile, batch, first, last
        WIDGET_CONTROL, info.message, $
          SET_VALUE="Flag scans "+string(first)+" to "+string(last)+ $
            " in Batch "+string(batch)
        endif else begin
          WIDGET_CONTROL, info.message, SET_VALUE="No active data"
        endelse
      end
  'ClrBatch' : begin
      WIDGET_CONTROL, info.message, GET_UVALUE=ObsFile
      if (N_ELEMENTS(ObsFile) GT 0) then begin
        WIDGET_CONTROL, info.batch, GET_VALUE=batch
        WIDGET_CONTROL, info.message, SET_VALUE="I'm working on it"
        vinci_OF_flag_batch, batch, *ObsFile, /clear
        WIDGET_CONTROL, info.message, $
          SET_VALUE="Clear flag on batch "+string(batch)
        ; update index
        WIDGET_CONTROL, info.index, SET_VALUE=vinci_index(*ObsFile)
      endif else begin
        WIDGET_CONTROL, info.message, SET_VALUE="No active data"
      endelse
      end
  'ClrScans' : begin
      WIDGET_CONTROL, info.message, GET_UVALUE=ObsFile
      if (N_ELEMENTS(ObsFile) GT 0) then begin
        WIDGET_CONTROL, info.batch, GET_VALUE=batch
        WIDGET_CONTROL, info.first, GET_VALUE=first
        WIDGET_CONTROL, info.last, GET_VALUE=last
        WIDGET_CONTROL, info.message, SET_VALUE="I'm working on it"
        vinci_OF_process_batch, *ObsFile, /clear
        WIDGET_CONTROL, info.message, $
          SET_VALUE="Clear all scan flags"
        endif else begin
            WIDGET_CONTROL, info.message, SET_VALUE="No active data"
        endelse
      end
  'RunFV' : begin
      WIDGET_CONTROL, info.message, GET_UVALUE=ObsFile
      if (N_ELEMENTS(ObsFile) GT 0) then begin
          WIDGET_CONTROL, info.message, SET_VALUE="Starting fv on file"
          spawn,"fv -cmap 2 "+(*ObsFile).infile+" &"
          WIDGET_CONTROL, info.message, SET_VALUE="Done"
        endif else begin
          ; just start fv
          WIDGET_CONTROL, info.message, SET_VALUE="Starting fv"
          spawn,"fv -cmap 2 &"
          WIDGET_CONTROL, info.message, SET_VALUE="Done"
        endelse
      end
  'ApplyCal' : begin
      WIDGET_CONTROL, info.message, GET_UVALUE=ObsFile
      if (N_ELEMENTS(ObsFile) GT 0) then begin
        WIDGET_CONTROL, info.message, SET_VALUE="I'm working on it"
        vinci_OF_apply_cal,*ObsFile
        WIDGET_CONTROL, info.message, $
          SET_VALUE="Apply calibration to targets"
        endif else begin
          WIDGET_CONTROL, info.message, SET_VALUE="No active data"
        endelse
      end
  'ExtractCal' : begin
      WIDGET_CONTROL, info.message, GET_UVALUE=ObsFile
      if (N_ELEMENTS(ObsFile) GT 0) then begin
        WIDGET_CONTROL, info.message, SET_VALUE="I'm working on it"
        vinci_OF_extract_cals,*ObsFile
        WIDGET_CONTROL, info.message, $
          SET_VALUE="Extracted calibrators to another file"
        endif else begin
          WIDGET_CONTROL, info.message, SET_VALUE="No active data"
        endelse
      end
  'RawDataDirectory' : begin
      WIDGET_CONTROL, info.message, GET_UVALUE=ObsFile
      if (N_ELEMENTS(ObsFile) GT 0) then begin
        (*ObsFile).rawdata = dialog_pickfile(file=(*ObsFile).rawdata,$
          title="Pick raw data directory",/DIRECTORY)
        WIDGET_CONTROL, info.message, $
          SET_VALUE="Raw data directory is now "+(*ObsFile).rawdata
        endif else begin
          WIDGET_CONTROL, info.message, SET_VALUE="No active data"
        endelse
      end
  'BatchSourceList' : begin
      *info.value = (*info.list)[ev[0].index]
      end
  'BatchValuesList' : begin
      *info.value = (*info.list)[ev[0].index]
      end
  'BPOpt1' : begin
      *info.value = (*info.list)[ev[0].index]
      end
  'BPOpt2' : begin
      *info.value = (*info.list)[ev[0].index]
      end
  'BatchPlot' : begin
      WIDGET_CONTROL, info.message, GET_UVALUE=ObsFile
      if (N_ELEMENTS(ObsFile) GT 0) then begin
        WIDGET_CONTROL, info.values, GET_UVALUE=values
        WIDGET_CONTROL, info.opt1, GET_UVALUE=opt1
        WIDGET_CONTROL, info.opt2, GET_UVALUE=opt2
        WIDGET_CONTROL, info.source, GET_UVALUE=source
;       WIDGET_CONTROL, info.message, $
;        SET_VALUE="Batch plot of "+string(values)
; print," plot value",*values.value
        com = "vinci_Plot_Batch, *ObsFile"+', source="'+*source.value+$
           '", '+*values.value+*opt1.value+*opt2.value
;print,com
        r=EXECUTE(com)
;print,r
        endif else begin
          WIDGET_CONTROL, info.message, SET_VALUE="No active data"
        endelse
      end
  'ScanSourceList' : begin
      *info.value = (*info.list)[ev[0].index]
      end
  'ScanValuesList' : begin
      *info.value = (*info.list)[ev[0].index]
      end
  'SPOpt1' : begin
      *info.value = (*info.list)[ev[0].index]
      end
  'SPOpt2' : begin
      *info.value = (*info.list)[ev[0].index]
      end
  'ScanPlot' : begin
      WIDGET_CONTROL, info.message, GET_UVALUE=ObsFile
      if (N_ELEMENTS(ObsFile) GT 0) then begin
        WIDGET_CONTROL, info.values, GET_UVALUE=values
        WIDGET_CONTROL, info.opt1, GET_UVALUE=opt1
        WIDGET_CONTROL, info.opt2, GET_UVALUE=opt2
;      WIDGET_CONTROL, info.batch, GET_VALUE=batch
        WIDGET_CONTROL, info.source, GET_UVALUE=source

;      WIDGET_CONTROL, info.message, $
;        SET_VALUE="Batch plot of "+string(values)
; print," plot value ",*values.value
; print," batch list ",batch
        com = "vinci_Plot_Scans, *ObsFile, -1"+', source="'+$
            *source.value+'",'+*values.value+*opt1.value+*opt2.value
;print,com
        r=EXECUTE(com[0])
;print,r
        endif else begin
          WIDGET_CONTROL, info.message, SET_VALUE="No active data"
        endelse
      end
  'FallPlot' : begin
      WIDGET_CONTROL, info.batch, GET_VALUE=batch
      WIDGET_CONTROL, info.message, GET_UVALUE=ObsFile
      if (N_ELEMENTS(ObsFile) GT 0) then begin
        WIDGET_CONTROL, info.message, SET_VALUE="Starting external programs"
        vinci_view_raw, batch, *ObsFile
        WIDGET_CONTROL, info.message, SET_VALUE="Done"
      endif else begin
        WIDGET_CONTROL, info.message, SET_VALUE="No active data"
      endelse
      end
  'PowerPlot' : begin
      WIDGET_CONTROL, info.batch, GET_VALUE=batch
      WIDGET_CONTROL, info.message, GET_UVALUE=ObsFile
      if (N_ELEMENTS(ObsFile) GT 0) then begin
        WIDGET_CONTROL, info.message, SET_VALUE="Starting external programs"
        vinci_view_power, batch, *ObsFile
        WIDGET_CONTROL, info.message, SET_VALUE="Done"
      endif else begin
        WIDGET_CONTROL, info.message, SET_VALUE="No active data"
      endelse
      end
ENDCASE
END

FUNCTION cw_vinci_filebrowser, parent, uvalue=uvalue, title=title, $
     rwtitle=rwtitle
;********************************************************************
;#function#
; cw_vinci_filebrowser
;#call#
; cw_vinci_filebrowser(parent, uvalue=uvalue, title=title, $
;     rwtitle=rwtitle)
;#description#
; Create Widget with controls to select and read/write selected files
;#inputs#
;\anArg{ parent }{ widget  }{ Parent widget }
;\anArg{ uvalue }{ widget structure  }{ widget information }
;\anArg{ title }{ string  }{ Title for file select button }
;\anArg{ rwtitle }{ string  }{ Title for read/write button }
;#return#
; a widget containing controls
;#end_function#
;********************************************************************
base = WIDGET_BASE(parent, /row)
text   = WIDGET_TEXT(base, XSIZE=70, UVALUE=uvalue, /EDITABLE)
uvalue.input=text
uvalue.output=text
info = {label:uvalue.label, input:text, output:text, mine:text,$
        message:uvalue.message, type:uvalue.type}
button = WIDGET_BUTTON(base, value=title, UVALUE=info)
uvalue.label=rwtitle
button = WIDGET_BUTTON(base, value=rwtitle, UVALUE=uvalue)
;print," text = ",text
return,base
END; end cw_filebrowser

FUNCTION cw_vinci_editscans, parent, uvalue=uvalue
;********************************************************************
;#function#
; cw_vinci_editscans
;#call#
; cw_vinci_editscans (parent, uvalue=uvalue)
;#description#
; Create Widget with controls to do scan editing
;#inputs#
;\anArg{ parent }{ widget  }{ Parent widget }
;\anArg{ uvalue }{ widget structure  }{ widget information }
;#return#
; a widget containing controls
;#end_function#
;********************************************************************
base = WIDGET_BASE(parent, /row, UVALUE=uvalue)
minWt  = CW_FIELD(base, title="minWt", xsize=7, value=3.0,/FLOATING)
minSNRP  = CW_FIELD(base, title="minSNRP", xsize=7, value=1.0,/FLOATING)
maxVel  = CW_FIELD(base, title="maxOPDvel", xsize=7, value=10.0,/FLOATING)
maxMom2 = CW_FIELD(base, title="maxMom2", xsize=7, value=0.2,/FLOATING)
sigEdit = CW_FIELD(base, title="sigEdit", xsize=7, value=4.0,/FLOATING)
info = {label:"EditScans",message:uvalue.message,$
  minWt:minWt, minSNRP:minSNRP, maxVEL:maxVel, maxMom2:maxMom2, sigEdit:sigEdit}
doit = WIDGET_BUTTON(base, value='Edit/Process Scans', UVALUE=info)
return,base
END; end cw_vinci_editscans

FUNCTION cw_vinci_remove, parent, uvalue=uvalue
;********************************************************************
;#function#
; cw_vinci_remove
;#call#
; cw_vinci_remove( parent, uvalue=uvalue)
;#description#
; Create Widget with controls to  remove scans or batches
;#inputs#
;\anArg{ parent }{ widget  }{ Parent widget }
;\anArg{ uvalue }{ widget structure  }{ widget information }
;#return#
; a widget containing controls
;#end_function#
;********************************************************************
base = WIDGET_BASE(parent, /row, UVALUE=uvalue)
batch  = CW_FIELD(base, title="batch", xsize=8, value=0, /long)
first  = CW_FIELD(base, title="first scan", xsize=8, value=0, /long)
last  = CW_FIELD(base, title="last scan", xsize=8, value=0, /long)
info = {label:"RmBatch",message:uvalue.message,$
  batch:batch, first:first, last:last, index:uvalue.index}
RmBatch = WIDGET_BUTTON(base, value='Rm Batch', UVALUE=info)
info.label="RmScans"
RmScans = WIDGET_BUTTON(base, value='Rm Scans', UVALUE=info)
info.label="ClrBatch"
RmBatch = WIDGET_BUTTON(base, value='Clr Batch', UVALUE=info)
info.label="ClrScans"
RmScans = WIDGET_BUTTON(base, value='Clr Scans', UVALUE=info)
return,base
END; end ccw_vinci_remove

FUNCTION cw_vinci_function, parent, uvalue=uvalue
;********************************************************************
;#function#
; cw_vinci_function
;#call#
; cw_vinci_function (parent, uvalue=uvalue)
;#description#
; Create Widget with function bar
;#inputs#
;\anArg{ parent }{ widget  }{ Parent widget }
;\anArg{ uvalue }{ widget structure  }{ widget information }
;#return#
; a widget containing controls
;#end_function#
;********************************************************************
base = WIDGET_BASE(parent, /row, UVALUE=uvalue)
uvalue.label='RunFV'
fv   = WIDGET_BUTTON(base, value='Run FV', UVALUE=uvalue)
uvalue.label='ApplyCal'
apply  = WIDGET_BUTTON(base, value='Apply cal', UVALUE=uvalue)
uvalue.label='ExtractCal'
ExtCal  = WIDGET_BUTTON(base, value='Extract cals', UVALUE=uvalue)
uvalue.label='RawDataDirectory'
raw    = WIDGET_BUTTON(base, value='Raw Data dir.', UVALUE=uvalue)
uvalue.label='DONE'
quit = WIDGET_BUTTON(base, value='QUIT', UVALUE=uvalue)
return,base
END; end cw_vinci_function

FUNCTION cw_vinci_editbatch, parent, uvalue=uvalue
;********************************************************************
;#function#
; cw_vinci_editbatch
;#call#
; cw_vinci_editbatch( parent, uvalue=uvalue)
;#description#
; Widget with controls to edit batches
;#inputs#
;\anArg{ parent }{ widget  }{ Parent widget }
;\anArg{ uvalue }{ widget structure  }{ widget information }
;#return#
; a widget containing controls
;#end_function#
;********************************************************************
base = WIDGET_BASE(parent, /row, UVALUE=uvalue)
maxChi2  = CW_FIELD(base, title="maxChi2", xsize=10, value=5.0,/FLOATING)
minSNR  = CW_FIELD(base, title="minSNR", xsize=10, value=5.0,/FLOATING)
maxOPDvsd  = CW_FIELD(base, title="maxOPDvsd", xsize=12, value=15.0,/FLOATING)
minScan  = CW_FIELD(base, title="minScan", xsize=8, value=10,/LONG)
info = {label:"BatchEdit",message:uvalue.message,index:uvalue.index,$
  maxChi2:maxChi2, minSNR:minSNR, maxOPDvsd:maxOPDvsd, minScan:minScan}
doit = WIDGET_BUTTON(base, value='EditBatches', UVALUE=info)
return,base
END; end cw_vinci_editbatch

FUNCTION cw_vinci_plotbatch, parent, uvalue=uvalue
;********************************************************************
;#function#
; cw_vinci_plotbatch
;#call#
; cw_vinci_plotbatch( parent, uvalue=uvalue)
;#description#
; Widget with controls to plot batch average data
;#inputs#
;\anArg{ parent }{ widget  }{ Parent widget }
;\anArg{ uvalue }{ widget structure  }{ widget information }
;#return#
; a widget containing controls
;#end_function#
;********************************************************************
base = WIDGET_BASE(parent, /row, UVALUE=uvalue)
label0 = WIDGET_LABEL(base, value="Source")
sources=["All","               "]
info = {label:"BatchSourceList",message:uvalue.message,$
   value:PTR_NEW(sources[0]), list:PTR_NEW(sources)}
sourceDrop =  WIDGET_DROPLIST(base, value=sources, UVALUE=info)
label1 = WIDGET_LABEL(base, value="Value")
values=["/mu12","/mu22","/t12","/t22","/v12","/v22","/sigOPD",$
   "/sigRateOPD","/corPow","/mom1","/mom2","/pa","/pb",  $
   "/sigCorPow","/sigMom1","/sigMom2","/sigPa","/sigPb"]
info = {label:"BatchValuesList",message:uvalue.message,$
   value:PTR_NEW(values[0]), list:PTR_NEW(values)}
valueDrop =  WIDGET_DROPLIST(base, value=values, UVALUE=info)
label2 = WIDGET_LABEL(base, value="Opt 1")
values=["    ", ",/over",",/number"]
info = {label:"BPOpt1",message:uvalue.message,$
   value:PTR_NEW(values[0]), list:PTR_NEW(values)}
opt1 =  WIDGET_DROPLIST(base, value=values, UVALUE=info)
label3 = WIDGET_LABEL(base, value="Opt 2")
values=["    ", ",/cal",",/nocal"]
info = {label:"BPOpt2",message:uvalue.message,$
   value:PTR_NEW(values[0]), list:PTR_NEW(values)}
opt2 =  WIDGET_DROPLIST(base, value=values, UVALUE=info)
info = {label:"BatchPlot",message:uvalue.message,$
  values:valueDrop, opt1:opt1, opt2:opt2, source:sourceDrop}
doit = WIDGET_BUTTON(base, value='Plot Batches', UVALUE=info)
; return sourceDrop so that the read routine can find it to update its value. 
return,sourceDrop
END; end cw_vinci_plotbatch

FUNCTION cw_vinci_plotscans, parent, uvalue=uvalue
;********************************************************************
;#function#
; cw_vinci_plotscans
;#call#
; cw_vinci_plotscans(parent, uvalue=uvalue)
;#description#
; Widget with controls to plot scan average data.
;#inputs#
;\anArg{ parent }{ widget  }{ Parent widget }
;\anArg{ uvalue }{ widget structure  }{ widget information }
;#return#
; a widget containing controls
;#end_function#
;********************************************************************
base = WIDGET_BASE(parent, /row, UVALUE=uvalue)
batch = 0L
;batch  = CW_FIELD(base, title="batches", xsize=15, value="[-1]", /string)
label0 = WIDGET_LABEL(base, value="Source")
sources=["All","               "]
info = {label:"ScanSourceList",message:uvalue.message,$
   value:PTR_NEW(sources[0]), list:PTR_NEW(sources)}
sourceDrop =  WIDGET_DROPLIST(base, value=sources, UVALUE=info)
label1 = WIDGET_LABEL(base, value="Value")
values=["/mu12","/mu22","/opd","/rateopd","/snrp1","/snrp2","/weight",$
   "/corPow","/mom1","/mom2","/pa","/pb        "]
info = {label:"ScanValuesList",message:uvalue.message,$
   value:PTR_NEW(values[0]), list:PTR_NEW(values)}
valueDrop =  WIDGET_DROPLIST(base, value=values, UVALUE=info)
label2 = WIDGET_LABEL(base, value="Opt 1")
values=["    ", ",/over  "]
info = {label:"SPOpt1",message:uvalue.message,$
   value:PTR_NEW(values[0]), list:PTR_NEW(values)}
opt1 =  WIDGET_DROPLIST(base, value=values, UVALUE=info)
label3 = WIDGET_LABEL(base, value="Opt 2")
values=["    ", ",/cal",",/nocal"]
info = {label:"SPOpt2",message:uvalue.message,$
   value:PTR_NEW(values[0]), list:PTR_NEW(values)}
opt2 =  WIDGET_DROPLIST(base, value=values, UVALUE=info)
info = {label:"ScanPlot",message:uvalue.message,$
  values:valueDrop, opt1:opt1, opt2:opt2, batch:batch, source:sourceDrop}
doit = WIDGET_BUTTON(base, value='Plot Scans', UVALUE=info)
; return sourceDrop so that the read routine can find it to update its value. 
return,sourceDrop
END; end cw_vinci_plotscans

PRO VINCI_gui_sourcelist, widget, Obsfile
;********************************************************************
;#procedure#
; VINCI_gui_sourcelist
;#call#
; VINCI_gui_sourcelist, widget, Obsfile
;#description#
; Update widget source lists
;#inputs#
;\anArg{ widget }{ drop list }{ list to contain source list }
;\anArg{ ObsFile }{ VINCIObsFile-like }{ VINCI observation file }
;#end_procedure#
;********************************************************************
; generate source list
nsource = N_ELEMENTS(ObsFile.source_data)
slist = strarr(nsource+1)
slist[0] = "All"
for i = 1,nsource do begin
  slist[i] = ObsFile.source_data[i-1].source
endfor

; set widget
WIDGET_CONTROL, widget, SET_VALUE=slist
WIDGET_CONTROL, widget, SET_DROPLIST_SELECT=0

; update values on widget's info structure
WIDGET_CONTROL, widget, GET_UVALUE=info
info.value = PTR_NEW(slist[0])
info.list = PTR_NEW(slist)
WIDGET_CONTROL, widget, SET_UVALUE=info
END  ; end VINCI_gui_sourcelist

FUNCTION cw_vinci_plotraw, parent, uvalue=uvalue
;********************************************************************
;#function#
; cw_vinci_plotraw
;#call#
; cw_vinci_plotraw(parent, uvalue=uvalue)
;#description#
; Widget with controls to plot raw data.
;#inputs#
;\anArg{ parent }{ widget  }{ Parent widget }
;\anArg{ uvalue }{ widget structure  }{ widget information }
;#return#
; a widget containing controls
;#end_function#
;********************************************************************
base = WIDGET_BASE(parent, /row, UVALUE=uvalue)
batch  = CW_FIELD(base, title="batch", xsize=10, value=0, /long)
info = {label:"FallPlot",message:uvalue.message, batch:batch}
fall = WIDGET_BUTTON(base, value='Raw data Waterfall display', UVALUE=info)
info = {label:"PowerPlot",message:uvalue.message, batch:batch}
power = WIDGET_BUTTON(base, value='Raw data Waterpower display', UVALUE=info)
return,base
END; end cw_vinci_plotraw

FUNCTION cw_vinci_index, parent, index
;********************************************************************
;#function#
; cw_vinci_index
;#call#
; cw_vinci_index(parent, uvalue=uvalue)
;#description#
; Widget with file index in text box
;#inputs#
;\anArg{ parent }{ widget  }{ Parent widget }
;\anArg{ index }{array of strings  }{ File index }
;#return#
; a widget with file index
;#end_function#
;********************************************************************
text = WIDGET_TEXT(parent, value=index,xsize=50,ysize=7,/scroll)
return,text
END; end cw_vinci_index

PRO vinci_gui
;********************************************************************
;#procedure#
; vinci_gui
;#call#
; vinci_gui
;#description#
; VINCI GUI
;#inputs#
;\anArg{ ev }{ event }{ event to be processed }
;#end_procedure#
;********************************************************************
; define information structure
info = {label:"LABEL",input:0L, output:0L, message:0L,index:0L,$
    plotScan:0L, plotBatch:0l, type:"  "}
base = WIDGET_BASE(/COLUMN, EVENT_FUNC='VINCI_EVENT',$
   title="VLTI/VINCI Analysis")
info.message = WIDGET_TEXT(base, XSIZE=100,VALUE=" Message line")
info.index = cw_vinci_index(base, $
   string("Select and read FITS file to begin."))
info.label='EditScanBar'
EditScanBar = cw_vinci_editscans(base, UVALUE=info)
info.label='EditBatchBar'
EditBatchBar = cw_vinci_editbatch(base, UVALUE=info)
RmBar = cw_vinci_remove(base, UVALUE=info)
info.plotBatch = cw_vinci_plotbatch(base, UVALUE=info)
info.plotScan  = cw_vinci_plotscans(base, UVALUE=info)
PlotRawBar = cw_vinci_plotraw(base, UVALUE=info)
info.label='SELECT_IN'
info.input =  cw_vinci_filebrowser(base, title='select input file', $
   UVALUE=info, rwtitle="Read")
info.label='SELECT_OUT'
info.type="process.fits"
info.output =  cw_vinci_filebrowser(base, title='select output file', $
   UVALUE=info, rwtitle="Write")
info.label='SELECT_OUT'
info.type="rpt"
report =  cw_vinci_filebrowser(base, title='select report file', $
   UVALUE=info, rwtitle="Report")
FunctionBar = cw_vinci_function(base, UVALUE=info)
WIDGET_CONTROL, info.input, SET_UVALUE=info
WIDGET_CONTROL, info.output, SET_UVALUE=info
WIDGET_CONTROL, base, /REALIZE
XMANAGER, 'vinci_gui', base, /no_block
END
