pro vinciwavetest
;
common VinciData,off,a,b,on,fr,nx,fsp,ob,im,obd
;
ntime = 256
y = RANDOMN(s,ntime)       ;*** create a random time series
y=sin(findgen(ntime)/2)
restore
dt = 0.25
time = FINDGEN(ntime)*dt   ;*** create the time index

wave = WAVELET(y,dt,PERIOD=period,COI=coi,/PAD,SIGNIF=signif)
nscale = N_ELEMENTS(period)
LOADCT,39
CONTOUR,ABS(wave)^2,time,period, $
       XSTYLE=1,XTITLE='Time',YTITLE='Period',TITLE='Noise Wavelet', $
       YRANGE=[MAX(period),MIN(period)], $  
       /YTYPE, $                          
       NLEVELS=25,/FILL

signif = REBIN(TRANSPOSE(signif),ntime,nscale)
CONTOUR,ABS(wave)^2/signif,time,period, $
           /OVERPLOT,LEVEL=1.0,C_ANNOT='95%'
PLOTS,time,coi,NOCLIP=0   ;*** anything "below" this line is dubious
;
end
