;********************************************************
;#class#
;fbtUtilities
;#description#
;some low level, very dum, utilities that
;dont belong in specific "classes" within FBT
;#end_class#
;*******************************************************

FUNCTION topClass, input
;********************************************************
;#function#
;topClass
;#description#
;return the topmost superclass of an IDL class object
;#call#
;topClassName = topClass(idlObject)
;#inputs#
;\anArg{idlObject}{IDL object}{arbitrary object}
;#return#
;\anArg{-}{string}{name of top of class hierarchy leading to input}
;#end_function#
;*******************************************************
;check if it is an object
   if (NOT OBJ_VALID(input)) then RETURN,''
   inClass = OBJ_CLASS(input)
   inClass = inClass[0]
;find highest order superclass of inclass
   sc      = inClass
   while (sc NE '') do begin
      superClass = sc
      sc = OBJ_CLASS(sc,/ super)
      sc = sc[0]
   endwhile
RETURN,superClass[0]
END


FUNCTION midiDumEl, idlType, nDim, iErr=iErr
;+
; Project : MIDI
;
;   Create a template IDL-variable representing one element 
;   of a binary table
;
; INPUTS:
;   idlType   int      IDL specification of input type, e.g. 1 = byte
;   nDIM      intarr   array specifying size of variable in each dimension
;
; OUTPUTS:    iErr
; RETURNS     ?arr     an empty IDL array of specified type and dimensions
;  Check the number of parameters.
;

;establish error handler
   cErr = 0
   catch, cErr
   if (cErr NE 0) then begin
;supress further handling at this level 
      catch, /cancel 
      midiCatchError
      iErr = 1
RETURN,0
   endif         ; handle actual error
   if N_PARAMS() NE 2 then $
      midiSetError, 'Syntax:  midiDumEl(IDLTYPE, nDim) '
;  Create a SIZE like array from nDim and idlType
   i0 = MIN(WHERE(nDim EQ 0))
   if (i0 EQ 1) then midiSetError, 'Empty Array'
;scalar
   if (i0 EQ 0 AND (idlType NE 7)) then begin
      CASE idlType OF
         1: structEl = 0B
	 2: structEL = 0
	 3: structEl = 0L
	 4: structEl = 0.0
	 5: structEl = double(0.0)
	 6: structEl = complex(0.0, 0.0)
      ENDCASE
      endif else begin
      if (i0 EQ -1) then I0 = nDim ELSE  I0 = nDim(0:I0 - 1)
;Fix for character strings.  Then the first dimension is actually
;the number of characters per string, which is irrelvant at this point
      if (idlType EQ 7) then begin
         nChar = i0[1]
         if (i0[0] EQ 1) then i0 = [1,1] else   $
         i0 = [i0[0]-1>1,i0[2:n_elements(i0)-1]]
      endif
      nl = 1L
      for i = 1, N_ELEMENTS(I0) - 1 do nl = nl * i0(i)
      i0 = [i0, idlType, nl]
;
      structEl = MAKE_ARRAY(SIZE = i0)
   endelse
   if (idlType EQ 7) then structEl[*] = STRING(REPLICATE(32b,nChar))
   iErr = 0
RETURN, structEl
END
