;*******************************************************************************
; File: vincigui.pro
;
; Implements GUI for easier VINCI/MONA/IONIC data analysis.
;
;************************************************************************Block 1
function vincigui_event,event
;
common VinciData,RawDir,obfileobj,obht
common VinciGUIWids,vinci_wid,button_wid,files_wid
common VinciTaskWids,fringes_wid,batch_wid,wave_wid,wiener_wid, $
		     vndrsf_wid,vndrsi_wid,vndrsw_wid,vndrso_wid,vndrsv_wid
;
widget_control,event.id,get_uvalue=dir
;
case event.value of
;
'Observation':	begin
	if n_elements(obfileobj) ne 0 then obj_destroy,obfileobj
;
;	Clean desktop a little
	wdall
	if n_elements(fringes_wid) eq 0 then fringes_wid=0L
	if n_elements(batch_wid) eq 0 then batch_wid=0L
	if n_elements(wave_wid) eq 0 then wave_wid=0L
	if n_elements(wiener_wid) eq 0 then wiener_wid=0L
	if n_elements(vndrsf_wid) eq 0 then vndrsf_wid=0L
	if n_elements(vndrsi_wid) eq 0 then vndrsi_wid=0L
	if n_elements(vndrsw_wid) eq 0 then vndrsw_wid=0L
	if n_elements(vndrso_wid) eq 0 then vndrso_wid=0L
	if n_elements(vndrsv_wid) eq 0 then vndrsv_wid=0L
	if widget_info(fringes_wid,/valid) then widget_control,fringes_wid,/destroy
	if widget_info(batch_wid,/valid) then widget_control,batch_wid,/destroy
	if widget_info(wave_wid,/valid) then widget_control,wave_wid,/destroy
	if widget_info(wiener_wid,/valid) then widget_control,wiener_wid,/destroy
	if widget_info(vndrsf_wid,/valid) then widget_control,vndrsf_wid,/destroy
	if widget_info(vndrsi_wid,/valid) then widget_control,vndrsi_wid,/destroy
	if widget_info(vndrsw_wid,/valid) then widget_control,vndrsw_wid,/destroy
	if widget_info(vndrso_wid,/valid) then widget_control,vndrso_wid,/destroy
	if widget_info(vndrsv_wid,/valid) then widget_control,vndrsv_wid,/destroy
;
	print,'Please wait, reading files...'
	obfileobj = obj_new('fitsfilelist',dir=dir, $
			guikeys=['obs name','ql framerate','ins mode','dpr catg','dpr type','win1 nx'], $
			guisearch=RawDir+'VINCI*.fits')
	widget_control,files_wid, $
		set_value=obfileobj->files(),set_uvalue=obfileobj->files()
	obsfiles=obfileobj->files()
	obht=obfileobj->headertable()
	allfiles=RawDir+obht.filename
	n=n_elements(obsfiles)
	index=intarr(n)
	for i=0,n-1 do index(i)=where(allfiles eq obsfiles(i))
	obht=obht(index)
	obht.filename=obsfiles
;
;	Obtain some useful info
	index=where(strtrim(obht.dprtype,2) eq 'STD',count)
	if count gt 0 then begin
		fitsfile=obj_new('fitsfile',obht(index(0)).filename)
		prihead=fitsfile->prihead()
		airmass=strtrim(prihead->getpar('ISS AIRM END'))
		seeing=strtrim(prihead->getpar('ISS AMBI FWHM'))
		framerate=prihead->getpar('DET QL FRAMERATE')
		fringespd=prihead->getpar('DET QL FRINGESPD')
		nfram=prihead->getpar('DET RM NFRAM')
		nscan=prihead->getpar('DET NC NSCAN')
		obj_destroy,prihead
		obj_destroy,fitsfile
		print,'Target: ',obht(index(0)).obsname
		print,'Airmass:',airmass,', seeing:',seeing
		print,'Scanning parameters:'
		print,'Number of scans:',nscan
		print,'Scan length [mu]:',nfram/framerate*fringespd*1e6
		print,'Scan length [ms]:',nfram/framerate*1e3
		print,'Frames per fringe:',2.2e-6/(fringespd/framerate)
	endif
	end
'Move':	begin
	for i=0,n_elements(obht.filename)-1 do print,obht(i).filename
	answer=' '
	read,prompt='Move these files to "morevincidata"? (y/n): ',answer
	if answer eq 'y' then begin
		spawn,'mkdir -p morevincidata'
		for i=0,n_elements(obht.filename)-1 do begin
			spawn,'mv '+obht(i).filename+' morevincidata'
		endfor
	endif
	end
'Delete':begin
	for i=0,n_elements(obht.filename)-1 do $
		print,obht(i).filename
	answer=' '
	read,prompt='Delete these files? (y/n): ',answer
	if answer eq 'y' then spawn,'rm -f '+strjoin(obht.filename,' ')
	end
'Fringes':begin
	index=where(strtrim(obht.dprtype,2) eq 'STD' $
		 or strtrim(obht.dprtype,2) eq 'THERMAL',count)
	if count eq 1 then begin
		print,'Reading data...'
		d=vincirawscans(obht(index).filename)
		plot_slide,findgen(n_elements(d(*,0,0))),d(*,*,4),wid=fringes_wid
	endif
	end
'Waterfall':begin
	index=where(strtrim(obht.dprtype,2) eq 'STD' $
		 or strtrim(obht.dprtype,2) eq 'THERMAL',count)
	if count eq 1 then begin
		print,'Reading data...'
		d=vincirawscans(obht(index).filename)
		loadct,0
		if !d.window eq -1 or $
		   !d.x_size ne n_elements(d(*,0,0)) or $
		   !d.y_size ne n_elements(d(0,*,0)) then $
			window,xsize=n_elements(d(*,0,0)),ysize=n_elements(d(0,*,0))
		tvscl,d(*,*,4)
	endif
	end
'Batch':begin
	flag=0
	if n_elements(obht) eq 4 then begin
	index1=where(strtrim(obht.dprtype,2) eq 'OFFSOURCE',count1)
	index2=where(strtrim(obht.dprtype,2) eq 'BEAM_A',count2)
	index3=where(strtrim(obht.dprtype,2) eq 'BEAM_B',count3)
	index4=where(strtrim(obht.dprtype,2) eq 'STD' $
		 or  strtrim(obht.dprtype,2) eq 'THERMAL',count4)
	if count1*count2*count3*count4 ne 1 then flag=1
	endif else flag=1
	if flag then begin
		print,'***Error: no complete batch selected!'
	endif else begin
		obht=obht([index1,index2,index3,index4])
		vincibatchgui,indgen(4)
	endelse
	end
;
endcase
;
end
;-------------------------------------------------------------------------------
function files_event,event
;
widget_control,event.id,get_uvalue=files
spawn,'fv -cmap 2 '+files(event.index)+' &'
;
end
;-------------------------------------------------------------------------------
pro myvincigui,dir
;
common VinciData,RawDir,obfileobj,obht
common VinciGUIWids,vinci_wid,button_wid,files_wid
;
RawDir=''
if n_elements(dir) eq 0 then spawn,'pwd',RawDir else RawDir=dir
RawDir=RawDir(0)+'/'
if total(strlen(findfile(RawDir))) eq 0 then $
RawDir='/data2/chummel/data/vlti/vinci/'+RawDir
;
vinci_wid=widget_base(/column,title=RawDir(0))
templates=['Observation', $
	   'Move', $
	   'Delete', $
	   'Fringes', $
	   'Waterfall', $
	   'Batch']
button_wid=cw_bgroup(vinci_wid,/row,templates, $
	event_func='vincigui_event',/return_name)
;
files_wid=widget_list(vinci_wid,value=strarr(10)+' ', $
	event_func='files_event', $
	xsize=15,ysize=10)
;
widget_control,vinci_wid,/realize
xmanager,'vinciggui',vinci_wid,/no_block
;
end
;-------------------------------------------------------------------------------
function vincibatchgui_event,event
;
common VinciAcqGUI,objindex
common VinciData,RawDir,obfileobj,obht
common VinciRawData,off,a,b,on,fr,nx,fsp,ob,im,obd
;
tek_color
!x.range=0
!y.range=0
;
target=strtrim(obht(objindex(0)).obsname,2)
;
case event.value of
; First row buttons
'Waterfall':	begin
		loadct,0
		if !d.window eq -1 or $
		   !d.x_size ne n_elements(on(*,0,0)) or $
		   !d.y_size ne n_elements(on(0,*,0)) then $
			window,xsize=n_elements(on(*,0,0)),ysize=n_elements(on(0,*,0))
		tvscl,on(*,*,4)
		end
'Wavelet':	vinciwavegui
'Wienerfilter': vinciwienergui
; Second row buttons
'VNDRS':	begin
		r=findfile(obht(objindex(3)).filename+'.log')
		if strlen(r(0)) eq 0 then begin
			print,'Running vndrs, please be patient...'
			vndrs,obfileobj
		endif else begin
			print,'Log file found, no need to rerun VNDRS.'
		endelse
		end
'ON-Source PSDs' :vincivndrsogui,findfile(obht(objindex(3)).filename+'.log')
'Wiener filters' :vincivndrsigui,findfile(obht(objindex(3)).filename+'.log')
'Fourier spectra':vincivndrsfgui,findfile(obht(objindex(3)).filename+'.log')
'Wavelet spectra':vincivndrswgui,findfile(obht(objindex(3)).filename+'.log')
'Scan data'      :vincivndrsvgui,findfile(obht(objindex(3)).filename+'.log')
else:
endcase
;
end
;-------------------------------------------------------------------------------
pro vincibatchgui,index
;
common VinciAcqGUI,objindex
common VinciData,RawDir,obfileobj,obht
common VinciTaskWids,fringes_wid,batch_wid,wave_wid,wiener_wid, $
		     vndrsf_wid,vndrsi_wid,vndrsw_wid,vndrso_wid,vndrsv_wid
;
; Remove any existing widget
if widget_info(batch_wid,/valid) then widget_control,batch_wid,/destroy
;
objindex=index
;
print,'Please wait, reading data...'
vincibatch,obfileobj
;
batch_wid=widget_base(/col,title=obht(objindex(0)).obsname)
guis=['Waterfall','Wavelet','Wienerfilter']
button_wid=cw_bgroup(batch_wid,/row,guis, $
	event_funct='vincibatchgui_event',/return_name)
guis=['VNDRS','ON-Source PSDs','Wiener filters', $
      'Fourier spectra','Wavelet spectra','Scan data']
button_wid=cw_bgroup(batch_wid,/row,guis, $
	event_funct='vincibatchgui_event',/return_name)
;
widget_control,batch_wid,/realize
xmanager,'vincibatchggui',batch_wid,/no_block
;
end
;-------------------------------------------------------------------------------
pro vinciwavegui_event,event
;
common VinciWaveGuiEventLocal,i,j,index0,d_wid
;
result=size(event)
if result(n_elements(result)-2) ne 8 then begin
        value=1
        i=1
        j=0
endif else begin
        widget_control,event.id,get_uvalue=slider,get_value=value
        case slider of
                'i':i=long(value)
                'j':j=long(value)
        endcase
endelse
;
index=i+j-1
if n_elements(index0) eq 0 then index0=index-1
if index eq index0 then return else index0=index
widget_control,d_wid,get_value=id
wset,id
vinciscanwavelet,index(0)
;
end
;-------------------------------------------------------------------------------
pro vinciwavegui
;
common VinciWaveGuiEventLocal,i,j,index0,d_wid
common VinciTaskWids,fringes_wid,batch_wid,wave_wid,wiener_wid, $
		     vndrsf_wid,vndrsi_wid,vndrsw_wid,vndrso_wid,vndrsv_wid
;
wave_wid=widget_base(/column)
d_wid=widget_draw(wave_wid,notify_realize='vinciwavegui_event', $
        event_pro='vinciwavegui_event', $
        scr_xsize=800,scr_ysize=500)
i_wid=cw_fslider(wave_wid,minimum=1,maximum=count,value=1,/drag, $
        title='Index I',xsize=500,format='(i0)',uvalue='i')
j_wid=cw_fslider(wave_wid,minimum=0,maximum=100,value=0,/drag, $
        title='Index J',xsize=500,format='(i0)',uvalue='j')
widget_control,wave_wid,/realize
xmanager,'vinciwavegui',wave_wid,/no_block,event_handler='vinciwavegui_event'
;
end
;-------------------------------------------------------------------------------
pro vinciwienergui_event,event
;
common VinciWienerGuiEventLocal,i,j,index0,d_wid
;
result=size(event)
if result(n_elements(result)-2) ne 8 then begin
        value=1
        i=1
        j=0
endif else begin
        widget_control,event.id,get_uvalue=slider,get_value=value
        case slider of
                'i':i=long(value)
                'j':j=long(value)
        endcase
endelse
;
index=i+j-1
if n_elements(index0) eq 0 then index0=index-1
if index eq index0 then return else index0=index
widget_control,d_wid,get_value=id
wset,id
vinciplotwiener,index(0)
;
end
;-------------------------------------------------------------------------------
pro vinciwienergui
;
common VinciWienerGuiEventLocal,i,j,index0,d_wid
common VinciTaskWids,fringes_wid,batch_wid,wave_wid,wiener_wid, $
		     vndrsf_wid,vndrsi_wid,vndrsw_wid,vndrso_wid,vndrsv_wid
;
wiener_wid=widget_base(/column)
d_wid=widget_draw(wiener_wid,notify_realize='vinciwienergui_event', $
        event_pro='vinciwienergui_event', $
        scr_xsize=800,scr_ysize=500)
i_wid=cw_fslider(wiener_wid,minimum=1,maximum=count,value=1,/drag, $
        title='Index I',xsize=500,format='(i0)',uvalue='i')
j_wid=cw_fslider(wiener_wid,minimum=0,maximum=100,value=0,/drag, $
        title='Index J',xsize=500,format='(i0)',uvalue='j')
widget_control,wiener_wid,/realize
xmanager,'vinciwienergui',wiener_wid,/no_block,event_handler='vinciwienergui_event'
;
end
;-------------------------------------------------------------------------------
function vincivndrsfgui_event,event
;
common VndrsFGuiLocal,d_wid
;
result=size(event)
if result(n_elements(result)-2) eq 8 then begin
widget_control,event.id,get_uvalue=data
index=where(strpos(data,event.value) ne -1)
widget_control,d_wid,get_value=id
wset,id
plot,float(nameparse(data(9))),float(nameparse(data(index(0)+9))), $
	title=event.value,xtitle='Wave number'
endif
;
end
;-------------------------------------------------------------------------------
pro vincivndrsfgui,logfile
;
common VinciTaskWids,fringes_wid,batch_wid,wave_wid,wiener_wid, $
		     vndrsf_wid,vndrsi_wid,vndrsw_wid,vndrso_wid,vndrsv_wid
common VndrsFGuiLocal,d_wid
;
openr,unit,logfile,/get_lun
data=strarr(1000)
l=''
i=0
repeat begin
	readf,unit,l
	data(i)=l
	i=i+1
endrep until eof(unit) eq 1
free_lun,unit
index=where(strpos(data,'Fourier power spectra of processed scans') ne -1)
plottitles=strmid(data(index(0)+2:index(0)+9),5,100)
;
vndrsf_wid=widget_base(/column)
d_wid=widget_draw(vndrsf_wid, $
        event_func='vincivndrsfgui_event', $
        scr_xsize=550,scr_ysize=400)
button_wid=cw_bgroup(vndrsf_wid,/col,plottitles, $
	uvalue=data(index(0)+1:index(0)+18), $
	event_func='vincivndrsfgui_event',/return_name)
widget_control,vndrsf_wid,/realize
xmanager,'vincivndrsfgui',vndrsf_wid,/no_block,event_handler='vincivndrsfgui_event'
;
end
;-------------------------------------------------------------------------------
function vincivndrswgui_event,event
;
common VndrsWGuiLocal,d_wid
;
result=size(event)
if result(n_elements(result)-2) eq 8 then begin
widget_control,event.id,get_uvalue=data
index=where(strpos(data,event.value) ne -1)
widget_control,d_wid,get_value=id
wset,id
plot,float(nameparse(data(5))),float(nameparse(data(index(0)+5))), $
	title=event.value,xtitle='Wave number'
endif
;
end
;-------------------------------------------------------------------------------
pro vincivndrswgui,logfile
;
common VinciTaskWids,fringes_wid,batch_wid,wave_wid,wiener_wid, $
		     vndrsf_wid,vndrsi_wid,vndrsw_wid,vndrso_wid,vndrsv_wid
common VndrsWGuiLocal,d_wid
;
openr,unit,logfile,/get_lun
data=strarr(1000)
l=''
i=0
repeat begin
	readf,unit,l
	data(i)=l
	i=i+1
endrep until eof(unit) eq 1
free_lun,unit
index=where(strpos(data,'Wavelets power spectra of processed scans') ne -1)
plottitles=strmid(data(index(0)+2:index(0)+5),5,100)
;
vndrsw_wid=widget_base(/column)
d_wid=widget_draw(vndrsw_wid, $
        event_func='vincivndrswgui_event', $
        scr_xsize=550,scr_ysize=400)
button_wid=cw_bgroup(vndrsw_wid,/col,plottitles, $
	uvalue=data(index(0)+1:index(0)+10), $
	event_func='vincivndrswgui_event',/return_name)
widget_control,vndrsw_wid,/realize
xmanager,'vincivndrswgui',vndrsw_wid,/no_block,event_handler='vincivndrswgui_event'
;
end
;-------------------------------------------------------------------------------
function vincivndrsigui_event,event
;
common VndrsIGuiLocal,d_wid
;
result=size(event)
if result(n_elements(result)-2) eq 8 then begin
widget_control,event.id,get_uvalue=data
index=where(strpos(data,event.value) ne -1)
widget_control,d_wid,get_value=id
wset,id
plot,float(nameparse(data(3))),float(nameparse(data(index(0)+3))), $
	title=event.value,xtitle='Wave number'
endif
;
end
;-------------------------------------------------------------------------------
pro vincivndrsigui,logfile
;
common VinciTaskWids,fringes_wid,batch_wid,wave_wid,wiener_wid, $
		     vndrsf_wid,vndrsi_wid,vndrsw_wid,vndrso_wid,vndrsv_wid
common VndrsIGuiLocal,d_wid
;
openr,unit,logfile,/get_lun
data=strarr(1000)
l=''
i=0
repeat begin
	readf,unit,l
	data(i)=l
	i=i+1
endrep until eof(unit) eq 1
free_lun,unit
index=where(strpos(data,'Average Wiener filters for PA and PB') ne -1)
plottitles=strmid(data(index(0)+2:index(0)+3),5,100)
;
vndrsi_wid=widget_base(/column)
d_wid=widget_draw(vndrsi_wid, $
        event_func='vincivndrsigui_event', $
        scr_xsize=550,scr_ysize=400)
button_wid=cw_bgroup(vndrsi_wid,/col,plottitles, $
	uvalue=data(index(0)+1:index(0)+6), $
	event_func='vincivndrsigui_event',/return_name)
widget_control,vndrsi_wid,/realize
xmanager,'vincivndrsigui',vndrsi_wid,/no_block,event_handler='vincivndrsigui_event'
;
end
;-------------------------------------------------------------------------------
function vincivndrsogui_event,event
;
common VndrsOGuiLocal,d_wid
;
result=size(event)
if result(n_elements(result)-2) eq 8 then begin
widget_control,event.id,get_uvalue=data
index=where(strpos(data,event.value) ne -1)
widget_control,d_wid,get_value=id
wset,id
plot,float(nameparse(data(6))),float(nameparse(data(index(0)+6))), $
	title=event.value,xtitle='Wave number',ytype=1
endif
;
end
;-------------------------------------------------------------------------------
pro vincivndrsogui,logfile
;
common VinciTaskWids,fringes_wid,batch_wid,wave_wid,wiener_wid, $
		     vndrsf_wid,vndrsi_wid,vndrsw_wid,vndrso_wid,vndrsv_wid
common VndrsOGuiLocal,d_wid
;
openr,unit,logfile,/get_lun
data=strarr(1000)
l=''
i=0
repeat begin
	readf,unit,l
	data(i)=l
	i=i+1
endrep until eof(unit) eq 1
free_lun,unit
index=where(strpos(data,'Average ON-SOURCE power spectra') ne -1)
plottitles=strmid(data(index(0)+2:index(0)+6),5,100)
;
vndrso_wid=widget_base(/column)
d_wid=widget_draw(vndrso_wid, $
        event_func='vincivndrsogui_event', $
        scr_xsize=550,scr_ysize=400)
button_wid=cw_bgroup(vndrso_wid,/row,plottitles, $
	uvalue=data(index(0)+1:index(0)+12), $
	event_func='vincivndrsogui_event',/return_name)
widget_control,vndrso_wid,/realize
xmanager,'vincivndrsogui',vndrso_wid,/no_block,event_handler='vincivndrsogui_event'
;
end
;-------------------------------------------------------------------------------
function vincivndrsvgui_event,event
;
common VndrsVGuiLocal,d_wid
;
result=size(event)
if result(n_elements(result)-2) eq 8 then begin
widget_control,event.id,get_uvalue=data
widget_control,d_wid,get_value=id
wset,id
index=where(data.iscan ge 0)
case event.value of
'OPD from wavelet':		plot,index,data.post(index),title=event.value
'Mu squared from FFT':		plot,index,data.mu2fft(index),title=event.value
'Mu squared from wavelet':	plot,index,data.mu2wl(index),title=event.value
'Phase of FFT':			plot,index,data.phs(index),title=event.value
'Total OPD':			plot,index,data.opd(index),title=event.value
'Position in frequency':	plot,index,data.posf(index),title=event.value
'FWHM in frequency':		plot,index,data.fwhmf(index),title=event.value
endcase
endif
;
!p.psym=0
;
end
;-------------------------------------------------------------------------------
pro vincivndrsvgui,logfile
;
common VinciTaskWids,fringes_wid,batch_wid,wave_wid,wiener_wid, $
		     vndrsf_wid,vndrsi_wid,vndrsw_wid,vndrso_wid,vndrsv_wid
common VndrsVGuiLocal,d_wid
;
openr,unit,logfile,/get_lun
data=strarr(1000)
l=''
i=0
repeat begin
	readf,unit,l
	data(i)=l
	i=i+1
endrep until eof(unit) eq 1
free_lun,unit
index=where(strpos(data,'Number of scans') ne -1)
words=nameparse(data(index(0)))
nscan=long(words(n_elements(words)-1))
index=where(strpos(data,'Scan Altitude_object') ne -1)
iscan=intarr(nscan)-1
alt=fltarr(nscan)
azi=fltarr(nscan)
bll=fltarr(nscan)
bla=fltarr(nscan)
pql=fltarr(nscan)
oql=fltarr(nscan)
post=fltarr(nscan)
phs=fltarr(nscan)
opd=fltarr(nscan)
fwhmt=fltarr(nscan)
posf=fltarr(nscan)
fwhmf=fltarr(nscan)
fp=fltarr(nscan)
ff=fltarr(nscan)
bgpa=fltarr(nscan)
bgpb=fltarr(nscan)
phi1=fltarr(nscan)
phi2=fltarr(nscan)
phpa=fltarr(nscan)
phpb=fltarr(nscan)
photom=fltarr(nscan)
balance=fltarr(nscan)
weight=fltarr(nscan)
mu2fft=fltarr(nscan)
mu2wl=fltarr(nscan)
i=0
repeat begin
	words=nameparse(data(index(0)+1+i))
	n=n_elements(words)
	iscan(i)=fix(words(0))
	alt(i)=float(words(1))
	azi(i)=float(words(2))
	bll(i)=float(words(3))
	bla(i)=float(words(4))
	pql(i)=float(words(5))
	oql(i)=float(words(6))
	post(i)=float(words(7))
	phs(i)=float(words(8))
	opd(i)=float(words(9))
	fwhmt(i)=float(words(10))
	posf(i)=float(words(11))
	fwhmf(i)=float(words(12))
	fp(i)=float(words(13))
	ff(i)=float(words(14))
	bgpa(i)=float(words(15))
	bgpb(i)=float(words(16))
	phi1(i)=float(words(17))
	phi2(i)=float(words(18))
	phpa(i)=float(words(19))
	phpb(i)=float(words(20))
	photom(i)=float(words(21))
	balance(i)=float(words(22))
	weight(i)=float(words(23))
	mu2fft(i)=float(words(24))
	mu2wl(i)=float(words(25))
	i=i+1
	words=nameparse(data(index(0)+1+i))
endrep until words(0) eq '#'
;
data={iscan:iscan,alt:alt,azi:azi,bll:bll,bla:bla,pql:pql,oql:oql, $
      post:post,phs:phs,opd:opd,fwhmt:fwhmt,posf:posf,fwhmf:fwhmf, $
      fp:fp,ff:ff,bgpa:bgpa,bgpb:bgpb,phi1:phi1,phi2:phi2, $
      phpa:phpa,phpb:phpb,photom:photom,balance:balance,weight:weight, $
      mu2fft:mu2fft,mu2wl:mu2wl}
;
vndrsv_wid=widget_base(/column)
d_wid=widget_draw(vndrsv_wid, $
        event_func='vincivndrsvgui_event', $
        scr_xsize=550,scr_ysize=400)
;
plottitles=['OPD from wavelet','Phase of FFT','Total OPD']
button_wid=cw_bgroup(vndrsv_wid,/row,plottitles,uvalue=data, $
	event_func='vincivndrsvgui_event',/return_name)
;
plottitles=['Position in frequency','FWHM in frequency']
button_wid=cw_bgroup(vndrsv_wid,/row,plottitles,uvalue=data, $
	event_func='vincivndrsvgui_event',/return_name)
;
plottitles=['Mu squared from FFT', 'Mu squared from wavelet']
button_wid=cw_bgroup(vndrsv_wid,/row,plottitles,uvalue=data, $
	event_func='vincivndrsvgui_event',/return_name)
;
widget_control,vndrsv_wid,/realize
xmanager,'vincivndrsvgui',vndrsv_wid,/no_block,event_handler='vincivndrsvgui_event'
;
end
;-------------------------------------------------------------------------------
pro myvincipipe,dir
;
; Processes all VINCI data in a directory and stores in OYSTER scan data.
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common ModelFit,parameters,ds_options
;
RawDir=''
if n_elements(dir) eq 0 then spawn,'pwd',RawDir else RawDir=dir
RawDir=RawDir(0)+'/'
if total(strlen(findfile(RawDir))) eq 0 then RawDir='/data2/chummel/data/vlti/vinci/'+RawDir
;
; Get header info for all files in this directory
obfileobj = obj_new('fitsfilelist',guisearchstring='VINCI.*.fits')
guikeys=['obs name','ql framerate','ins mode','dpr catg','dpr type','win1 nx']
keys=obfileobj->getHeaderKeys(guikeys)
;
; No run the VNDRS software
vndrs,obfileobj
obj_destroy,obfileobj
;
; VNDRS writes to .log files, and we now read all of them
files=findfile('VINCI.*.fits.log')
IF strpos(files(0),'.log') ge 0 THEN BEGIN
;
data=strarr(10000)
utdate=''
date0=''
;
FOR n=0,n_elements(files)-1 DO BEGIN
;
; Open ASCII file and read into string array
openr,unit,files(n),/get_lun
l=''
i=0
repeat begin
	readf,unit,l
	data(i)=l
	i=i+1
endrep until eof(unit) eq 1
free_lun,unit
;
; Which star?
i=where(strpos(data,'Target') ge 0)
words=nameparse(data(i(0)))
star=words(n_elements(words)-1)
bsc=cri(star,'bsc')
if bsc(0) lt 0 then begin
	hip=cri(star,'hic')
	if hip(0) lt 0 then begin
		print,'***Error(GET_VINCIDATA): unknown star:'+star+'!'
		return
	endif
	starid='HIP'+string(hip,format='(i6.6)')
endif else starid='BSC'+string(bsc,format='(i4.4)')
;
; Which date?
i=where(strpos(data,'Date') ge 0)
words=nameparse(data(i(0)))
date=strmid(words(n_elements(words)-1),0,10)
;
; Which time?
i=where(strpos(data,'Date') ge 0)
words=nameparse(data(i(0)))
time=strmid(words(n_elements(words)-1),11,8)
time=double(strmid(time,0,2)) $
    +double(strmid(time,3,2))/60 $
    +double(strmid(time,6,2))/3600
;
; Determine dates
if strlen(date0) eq 0 then date0=date
if strlen(utdate) eq 0 then begin
	if time lt 12 then utdate=date else utdate=nextdate(date)
endif
if date eq nextdate(date0) then time=time+24
;
; Which JD?
; i=where(strpos(data,'Julian') ge 0)
; words=nameparse(data(i(0)))
; jd=double(words(n_elements(words)-1))
;
; Which stations?
i=where(strpos(data,'Station 1') ge 0)
words=nameparse(data(i(0)))
st1='V'+words(n_elements(words)-1)
i=where(strpos(data,'Station 2') ge 0)
words=nameparse(data(i(0)))
st2='V'+words(n_elements(words)-1)
;
; Which fringe file?
i=where(strpos(data,'Fringes:') ge 0)
words=nameparse(data(i(0)))
onfile=obj_new('fitsfile',words(n_elements(words)-1))
prihead=onfile->prihead()
station_1=strtrim(prihead->getpar('ISS CONF STATION1'))
station_2=strtrim(prihead->getpar('ISS CONF STATION2'))
stations=[station_1,station_2]
delayline_1=strtrim(prihead->getpar('ISS CONF DL1'))
delayline_2=strtrim(prihead->getpar('ISS CONF DL2'))
delaylines=[delayline_1,delayline_2]
delaylineids=strmid(delaylines,2,1)
bcinput_1=strtrim(prihead->getpar('ISS CONF INPUT1'))
bcinput_2=strtrim(prihead->getpar('ISS CONF INPUT2'))
bcinputs=[bcinput_1,bcinput_2]
dlt1=prihead->getpar('DEL DLT1 OPL START')
dlt2=prihead->getpar('DEL DLT2 OPL START')
refopl=prihead->getpar('DEL REF OPL')
refname=prihead->getpar('DEL REF NAME')
obj_destroy,prihead
obj_destroy,onfile
;
; Which filter?
i=where(strpos(data,'Filter') ge 0)
words=nameparse(data(i(0)))
i=where(strpos(words,'microns') ge 0)
lambda=double(words(i(0)-1))
;
; How many "scans" (=numpoint)
i=where(strpos(data,'Number of scans') ge 0)
words=nameparse(data(i(0)))
numpoint=long(words(n_elements(words)-1))
;
; PA, PB, I1, I2 fluxes (=natcounts and =photonrate)
i=where(strpos(data,'Cal avg ON-SOURCE') ge 0)
reads,data(i(0)+1),pr1,pr2,nat1,nat2
;
; Squared visibility amplitude
i=where(strpos(data,'Avg final Mu^2') ge 0)
words=nameparse(data(i(0)))
vissq=float(words(n_elements(words)-4))
vissqerr=float(words(n_elements(words)-3))
;
; Check if FITS container for all batches already exists
fitsfile='VINCI.'+utdate+'.xdr'
fitsfiles=findfile(fitsfile)
;
if strlen(fitsfiles(0)) gt 0 then begin
;
; 	get_oifits,fitsfiles(0)
	get_xdr,fitsfiles(0)
	scans.vissq=scans.vissqc
	scans.vissqerr=scans.vissqcerr
	scans0=scans
	scantable0=scantable
;
endif else begin
;
	SystemId='VLTI/IONIC'
;
	NumSid=2
	NumOutBeam=1
	maxBaseline=1
	maxSpecChan=1
	maxNumTriple=10
	maxConfig=NumSid 
	for i=2,NumSid do maxConfig=maxConfig+combinations(NumSid,i)
	GenConfig=allocgenconfig(NumSid,NumOutBeam, $
		 maxNumTriple,maxBaseline,maxSpecChan,maxConfig)
	GenConfig.Date=utdate
	GenConfig.NumSid=NumSid
	GenConfig.NumOutBeam=NumOutBeam
	GenConfig.NumBaseline=[1]
	GenConfig.NumSpecChan=[1]
	GenConfig.refstation=1
	GenConfig.BeamCombinerId=12
;
	GenConfig.Wavelength(0,0)=lambda/1.d6
	GenConfig.ChanWidth(0,0)=0.4/1.d6
;
	GenConfig.BaselineId(0,0)=st1+'-'+st2
	GenConfig.StationId(0)=strmid(GenConfig.BaselineId(0,0),0,3)
	GenConfig.StationId(1)=strmid(GenConfig.BaselineId(0,0),4,3)
;
        genconfig.delaylineid=delaylineids
        genconfig.refstation=where(delaylineids eq long(strmid(refname,2,1)))+1
        genconfig.bcinputid=bcinputs
;
	get_stationtable
	date=date0
	get_geoparms
;
endelse
;
; Allocate scans
num_scan=1
scans=replicate(scan(),num_scan)
scans.iscan=1
scans.starid=starid
scans.time=time*3600
if genconfig.refstation eq 1 then dlt2=dlt2-dlt1
if genconfig.refstation eq 2 then dlt1=dlt1-dlt2
scans.fdlpos(0)=dlt1
scans.fdlposerr(0)=1e-6
scans.fdlpos(1)=dlt2
scans.fdlposerr(1)=1e-6
;
scans.VisSq=vissq
scans.VisSqErr=vissqerr
scans.VisSqC=vissq
scans.VisSqCErr=vissqerr
;
scans.natcounts=[nat1,nat2]
scans.natcountserr=sqrt([nat1,nat2])
scans.photonrate=sqrt(pr1*pr2)
scans.photonrateerr=sqrt(sqrt(pr1*pr2))
;
print,'ScanData read.'
;
; Create ScanTable
get_scantable
;
; If container file was read, concatenate
if n_elements(scans0) gt 0 then begin
	scans=[scans0,scans]
	scantable=[scantable0,scantable]
;	Sort using time in case these were assembled non-chronologically
	si=sort(scans.time)
	scans=scans(si)
	scantable=scantable(si)
;	Remove duplicate items, hopefully this will keep the latter
	si=uniq(scans.time)
	scans=scans(si)
	scantable=scantable(si)
endif
;
get_startable
calcastrom
;
; These coordinates from the data files should take precedence
; scans.uvw(0,0,0,0)=u
; scans.uvw(0,0,0,1)=v
;
; Write this data into the container file
; put_oifits,fitsfile=fitsfile
put_xdr,fitsfile
;
ENDFOR
;
ENDIF ELSE BEGIN
;
get_xdr,files(0)
;
ENDELSE
;
; Clear AMOEBA's data buffer and store this night's data
bufferinfo=replicate(nightinfo(),1)
GeoInfo=replicate(GeoParms,1)
GenInfo=replicate(GenConfig,1)
freememory
storenight
ds_options.i=1	; True: interferometry loaded
ds_options.t=-1	; Type: use only squared visibilities
;
; Remove intermediate xdr file
spawn,'rm -f VINCI*.xdr'
;
end
;-------------------------------------------------------------------------------
