;-------------------------------------------------------------------------------
pro vincibatch,f
;
; Input the object pointer (returned by vincifilegui) to four files,
; namely the OFFSOURCE, BEAM_A, BEAM_B, and STD files.
; Combine these four FITS files and read the batch. Apply the offsource
; correction and initialize the Wiener filter.
;
common VinciRawData,off,a,b,on,fr,nx,fsp,ob,im,obd
;
; fr	= frame rate
; nx	= window size in pixels
; fsp	= fringe speed in m/s
; ob	= OB name
; im	= instrument mode
; obd	= observation date
;
vinciassembleraw,f,off,a,b,on,fr,nx,fsp,ob,im,obd
vinciunoff,off,a,b,on,offstat
vinciwiener
;
end
;-------------------------------------------------------------------------------
pro vinciplotwiener,id
;
forward_function signalfilter
;
common VinciRawData,off,a,b,on,fr,nx,fsp,ob,im,obd
common VinciWienerFilter,wiener_a,wiener_b
;
psda=vincipower(on(*,*,2),/average)
psdb=vincipower(on(*,*,3),/average)
;
n=n_elements(psda)
bias_psda=avg(psda(n/2:n-1))
stdv_psda=stdev(psda(n/2:n-1))
bias_psdb=avg(psdb(n/2:n-1))
stdv_psdb=stdev(psdb(n/2:n-1))
index_a=where(psda lt bias_psda)
index_b=where(psdb lt bias_psdb)
;
!p.multi=[0,2,3]
plot,psda,title='Average PSD(PA)',ytype=1
oplot,findgen(n),fltarr(n)+bias_psda
plot,psdb,title='Average PSD(PB)',ytype=1
oplot,findgen(n),fltarr(n)+bias_psdb
;
wiener_a=median((psda-bias_psda)/psda,11)
wiener_b=median((psdb-bias_psdb)/psdb,11)
wiener_a(index_a(0):n-1)=0
plot,wiener_a,title='Wiener filter A'
wiener_b(index_b(0):n-1)=0
plot,wiener_b,title='Wiener filter B'
;
pa=reform(on(*,id,2))
pb=reform(on(*,id,3))
plot,pa,psym=3
oplot,signalfilter(pa,wiener_a),color=4
plot,pb,psym=3
oplot,signalfilter(pb,wiener_b),color=4
;
end
;-------------------------------------------------------------------------------
pro vinciwiener
;
common VinciRawData,off,a,b,on,fr,nx,fsp,ob,im,obd
common VinciWienerFilter,wiener_a,wiener_b
;
psda=vincipower(on(*,*,2),/average)
psdb=vincipower(on(*,*,3),/average)
;
n=n_elements(psda)
bias_psda=avg(psda(n/2:n-1))
stdv_psda=stdev(psda(n/2:n-1))
bias_psdb=avg(psdb(n/2:n-1))
stdv_psdb=stdev(psdb(n/2:n-1))
index_a=where(psda lt bias_psda)
index_b=where(psdb lt bias_psdb)
;
wiener_a=median((psda-bias_psda)/psda,11)
wiener_b=median((psdb-bias_psdb)/psdb,11)
wiener_a(index_a(0):n-1)=0
wiener_b(index_b(0):n-1)=0
;
end
;-------------------------------------------------------------------------------
pro vincilinkappa
;
common VinciRawData,off,a,b,on,fr,nx,fsp,ob,im,obd
common VinciKappaData,kappa
;
kappa=fltarr(4)
!p.multi=[0,2,2]
plot,a(*,*,2),a(*,*,0),psym=3
r=poly_fit(a(*,*,2),a(*,*,0),1)
kappa(0)=r(1)
plot,a(*,*,2),a(*,*,1),psym=3
r=poly_fit(a(*,*,2),a(*,*,1),1)
kappa(2)=r(1)
plot,b(*,*,3),b(*,*,0),psym=3
r=poly_fit(b(*,*,3),b(*,*,0),1)
kappa(1)=r(1)
plot,b(*,*,3),b(*,*,1),psym=3
r=poly_fit(b(*,*,3),b(*,*,1),1)
kappa(3)=r(1)
;
print,'kappa=',kappa
;
end
;-------------------------------------------------------------------------------
pro vinciscanpower,id
;
common VinciRawData,off,a,b,on,fr,nx,fsp,ob,im,obd
;
kappa=vincikappa(a,b)
print,'kappa=',kappa
;
hf=vinciunphoto(on,kappa)
;
!p.multi=[0,2,3]
plot,on(*,id,0),title='I1'
plot,on(*,id,1),title='I2'
plot,hf(*,id,0),title='I1 cal.'
plot,hf(*,id,1),title='I2 cal.'
; plot,on(*,id,4),title='QL'
plot,hf(*,id,1)-hf(*,id,0),title='I2-I1 cal.'
vincipowersp,id
;
end
;-------------------------------------------------------------------------------
pro vinciscanwavelet,id
;
forward_function signalfilter
;
common VinciRawData,off,a,b,on,fr,nx,fsp,ob,im,obd
common VinciWienerFilter,wiener_a,wiener_b
common VinciKappaData,kappa
;
!p.multi=[0,2,4]
!p.charsize=2.0
tek_color
;
; Plot interferometric channels
i1=reform(on(*,id,0))
plot,i1,title='I1'
i2=reform(on(*,id,1))
plot,i2,title='I2'
;
; Plot photometric channels
pa=reform(on(*,id,2))
plot,pa,title='PA',psym=3
paf=signalfilter(pa,wiener_a) > 1
oplot,paf,color=3
pb=reform(on(*,id,3))
plot,pb,title='PB',psym=3
pbf=signalfilter(pb,wiener_b) > 1
oplot,pbf,color=3
;
; MONA transfer matrix
kappa=vincikappa(a,b)
;
i1c=(1/(2*sqrt(kappa(0)*kappa(1))))*((i1-kappa(0)*pa-kappa(1)*pb)/sqrt(paf*pbf))
i2c=(1/(2*sqrt(kappa(2)*kappa(3))))*((i2-kappa(2)*pa-kappa(3)*pb)/sqrt(paf*pbf))
plot,i1c,title='I1 cal.'
plot,i2c,title='I2 cal.'
;
i21c=(i2c-i1c)/2
plot,i21c,title='I2-I1 cal.'
; plot,on(*,id,4),title='I2-I1 cal. pipeline'
;
xrange=!x.range
!x.range=0
; on(*,id,4)=i21c
vinciwavelet,id
!x.range=xrange
;
!p.multi=0
;
end
;-------------------------------------------------------------------------------
pro vinciwavelet,id
;
common VinciRawData,off,a,b,on,fr,nx,fsp,ob,im,obd
;
ntime = 256/2
; y = RANDOMN(s,ntime)       ;*** create a random time series
; y=sin(findgen(ntime)/2)
; restore
y=on(270-ntime/2:270+ntime/2-1,id,4)
; restore
dt = 0.25
time = FINDGEN(ntime)*dt   ;*** create the time index

wave = WAVELET(y,dt,PERIOD=period,COI=coi,/PAD,SIGNIF=signif)
nscale = N_ELEMENTS(period)
LOADCT,39
CONTOUR,ABS(wave)^2,time,period, $
       XSTYLE=1,XTITLE='Time',YTITLE='Period',TITLE='Noise Wavelet', $
       YRANGE=[MAX(period),MIN(period)], $  
       /YTYPE, $                          
       NLEVELS=25,/FILL

signif = REBIN(TRANSPOSE(signif),ntime,nscale)
tek_color
CONTOUR,ABS(wave)^2/signif,time,period, $
           /OVERPLOT,LEVEL=1.0,C_ANNOT='95%'
PLOTS,time,coi,NOCLIP=0   ;*** anything "below" this line is dubious
;
end
;-------------------------------------------------------------------------------
pro vincipowersp,id
;
common VinciRawData,off,a,b,on,fr,nx,fsp,ob,im,obd
forward_function powerspectrum
;
n=32
y=on(270-n:270+n-1,id,4)
;
psd=powerspectrum(y,1/fr,f,p,f_avg,p_avg)
;
!x.range=0
plot,f_avg,p_avg,xtitle='Frequency [Hz]',ytitle='Power'
;
end
;-------------------------------------------------------------------------------
pro vndrs,f
;
fn=f->files()
num_files=n_elements(fn)
ht=f->headerTable()
dprtype=strarr(num_files)
types=['OFFSOURCE','BEAM_A','BEAM_B','STD']
jndex=intarr(num_files)
for i=0,num_files-1 do begin
	index=where(ht.filename eq specname(fn(i)))
	dprtype(i)=strtrim(ht(index).dprtype)
	jndex(where(types eq dprtype(i)))=i
endfor
fn=fn(jndex)
;
openw,unit,'vndrs_filelist',/get_lun
for i=0,num_files-1 do printf,unit,fn(i)
free_lun,unit
;
vndrs='vndrs'
if getenv('USER') eq 'vltip' then $
vndrs='/diskb/vltip/chummel/VINCI_DRS_3.0/bin/vndrs'
if getenv('HOST') eq 'crux' then $
vndrs='/data1/chummel/VINCI_DRS_3.0/bin/vndrs'
if num_files eq 4 then spawn,vndrs+' -list vndrs_filelist',r $
		  else spawn,vndrs+' -list vndrs_filelist'
spawn,'rm -f vndrs_filelist'
;
if num_files eq 4 then $
for i=0,num_files/4-1 do xdisplayfile,fn((i+1)*4-1)+'.log'
;
end
;-------------------------------------------------------------------------------
