;**************************************************************
;#class#
;VINCI PACK
;#description#
;Fairly simple EWS routines repackaged for VINCI
;usually the goal is to hide the object oriented stuff
;or combine several often used functions together
;#end_class#
;******************************************************************

FUNCTION vinciFileGui,dataDir,reduced=reduced
;*************************************************************
;#function#
;vinciFileGui
;#description#
;bring up Gui to select raw or reduced vinci data set
;This requires two environmental variables to be set:
;vinciRawData describes the root directory of raw data
;vinciReducedData describes the root directory of reduced data
;#call#
;fileListObject = vinciFileGui()
;fileListObject = vinciFileGui(/reduced)
;#inputs#
;\anArg{reduced}{bool}{if specified look for reduced files, otherwise raw}
;#return#
;\anArg{-}{fitsFileListObject}{an object containing the selected files}
;\anArg{-}{-}{and a table of selected keyword values for each file}
;#end_function#
;****************************************************************
   COMPILE_OPT HIDDEN
;select a set of vinci files
   doRed = KEYWORD_SET(reduced)
   if n_elements(dataDir) eq 0 then dataDir='.'
   if (doRed) then begin
;     dataDir = getenv('vinciReducedDir')
      Keys = ['ql framerate']
   endif else begin 
;     dataDir = getenv('vinciRawDir')
;     Keys = ['targ name','ql framerate','ins mode','dpr catg','win1 nx']
      Keys = ['obs name','ql framerate','ins mode','dpr catg','dpr type','win1 nx']
   endelse
   RETURN, OBJ_NEW('fitsFileList', dir=dataDir, guiKeys=Keys)
END
