pro hongphasefunction, nu, pfunc

; output a tabuated phasefunction, pfunc, for use in
; xscatteringzodimodel and
; xfullzodimodel
; pfunc is a function of cosinetheta
; (the cosine of the scattering angle)
; and is tabulated for
; cos(theta)=-1.0. -0.998, -0.996 . . . 1.0

costheta=(findgen(1001)-500)/500.0

; Phase function at 0.5 Ang from Hong, S. S. 1985, A&A, 146, 67
; for nu=1.0
; This function is only good to 15 degrees from forward!
g=[0.70, -0.20, -0.81]
w=[0.665, 0.330, 0.005]
nhong=0.0795775  ; 1/ ( 4 pi)

pi=3.1415926536
pfunc1=fltarr(1001)
for i=0,2 do begin
pfunc1=pfunc1+w(i)*(1.0-g(i)*g(i))/((1.0+g(i)*g(i)-2.0*g(i)*costheta)^1.5)
endfor
pfunc1=nhong*pfunc1

; and convert this form to the new nu
; start by doing the brightness integral 
; get the answer to within a factor of zeta1sigmabar1

z=fltarr(1001)

; brightness integral for nu=1
; as a function of cosine(theta)
istepnum=500.0
for j=1,999 do begin
eps=acos(costheta(j))
sineps=sin(eps)
angi=eps+(pi-eps)*findgen(istepnum+1)/istepnum
pfunci=fltarr(istepnum+1)
for i=0,2 do begin
pfunci=pfunci+w(i)*(1.0-g(i)*g(i))/((1.0+g(i)*g(i)-2.0*g(i)*cos(angi))^1.5)
endfor
pfunci=nhong*pfunci
integrand=pfunci*sin(angi)
z(j)=(1.0/(sineps*sineps))*total(integrand)*((pi-eps)/istepnum)
endfor

; do the conversion via equation 14 of Hong
pfunc=pfunc1-(nu-1.0)*costheta*z

; optionally, compute the normalization
;ar=0.0
;theta=0.0
;stepnum=1d3  ;  use 1d2 for speed, use 1d5 for 5 decimal places accuracy
;thetastep=pi/(1.0*stepnum)
;for i=1.0, stepnum do begin
;theta=theta+thetastep
;ar=ar+sin(theta)*2.0*pi*thetastep*pfunc(i)
;endfor
;print, 'integral', ar

;p=0.08
;capk=0.77
;pfuncmoon=(p/pi)*exp(capk*(acos(costheta)-pi))
;pfuncmoon=(p/pi)*exp(capk*(theta-pi))

end