      SUBROUTINE TEST_SKCHR(STATUS)
*+
*  Name:
*     TEST_SKCHR

*  Purpose:
*     Test CHR_SKCHR.

*  Language:
*     Starlink Fortran 77

*  Invocation:
*     CALL TEST_SKCHR(STATUS)

*  Description:
*     Test CHR_SKCHR.
*     If any failure occurs, return STATUS = SAI__ERROR.
*     Otherwise, STATUS is unchanged.

*  Arguments:
*     STATUS = INTEGER (Returned)
*        The status of the tests. 

*  Authors:
*     RLVAD::AJC: A J Chipperfield (STARLINK)
*     RLVAD::ACC: A C Charles (STARLINK)
*     {enter_new_authors_here}

*  History:
*     17-AUG-1989 (RLVAD::AJC):
*        Original version.
*     14-SEP-1993 (ACC)
*        Modularised version: broken into one routine for each of 5 main 
*        categories of tests.
*     02-MAR-1994 (ACC)
*        Second modularised version: broken further into one routine for 
*        each of subroutine tested.  This subroutine created.
*     {enter_further_changes_here}

*  Bugs:
*     {note_any_bugs_here}

*  Subprograms called:    
*     CHR_SKCHR

*-

*  Type Definitions:
      IMPLICIT NONE              ! No implicit typing

*  Arguments Given:
*     None

*  Arguments Returned:
      INTEGER STATUS

*  Global Constants:
      INCLUDE 'SAE_PAR'          ! Standard SAE constants
      INCLUDE 'CHR_ERR'

*  Local Variables:
      INTEGER ISTAT              ! Local status
      INTEGER PTR1               ! String index
      INTEGER STRLEN             ! Length of STRING
      CHARACTER*120 STRING

*.

      STRLEN = LEN( STRING )

*    Test CHR_SKCHR

      ISTAT = SAI__OK
      STRING = 'ABCDEFGABCDEFG'

*    All chars are to be skipped, forward
      PTR1 = 1
      CALL CHR_SKCHR( 'ABCDEFG ', STRING, .TRUE., PTR1 )
      IF ( PTR1 .NE. STRLEN + 1 ) THEN
         PRINT *, 'CHR_SKCHR skip all chars forward FAILS, IPOSN =', 
     :             PTR1
         ISTAT = SAI__ERROR
      END IF

*    All chars are to be skipped, backward
      PTR1 = 30
      CALL CHR_SKCHR( 'ABCDEFG ', STRING, .FALSE., PTR1 )
      IF ( PTR1 .NE. 0 ) THEN
         PRINT *, 'CHR_SKCHR skip all chars backward FAILS, IPOSN =',
     :             PTR1
         ISTAT = SAI__ERROR
      END IF

*    Initial position invalid
      PTR1 = 150
      CALL CHR_SKCHR( 'ABCDEFG', STRING, .TRUE., PTR1 )
      IF ( PTR1 .NE. 150 ) THEN
         PRINT *, 'CHR_SKCHR initial position invalid FAILS, IPOSN =',
     :             PTR1
         ISTAT = SAI__ERROR
      END IF
 
*    Valid inputs forward
      PTR1 = 1
      CALL CHR_SKCHR( 'ABCD', STRING, .TRUE., PTR1 )
      IF ( PTR1 .NE. 5 ) THEN
         PRINT *, 'CHR_SKCHR valid inputs forward FAILS, IPOSN =', 
     :             PTR1
         ISTAT = SAI__ERROR
      END IF

*    Valid inputs backward
      PTR1 = 15
      CALL CHR_SKCHR( 'EFG ', STRING, .FALSE., PTR1 )
      IF ( PTR1 .NE. 11 ) THEN
         PRINT *, 'CHR_SKCHR valid inputs backward FAILS, IPOSN =', 
     :             PTR1
         ISTAT = SAI__ERROR
      END IF

      IF ( ISTAT .EQ. SAI__OK ) THEN
         PRINT *, 'CHR_SKCHR OK'
      ELSE
         STATUS = SAI__ERROR
      ENDIF

      END
