#include "hds1_feature.h"	 /* Define feature-test macros, etc.	    */
#include <string.h>
#include <stddef.h>
#include "f77.h"		 /* F77 <-> C interface macros		    */
#include "ems.h"		 /* EMS error reporting routines	    */
#include "ems_par.h"		 /* EMS__ public constants		    */
#include "hds1.h"		 /* Global definitions for HDS		    */
#include "rec.h"		 /* Public rec_ definitions		    */
#include "str.h"		 /* Character string import/export macros   */
#include "dat1.h"		 /* Internal dat_ definitions		    */
#include "dat_err.h"		 /* DAT__ error code definitions	    */

   F77_INTEGER_FUNCTION(dat_ermsg)
                       ( const int *status,
		         int *len,
			 struct STR *msg_str,
			 int msg_lenarg )
   {
/*
*+
*  Name:
*     DAT_ERMSG

*  Purpose:
*     Translate a status value into an error message.

*  Language:
*     ANSI C

*  Invocation:
*     CALL DAT_ERMSG( STATUS, LENGTH, MSG )

*  Description:
*     This routine translates an error status value into an associated
*     error message. It first attempts to translate the value supplied
*     as a DAT__ error code. If this fails, it then attempts to
*     translate it as a system status code for the host operating
*     system. If this also fails, then the returned string is a message
*     indicating that the status value could not be translated.

*  Arguments:
*     STATUS = INTEGER (Given)
*        The error status value to be translated.
*     LENGTH = INTEGER (Returned)
*        Number of significant characters in the returned error message
*        (i.e.  excluding trailing blanks). This value will not exceed
*        the length of the character variable supplied for the MSG
*        argument.
*     MSG = CHARACTER * ( * ) (Returned)
*        The error message.

*  Notes:
*     -  If the variable supplied for the MSG argument is not long
*     enough to accommodate the error message, then the message will be
*     truncated and the returned value of LENGTH will reflect the
*     truncated length.
*     -  No returned error message will contain more significant
*     characters than the value of the EMS__SZMSG symbolic constant.
*     This constant is defined in the include file EMS_PAR.

*  Authors:
*     RFWS: R.F. Warren-Smith (STARLINK, RAL)
*     {enter_new_authors_here}

*  History:
*     5-APR-1991 (RFWS):
*        Original portable version.
*     8-APR-1991 (RFWS):
*        Improved prologue.
*     13-MAY-1991 (RFWS):
*        Added calls to ems_mark_c and ems_rlse_c to prevent use of ems_
*        routines from affecting any previously defined message tokens.
*     9-JAN-1992 (RFWS):
*        Updated error message for DAT__NOMEM status.
*     1-DEC-1992 (RFWS):
*        Added DAT__WLDIN error message.
*     {enter_further_changes_here}

*  Bugs:
*     {note_any_bugs_here}

*-
*/

/* Local Variables:							    */
      char sysbuf[ EMS__SZMSG + 1 ]; /*	Buffer for system translation	    */
      const char *trans;	 /* Pointer to translation text		    */
      int lstat;		 /* Local status variable		    */
      int msg_len = msg_lenarg;	 /* Output string length		    */
      struct DSC msg;		 /* Descriptor for output string	    */

/*.									    */

/* Set up a descriptor for the output string.				    */
      _strexp( &msg, msg_str, &msg_len );

/* Test for each DAT__ error code, obtaining a pointer to the textual	    */
/* translation.								    */
      switch ( *status )
      {
         default:
	    trans = NULL;
	    break;

         case DAT__OK:
            trans = "OK, no error (DAT__OK)";
	    break;
 
         case DAT__LOCIN:
            trans = "Locator invalid (DAT__LOCIN)";
	    break;
 
         case DAT__TYPIN:
            trans = "Type invalid (DAT__TYPIN)";
	    break;
 
         case DAT__NAMIN:
            trans = "Name invalid (DAT__NAMIN)";
	    break;
 
         case DAT__MODIN:
            trans = "Mode invalid (DAT__MODIN)";
	    break;
 
         case DAT__DELIN:
            trans = "Deletion invalid (DAT__DELIN)";
	    break;
 
         case DAT__DIMIN:
            trans = "Dimensions invalid (DAT__DIMIN)";
	    break;
 
         case DAT__FILIN:
            trans = "File invalid (DAT__FILIN)";
	    break;
 
         case DAT__OBJIN:
            trans = "Object invalid (DAT__OBJIN)";
	    break;
 
         case DAT__GRPIN:
            trans = "Group invalid (DAT__GRPIN)";
	    break;
 
         case DAT__SUBIN:
            trans = "Subscripts invalid (DAT__SUBIN)";
	    break;
 
         case DAT__COMEX:
            trans = "Component already exists (DAT__COMEX)";
	    break;
 
         case DAT__OBJNF:
            trans = "Object not found (DAT__OBJNF)";
	    break;
 
         case DAT__TRUNC:
            trans = "Text truncated (DAT__TRUNC)";
	    break;
 
         case DAT__ACCON:
            trans = "Access conflict (DAT__ACCON)";
	    break;
 
         case DAT__CONER:
            trans = "Conversion error (DAT__CONER)";
	    break;
 
         case DAT__UNSET:
            trans = "Primitive data undefined (DAT__UNSET)";
	    break;
 
         case DAT__VERMM:
            trans = "Version mismatch (DAT__VERMM)";
	    break;
 
         case DAT__PRMAP:
            trans = "Primitive data mapped (DAT__PRMAP)";
	    break;
 
         case DAT__FILCK:
            trans = "File lock error (DAT__FILCK)";
	    break;
 
         case DAT__FILNF:
            trans = "File not found (DAT__FILNF)";
	    break;
 
         case DAT__FILPR:
            trans = "File protected (DAT__FILPR)";
	    break;
 
         case DAT__INCHK:
            trans = "Integrity check (DAT__INCHK)";
	    break;
 
         case DAT__FATAL:
            trans = "Fatal internal error (DAT__FATAL)";
	    break;
 
         case DAT__ISMAP:
            trans = "Data currently mapped (DAT__ISMAP)";
	    break;
 
         case DAT__BOUND:
            trans = "Outside bounds of object (DAT__BOUND)";
	    break;
 
         case DAT__FILCL:
            trans = "File close error (DAT__FILCL)";
	    break;
 
         case DAT__FILCR:
            trans = "File create error (DAT__FILCR)";
	    break;
 
         case DAT__FILMP:
            trans = "File mapping error (DAT__FILMP)";
	    break;
 
         case DAT__FILND:
            trans = "File not deleted (DAT__FILND)";
	    break;
 
         case DAT__FILNX:
            trans = "File not extended (DAT__FILNX)";
	    break;
 
         case DAT__FILRD:
            trans = "File read error (DAT__FILRD)";
	    break;
 
         case DAT__FILWR:
            trans = "File write error (DAT__FILWR)";
	    break;
 
         case DAT__NOMEM:
            trans = "Memory allocation error (DAT__NOMEM)";
	    break;

         case DAT__WLDIN:
            trans = "Wild card search context invalid (DAT__WLDIN)";
	    break;
      }

/* If translation text was found, then determine the number of significant  */
/* characters to be returned and copy them to the output string.	    */
      if ( trans != NULL )
      {
         *len = _min( (int) strlen( trans ), (int) msg.length );
	 _chcopy( *len, trans, ' ', (int) msg.length, msg.body );
      }

/* If the error code is not a DAT__ error code, then use ems_ to translate  */
/* it as a system error code, and copy the resulting text to the output	    */
/* string.								    */
      else
      {
         lstat = DAT__OK;
	 ems_mark_c( );
         ems_syser_c( "MESSAGE", *status );
	 ems_mload_c( " ", "^MESSAGE", sysbuf, len, &lstat );
	 ems_rlse_c( );
         *len = _min( *len, (int) msg.length );
         _chcopy( *len, sysbuf, ' ', (int) msg.length, msg.body );
      }

/* Exit the routine.							    */
      return DAT__OK;
   }
