#!/bin/bash

# This script generates the split log files and associated LaTeX commands
# It should be called with 3 arguments :
#
# autolog.sh  LOG_FILE  NML_FILE  OUT_DIR
#

TEX="autologdefs.tex"          # Name of the output LaTeX defs file
AWK="awk"                      # awk command
GREP="grep"                    # grep command

[ $# -lt 3 ] && exit 1

LOG=$1; [ ! -e $LOG ] && exit 1
NML=$2; [ ! -e $NML ] && exit 1
OUT=$3; [ ! -d $OUT ] && exit 1

FULLTEX=$OUT/$TEX

echo -e "% auto-generated LaTeX commands, see scripts/autolog.sh" > $FULLTEX
echo -e "% generated by autolog.sh:"        >> $FULLTEX

# Extract the base names of the log and nml files (escaping underscores)
LOGSTRIP=`echo "$LOG" | rev | cut -d/ -f1 | rev | sed -e 's/_/\\_/'`
NMLSTRIP=`echo "$NML" | rev | cut -d/ -f1 | rev | sed -e 's/_/\\_/'`
echo "\newcommand{\\logfilename}{${LOGSTRIP}}" >> $FULLTEX
echo "\newcommand{\\nmlfilename}{${NMLSTRIP}}" >> $FULLTEX
echo "\newcommand{\\fullnmlfilename}{${NML}}"  >> $FULLTEX

# Run the log-parsing awk scripts
echo -e "% generated by lastlines.awk:"     >> $FULLTEX
$AWK -v TEXFILE=$FULLTEX -f scripts/lastlines.awk $LOG   > $OUT/lastlines.log

echo -e "\n% generated by logstart.awk:"    >> $FULLTEX
$AWK -v TEXFILE=$FULLTEX -f scripts/logstart.awk  $LOG   > $OUT/logstart.log

echo -e "\n% generated by finestep.awk:"    >> $FULLTEX
$GREP -n -A1 -B3 "Fine step= *0 " $LOG \
   | $AWK -v TEXFILE=$FULLTEX -f scripts/finestep.awk    > $OUT/finestep.log

echo -e "\n% generated by lastoutput.awk:"  >> $FULLTEX
$AWK -v TEXFILE=$FULLTEX -f scripts/lastoutput.awk $LOG  > $OUT/lastoutput.log

echo -e "\n% generated by parse_log.awk:"   >> $FULLTEX
$AWK -v TEXFILE=$FULLTEX -f scripts/parse_log.awk $LOG

# Run the namelist-parsing awk script
echo -e "\n% generated by parse_nml.awk:"   >> $FULLTEX
$AWK -v TEXFILE=$FULLTEX -f scripts/parse_nml.awk $NML
