;+
; NAME:
;	MAKE_DENS
;
; PURPOSE:
;	This procedure compute the local density for each particle.
;	It uses the TIPSY routine SMOOTH as a spawned process. This
;	routine must be properly installed before using MAKE_DENS.
;
; CATEGORY:
;	Data analysis.
;
; CALLING SEQUENCE:
;       MAKE_DENS, Part, PREFIX= prefix, TIPSY_DIR= tipsy_dir
;
; INPUTS:
;       Part = Structure defining particles.
;
; OPTIONAL INPUTS:
;       PREFIX: If set, defines the prefix for the 3 output files
;       generated by the routine and TIPSY routine SMOOTH (see
;       OUTPUTS). The default is: tipsy.
;
;       TIPSY_DIR: If set, defines the directory (full path) where the
;       TIPSY executable SMOOTH is installed. 
;       Default: /home/storage/teyssier/halos_finder/smooth/ 
;
; OUTPUTS:
;       Three output files are generated: tipsy.ascii, tipsy.bin and
;       tipsy.den. The latter file contains the particle density
;       array, used in PP_PART3D for example.
;       
; COMMON BLOCKS:
;       None.
;
; EXAMPLE:
;       To compute the density of particle PART, type:
;
;	        MAKE_DENS, PART, PREFIX='my_prefix'
;
;       After completion, the routine should have created 3 new files:
;              
;               my_prefix.ascii
;               my_prefix.bin
;               my_prefix.den
;
;       The last file my_prefix.den should be used in PP_PART3D.
;
; MODIFICATION HISTORY:
; 	Written by:	Romain Teyssier, 01/01/2000.
;                       e-mail: Romain.Teyssier@cea.fr
;	Fevrier, 2001:	Comments and header added by Romain Teyssier.
;-
;###################################################
;###################################################
;###################################################
pro make_dens, part, prefix=prefix, tipsy_dir=tipsy_dir

IF N_PARAMS() NE 1 THEN BEGIN
    PRINT, 'Wrong number of arguments'
    DOC_LIBRARY,'make_dens'
    RETURN
ENDIF

filexist=prefix+'.den'
if ((FINDFILE(filexist))[0] ne '')then begin
    print,'file '+prefix+'.den already exists.'
    print,'skipping routine...'
    return
endif

npart=part.npart
ndim=part.ndim

x =part.xp(*,0)
y =part.xp(*,1)
z =part.xp(*,2)
vx=part.vp(*,0)
vy=part.vp(*,1)
vz=part.vp(*,2)
m =part.mp

time=1.0

if not keyword_set(prefix) then prefix='tipsy'
if not keyword_set(tipsy_dir) then $
  tipsy_dir='~/ramses/idl/smooth/'

print,'building tipsy ascii file'
file=prefix+'.ascii'
openw,1,file
printf,1,npart,0,0
printf,1,ndim
printf,1,time
printf,1,m
printf,1,x
printf,1,y
printf,1,z
printf,1,vx
printf,1,vy
printf,1,vz
close,1

command=tipsy_dir+'smooth -o '+prefix+' density < '+file
;print,command
print,'computing density using tipsy routine SMOOTH'
print,'please wait...'
spawn,command
print,'particle density array stored in ',prefix+'.den'
spawn,'ls -als '+prefix+'.*'

; Free memory
x =0.
y =0.
z =0.
vx=0.
vy=0.
vz=0.
m =0.


end
