;+
; NAME:
;	RD_IM
;
; PURPOSE:
;	This procedure reads an 2D image
;
; CATEGORY:
;	Input/Output.
;
; CALLING SEQUENCE:
;	RD_IM, Image, FILE=file, SWAP=swap, VERBOSE=verbose 
;
; OPTIONAL INPUTS:
;	FILE:   if set, input the scalar string containing the name of
;	        the file to be read. Otherwise, a PICKFILE widget is
;	        launched.  
;
;       SWAP:   if set, reverse the bit ordering (Little Endian versus
;               Big Endian)
;
; OUTPUTS:
;	Image:   store the image in array Image
;
; COMMON BLOCKS:
;       None.
;
; EXAMPLE:
;
;	        RD_IM, Image, file='toto.dat',/swap
;
; MODIFICATION HISTORY:
; 	Written by:	Romain Teyssier, 01/01/2003.
;                       e-mail: Romain.Teyssier@cea.fr
;-
pro rd_im, image, file=file, swap=swap, verbose=verbose, header=header

IF N_PARAMS() NE 1 THEN BEGIN
    PRINT, 'Wrong number of arguments'
    DOC_LIBRARY,'rd_im'
    RETURN
ENDIF

if not keyword_set(file) then begin
    file=DIALOG_PICKFILE(/READ)
endif
if not keyword_set(file) then return

if keyword_set(verbose) then print,'Reading file ',trim(file)

if not file_test(file) then return

nx=0L & ny=0L
t=0d0 & dx=0d0 & dy=0d0 & dz=0d0
openr,1,file,/f77_unformatted,swap_endian=swap
readu,1,t,dx,dy,dz
;print,t,dx,dy,dz
readu,1,nx,ny
image=fltarr(nx,ny)
readu,1,image
close,1

header={t:t,dx:dx,dy:dy,dz:dz}

return

bad_luck:  print,'I/O Error, exiting...'
           close,1
           return

end
;###################################################
;###################################################
;###################################################
