#!/bin/bash
#SBATCH -J MWay_r001
#SBATCH --output=./job%x.%j.out
#SBATCH --error=./job%x.%j.err
#SBATCH -D /hppfs/scratch/0E/di34hok3/MockSims_SM/logs/
#SBATCH --mail-type=END
#SBATCH --mail-user=eric.emsellem@eso.org
#SBATCH --time=48:00:00
#SBATCH --no-requeue
#SBATCH --export=NONE
#SBATCH --get-user-env
#SBATCH --account=pn57wu
#SBATCH --partition=general
#SBATCH --nodes=25
#SBATCH --ntasks-per-node=40
#constraints are optional
#SBATCH --constraint="scratch&work"
# Loading module
module load slurm_setup
# Variable def
SIMU=/hppfs/work/pn57wu/di34hok3/MockSims_SM/
SIMURUN=/hppfs/scratch/0E/di34hok3/MockSims_SM/
THISOUTPUT=MWay_OA25_r001
NML_NAME="MWay_OA25_final_25n"
# New ramses from OA (2025), with an updated patch for units
# Specific compil with DNVECTOR=256 
RAMSES=$SIMU/bin/ramses_oa25_16_3d
pwd
cd $SIMURUN
pwd
NAMELIST=$SIMU'/nml/'$NML_NAME'.nml'
echo $NAMELIST
cd $SIMURUN/output_$THISOUTPUT
RESTART=$(ls | grep 'output_*' | tail -1 | sed 's|output_0*\([0-9*]\)|\1|g')
if [[ $RESTART == 0 ]] || [[ $RESTART == '' ]] ; then
        RESTART=0
        NML=$NAMELIST
else
        NML=$SIMU'/nml/'$NML_NAME'_'$RESTART'.nml'
        awk -v nbout="$RESTART" 'BEGIN {FS="=" ; OFS="="}
                $1~/restart/ {$2 = nbout}
                {print $0}' $NAMELIST > $NML
fi
DATE=$( date +%Y-%m-%d_%Hh%M )
cd $SIMURUN/output_$THISOUTPUT
# New mpiexec
mpiexec -n $SLURM_NTASKS $RAMSES $NML > $SIMURUN'/ramses_logs/run_'$NML_NAME'_'$DATE'_'$RESTART.log
