/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import java.io.IOException;
import java.io.InputStream;

public class LimiterInputStream
extends InputStream {
    public static final int NO_LIMIT = -1;
    private int _lengthLimit;
    private InputStream _in;

    public LimiterInputStream(InputStream inputStream, int n) throws IOException {
        this._lengthLimit = n;
        this._in = inputStream;
    }

    public int available() throws IOException {
        int n = this._in.available();
        if (this._lengthLimit != -1 && n > this._lengthLimit) {
            return this._lengthLimit;
        }
        return n;
    }

    public void close() throws IOException {
        this._lengthLimit = 0;
        this._in.close();
    }

    public int read() throws IOException {
        if (this._lengthLimit == 0) {
            return -1;
        }
        if (this._lengthLimit != -1) {
            --this._lengthLimit;
        }
        return this._in.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2;
        if (this._lengthLimit != -1 && n3 > this._lengthLimit) {
            n3 = this._lengthLimit;
        }
        int n4 = this._in.read(byArray, n, n3);
        if (this._lengthLimit != -1) {
            this._lengthLimit -= n4;
        }
        return n4;
    }

    public long skip(long l) throws IOException {
        long l2 = l;
        if (this._lengthLimit != -1 && l2 > (long)this._lengthLimit) {
            l2 = this._lengthLimit;
        }
        long l3 = this._in.skip(l2);
        if (this._lengthLimit != -1) {
            this._lengthLimit = (int)((long)this._lengthLimit - l3);
        }
        return l3;
    }
}

